//
// TIPWND.C
//
// This is linked with DBTTIP.VBX. It contains all the code managing
// the tool tip window.
//
// "Real programmers don't write comments - the code is obvious"
//

#include "dbttip.h"


void PaintTheTip( HDC hDC, LPRECT lpRect, HCTL hctl)
{
 extern void PipeCopy( LPSTR, LPCSTR );
 LPDBTTIP lpDBTTip = LPDBTTIPDEREF( hctl );
 PIC pic;

 VBGetPic( lpDBTTip->uUse.hPic, &pic );
 lpDBTTip = LPDBTTIPDEREF( hctl );
 if ( pic.picType == PICTYPE_METAFILE )
  {  //Draw the WMF
   short sdc = SaveDC( hDC );
   SetMapMode( hDC, MM_ANISOTROPIC );
   SetWindowExt( hDC, pic.picData.wmf.xExt, pic.picData.wmf.yExt );
   SetViewportExt( hDC, lpRect->right, lpRect->bottom );
   PlayMetaFile( hDC, pic.picData.wmf.hmeta );
   RestoreDC( hDC, sdc );
  }
 else
   return;  // Error - no picture

 { // Draw the text
  char szText[1200];
  HFONT hFontOld = NULL;
  UINT uAlign;

  switch ( lpDBTTip->uUse.nAlignment )
   {
    case 0: uAlign = DT_LEFT; break;
    case 1: uAlign = DT_RIGHT; break;
    case 2: uAlign = DT_CENTER; break;
   }
  if ( lpDBTTip->uUse.hFont )
    hFontOld = SelectObject( hDC, lpDBTTip->uUse.hFont );
  SetBkMode( hDC, TRANSPARENT );
  SetTextColor( hDC, lpDBTTip->uUse.rgbForeColor );
  PipeCopy( szText, VBDerefHsz(lpDBTTip->hszText) );
  DrawText( hDC, szText, -1, &(LPDBTTIPDEREF(hctl)->rectText), uAlign|DT_WORDBREAK );
  if ( hFontOld )
     SelectObject( hDC, hFontOld );
 }

}


/////////////////////////////////////////////////////////////////////////////
// A normal window procedure

long FAR PASCAL __export TipWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
 switch ( message )
  {
   case WM_PAINT: {
     PAINTSTRUCT ps;
     RECT rect;
     HDC hDC = BeginPaint( hWnd, &ps );
     GetClientRect( hWnd, &rect );
     PaintTheTip( hDC, &rect, (HCTL)GetWindowLong(hWnd,0) );
     EndPaint( hWnd, &ps );
     return 0; }
  }

 return DefWindowProc(hWnd, message, wParam, lParam);
}


/////////////////////////////////////////////////////////////////////////////
// Tool tip window creation and destruction

static char const szClassName[] = "DBTTipClass";

void CreateTipWnd( HCTL hctl )
{
 LPDBTTIP lpDBTTip = LPDBTTIPDEREF( hctl );
 short nHotX = (short)( ((LONG)lpDBTTip->nTipWidth*(LONG)lpDBTTip->uUse.nHotSpotX) / 100L );
 short nHotY = (short)( ((LONG)lpDBTTip->nTipHeight*(LONG)lpDBTTip->uUse.nHotSpotY) / 100L );
 short nPosX = lpDBTTip->pMouse.x + lpDBTTip->uUse.nMouseOffX + lpDBTTip->nExtraOffX - nHotX;
 short nPosY = lpDBTTip->pMouse.y + lpDBTTip->uUse.nMouseOffY + lpDBTTip->nExtraOffY - nHotY;

 // Posistion the tip so that it's always visible
 if ( nPosX<0 )
   nPosX = 0;
 if ( nPosY<0 )
   nPosY = 0;
 if ( (nPosX+lpDBTTip->nTipWidth) > GetSystemMetrics(SM_CXSCREEN) )
   nPosX = GetSystemMetrics(SM_CXSCREEN)-lpDBTTip->nTipWidth;
 if ( (nPosY+lpDBTTip->nTipHeight) > GetSystemMetrics(SM_CYSCREEN) )
   nPosY = GetSystemMetrics(SM_CYSCREEN)-lpDBTTip->nTipHeight;

 lpDBTTip->hWndTip = CreateWindow(
	szClassName,
	NULL,
	WS_POPUP,
	nPosX,
	nPosY,
	lpDBTTip->nTipWidth,
	lpDBTTip->nTipHeight,
	NULL,
	NULL,
	ghmodDLL,
	NULL );
 SetWindowPos( lpDBTTip->hWndTip, HWND_TOPMOST, 0, 0, 0, 0,
               SWP_NOACTIVATE | SWP_SHOWWINDOW | SWP_NOMOVE | SWP_NOSIZE );
 SetWindowLong( lpDBTTip->hWndTip, 0, (LONG)hctl );
}


void DestroyTipWnd(HCTL hctl)
{
 LPDBTTIP lpDBTTip = LPDBTTIPDEREF( hctl );

 if ( lpDBTTip->hWndTip )
   DestroyWindow( lpDBTTip->hWndTip );
 lpDBTTip->hWndTip = NULL;
 lpDBTTip->nExtraOffX = 0;
 lpDBTTip->nExtraOffY = 0;
}


/////////////////////////////////////////////////////////////////////////////
// Tool tip class registration and unregistration

static short gnRegisters = 0;

BOOL RegisterTipClass(void)
{
 WNDCLASS wc;

 if ( gnRegisters++ )  // need only register once
   return TRUE;

 wc.style			= CS_SAVEBITS; //NULL;
 wc.lpfnWndProc		= TipWndProc;
 wc.cbClsExtra		= 0;
 wc.cbWndExtra		= sizeof(long);
 wc.hInstance		= ghmodDLL;
 wc.hIcon			= NULL;
 wc.hCursor			= NULL;
 wc.hbrBackground	= NULL;
 wc.lpszMenuName	= NULL;
 wc.lpszClassName	= szClassName;

 return RegisterClass( &wc );
}


void UnregisterTipClass(void)
{
 if ( gnRegisters-- )
   return;
 UnregisterClass( szClassName, ghmodDLL );
}
