'---------------------------------------------------------------------------
' MDI Background Demo Program, Copyright (c) 1994 Karl E. Peterson
' Redistributed by permission.
'
' These programs may be distributed freely on the condition that it is
' distributed in full, and unmodified, and that no fee is charged for such
' distribution with the exception of reasonable media and shipping charges.
' Any or all portions of the source code may be incorporated into your own
' programs, and those programs may be distributed without payment of
' royalties on the condition that such programs differ substantially from
' this demonstration program.
'
' Two sample apps are included in this package.  The first, MDILOGO, uses
' pure VB (no third-party controls) and the Windows API.  The second,
' which is perhaps the better, and certainly the cleaner, approach uses
' a custom message interceptor.  The routines in this module are used by
' both, and as such some are not required in one or the other.

' MDILOGO demonstrates how to create an interesting background on MDI
' parent forms in Visual Basic.  It uses several different approaches to
' achieve this goal.  These include a Windows Metafile (WMF) which resizes
' to fit the background, a bitmap (BMP) centered on the background, a bitmap
' which resizes to fit the background, and finally a tiled bitmap (similar to
' Windows wallpaper) BitBlt'ed across the background.
'
' The other objective was to provide a method to "hide" MDI children, since
' this is not allowed in VB.  The ShowWindow API was used to accomplish this,
' and likewise SendMessage was used to replace VB's native Arrange method.
'
' The design goal of MDILOGO was to use "Pure VB", that is, no custom controls
' to accomplish the background effect.  The THREED.VBX is used to provide a
' toolbar and a status bar, but is not integral to the method.  Other than
' THREED, all methods used in this program are entirely compatable with
' the Standard Edition of Visual Basic 3.0.
'
' MDIDRAW uses the custom control MsgBlast.Vbx to intercept Windows messages
' used to control the client space of the MDIParent form.  Then, using GDI
' calls, paints the background from the new MDIForm_Paint event. It is a much
' cleaner method to accomplish the objective.
'
' MsgBlast is a shareware VBX distributed on the MSDNCDs.  The author is:
'   The Message Blaster Custom Control
'   Copyright (c) 1992 Ed Staffin
'   23831 I. Dunwoody Crossing
'   Atlanta, GA 30338
'   CIS: 72240,2171
'
' To observe the different background effects, press the "Background" button
' on the main toolbar.  This will cycle through each effect.  You may also want
' to resize the forms to see how that is handled.
'
' This program was created and distributed by:
'   Karl E. Peterson
'   Regional Transportation Council
'   1351 Officers' Row
'   Vancouver, Washington 98661
'   CompuServe: 72302,3707
'
' Your comments or questions are invited!  Unfortunately, due to the high 
' interest in this product, no messages from the Internet will be answered
' if posted to my CompuServe Address (it simply costs too much!).  Please
' correspond *only* via CompuServe!  Thanks.
'---------------------------------------------------------------------------

' Default behavior
DefInt A-Z
Option Explicit

' Document (child) tracking arrays
Global fState()  As Integer
Global fDoc() As New frmChild

' State constants
Global Const frmVisible = 2
Global Const frmHidden = 1
Global Const frmDeleted = 0
Global Const HiMenu = 1

' API Types
Type Rect
  Left As Integer
  Top As Integer
  Right As Integer
  Bottom As Integer
End Type
Type POINTAPI
  X As Integer
  Y As Integer
End Type
Type LOGBRUSH
  lbStyle As Integer
  lbColor As Long
  lbHatch As Integer
End Type
Type LOGPEN
  lopnStyle As Integer
  lopnWidth As POINTAPI
  lopnColor As Long
End Type

' API Calls
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer
Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, lpRect As Rect)
Declare Sub InflateRect Lib "User" (lpRect As Rect, ByVal X As Integer, ByVal Y As Integer)
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
Declare Function IsWindowVisible Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function StretchBlt% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&)
Declare Function SetParent Lib "User" (ByVal hWndChild As Integer, ByVal hWndNewParent As Integer) As Integer

Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer

Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function CreatePen Lib "GDI" (ByVal nPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Long) As Integer
Declare Function CreateEllipticRgn Lib "GDI" (ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer

Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As Rect, ByVal hBrush As Integer) As Integer
Declare Function FillRgn Lib "GDI" (ByVal hDC As Integer, ByVal hRgn As Integer, ByVal hBrush As Integer) As Integer
Declare Function TextOut Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer

Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function GetBkColor Lib "GDI" (ByVal hDC As Integer) As Long
Declare Function SetBkMode Lib "GDI" (ByVal hDC As Integer, ByVal nBkMode As Integer) As Integer
Declare Function GetBkMode Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function SetTextColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function GetTextColor Lib "GDI" (ByVal hDC As Integer) As Long

' Some Windows messages watchable by MsgBlast
Global Const WM_CHILDACTIVATE = &H22
Global Const WM_ERASEBKGND = &H14
Global Const WM_HSCROLL = &H114
Global Const WM_MDIACTIVATE = &H222
Global Const WM_MDICASCADE = &H227
Global Const WM_MDICREATE = &H220
Global Const WM_MDIDESTROY = &H221
Global Const WM_MDIGETACTIVE = &H229
Global Const WM_MDIICONARRANGE = &H228
Global Const WM_MDIMAXIMIZE = &H225
Global Const WM_MDINEXT = &H224
Global Const WM_MDIRESTORE = &H223
Global Const WM_MDISETMENU = &H230
Global Const WM_MDITILE = &H226
Global Const WM_PAINT = &HF
Global Const WM_SETREDRAW = &HB
Global Const WM_VSCROLL = &H115

' MsgBlast processing options
Global Const MB_PREPROCESS = -1
Global Const MB_EATMESSAGE = 0
Global Const MB_POSTPROCESS = 1

' ShowWindow() Commands
Global Const WM_SHOWWINDOW = &H18
Global Const SW_HIDE = 0
Global Const SW_SHOWNORMAL = 1
Global Const SW_NORMAL = 1
Global Const SW_SHOWMINIMIZED = 2
Global Const SW_SHOWMAXIMIZED = 3
Global Const SW_MAXIMIZE = 3
Global Const SW_SHOWNOACTIVATE = 4
Global Const SW_SHOW = 5
Global Const SW_MINIMIZE = 6
Global Const SW_SHOWMINNOACTIVE = 7
Global Const SW_SHOWNA = 8
Global Const SW_RESTORE = 9

' MDI messages (previously defined)
'Global Const WM_MDITILE = &H226
'Global Const WM_MDICASCADE = &H227
'Global Const WM_MDIICONARRANGE = &H228

' wParam values for WM_MDITILE and WM_MDICASCADE messages.
Global Const MDITILE_VERTICAL = &H0
Global Const MDITILE_HORIZONTAL = &H1
Global Const MDITILE_SKIPDISABLED = &H2 'Requires Win 3.1

' GetWindow() Constants
Global Const GW_HWNDFIRST = 0
Global Const GW_HWNDLAST = 1
Global Const GW_HWNDNEXT = 2
Global Const GW_HWNDPREV = 3
Global Const GW_OWNER = 4
Global Const GW_CHILD = 5

' WindowState
Global Const NORMAL = 0    ' 0 - Normal
Global Const MINIMIZED = 1 ' 1 - Minimized
Global Const MAXIMIZED = 2 ' 2 - Maximized

' System Color(s)
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.

' Raster-ops (Ternary)
Global Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Global Const SRCPAINT = &HEE0086  ' (DWORD) dest = source OR dest
Global Const SRCAND = &H8800C6  ' (DWORD) dest = source AND dest
Global Const SRCINVERT = &H660046 ' (DWORD) dest = source XOR dest
Global Const SRCERASE = &H440328  ' (DWORD) dest = source AND (NOT dest )
Global Const NOTSRCCOPY = &H330008  ' (DWORD) dest = (NOT source)
Global Const NOTSRCERASE = &H1100A6 ' (DWORD) dest = (NOT src) AND (NOT dest)
Global Const MERGECOPY = &HC000CA ' (DWORD) dest = (source AND pattern)
Global Const MERGEPAINT = &HBB0226  ' (DWORD) dest = (NOT source) OR dest
Global Const PATCOPY = &HF00021 ' (DWORD) dest = pattern
Global Const PATPAINT = &HFB0A09  ' (DWORD) dest = DPSnoo
Global Const PATINVERT = &H5A0049 ' (DWORD) dest = pattern XOR dest
Global Const DSTINVERT = &H550009 ' (DWORD) dest = (NOT dest)
Global Const BLACKNESS = &H42&  ' (DWORD) dest = BLACK
Global Const WHITENESS = &HFF0062 ' (DWORD) dest = WHITE

' StretchBlt() Modes
Global Const BLACKONWHITE = 1
Global Const WHITEONBLACK = 2
Global Const COLORONCOLOR = 3

' Pen Styles
Global Const PS_SOLID = 0
Global Const PS_DASH = 1        '  -------
Global Const PS_DOT = 2 '  .......
Global Const PS_DASHDOT = 3     '  _._._._
Global Const PS_DASHDOTDOT = 4  '  _.._.._
Global Const PS_NULL = 5
Global Const PS_INSIDEFRAME = 6

' ScaleMode
Global Const USER = 0        ' 0 - User
Global Const TWIPS = 1       ' 1 - Twip
Global Const POINTS = 2      ' 2 - Point
Global Const PIXELS = 3      ' 3 - Pixel
Global Const CHARACTERS = 4  ' 4 - Character
Global Const INCHES = 5      ' 5 - Inch
Global Const MILLIMETERS = 6 ' 6 - Millimeter
Global Const CENTIMETERS = 7 ' 7 - Centimeter

' GetSystemMetrics() codes
Global Const SM_CXSCREEN = 0
Global Const SM_CYSCREEN = 1
Global Const SM_CXVSCROLL = 2
Global Const SM_CYHSCROLL = 3
Global Const SM_CYCAPTION = 4
Global Const SM_CXBORDER = 5
Global Const SM_CYBORDER = 6
Global Const SM_CXDLGFRAME = 7
Global Const SM_CYDLGFRAME = 8
Global Const SM_CYVTHUMB = 9
Global Const SM_CXHTHUMB = 10
Global Const SM_CXICON = 11
Global Const SM_CYICON = 12
Global Const SM_CXCURSOR = 13
Global Const SM_CYCURSOR = 14
Global Const SM_CYMENU = 15
Global Const SM_CXFULLSCREEN = 16
Global Const SM_CYFULLSCREEN = 17
Global Const SM_CYKANJIWINDOW = 18
Global Const SM_MOUSEPRESENT = 19
Global Const SM_CYVSCROLL = 20
Global Const SM_CXHSCROLL = 21
Global Const SM_DEBUG = 22
Global Const SM_SWAPBUTTON = 23
Global Const SM_RESERVED1 = 24
Global Const SM_RESERVED2 = 25
Global Const SM_RESERVED3 = 26
Global Const SM_RESERVED4 = 27
Global Const SM_CXMIN = 28
Global Const SM_CYMIN = 29
Global Const SM_CXSIZE = 30
Global Const SM_CYSIZE = 31
Global Const SM_CXFRAME = 32
Global Const SM_CYFRAME = 33
Global Const SM_CXMINTRACK = 34
Global Const SM_CYMINTRACK = 35
Global Const SM_CMETRICS = 36

Sub DisplayStatus (StatTxt$)

  'Update status bar on main form
    If frmMain!pStatus <> StatTxt$ Then
      frmMain!pStatus = StatTxt$
    End If

End Sub

Sub mdiArrange (method%)
  
  'Use the MDI Arrange methods rather than VB's because it can
  'ignore disabled (hidden) children.
    Dim Ret%
    Select Case method
      Case WM_MDICASCADE
	Ret = SendMessage(GetWindow(frmMain.hWnd, GW_CHILD), WM_MDICASCADE, MDITILE_SKIPDISABLED, 0&)
      Case MDITILE_HORIZONTAL
	Ret = SendMessage(GetWindow(frmMain.hWnd, GW_CHILD), WM_MDITILE, MDITILE_HORIZONTAL Or MDITILE_SKIPDISABLED, 0&)
      Case MDITILE_VERTICAL
	Ret = SendMessage(GetWindow(frmMain.hWnd, GW_CHILD), WM_MDITILE, MDITILE_VERTICAL Or MDITILE_SKIPDISABLED, 0&)
      Case WM_MDIICONARRANGE
	Ret = SendMessage(GetWindow(frmMain.hWnd, GW_CHILD), WM_MDIICONARRANGE, MDITILE_SKIPDISABLED, 0&)
    End Select

End Sub

Sub mdiBitBltCentered (sWnd%, sDC%, dWnd%)
  
  'Initialize some variables
    Dim nRet%, cDC%, cWnd%, dX%, dY%
    Dim sR As Rect, dR As Rect

  'get DC to client space (assumes we're Blt'ing onto an MDI client space)
    cWnd = GetWindow(dWnd, GW_CHILD)
    cDC = GetDC(cWnd)
  
  'Get source and destination rectangles
    Call GetClientRect(sWnd, sR)
    Call GetClientRect(cWnd, dR)

  'Calc parameters
    dX = (dR.Right - sR.Right) \ 2
    dY = (dR.Bottom - sR.Bottom) \ 2

  'Do it
    nRet = BitBlt(cDC, dX, dY, sR.Right, sR.Bottom, sDC, 0, 0, SRCCOPY)

  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiBitBltTiled (sWnd%, sDC%, dWnd%)
  
  'Initialize some variables
    Dim nRet%, cDC%, cWnd%, dX%, dY%
    Dim Rows%, Cols%, I%, j%
    Dim sR As Rect, dR As Rect

  'get DC to client space (assumes we're Blt'ing onto an MDI client space)
    cWnd = GetWindow(dWnd, GW_CHILD)
    cDC = GetDC(cWnd)
  
  'Get source and destination rectangles
    Call GetClientRect(sWnd, sR)
    Call GetClientRect(cWnd, dR)

  'Calc parameters
    Rows = dR.Right \ sR.Right
    Cols = dR.Bottom \ sR.Bottom

  'Spray out across destination
    For I = 0 To Rows
      dX = I * sR.Right
      For j = 0 To Cols
	dY = j * sR.Bottom
	nRet = BitBlt(cDC, dX, dY, sR.Right, sR.Bottom, sDC, 0, 0, SRCCOPY)
      Next j
    Next I

  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiEnforceHidden ()
  
  'Required because when one child is maximized, then restored,
  'the "hidden" children are again visible (sometimes).
  Dim I%, Ret%
  For I = 1 To UBound(fState)
    If Not fDoc(I)!mMain(0).Visible Then
      'Child menu not visible, so child shouldn't be either!
	Ret% = ShowWindow(fDoc(I).hWnd, SW_HIDE)
    End If
  Next I

End Sub

Function mdiFreeIndex () As Integer
    
  Dim I%, ArrayCount%
  ArrayCount = UBound(fDoc)

  ' Cycle throught the document array. If one of the
  ' documents has been deleted, then return that index
  For I = 1 To ArrayCount
    If fState(I) = frmDeleted Then
      mdiFreeIndex = I
      Exit Function
    End If
  Next

  ' If none of the elements in the document array have
  ' been deleted, then increment the document and the
  ' state arrays by one and return the index to the
  ' new element.
  ReDim Preserve fDoc(ArrayCount + 1)
  ReDim Preserve fState(ArrayCount + 1)
  mdiFreeIndex = UBound(fDoc)

End Function

Sub mdiHide (Frm As Form)
  
    Dim I%, Ret%
  'Hidden maximized is *asking* for trouble!
    If Frm.WindowState = MAXIMIZED Then
      Frm.WindowState = NORMAL
    End If

  'Hide menu so it won't show up on parent if it's
  'the last hidden form, then disable & hide form.
    Frm.Enabled = False
    Ret% = ShowWindow(Frm.hWnd, SW_HIDE)
    For I = 0 To HiMenu
      Frm!mMain(I).Visible = False
    Next I
  
  'Set focus to next child
    Ret = SendMessage(GetWindow(frmMain.hWnd, GW_CHILD), WM_MDINEXT, 0, 0&)

End Sub

Sub mdiNew ()

  'Get first available index into forms arrays
    Dim fIndex%
    fIndex = mdiFreeIndex()
  
  'Set new child's state
    fState(fIndex) = frmVisible

  'Implicitly load and set properties
    fDoc(fIndex).Caption = "Child:" & Format(fIndex)
    fDoc(fIndex).Tag = fIndex
    fDoc(fIndex).Refresh
    fDoc(fIndex)!mMain(0).Caption = "&" & fDoc(fIndex).Caption
    fDoc(fIndex)!mForm(0).Caption = fDoc(fIndex)!mForm(0).Caption & fDoc(fIndex).Caption
    fDoc(fIndex)!mForm(1).Caption = fDoc(fIndex)!mForm(1).Caption & fDoc(fIndex).Caption

End Sub

Sub mdiPaintGradiant (hWndParent%)

  'initialize some vars
    Const Shades% = 64
    Dim cWnd%, cDC%, nRet%, I%
    Dim FillBoxHeight%
    Dim cRect As Rect
    Dim NewBrush%
    Static fRect(1 To Shades) As Rect

  'get DC to client space
    cWnd = GetWindow(hWndParent, GW_CHILD)
    cDC = GetDC(cWnd)
  
  'set up a structure of rectangles for fills
    Call GetClientRect(cWnd, cRect)
    FillBoxHeight = cRect.Bottom \ Shades
    For I = 1 To Shades
      fRect(I).Left = cRect.Left
      fRect(I).Right = cRect.Right
      fRect(I).Top = (I - 1) * FillBoxHeight
      fRect(I).Bottom = fRect(I).Top + FillBoxHeight
    Next I

  'make up for slop on last one
    fRect(Shades).Bottom = cRect.Bottom

  'fill-er-up!
    For I = Shades - 1 To 0 Step -1
      NewBrush = CreateSolidBrush(RGB(0, 0, (I + 1) * 4 - 1))
      nRet = FillRect(cDC, fRect(Shades - I), NewBrush)
      nRet = DeleteObject(NewBrush)
    Next I
  
  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiPaintSolid (hWndParent%, FillColor&)

  Dim cWnd%, cDC%, nRet%
  Dim cRect As Rect
  Dim NewBrush%, OldBrush%
  Dim NewPen%, OldPen%

  cWnd = GetWindow(hWndParent, GW_CHILD)
  cDC = GetDC(cWnd)
  
  NewBrush = CreateSolidBrush(FillColor)
  OldBrush = SelectObject(cDC, NewBrush)
  NewPen = CreatePen(PS_SOLID, 1, FillColor)
  OldPen = SelectObject(cDC, NewPen)

  Call GetClientRect(cWnd, cRect)
  nRet = Rectangle(cDC, cRect.Left, cRect.Top, cRect.Right, cRect.Bottom)
  
  nRet = SelectObject(cDC, OldBrush)
  nRet = DeleteObject(NewBrush)
  nRet = SelectObject(cDC, OldPen)
  nRet = DeleteObject(NewPen)
  nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiPaintTunnel1 (hWndParent%)

  'initialize some vars
    Const Shades% = 64
    Dim cWnd%, cDC%, nRet%, I%
    Dim dX%, dY%
    Dim cRect As Rect
    Dim NewBrush%

  'get DC and rectangle of client space
    cWnd = GetWindow(hWndParent, GW_CHILD)
    cDC = GetDC(cWnd)
    Call GetClientRect(cWnd, cRect)
    dX% = cRect.Right / Shades \ 2
    dY% = cRect.Bottom / Shades \ 2

  'fill-er-up!
    For I = Shades - 1 To 0 Step -1
      NewBrush = CreateSolidBrush(RGB((I + 1) * 4 - 1, 0, 0))
      nRet = FillRect(cDC, cRect, NewBrush)
      nRet = DeleteObject(NewBrush)
      InflateRect cRect, -dX, -dY
    Next I
  
  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiPaintTunnel2 (hWndParent%)

  'initialize some vars
    Const Shades% = 32
    Dim cWnd%, cDC%, nRet%, I%
    Dim dX%, dY%
    Dim cRect As Rect
    Dim NewBrush%, eRgn%

  'get DC and rectangle of client space
    cWnd = GetWindow(hWndParent, GW_CHILD)
    cDC = GetDC(cWnd)
    Call GetClientRect(cWnd, cRect)
    dX% = cRect.Right / Shades / 2
    dY% = cRect.Bottom / Shades / 2

  'fill background
    NewBrush = CreateSolidBrush(RGB(0, 255, 0))
    nRet = FillRect(cDC, cRect, NewBrush)
    nRet = DeleteObject(NewBrush)

  'fill-er-up!
    For I = Shades - 1 To 0 Step -1
      NewBrush = CreateSolidBrush(RGB(0, (I + 1) * 8 - 8, 0))
      eRgn = CreateEllipticRgn(cRect.Left, cRect.Top, cRect.Right, cRect.Bottom)
      nRet = FillRgn(cDC, eRgn, NewBrush)
      nRet = DeleteObject(NewBrush)
      nRet = DeleteObject(eRgn)
      Call InflateRect(cRect, -dX, -dY)
    Next I
  
  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiSetBkColor (hWndParent%, NewBkColor&)

  Dim cWnd%, cDC%, lRet&, nRet%
  cWnd = GetWindow(hWndParent, GW_CHILD)
  cDC = GetDC(cWnd)
  lRet = SetBkColor(cDC, NewBkColor&)
  Debug.Print Hex$(lRet)
  nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiShowAll ()
  
  'Use ShowWindow API to make all "hidden" children visible again
    Dim I%, j%, Ret%
    For I = 1 To UBound(fState)
      If fState(I) <> frmDeleted Then
	If IsWindowVisible(fDoc(I).hWnd) = False Then
	  'Set menus visible again
	    For j = 0 To HiMenu
	      fDoc(I)!mMain(j).Visible = True
	    Next j
	  'Unhide child
	    Ret% = ShowWindow(fDoc(I).hWnd, SW_SHOWNA)
	  'Reenable child and set focus to it
	    fDoc(I).Enabled = True
	    fDoc(I).SetFocus
	End If
      End If
    Next I

End Sub

Sub mdiStretchBlt (sWnd%, sDC%, dWnd%, Proportional%)

  'Initialize some variables
    Dim nRet%, cDC%, cWnd%
    Dim sR As Rect, dR As Rect
    Dim fac!, dX%, dY%

  'get DC to client space (assumes we're Blt'ing onto an MDI client space)
    cWnd = GetWindow(dWnd, GW_CHILD)
    cDC = GetDC(cWnd)
  
  'Get source and destination rectangles
    Call GetClientRect(sWnd, sR)
    Call GetClientRect(cWnd, dR)

  'Alter destination if proportional
    If Proportional Then
      If dR.Bottom / sR.Bottom < dR.Right / sR.Right Then
	'Height is constraining dimension
	fac! = dR.Bottom / sR.Bottom
	dX = (dR.Right - (fac! * sR.Right)) \ -2
      Else
	'Width is constraining dimension
	fac! = dR.Right / sR.Right
	dY = (dR.Bottom - (fac! * sR.Bottom)) \ -2
      End If
      InflateRect dR, dX, dY
    End If
  
  'Stretch out across destination
    nRet = StretchBlt(cDC, dR.Left, dR.Top, dR.Right - dR.Left, dR.Bottom - dR.Top, sDC, 0, 0, sR.Right, sR.Bottom, SRCCOPY)

  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub mdiTextOut (dWnd%, Text$, dX%, dY%)

  'Initialize some vars
    Dim nRet%, cWnd%, cDC%

  'Get DC to client space (assumes we're Blt'ing onto an MDI client space)
    cWnd = GetWindow(dWnd, GW_CHILD)
    cDC = GetDC(cWnd)

  'Do it!
    nRet = TextOut(cDC, dX, dY, Text$, Len(Text$))
  
  'and clean up
    nRet = ReleaseDC(cWnd, cDC)

End Sub

Sub StretchBltPictToForm (Source As PictureBox, Destination As Form)

  'Initialize some variables
    Dim Ret%, sDC%, dDC%, sSM%, dSM%
    Dim sW%, sH%, dW%, dH%
  
  'Store scalemodes, set to PIXELS
    sSM = Source.ScaleMode
    dSM = Destination.ScaleMode
    Source.ScaleMode = PIXELS
    Destination.ScaleMode = PIXELS

  'Calc parameters
    dDC = Destination.hDC
    dH = Destination.ScaleHeight
    dW = Destination.ScaleWidth
    sDC = Source.hDC
    sH = Source.ScaleHeight
    sW = Source.ScaleWidth

  'Stretch out across destination
    Ret = StretchBlt(dDC, 0, 0, dW, dH, sDC, 0, 0, sW, sH, SRCCOPY)

  'Restore original scalemodes
    Source.ScaleMode = sSM
    Destination.ScaleMode = dSM

End Sub

Sub StretchImageToForm (Source As Image, Target As Form)

  'Initialize some vars
    Dim h1%, h2%, w1%, w2%
    Dim newLeft%, newTop%, newWidth%, newHeight%

  'Use variables rather than properties for speed
    h1 = Target.ScaleHeight
    h2 = Source.Height
    w1 = Target.ScaleWidth
    w2 = Source.Width

  'Set new size so as not to warp proportions
    If h1 / h2 < w1 / w2 Then 'Height is constraining dimension
      newWidth = ((h1 / h2) * w2)
      newLeft = (w1 - newWidth) \ 2
      Source.Move newLeft, 0, newWidth, h1
    Else 'Width is constraining dimension
      newHeight = ((w1 / w2) * h2)
      newTop = (h1 - newHeight) \ 2
      Source.Move 0, newTop, w1, newHeight
    End If

End Sub

Sub TiledBitBltPictToForm (Source As PictureBox, Destination As Form)

  'Assumes Source is not visible

  'Initialize some variables
    Dim Ret%, sDC%, dDC%, sSM%, dSM%
    Dim sX%, sY%, sW%, sH%, dX%, dY%
    Dim Rows%, Cols%, I%, j%
  
  'Store scalemodes, set to PIXELS
    sSM = Source.ScaleMode
    dSM = Destination.ScaleMode
    Source.ScaleMode = PIXELS
    Destination.ScaleMode = PIXELS

  'Calc parameters
    sDC = Source.hDC
    dDC = Destination.hDC
    sH = Source.ScaleHeight
    sW = Source.ScaleWidth
    Rows = Destination.ScaleWidth \ sW
    Cols = Destination.ScaleHeight \ sH

  'Spray out across destination
    For I = 0 To Rows
      dX = I * sW
      For j = 0 To Cols
	dY = j * sH
	Ret = BitBlt(dDC, dX, dY, sW, sH, sDC, sX, sY, SRCCOPY)
      Next j
    Next I

  'Restore original scalemodes
    Source.ScaleMode = sSM
    Destination.ScaleMode = dSM

End Sub

