#include <windows.h>
#include <stdio.h>
#include "visualib.h"
#include "vlibdemo.h"
#include "dialogs.h"

extern HINSTANCE	hInst;
static POINT3D	p3;
static POINT2D	p2;

BINARY _export DlgInputPoint3D (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x;

    switch (msg) {
		case WM_INITDIALOG:
			sprintf (buf, "%.3f", (REAL) p3.x);
			SetDlgItemText (hdlg, XCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p3.y);
			SetDlgItemText (hdlg, YCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p3.z);
			SetDlgItemText (hdlg, ZCOORD, buf);
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case IDOK:
					GetDlgItemText (hdlg, XCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.x = x;
					GetDlgItemText (hdlg, YCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.y = x;
					GetDlgItemText (hdlg, ZCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.z = x;
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BINARY	InputPoint3D (LPPOINT3D p)
{
	BOOL	flag;
	
	p3 = *p;
	flag = DialogBox (hInst, MAKEINTRESOURCE(DLGSETPOINT3D), NULL, DlgInputPoint3D) > 0;
	if (flag)
		*p = p3;
	return (flag);
}

BINARY _export DlgInputPoint2D (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x;

    switch (msg) {
		case WM_INITDIALOG:
			sprintf (buf, "%.3f", (REAL) p2.x);
			SetDlgItemText (hdlg, XCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p2.y);
			SetDlgItemText (hdlg, YCOORD, buf);
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case IDOK:
					GetDlgItemText (hdlg, XCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p2.x = x;
					GetDlgItemText (hdlg, YCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p2.y = x;
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BINARY	InputPoint2D (LPPOINT2D p)
{
	BOOL	flag;
	
	p2 = *p;
	flag = DialogBox (hInst, MAKEINTRESOURCE(DLGSETPOINT2D), NULL, DlgInputPoint2D) > 0;
	if (flag)
		*p = p2;
	return (flag);
}

BINARY	DlgLightSetup (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x;
	int lighton;
	COLORREF color;
	VECTOR3 loc, dir;

    switch (msg) {
		case WM_INITDIALOG:
			ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, TRUE, loc);
			ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, TRUE, dir);
			lighton = SwitchLight (VL_CURRENT, VL_INQUIRE);
			
			sprintf (buf, "%.3f", (REAL) loc[0]);
			SetDlgItemText (hdlg, LIGHTLOCX, buf);
			sprintf (buf, "%.3f", (REAL) loc[1]);
			SetDlgItemText (hdlg, LIGHTLOCY, buf);
			sprintf (buf, "%.3f", (REAL) loc[2]);
			SetDlgItemText (hdlg, LIGHTLOCZ, buf);
			
			sprintf (buf, "%.3f", (REAL) dir[0]);
			SetDlgItemText (hdlg, LIGHTDIRX, buf);
			sprintf (buf, "%.3f", (REAL) dir[1]);
			SetDlgItemText (hdlg, LIGHTDIRY, buf);
			sprintf (buf, "%.3f", (REAL) dir[2]);
			SetDlgItemText (hdlg, LIGHTDIRZ, buf);

			CheckDlgButton (hdlg, LIGHTON, lighton);
			
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case LIGHTCOLOR:
					color = ShadingColor
						(VL_CURRENT, VL_LIGHTCOLOR, VL_INQUIRE);
					color = SelectColor (color);
					ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, color);
					return (TRUE);
			
				case IDOK:
					GetDlgItemText (hdlg, LIGHTLOCX, buf, 20);
					if (sscanf (buf, "%f", &x))
						loc[0] = x;
					GetDlgItemText (hdlg, LIGHTLOCY, buf, 20);
					if (sscanf (buf, "%f", &x))
						loc[1] = x;
					GetDlgItemText (hdlg, LIGHTLOCZ, buf, 20);
					if (sscanf (buf, "%f", &x))
						loc[2] = x;
					
					GetDlgItemText (hdlg, LIGHTDIRX, buf, 20);
					if (sscanf (buf, "%f", &x))
						dir[0] = x;
					GetDlgItemText (hdlg, LIGHTDIRY, buf, 20);
					if (sscanf (buf, "%f", &x))
						dir[1] = x;
					GetDlgItemText (hdlg, LIGHTDIRZ, buf, 20);
					if (sscanf (buf, "%f", &x))
						dir[2] = x;
					
					lighton = IsDlgButtonChecked (hdlg, LIGHTON);
					
					ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, loc);
					ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, dir);
					SwitchLight (VL_CURRENT, lighton);
					
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}


BINARY DlgMaterial (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	COLORREF color;
	
    switch (msg) {
		case WM_INITDIALOG:
			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case MATDIFFUSE:
					color = ShadingColor
						(VL_CURRENT, VL_MATERIALDIFFUSE, VL_INQUIRE);
					color = SelectColor (color);
					ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, color);
					return (TRUE);
				case MATAMBIENT:
					color = ShadingColor
						(VL_CURRENT, VL_MATERIALAMBIENT, VL_INQUIRE);
					color = SelectColor (color);
					ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, color);
					return (TRUE);
				case MATSPECULAR:
					color = ShadingColor
						(VL_CURRENT, VL_MATERIALSPECULAR, VL_INQUIRE);
					color = SelectColor (color);
					ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, color);
					return (TRUE);
				case MATEMISSION:
					color = ShadingColor
						(VL_CURRENT, VL_MATERIALEMISSION, VL_INQUIRE);
					color = SelectColor (color);
					ShadingColor (VL_CURRENT, VL_MATERIALEMISSION, color);
					return (TRUE);
			
				case IDOK:
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}


BINARY	DlgTexture (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	static int texture = TEXTURENONE;
	static int check1, check2, check3, check4;
	
    switch (msg) {
		case WM_INITDIALOG:
			CheckRadioButton (hdlg, TEXTURENONE, TEXTUREGRANITE, texture);
			check1 = ShadingOption(VL_CURRENT,VL_PERTURBMATERIAL,VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK1, check1);
			check2 = ShadingOption(VL_CURRENT,VL_PERTURBNORMAL,VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK2, check2);
			check3 = ShadingOption(VL_CURRENT,VL_PERTURBPIXEL,VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK3, check3);
			check4 = ShadingOption(VL_CURRENT,VL_PERTURBFACET,VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK4, check4);
			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case TEXTURENONE:
				case TEXTUREMARBLE:
				case TEXTUREWOOD:
				case TEXTUREGRANITE:
					texture = wp;
					CheckRadioButton (hdlg, TEXTURENONE, TEXTUREWOOD, wp);
					return (TRUE);
				case IDC_CHECK1:
					check1 = !check1;
					CheckDlgButton (hdlg, IDC_CHECK1, check1);
					break;
				case IDC_CHECK2:
					check2 = !check2;
					CheckDlgButton (hdlg, IDC_CHECK2, check2);
					break;
				case IDC_CHECK3:
					check3 = !check3;
					CheckDlgButton (hdlg, IDC_CHECK3, check3);
					break;
				case IDC_CHECK4:
					check4 = !check4;
					CheckDlgButton (hdlg, IDC_CHECK4, check4);
					break;
				case IDOK:
					switch (texture) {
						case TEXTUREMARBLE:
							SolidTexture (VL_MARBLE);
							break;
						case TEXTUREWOOD:
							SolidTexture (VL_WOODGRAIN);
							break;
						case TEXTUREGRANITE:
							SolidTexture (VL_GRANITE);
							break;
						default:
							SolidTexture (VL_NONE);
							break;
					}
					ShadingOption(VL_CURRENT,VL_PERTURBMATERIAL,check1);
					ShadingOption(VL_CURRENT,VL_PERTURBNORMAL,check2);
					ShadingOption(VL_CURRENT,VL_PERTURBPIXEL,check3);
					ShadingOption(VL_CURRENT,VL_PERTURBFACET,check4);
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BINARY DlgShading (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	static int mode, mbutton;
	
    switch (msg) {
		case WM_INITDIALOG:
			mode = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_INQUIRE);
			switch (mode){
				case VL_WIREFRAME:
                    mbutton = WIREFRAME;
                    break;
                case VL_SOLIDFILL:
                    mbutton = SOLIDFILL;
                    break;
                case VL_FLATSHADE:
                    mbutton = FLATSHADING;
                    break;
                case VL_GOURAUDSHADE:
                    mbutton = GOURAUD;
                    break;
                case VL_PHONGSHADE:
                    mbutton = PHONG;
                    break;
				case VL_SPECULARMODEL:
					break;
			}
			CheckRadioButton (hdlg, WIREFRAME, SPECULAR, mbutton);
			
			CheckDlgButton (hdlg, DEPTHBUFFER,
				ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, VL_INQUIRE));
			CheckDlgButton (hdlg, LOCALVIEWER,
				ShadingOption (VL_CURRENT, VL_LOCALVIEWER, VL_INQUIRE));
			CheckDlgButton (hdlg, TWOSIDE,
				ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, VL_INQUIRE));
			CheckDlgButton (hdlg, BACKFACEREM,
				ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, VL_INQUIRE));

			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case WIREFRAME:
                case SOLIDFILL:
                case FLATSHADING:
                case GOURAUD:
                case PHONG:
				case SPECULAR:
					mbutton = wp;
					CheckRadioButton (hdlg, WIREFRAME, SPECULAR, wp);
					return (TRUE);
			
				case IDOK:
					switch (mbutton) {
						case WIREFRAME:
							mode = VL_WIREFRAME;
							break;
						case SOLIDFILL:
							mode = VL_SOLIDFILL;
							break;
						case FLATSHADING:
							mode = VL_FLATSHADE;
							break;
						case GOURAUD:
							mode = VL_GOURAUDSHADE;
							break;
						case PHONG:
							mode = VL_PHONGSHADE;
							break;
						case SPECULAR:
							mode = VL_PHONGSHADE;
							break;
				    }
					ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, mode);
					
					ShadingOption (VL_CURRENT, VL_DEPTHBUFFER,
						IsDlgButtonChecked (hdlg, DEPTHBUFFER));
					ShadingOption (VL_CURRENT, VL_LOCALVIEWER,
						IsDlgButtonChecked (hdlg, LOCALVIEWER));
					ShadingOption (VL_CURRENT, VL_TWOSIDESHADE,
						IsDlgButtonChecked (hdlg, TWOSIDE));
					ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL,
						IsDlgButtonChecked (hdlg, BACKFACEREM));

					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}
