VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Wave VBX Start/End Sample"
   ClientHeight    =   3135
   ClientLeft      =   1650
   ClientTop       =   1920
   ClientWidth     =   4095
   Height          =   3540
   Left            =   1590
   LinkTopic       =   "Form1"
   ScaleHeight     =   3135
   ScaleWidth      =   4095
   Top             =   1575
   Width           =   4215
   Begin Timer Timer1 
      Interval        =   50
      Left            =   3000
      Top             =   0
   End
   Begin TextBox txtPosition 
      Height          =   285
      Left            =   240
      TabIndex        =   9
      Top             =   1200
      Width           =   3615
   End
   Begin TextBox txtEnd 
      Height          =   285
      Left            =   2160
      TabIndex        =   7
      Top             =   1800
      Width           =   1695
   End
   Begin TextBox txtStart 
      Height          =   285
      Left            =   240
      TabIndex        =   5
      Top             =   1800
      Width           =   1695
   End
   Begin MabryWave Wave1 
      Exclusive       =   0   'False
      FileLength      =   -1
      Filename        =   ""
      Left            =   3480
      Loop            =   0   'False
      LoopCount       =   0   'False
      PlayEnd         =   -1
      PlayStart       =   -1
      Top             =   0
   End
   Begin TextBox txtFilename 
      Height          =   285
      Left            =   240
      TabIndex        =   2
      Text            =   "C:\WINDOWS\RINGOUT.WAV"
      Top             =   480
      Width           =   3615
   End
   Begin CommandButton btnStop 
      Caption         =   "Stop"
      Height          =   615
      Left            =   2040
      TabIndex        =   1
      Top             =   2280
      Width           =   1815
   End
   Begin CommandButton btnPlay 
      Caption         =   "Play"
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   2280
      Width           =   1815
   End
   Begin Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Position:"
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   960
      Width           =   1215
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "End:"
      Height          =   255
      Left            =   2160
      TabIndex        =   6
      Top             =   1560
      Width           =   1215
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Start:"
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   1560
      Width           =   1215
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Filename:"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   240
      Width           =   1935
   End
End
Option Explicit

Dim fChanged As Integer ' flag: has filename changed?

Sub btnPlay_Click ()
    ' make sure the filename is up to date
    SetFilename

    ' check for start field
    If Trim(txtStart) <> "" Then
        Wave1.PlayStart = Val(txtStart)
    Else
        Wave1.PlayStart = -1
    End If

    ' check for end field
    If Trim(txtEnd) <> "" Then
        Wave1.PlayEnd = Val(txtEnd)
    Else
        Wave1.PlayEnd = -1
    End If

    ' play the file
    Wave1.Action = 1
    EnableButtons
End Sub

Sub btnStop_Click ()
    ' stop playing
    Wave1.Action = 4

    ' update buttons
    EnableButtons
End Sub

Sub EnableButtons ()
    Select Case Wave1.Status
        Case 1: ' playing
            btnStop.Enabled = True

        Case 2: ' paused
            btnStop.Enabled = True

        Case 4: ' stopped
            btnStop.Enabled = False
    End Select
End Sub

Sub Form_Load ()
    fChanged = True
    EnableButtons
End Sub

Sub SetFilename ()
    ' if the filename has changed, tell Wave VBX
    If fChanged Then
        ' changed no more
        fChanged = False
        Wave1.Filename = txtFilename
    End If
End Sub

Sub Timer1_Timer ()
    If Wave1.Position = -1 Then
        txtPosition = ""
    Else
        txtPosition = Format(Wave1.Position / 1000, "0.000") & " seconds"
    End If
End Sub

Sub txtFilename_Change ()
    fChanged = True
End Sub

Sub Wave1_PlayDone ()
    EnableButtons
End Sub

