// Contents ---------------------------------------------------------------
//
//   dialogs.c -- Dialog functions
//
//   Version 1.0, a Windows Socket Finger Daemon
//
//   Copyright (C) Frederick W. Bent 1994
//   All rights reserved.
//
//
// Description
//
//
// Ends -------------------------------------------------------------------

// History ----------------------------------------------------------------
//
// 6/28/94  1.0  Fred Bent	Wrote this thing
//
// Ends -------------------------------------------------------------------

// Interface Dependencies -------------------------------------------------

#define STRICT

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <ctl3d.h>
#include "fingerd.h"
#include "strlib.h"
#include "file.h"

#pragma warn -par
// End Interface Dependencies ---------------------------------------------

char szFileSpec[MAX_PATH];
char szFileName[MAX_PATH];
int  wFileAttr = DDL_DIRECTORY;

// External Declarations --------------------------------------------------

extern    SOCKET  	sListen;	// awaits connection requests
extern    char szNetworkClass[];    	// class name of network window
extern	  char szAppName[];
extern	char szLocalHostName[];

extern    HWND	hwndMain;      // handle of main window
extern    HWND	hwndNetwork;   // our invisible network "window"
extern    HINSTANCE	hInst;         // our main instance

extern    char szLocalFile[MAX_PATH];	    	// filename
extern 	  char szFileDir[MAX_PATH];
extern	  char szHelpFileName[MAX_PATH];
extern    int  iDebugLevel;
extern	  BOOL bOnlySnark;


// End External Declarations ----------------------------------------------


// Server Implementation --------------------------------------------------

// Window Function

	LRESULT DoMenuAbout(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "About..." menu selection by invoking the "About"
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Ends -------------------------------------------------------------------

	{
		DLGPROC lpProcAbout;

		lpProcAbout = (DLGPROC) MakeProcInstance((FARPROC)AboutDlgProc, hInst);
		DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
		FreeProcInstance((FARPROC)lpProcAbout);

		return(FALSE);
	}


// Windows Function

	LRESULT DoMenuHelp(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "Help" menu selection by invoking the error dialog box
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Ends -------------------------------------------------------------------

	{

	   WinHelp(hWnd,szHelpFileName,HELP_INDEX,0L);

//		MessageBox(hWnd, "Help not yet implemented.", szAppName, MB_ICONINFORMATION | MB_OK );

		return(FALSE);
	}

// Windows Function

	LRESULT DoMenuExit(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "Help" menu selection by invoking the error dialog box
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Ends -------------------------------------------------------------------

	{
		SendMessage(hWnd, WM_CLOSE, 0, 0L);

		return(FALSE);
	}


// Dialog Box Function

	BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
//	The callback function for the "About" dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Returns
//
//	BOOL	TRUE if the message was processed, otherwise FALSE (zero)
//		if the message was not processed.
//
// Ends -------------------------------------------------------------------

	{
		switch(Msg)
		{
			default: return FALSE;

			case WM_INITDIALOG:
                        	return TRUE;

			case WM_SYSCOLORCHANGE:
#ifdef USE_CTL3D
				Ctl3dColorChange();
#endif
				break;

			case WM_COMMAND:
			{
				switch(wParam)
				{
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg, TRUE);
					break;

				default : return FALSE;
				}
			} // WM_COMMAND
		}
		return TRUE;
	}

// Window Function

	LRESULT DoMenuOptions(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "About..." menu selection by invoking the "About"
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Ends -------------------------------------------------------------------

	{
		DLGPROC lpProcOptions;

		lpProcOptions = (DLGPROC) MakeProcInstance((FARPROC)DlgProc, hInst);
		DialogBox(hInst, "DLGFINGERSRV", hWnd, lpProcOptions);
		FreeProcInstance((FARPROC)lpProcOptions);

		return(FALSE);
	}


// Dialog Box Function

	BOOL CALLBACK DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "Options..." menu selection by invoking the "Options"
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Returns
//
//	BOOL	TRUE if the message was processed, otherwise FALSE (zero)
//		if the message was not processed.
//
// Ends -------------------------------------------------------------------

	{
	    switch (Msg)
	    {
		default:
			return FALSE;

		case WM_SYSCOLORCHANGE:
#ifdef USE_CTL3D
			Ctl3dColorChange();
#endif
			break;

		case WM_INITDIALOG:
		{
			iDebugLevel = GetPrivateProfileInt( SECTION_MAIN
					, ENTRY_DEBUG
					, DEBUG_OFF
					, (LPCSTR) INI_FILE);

			if ( iDebugLevel == 0 )
				CheckRadioButton(hDlg,IDR_NORMAL, IDR_DEBUG, IDR_NORMAL);
			else
				CheckRadioButton(hDlg,IDR_NORMAL, IDR_DEBUG, IDR_DEBUG);

			SetDlgItemText(hDlg, IDE_PATH, (LPSTR) szLocalFile);
//			SetDlgItemText(hDlg, IDE_HOSTNAME, (LPSTR) "localhost");
                        SetDlgItemText(hDlg, IDE_HOSTNAME, (LPSTR) szLocalHostName);
			SetDlgItemText(hDlg, IDE_DIR, (LPSTR) szFileDir);
			DlgGetLogStrings(hDlg, IDL_LOG, MAXITEMS);
			bOnlySnark = GetPrivateProfileInt( SECTION_MAIN
					, ENTRY_ONLYSNARK
					, FALSE
					, (LPCSTR) INI_FILE);

			CheckDlgButton(hDlg, IDR_ONLYSNARK, bOnlySnark);

			EnableWindow(GetDlgItem(hDlg, IDB_DIR), FALSE);
			break;
		} // WM_INITDIALOG

		case WM_COMMAND:
		{
			switch(wParam)
			{
			case IDOK:
				if (iDebugLevel == 0)
				{
					WritePrivateProfileString(SECTION_MAIN
						, ENTRY_DEBUG
						, (LPSTR) "0"
						, (LPSTR) INI_FILE);
				} else {
					WritePrivateProfileString(SECTION_MAIN
						, ENTRY_DEBUG
						, (LPSTR) "1"
						, (LPSTR) INI_FILE);
				}

				bOnlySnark = IsDlgButtonChecked(hDlg, IDR_ONLYSNARK);
				if ( bOnlySnark )
				{
					WritePrivateProfileString(SECTION_MAIN
						, ENTRY_ONLYSNARK
						, (LPSTR) "1"
						, (LPSTR) INI_FILE);
				} else {
					WritePrivateProfileString(SECTION_MAIN
						, ENTRY_ONLYSNARK
						, (LPSTR) "0"
						, (LPSTR) INI_FILE);
				}

				WritePrivateProfileString(SECTION_MAIN
					, ENTRY_DEFAULTFILE
					, (LPSTR) szLocalFile
					, (LPSTR) INI_FILE);


				WritePrivateProfileString(SECTION_MAIN
					, ENTRY_DIR
					, (LPSTR) szFileDir
					, (LPSTR) INI_FILE);

				EndDialog(hDlg,TRUE);
				break;

			case IDCANCEL:
				EndDialog(hDlg,TRUE);
				break;

			case IDR_NORMAL:
				iDebugLevel = 0;
				break;

			case IDR_DEBUG:
				iDebugLevel = 1;
				break;

			case IDB_PATH:
                        	FileOpen(hDlg);
				SetDlgItemText(hDlg, IDE_PATH, (LPSTR) szLocalFile);
				break;

			case IDE_DIR:
			{
				switch(HIWORD(lParam))
				{
                                case EN_CHANGE:
					GetDlgItemText(hDlg, IDE_DIR, szFileDir, MAX_PATH);
					break;
				case EN_KILLFOCUS:
					if ( VerifyDir(szFileDir) )
                                        	Whine(hDlg, szFileDir);
//						OkMsgBox("Finger Dir", "Invalid Directory\n\n%s", (LPSTR)szFileDir);
					break;
                                }
                        }
			break;

/*			case IDB_DIR:
				DoFindDirDlg(hDlg, Msg, wParam, lParam);
//				DlgDirList(hDlg, szFileDir, NULL, IDE_DIR,  DDL_DIRECTORY);
//				SetDlgItemText(hDlg, IDE_DIR, (LPSTR) szFileDir);
				break;
*/

/*			case IDL_LOG:
				{
				HWND	hwndList;

				hwndList = (HWND) LOWORD(lParam);
				switch(HIWORD(lParam))
				{
				case LBN_ERRSPACE:
				case LBN_SELCHANGE:
				case LBN_DBLCLK:
				case LBN_SELCANCEL:
				case LBN_SETFOCUS:
				case LBN_KILLFOCUS: break;
				}
				break;
				}	// IDL_LOG
*/
			default: return FALSE;
			}
		} // WM_COMMAND
	    }

	    return TRUE;
	}


// Debugging Function

	void OkMsgBox(PSTR szCaption, PSTR szFormat, ...)

// Summary ----------------------------------------------------------------
//
//	Generates a message box with an OK button.
//
// Parameters
//
//	szCaption	Pointer to a title for the message box
//
//	szFormat	A format string for the message
//
//	...		A variable number of arguments
//
// Returns
//
//	nothing
//
// Ends -------------------------------------------------------------------


	{
		char	szBuffer[256];
		char	*pArgument;
		va_list	vaArgs;


		va_start(vaArgs, szFormat);
		wvsprintf((LPSTR)szBuffer, (LPSTR)szFormat, vaArgs);
//                MessageBeep(MB_OK);
		MessageBox(NULL, szBuffer, szCaption, MB_OK);
		
		va_end(vaArgs);
	}




// Debugging Function

	void Whine(HWND hWnd, PSTR szCaption)

// Summary ----------------------------------------------------------------
//
//	Generates a message box with an OK button.
//
// Parameters
//
//	szCaption	Pointer to a title for the message box
//
// Returns
//
//	nothing
//
// Ends -------------------------------------------------------------------


	{
		char	szBuffer[256];
		char	*pArgument;
		va_list	vaArgs;


		wsprintf((LPSTR)szBuffer, (LPSTR)"Invalid Directory:\n\n%s", (LPSTR)szCaption);
		MessageBeep(MB_ICONEXCLAMATION);
		MessageBox(hWnd, szBuffer, "Finger Users Directory", MB_ICONEXCLAMATION | MB_OK);
		
	}

// Callback function

	BOOL CALLBACK GetStrCallback(LPSTR lpString, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
//	Called by the string library to add each string to the list box
//
// Parameters
//
//	lpString	A far pointer to the string.
//
//	lParam		Argument to the function.
//
// Returns
//
//	BOOL		True if the string was added to the list box
//
// Ends -------------------------------------------------------------------


	{
		HWND	hDlg;
		UINT	nButton;
		LONG	lResult;

		hDlg = (HWND) HIWORD(lParam);
		nButton = LOWORD(lParam);
		lResult = SendDlgItemMessage(hDlg, nButton, LB_ADDSTRING, 0, (LPARAM) lpString);

		return TRUE;
	}


// Function

	void DlgGetLogStrings(HWND hDlg, UINT nButton, int iMax)

// Summary ----------------------------------------------------------------
//
//	Initializes the list box by using string library to add all of the
//	strings to the list box.
//
// Parameters
//
//	hDlg	Handle of the dialog window.
//
//	nButton	The ID of the list box
//
// Returns
//
//	nothing
//
// Ends -------------------------------------------------------------------


	{
		LPARAM	lParam;
		FARPROC lpfnGetStrCallback;

		lParam = MAKELPARAM(nButton,hDlg);
		lpfnGetStrCallback = MakeProcInstance((FARPROC)GetStrCallback, hInst);

		GetStrings(lpfnGetStrCallback, lParam);

	}



// Window Function

	LRESULT DoFindDirDlg(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
// 	Respond to "About..." menu selection by invoking the "About"
//	dialog box.
//
// Parameters
//
//	hWnd	Handle of the window.
//
//	Msg	Message.
//
//	wParam	First message paramter.
//
//	lParam	Second message parameter.
//
// Ends -------------------------------------------------------------------

	{
		DLGPROC lpProcAbout;

		lpProcAbout = (DLGPROC) MakeProcInstance((FARPROC)FindDirDlgProc, hInst);
		DialogBox(hInst, "FindDir", hWnd, lpProcAbout);
		FreeProcInstance((FARPROC)lpProcAbout);

		return(FALSE);
	}


BOOL CALLBACK FindDirDlgProc(HWND hDlg, UINT nMsg, WPARAM wParam, LPARAM lParam)
{
    switch (nMsg)
    {
	case WM_INITDIALOG:
		SendDlgItemMessage(hDlg, IDD_FNAME, EM_LIMITTEXT, 120, 0L);
		DlgDirList(hDlg, szFileSpec, IDD_FLIST, IDD_FPATH, wFileAttr );
		SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
		break;

	case WM_COMMAND:
		switch(wParam)
		{
		case IDD_FLIST:
			switch(HIWORD(lParam))
                        {
			case LBN_SELCHANGE:
				if (DlgDirSelect(hDlg, szFileName, IDD_FLIST))
					lstrcat(szFileName, szFileSpec);
				SetDlgItemText(hDlg,IDD_FNAME, szFileName);
				return TRUE;

			case LBN_DBLCLK:
				if (DlgDirSelect(hDlg, szFileName, IDD_FLIST))
				{
					lstrcat(szFileName, szFileSpec);
					DlgDirList(hDlg, szFileName, IDD_FLIST, IDD_FPATH, wFileAttr);
					SetDlgItemText(hDlg,IDD_FNAME,szFileSpec);
				}
				else
				{
					SetDlgItemText(hDlg,IDD_FNAME, szFileName);
                                        SendMessage(hDlg,WM_COMMAND, IDOK, 0L);
				}
				return TRUE;
			}
			break;


		case IDD_FNAME:
			if (HIWORD(lParam) == EN_CHANGE)
				EnableWindow(GetDlgItem(hDlg, IDOK),
					(BOOL) SendMessage((HWND)LOWORD(lParam), WM_GETTEXTLENGTH, 0, 0L) );
			return TRUE;

		case IDOK:
		{
			int nEditLen;
			char cLastChar;

			GetDlgItemText(hDlg, IDD_FNAME, szFileName, 120);

			nEditLen = lstrlen(szFileName);
			cLastChar = *AnsiPrev(szFileName, szFileName + nEditLen);

			if (cLastChar == '\\' || cLastChar == ':')
				lstrcat(szFileName, szFileSpec);

			if (lstrchr(szFileName, '*') || lstrchr(szFileName, '?'))
			{
				if (DlgDirList(hDlg,szFileName, IDD_FLIST, IDD_FPATH, wFileAttr))
				{
					lstrcpy(szFileSpec, szFileName);
					SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
				}
				return TRUE;
			}

			lstrcat(lstrcat(szFileName, "\\"), szFileSpec);

			if (DlgDirList(hDlg,szFileName,IDD_FLIST,IDD_FPATH,wFileAttr))
			{
				lstrcpy(szFileSpec,szFileName);
				SetDlgItemText(hDlg,IDD_FNAME,szFileSpec);
                                return TRUE;
			}

			szFileName[nEditLen] = '\0';


			EndDialog(hDlg, TRUE);
			return TRUE;
		}

		case IDCANCEL:
			EndDialog(hDlg, FALSE);
                        return TRUE;

		} // WM_COMMAND
        }
	return FALSE;
}
