#include <windows.h>
#include <windowsx.h>
#include "strlib.h"

HANDLE	hStrings[MAX_STRINGS];
int	aTotal = 0;


int	NumberOfStrings( void )
{
	return aTotal;
}

BOOL	AppendFirstString(LPSTR lpStringIn)
{
	HANDLE hString, hStringNew;
	LPSTR lpString, lpStringNew;
	int	i, nLength;

	if ( aTotal== 0 )
		return FALSE;

        hString = hStrings[0];
	lpString = GlobalLock(hString);
	nLength = lstrlen(lpStringIn);
        nLength += lstrlen(lpString);

	if ( NULL == (hStringNew = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (1 + nLength))))
		return FALSE;
	lpStringNew = GlobalLock(hStringNew);

        lstrcpy(lpStringNew, lpString);
	lstrcat(lpStringNew, lpStringIn);
	GlobalUnlock(hStringNew);

	hStrings[0] = hStringNew;

	GlobalUnlock(hString);
	GlobalFree(hString);

	return TRUE;
}



BOOL AddString(LPSTR lpStringIn)
{
	HANDLE hString;
	LPSTR lpString;
	int	i, nLength;

	if ( aTotal == (MAX_STRINGS - 1) )
		return FALSE;

	if ( 0 == (nLength = lstrlen(lpStringIn)))
		return FALSE;

	if ( NULL == (hString = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (1 + nLength))))
		return FALSE;

	lpString = GlobalLock(hString);
	lstrcpy(lpString, lpStringIn);
	GlobalUnlock(hString);

	for( i = aTotal; i > 0; i-- )
	{
		hStrings[i] = hStrings[i - 1];
	}
        hStrings[0] = hString;
	aTotal++;
	return TRUE;
}


BOOL	DeleteString(LPSTR lpStringIn)
{
	LPSTR	lpString;
	int	j, i, nCompare;

	if ( 0 == lstrlen(lpStringIn)) return FALSE;

	for ( i = 0; i < aTotal; i++ )
	{
		lpString = GlobalLock(hStrings[i]);
		nCompare = lstrcmp(lpString, lpStringIn);
		GlobalUnlock(hStrings[i]);
		if ( nCompare == 0 ) break;
	}
	if ( i == aTotal ) return FALSE;

	for ( j = i; j < aTotal; j++ )
		hStrings[j] = hStrings[j + 1];
	aTotal--;
	return TRUE;
}


BOOL	DeleteFirstString( void )
{
	int	i;

	if ( aTotal == 0 ) return FALSE;

	for ( i = aTotal; i > 0; i-- )
		hStrings[i] = hStrings[i - 1];

	aTotal--;
	return TRUE;
}


BOOL	DestroyStrings( void )
{
	int	i;

	if ( aTotal== 0 ) return TRUE;

	for ( i = 0; i < aTotal; i++ )
		GlobalFree(hStrings[i]);

	aTotal = 0;
	return TRUE;
}


int	GetStrings(GETSTR lpfnGetStrCallBack, LPARAM lParam)
{
	BOOL	bReturn;
	LPSTR	lpString;
	int	i;

	for( i = 0; i < aTotal; i++ )
	{
		lpString = GlobalLock(hStrings[i]);
		bReturn = (*lpfnGetStrCallBack)((LPSTR) lpString, lParam);
		GlobalUnlock(hStrings[i]);

		if ( bReturn == FALSE ) return (i+1);
	}

	return aTotal;
}
