









 



                            NETWORK MANUAL
                            
                          CITADEL-86: V3.03

                             by Hue, Jr.

                        C-86 Test System Sysop

                               88Mar01



















































     TABLE OF CONTENTS

     I. Introduction . . . . . . . . . . . . . . . . . . . . . . . . . . 2

     II. Compatibility Ishes . . . . . . . . . . . . . . . . . . . . . . 2

     III. Functionality  . . . . . . . . . . . . . . . . . . . . . . . . 3
          III.1 Normal User Capabilities . . . . . . . . . . . . . . . . 3
          III.2 Aides and Citadel-86's net . . . . . . . . . . . . . . . 4
          III.3 Sysop Capabilities . . . . . . . . . . . . . . . . . . . 4
                III.3.a Node Creation  . . . . . . . . . . . . . . . . . 5
                III.3.b Node Administration & Member Nets  . . . . . . . 6
                III.3.c Network Sessions . . . . . . . . . . . . . . . . 7
                III.3.d User Administration  . . . . . . . . . . . . . . 7
                III.3.e Normal Shared rooms  . . . . . . . . . . . . . . 8
                III.3.f File Requests  . . . . . . . . . . . . . . . . . 8
                III.3.g Sending Files  . . . . . . . . . . . . . . . . . 9
                III.3.h Miscellaneous Net Menu Options . . . . . . . . . 9
                III.3.i Advanced Room Sharing Options: Routing . . . . . 9

     IV. CTDLCNFG.SYS Parameters . . . . . . . . . . . . . . . . . . .  13

     Appendix A: Other room-based Networks . . . . . . . . . . . . . .  14

     Appendix B: Temporary Files . . . . . . . . . . . . . . . . . . .  14






























                                    -1-






     I. Introduction
        In this document, we are going to talk about the functionality and
     usage of the Citadel-86 Network.  This is not a technical discussion of
     the transmission protocols used in the Citadel-86; for such a discussion,
     please consult NETHACK3.DOC.

        We want to discuss what the Citadel-86 Network is capable of, and what
     you, the sysop, must do to use these capabilities.  As a relevant part of
     this discussion, we'll also tell you what it can't do.

        As a useful acronym/identifier, we are going to refer to the Citadel-86
     Network as C86Net throughout this documentation.

     II. Compatibility Ishes
        So, let's start with the vague topic of what we're compatible with.
     First the bad news: No, we do not talk to FidoNet.  Nor do we talk to a
     number of other networks, such as USENET, BITNET, etc.  C86net was
     designed, first, as a learning experience (so beware!), and, second, with
     room-based systems in mind.  Rather than attempting to use something
     designed with other purposes in mind, we decided to have fun.

        It is not impossible to talk to those networks in the future through
     the judicious use of the #event parameter and the labors of a captive
     programmer. Currently, the only network with which there are any plans to
     talk to via Citadel-86 is USENET, due to the fact that the STadel guru,
     orc of Pell, has written such a gateway for STadel, and has graciously
     given us the source code.  Sometime in the future there may be an attempt
     to actually make that code work with Citadel-86.

        Speaking of STadel, we'll now move to the good news.  Since STadel, as
     maintained by orc of Pell, was originally derived from Citadel-86, it has
     maintained close compatibility with C86Net, so you should be able to
     network with STadels in your area.

        Amiga Citadel-68K, as maintained by Stallion (aka Jay Johnson) of The
     Phoenix, since it was also derived from Citadel-86, is also compatible
     with C86Net.

        NeoCitadel, as maintained by Hue, Sr. of SuperComp II, is compatible
     with C86Net.

        We should mention that when we say that something is compatible with
     C86Net, this means that a minimal network session can take place between
     the two pieces of BBS software.  Not all of the software mentioned here
     supports all of the functionality of C86Net.  Consult the documentation
     of the respective software for details.













                                    -2-






     III. Functionality
        So let's talk about what C86Net is capable of (this is the same as
     discussing what Citadel-86 is capable of).  First, to simplify this
     discussion, let's set up an "inheritance hierarchy" of users.  The
     bottom-most level will have certain capabilities on the network, the next
     level will have those capabilities plus several of their own, etc.
     Here's what we'll use:

              Sysops
                |
              Aides
                |
           Normal Users

        Each level, starting with the Normal Users, adds more capabilities.
     So we'll start with the lowest level, describing these capabilities.

     III.1 Normal User Capabilities
        Normal users have three capabilities on the network.

        First, they may send Mail> to users on other nodes of the network.
     C86Net Mail> can be sent by any user with network privileges to any local
     node, or if the user has Long Distance (LD) credits, to any LD node.

        The Mail> is entered by going to the Mail> room and typing .Enter
     Net-Message at the room prompt.  The user is then asked for the name of
     the system.  A '?' will elicit a list of systems that Mail may be sent to;
     an empty line will abort the .EN command.  If the user enters a legal node
     name, then the user is asked for the name of a user on the target system.
     An empty line will again abort the .EN command; any other input will be
     assumed to be the name of a user on the target system.  The user may then
     enter their message.

        Due to both the volatility of the user bases of room-based systems and
     space considerations, user names cannot be validated during message entry.
     Therefore, Citadel-86 will try to validate the user name during the
     network session.  If the user has entered an invalid name for the target
     system, he will be notified via Mail> from Citadel of his/her mistake.

        A normal user's second ability is to enter messages in shared rooms.
     Shared rooms will be discussed in full in Section III.3; to summarize,
     they are rooms in which messages from your system can be sent to other
     systems, and messages from those system can be received. Normally, a user
     uses the command .Enter Net-Message to enter a message that should be sent
     to rooms on other systems; a normal Enter message will cause the message
     not to be networked to other systems (however, a shared room can be set
     up so that all messages are networked -- see Section III.3).

        A shared room can be recognized by the blood-shot eyes of the sysop,
     and also by the fact that rather than having a '>' at the room prompt, it
     has a ')'.  A room that has a ':' for a room prompt is also shared, and
     also has a directory attached to it (which has nothing to do with the
     network).






                                    -3-






        In both of the above cases, a normal message may be converted into a
     net message (when in an appropriate room) when saving the message by
     typing 'N' rather than 'S'.  A non-net message can not be directly
     changed into a net-message.

         The third normal user ability is Local Mail> Forwarding (V3.01).
     This feature is useful in densely networked areas where users tend to
     have accounts on several systems, but do not have time to call all the
     systems daily.

         Local Mail> Forwarding allows the user to specify that Mail> sent
     to the user locally should be forwarded to another system.  Mail> sent
     to the user will then be converted to C86Net Mail>, with one copy being
     sent to the user's account on the system specified, and one copy being
     left in the Mail> on the local system, in case the user should login at
     a propitious moment.

         In order for a user to have access to this feature, the user must
     must have net privileges.  If the user specifies forwarding to a LD
     system, the user must have LD credits, or the Mail> will not be forwarded
     (thus making forwarded Mail> his financial responsibility, rather than
     the sender's).

         Local Mail> Forwarding is accessed via the .Enter Configuration
     Address command.  The user will be asked for a system to forward his/her
     Mail> to.  A simply blank line will cancel Mail> Forwarding.

         Mail from the Sysop to Citadel will never be Forwarded.  Nor will
     C86Net Mail> to the user's account be forwarded.


     III.2 Aides and Citadel-86's net
        The Aides of a Citadel-86 system gain only one extra capability that a
     Normal User doesn't have, and this is called the Local Systems
     Announcement. This is the ability to send a Mail> item via the network to
     a user on all systems which are local to your system.  This is useful for
     informing all local sysops of an important development.

        An Aide does this by going to the Mail> room and using the .Enter
     Net-Message command.  When the system asks for a node name to send the
     Mail> to, the Aide should then answer with '&L'.  The Mail> that the Aide
     subsequently enters will then be sent to the user that they indicated on
     all local systems.

     III.3 Sysop Capabilities
        Sysop capabilities in Citadel-86 regarding the network are numerous,
     and we will organize them into sections.












                                    -4-






     III.3.a Node Creation
        Before anyting useful can take place on the network, you must have
     other systems (also known as nodes) to call. Therefore, we'll begin with
     adding systems to your netlist.  We add systems to a netlist via the
     Network Menu, which is available to sysops from the Sysop menu as the 'N'
     option.  Once you have entered the Network Menu, type 'A' to add systems.
     Your system should begin by asking for the name of the system to add,
     which you should type in.  Next it will ask for its Node Id.  It is
     important that you get this right.  The format of the node Id is

      <Country Code> <Area code> <Phone #>

        Country Code is the country code of your system's location, which
     should be listed in COUNTRY.DOC; US is the United States and CA is Canada.
     Area code is the area code of the system, and Phone # is the number used
     to call that system under normal circumstances.  Citadel-86 will usually
     use the node Id for calling other systems, which is why it's important to
     get this right. However, if you are in a special circumstance where using
     the node Id to call a system will simply not work (such as an intra-campus
     phone system), there are ways around the problem.  See Section III.3.b.

        An example of a valid node Id would be

     US (612) 866-1804

        Notice the use of punctuation.  Punctuation is stripped out of node
     Ids when dialing other systems, but punctuation should still be used
     conservatively.

        You will then be asked the baud rate of the new system.  Usually, you
     should answer with the highest baud rate that the new system supports; if
     your system doesn't support their highest speed, then your system will
     dial that system at the highest speed that your own system supports.
     Sometimes, though, you will have to answer this question with a lower baud
     rate, due to the fact that on some lines the network won't work at high
     speeds.  We are not entirely sure, although we suspect that it's simply
     the phone system's fault.

        Finally, you'll be asked if the system is local or not.  This question
     also affects how your modem will dial this system during networking, and
     here's how:

        If you answer that this is a local node, then the modem will be dialed
     using

        <#callOutPrefix><phone#><#callOutSuffix>













                                    -5-






        (If you don't know what #callOutPrefix and #callOutSuffix are, please 
     review the Citadel-86 Installation Manual, or see Section IV of this
     document.) Essentially, we just dial the system as a local call.  But if
     you answer that the system is not local, then the modem dials with

        <#callOutPrefix>1<area code><phone#><#callOutSuffix>

        This is just a normal LD call in the States.  All of this can be
     overridden, as stated above: see Section III.3.b.

     III.3.b Node Administration & Member Nets
        Nothing stays the same, including nodes on your netlist.  Therefore,
     there is an editing ability for nodes.  You may access this via the
     Network Menu. Once at the Network Menu prompt, type 'E' for Edit Node.
     The system will ask for the name of the node to edit, so type the name of
     the node that you need.  Once you type a valid name, you will be given a
     short summary of that node's condition, and then a Node Edit prompt will
     show up.  From this prompt you may do the following:

      A - Override the dialing format described in III.3.a
      B - Change this system's baud rate
      I - Change this system's Id
      K - Kill this system from the net list
      L - Change the Local setting
      M - Change which nets that this system is a member of
      N - Change this system's name
      P - Activate security measures for this node
      R - View which rooms you are sharing with this node

        Let's take these one at a time.

        'A' from the Node Editing prompt lets you change the Access string for
     calling this node.  If you give this string any value, the procedure for
     calling this node will change to the following:

        <#callOutPrefix><access string><#callOutSuffix>

     which makes it very easy to construct special dialing sequences for nodes
     in special situations.  Use this with some caution.

        'B' allows you to reset the baud rate for this system.

        'I' allows you to change the Node Id of this system.  When you use this
     option, you will be asked if you are changing the meaning of this node
     entirely, that is, you are making this record refer to another system
     entirely. This is for the purpose of Mail forwarding (an unimplemented
     facility), so answer this correctly.

        'K' causes this system to be deleted from your node list.

        'L' lets you change the Local/LD setting for this node.

        'N' allows you to change the name of this node.






                                    -6-






        'P' allows you to setup security arrangements between this node and
     yourself.  Security arrangements consist of two passwords, one of which
     applies to your system, while the other applies to the node that you are
     editing.  If neither your system nor the node that you are editing are
     using passwords, then security is not active.  If either system is using
     them, then security is active, and passwords must match during networking
     in order for room sharing to be successful.

        'R' allows you to see a list of the rooms that you are currently
     sharing with this node.

        'M' allows you to change the nets that this system is associated with.
     Citadel-86 allows you to associate any node on your node list with 0 or
     more nets, up to 32.  When a node is created, it is automatically
     associates with net 1 as a matter of convenience.

        The ability to assign a node to different nets is that, in conjunction
     with the #event parameter (covered in Section III.3.c), you may then
     network with different nodes at different times and/or days. This gives
     you a lot of flexibility to participate in different nets at different
     times. If necessary, you can assign a node to more than 1 network.

        If you take a node off of all the nets, then the node is disabled,
     which means that Mail> cannot be sent to that node.

     III.3.c Network Sessions
        Network sessions are set up using the #event parameter of CTDLCNFG.SYS
     (yes, we should cover this in Section IV of this manual, but we're going
     to do it here); please review The Citadel-86 Installation Manual if you
     are not familiar with this parameter.  Using #event for networking should
     be straightforward and easy to do.  You simply have to make sure that you
     and the systems that you want to network with have a firm agreement to
     network at the same time, and that you use the right Member net number for
     the <depends> field of the #event parameter.  Here is an example for
     networking every night at 3AM for 45 minutes for systems on net 1.

     #event All 3:00 network preempt 45 "Networking" 1

     III.3.d User Administration
        For any user to use the room sharing or net Mail> abilities, they must
     have "Network privileges".  There are two ways that Network privileges are
     assigned. The first is via the CTDLCNFG.SYS parameter #NewNetPrivs, which
     allows you to decide whether or not new users automatically have net
     privileges (see Section IV).  The second method is via the Network menu.
     The Network Menu is available to sysops from the Sysop menu as the 'N'
     option.  Once you have entered the Network Menu, type 'N' to set Network
     privileges and follow the prompts.

        If you (or other users) wish to send Mail> via the net to LD systems,
     then you must assign one or more LD credits to the appropriate accounts.
     You do this from the Network Menu as well.  Type 'C' at the Network Menu
     prompt and follow the prompts.  Each Mail> message to a LD system costs
     exactly one credit; there is no accounting on a byte count basis.






                                    -7-






     III.3.e Normal Shared rooms
        Sysops have the ability and responsibility of administrating shared
     rooms, of which we are going to discuss the normal variety of shared rooms
     here.

        A shared room, as noted above, is a room which will send to and receive
     from other systems certain messages which were entered in the room.
     Normal shared rooms transmit their messages using the point-to-point model
     of networking.  For each system that you are sharing this room with, your
     system will call that system and send only the net-messages that were
     originally entered on this system.  There is no routing for normal shared
     rooms.  If you have a pressing need for routed rooms, see Section III.3.i.

        To make a shared room, go to (or create) the room that you wish to make
     a shared room, and edit the room.  At the room editing prompt you should
     type 'S', which is the command for Shared rooms.  The system should now
     ask if you want to make the room a shared room, so answer 'Y'.  Now you
     will be asked to enter the systems that you wish to share this room with.
     If the room was already a shared room, then you do NOT have to re-enter
     any systems that you are already sharing this room with, but only the
     systems which were not sharing the room before.

        Once you have finished entering the systems to share this room with
     you will be asked to enter the names of the systems to remove from room
     sharing.  Answer appropriately.

        Finally, you will be asked if you want this room to be an autonet room.
     If you answer 'Y', then the system will ask if only people with net
     privileges will have their messages automatically made into net messages,
     or if everyone will have this privilege.  If you answer that only
     people with net privileges will have the ability, then only they can
     enter net messages in the room, and all other messages will be normal.
     If you answer that everyone's messages should be converted, then that's
     what will happen, regardless of their privilege setting.

        In order to have a successful shared room, all systems with which you
     wish to share this room with must have a room with an identical name, and
     must know that you want to share this room.  There is no such thing as
     involuntary sharing of rooms.

     III.3.f File Requests
        Sysops have the ability to request file(s) from other systems.  In
     order to do this, you must know the name of the room and the name of the
     file(s) that you wish from the other system.

        You may access this facility from the Net Menu by pressing 'R'.  You
     are then asked for the system's name, the name of the room on the system
     that has the file(s) that you want, and the name of the file(s).  You may
     specify an ambiguous name for files, but your specification must be one
     that the target system understands, rather than what your system
     understands, so this may vary.

        You will then be asked for a location to place the files when your
     system receives them.  You may specify anywhere on your disk system, but
     you should try to ensure that you have enough room for the files.




                                    -8-






        As a Citadel-86, your own directory rooms can be accessed via the
     network for file transfer unless you otherwise designate.   To do so, go
     to the room that you wish to be impervious to the net, edit the room, and
     type Z, which will give the option of disabling this room for net
     downloading.

     III.3.g Sending Files
        Sysops have the ability to send file(s) to other systems.  There are
     two aspects to this ability.

        First, sending a file.  This facility is accessed via the Net Menu by
     pressing 'S'.  You will be asked for the name of the system to send the
     files to, and the name of the files to send.  You may specify any location
     on your system for the files, and your specification may be ambiguous, so
     that you send multiple files to the target system.

        Second, receiving files.  You can control how much space you wish to
     devote to files that are sent to you via the net and the maximum size of
     any file you receive, as well as the location for the files to end up at,
     through parameters in CTDLCNFG.SYS.  Please review The Citadel-86
     Installation Manual or read Section IV for more details on this.

     III.3.h Miscellaneous Net Menu Options
        There are a couple of Net Menu options that haven't been covered yet.
     They are:

        'V'iew the net list.  This option lets you view all the systems on your
     netlist.  The format is

     <name>  <nodeId>   <need to call>  <baud> <disabled flag>

        "need to call" and "disabled flag" only appear if they are true.

        'D'ial out allows you to dial other systems manually for BBSing
     purposes. After causing your modem to dial that number, the system will
     drop you into chat mode.  You can dial systems that are disabled, thus
     allowing you to list systems which are not C86Net compatible.

     III.3.i Advanced Room Sharing Options: Routing
        C86Net (and thus Citadel-86) has support for Room Sharing routing.
     This is an advanced option, and should be approached with caution.

        Routing in C86Net is used to transfer messages from one group of one
     or more systems to another group of one or more systems.  Commonly, this
     is between two different toll areas in order to reduce costs while
     maintaining communications; however, there is no reason, that with careful
     planning, routing cannot be used within a toll area.

        Normal room sharing and room sharing routing can be, and usually are,
     used together.  Graphically:

      R1         |  R2
         p1
         | \     |
         |  p3- - - -p4
         | /     |     \
         p2             p5

                 |
                                    -9-






        In this diagrom, p1, p2, and p3 communicate with each other using the
     Normal room sharing facility, as does p4 with p5.  However, p3 and p4
     communicate using the routing facility; p5 then communicates with p1, p2,
     and p3 indirectly via p4 (and vice versa, of course).  This is a simple
     situation; complex situations can also be handled:

      R1         |  R2       | R3   |  R5
         p1                                    p11
         | \     |           |      |         /
         |  p3- - - -p4- - - - -p6- - - - -p10
         | /     |     \     |  |   |         \
         p2             p5      |              p12
                 |           |--|---|
                                |
                            R4  |
                                p7
                               /  \
                             p8    p9

        p6, for instance, only performs routing, while p3, p4, p7, and p10 will
     perform both normal and routing.

        So how do we explain this in a coherent manner?  First, let's remember
     that all of this applies on a room by room basis; a system that is
     performing routing for one room may be performing normal room sharing for
     another room. Now let's define some classes of nodes.  The first class
     encompasses the majority of nodes sharing any room, since most nodes do
     not need to route messages; the latter three classes are capable of
     routing.  The one that you pick will be determined by your circumstances
     and their capabilities.

        PEON: This is a node that thinks it is participating in a normal
     shared room.  A PEON node never "knows" that the room is being routed by
     another node, and so the administration of this room is very easy for PEON
     nodes.  This is because the node(s) that may be performing the routing
     role for this room always talks to PEON nodes using the normal room
     sharing schemes.

        Let's formalize the rules of PEON room sharing (this is just a review
     of Section III.3.f).  A PEON node regards the room being shared as part of
     a point-to-point network, and therefore always calls all systems that it
     is directly sharing the room with whenever it has new net-messages that
     were entered on this PEON node to send.  Incoming net-messages are never
     passed on to anyone else.  Systems that are compatible with C86Net but
     don't support the advance room sharing routing schemes should be easily
     able to participate as a PEON node in a room that is being routed by
     someone else.












                                    -10-






        HOST: This is the first type of routing node, and the simplest.  A HOST
     node will route all net-messages that originated in its REGION (or group)
     to all BACKBONES (a class to be defined shortly), and will route all
     messages that were routed to it from the BACKBONES to all the nodes in
     its REGION. Furthermore, a HOST node will NEVER call a BACKBONE or a HOST
     for room sharing; all calls will be made by the BACKBONES (and therefore
     the BACKBONES will bear all of the costs, if any).  Let's look at a
     graphic example:

      R1         |  R2       | R3            p1 = BACKBONE
                        p3                   p2 = HOST
                 |     /     |               p6 = BACKBONE
            p1- - - -p2- - - - -p6           p3 = p4 = PEONS
                 |     \     |               contents of R1 and R3 are
                        p4                     otherwise unimportant.
                 |           |

        In this example, routed messages from p1 and p6 will be sent to p2,
     which will route them to p3 and p4.  p6, as a HOST, will also route all
     net messages for this room from p3 and p4 to the BACKBONES p1 and p6.

        It is important to note, however, that p2 does NOT route messages from
     p1 to p6.  This leads us to the second type of routing node.

        PASSIVE BACKBONES: This node is precisely the same as a HOST node,
     except that in the above diagram, if p2 were a PASSIVE BACKBONE, it would
     route messages coming in from p1 to p6, and vice versa.  Additionally, a
     system does not have to be a PASSIVE BACKBONE for all other BACKBONE
     systems for this room; for some, it can choose to be an ACTIVE BACKBONE
     (to be covered shortly), while for others it will be a PASSIVE BACKBONE.
     For instance, consider this diagram:

               p1
                 \
                  \
         p3- - - - p2 - - - - p4
                    |
                    |
                    p5


        We can designate that p2 be a PB (PASSIVE BACKBONE) for p3 and p1,
     while an AB (ACTIVE BACKBONE) for p4 and p5.  As a sneak preview, we'll
     now divulge the fact that an ACTIVE BACKBONE may call other backbones;
     therefore, p3 and p1 will call p2 to deliver their messages and pick up
     others, while p2 will call p4 and p5 to deliver its and other messages
     and pick up messages from them.

        This ability to be a PASSIVE BACKBONE for a room in relation to some
     systems and an ACTIVE BACKBONE for other systems gives us some useful
     flexibility in keeping costs spread out and controllable.  Now let's be
     completists and formalize an ACTIVE BACKBONE.







                                    -11-






        ACTIVE BACKBONE: An ACTIVE BACKBONE differs from a PASSIVE BACKBONE in
     that it will call other BACKBONES at least (and hopefully at most) once
     during each network session which concerns those systems to pick up and
     send messages for the given room.  To clarify a possibly hazy point, a
     system which is sharing a room for which it is routing will possibly be
     classified as a BACKBONE for this room.  If so, during a networking
     session it will call any nodes who are part of this net for which we are
     classified as their ACTIVE BACKBONE.

        So, now you're wondering how to actually get these setup, right?  This
     is accomplished by editing the room.  First, use 'S' to enter all systems
     sharing this room DIRECTLY with, including all of your local PEON nodes,
     and all the BACKBONES that you will be talking to, but NOT any non-local
     PEON nodes (i.e., PEONS that will receive your region's messages via a
     routing). After finishing that, hit 'B' at the Room Edit prompt.  The 
     system will then ask you if you want your system to be a Host or Backbone
     node.

        If you want to be a Host, then type 'H', and you will be asked which
     systems will be BACKBONES for your node.  Remembering that these are all
     ACTIVE BACKBONES (since PASSIVE BACKBONES won't call your system,
     remember?), type in their names.  When networking comes around, you'll
     never call these nodes for the purpose of sharing this room; instead, if
     you have planned correctly, these nodes should call you once a night to
     leave and pick up messages.  All of the other nodes that are sharing this 
     room should continue to be treated as PEONS.

        If you want to be a BACKBONE, type 'B'.  You will then be asked three
     questions: which nodes are HOSTS, which nodes do you want to be PASSIVE
     BACKBONES for, and which nodes you wish to be ACTIVE BACKBONES for.

        Here are two last thoughts on routing.  First, you may wish to consider
     using the Member nets to separate nodes into two different classes, and
     then network at different times for the different classes.  For instance,
     in the Twin Cities we network from 3 to 3:45 in the morning for local room
     sharing.  At 3:45 all but one of the systems returns to normal operating
     mode.  That remaining system drops from the first networking session,
     which was for net 1, and then goes right into another network session
     again, but this time for net 2, which keeps it from trying to talk to
     anyone else but for a system in New York, which functions as an ACTIVE
     BACKBONE for several rooms (the lone system in the Twin Cities functions
     as a PASSIVE BACKBONE). This networking session lasts for 15 minutes,
     which is normally more than enough time to complete this single call.
     Therefore, we usually have a successful nightly connection with New York.

         Our second thought relates to network configurations and routing.  So
     far, all of our diagrams have had two BACKBONES (or at least a HOST and a
     BACKBONE) communicating.  While this is normal, it is also possible to
     have a configuration like this when all nodes are local to each other:

               p1
               | \                   p1 = p3 = p4 = PEON
               |  p2 - - - - p4      p2 = ACTIVE BACKBONE for p4
               | /
               p3




                                    -12-






        When all the nodes are local, p2 will communicate with p4 using the
     normal room sharing protocol rather than using the routing protocol.
     This is useful when p4 has C86Net compatible software that does not
     support routing, along with a modem that will not dial out.  If p4 were
     to have software that supported room sharing routing, but still had the
     bad modem, then p4 could of course be classified (classify itself) as a
     HOST or PASSIVE BACKBONE for p2. Since an ACTIVE BACKBONE always calls
     other BACKBONES, in either case then p2 should make at least one call to
     p4 for pickup and delivery.  If p1 and p3 simply had p4 classified as a
     PEON node, then there is no guarantee that p4 would receive nightly calls
     from all systems.

         Confusing?  For us, too.

     IV. CTDLCNFG.SYS Parameters
        There are several parameters in CTDLCNFG.SYS that help you control what
     Citadel-86 will do with the network.  All of these parameters were covered
     in the Citadel-86 Installation Manual, but we shall cover them again here.

        The #NETWORK parameter is the basic parameter that decides if you are a
     networking system or not.  A numeric value of 1 indicates that you are;
     0 indicates no.

        The #LONG-HAUL parameter is a semi-obsolete parameter which limits your
     LD calls.  1 means that you don't mind calling long distance, while 0
     indicates that you have a problem calling long distance.  Since this is
     easily controlled through simply not listing LD systems on your nodelist,
     this parameter may go away someday.

        The #NewNetPrivs lets you decide whether or not new users automatically
     gain net privileges on login.  1 indicates yes, 0 indicates no (a good
     paranoid value).

        The #NETAREA parameter indicates where CTDLNET.SYS and all temporary
     network files should reside on your system.  It is just like #MSGAREA,
     etc., specifying a directory for the location.  CTDLNET.SYS may be large,
     depending on how many nodes you have and the values of two parameters
     that follow this one, but the temporary files very rarely exceed 1K, and
     usually are short-lived.


        #SHARED-ROOMS indicates the maximum number of rooms that you think
     you'll ever share with another system simultaneously.

        #NET-ARCH-ROOMS indicates the maximum number of rooms that you think
     you'll ever network archive to another system simultaneously.  This is a
     currently unimplemented facility, which is why you're furrowing your brow
     right now.

        #NET_RECEPT_AREA designates the area on your system that files that
     were sent to you with the Send File facility (Section III.3.g) should be
     placed. This may be anywhere on your system.







                                    -13-






        #NET_AREA_SIZE specifies the maximum number of bytes that may occupy
     the #NET_RECEPT_AREA directory at any one time, which provides you with
     a way of keeping your system from being flooded.

        #MAX_NET_FILE specifies the maximum size of any single file to be
     received from the network via the Send File option (see Section III.3.g).
     If you don't want monster files sent to you, here is your solution.

        #callOutPrefix is a string value that tells the modem to prepare to
     dial out.  For Hayes/compatibles, this is usually "ATDT".

        #callOutSuffix is a string value that tells the modem that all the
     information that it needs to dial has been sent to it.  For
     Hayes/compatibles, this is usually "\r".



     Appendix A: Other room-based Networks

     HengeNet: This network is for the StoneHenges.  The last news I heard
     was that the homebase of the Stonehenges, CKMCMS, was down.

     CitaNet: The exact nature of this network is not clear, but seems to be
     semi-manual and is used by the K2NE (Commodore 128) systems, along with
     one or two Citadel-86 systems and possibly others.  Homebase for this net
     is Vince Quaresima of The Jersey Devil ((609) 893-2152).

     Citadel-286: These systems have some sort of network.  Homebase is
     probably Farokh Irani of Electronic New York ((914) 735-9362).

     Appendix B: Temporary Files

        Citadel-86 generates and destroys temporary files in order to service
     C86Net.  All of these files are placed in the directory specified by the
     CTDLCNFG.SYS parameter #NETAREA, and most should not last past the next
     networking session once generated.

        They are all of the form <numeric>.<ext>.  The numeric value is the
     position that the relevant node occupies in CTDLNET.SYS; ext indicates the
     purpose of the temporary file.  The current ext values currently used are:

      ML  = Mail file
      RFL = Request Files
      SFL = Send Files

        Thus, the file 12.ML contains the data necessary to send net Mail> to
     the twelfth system on your netlist.












                                    -14-



