/*
** Task Control Block (TCB) structure, along with other related
** memory structures for the Adept Multi-Tasker
**
** Copyright 1990 Herb Rose
**
*/

#define maxtasks 64
#define num_mcbs 256
#define maxsem 128
#define maxmsgq 160

#define map_a_task(x) ems_map_handle(tcb[x].handle)

struct tcb_rec
{
    int     next_tcb;   /* tcbs are arranged as a table, this is next index */
    int     base_pri;   /* base priority */
    int     cur_pri;    /* current priority */
    int     pportnum;   /* port number (FOSSIL) used as stdio files  */
    unsigned int     stackseg;
    unsigned int     stackptr;
    int     mcb_ptr;    /* first mcb */
    int     tcbflags;   /* various state flags */
    int     cur_state;  /* numerical value for task state */
    int     sem_wait_num;
    unsigned int mcbs_in_use;    /* doubles as the logical page count */
/*
** Address of the last block of EMS memory allocated to this task,
** used by the 'resize block' directive.
*/
    unsigned int last_ems_bl;
    unsigned int expused;       /* expanded memory allocated by cswitch */
    unsigned int expfree;       /* free expanded memory */
    unsigned int dtaseg;    /* this guys disk transfer area - segment */
    unsigned int dtaoff;    /* dta offset   */
    unsigned int pspseg;    /* our psp segment */
    int     load_status;    /* status of last 'loadtask' call */
    int     handle;
    int     parent;         /* tcb number of parent task */
    void far *termfunc;     /* a function to call when task is terminated */
    char    tcbname[14];
    int  mem_strategy;
    unsigned fpstat_off;
    unsigned fpstat_seg;
    unsigned fpvect_off;
    unsigned fpvect_seg;
    char unused[20];
};

#define st_free    -1   /* this tcb not being used */
#define st_active   0   /* the runner */
#define st_ready    1   /* ready to run */
#define st_sem_wait 2   /* waiting for a semaphore */
#define st_delay    3   /* task is delaying */
#define st_suspend  4   /* task is suspended - needs a wakeup signal */
#define st_msg_wait 5   /* task is waiting for a message */
#define st_stopping 6   /* task is terminating */
#define st_swapout  7   /* task is currently swapped out */
#define st_pipe_wait 8  /* task is waiting for something in the pipe */
#define st_child_wait 9 /* waiting for a child task to complete */

/* the following are bit values for the flags word */

#define fl_no_swap  1   /* when this task is the runner, do not task swap */
#define fl_in_dos   2   /* this task is in dos */
#define fl_in_emm   4   /* this task executes in emm */
#define fl_spawned  8   /* this task created with spawn */
#define fl_pipe    16   /* this task uses pipes for stdin/stdout/stderr */
#define fl_nofpu   32   /* program does not use FPU */

struct mem_ctrl_block {
    int fwd_link;       /* index of next tcb */
    unsigned int actlen;         /* actual length of data (for message queues) */
    unsigned int m_size;         /* number of paragraphs */
    unsigned int m_address;      /* the segment address */
    };

struct msgq_rec {
    int mmcb;    /* hoq and mcb for messages */
    int mtcb;       /* same for tcbs */
    };

struct pipe_rec
{
    int pmcb;
    struct
    {
        int sendr;
        int recvr;
        int phead;
        int ptail;
        int pcount;
        char *pbuf;
    }   pipedir[2];
};

/*
** Prototypes for CSWITCH function calls.
*/

void relinq( void );
int sem_attach(int semnum);
int sem_test(int semnum);
int sem_release(int semnum);
void delay(int numticks);
void suspend( void );
int spawn(void *addr, int pri);
void wakeup(int tasknum);
void setpri(int pri);
int testmsg(int qnum);
int send_md_msg(int qnum, void *buf, int len);
int recvmsg(int qnum, void *buf, int len);
int recvmsg_nowait(int qnum, void *buf, int len);
void hog( void );
void nohog( void );
int loadtask(void *addr, int pri, int bgrd);
void spawn_exit( void );
int get_tcb_info(void *addr);
int get_tcb_address(void *addr);
int get_load_status( void );
int send_pipe(int qnum, void *buf, int len);
int recv_pipe(int qnum, void *buf, int len);
int test_pipe(int pipenum);
int loadpipe(void *addr, int pri, int bgrd);
int execprog(void *addr, int pri, int bgrd);
int ems_map_handle(int);
void termtask(int);
int ploadprg(char *name, int pri, int bgrdflag);
int loadprg(char *name, int pri, int bgrdflag);
int load_a_prog(char *name, int pri, int itcb, int bgrdflag);

