/* Trimmer written by Steven M. Palm.   Portions of this source code
   came from ideas taken from Bob Hartman's ConfMail program.

   This version compiled under Turbo-C v1.5   If you can get it to work
   under something else, go for it.  It's all I have currently.

   You can use this code to your heart's content.  Just don't go putting
   your name on it and taking mine out.

   (SORRY, earlier revision lists were wiped out!  This shouldn't matter
   as it wasn't distrbuted prior to this anyway.  The revisions described
   below are after 0.11)

   January 6, 1990:  Re-Coded the routine to insert the net/node  in the
                     Seen-By.  A problem was  reported in which it would
                     duplicate a seen-by set if your net(/node?) was the
         0.12        first in the Seen-By list.  I cannot duplicate this
                     problem after re-coding this section.
                     (Soon I plan on going over the source again to trim
                     down some of the unnecessary baggage and generally
                     make it a bit more streamlined.)

  January 13, 1990:  Fixed a slight bug that crept in.  Trimmer no longer
                     ignores 1.MSG's High-Water mark.  Also, I tested to
         0.13        try and locate the elusive, 'SCREW UP THE SEEN-BY's
                     IF YOU'RE THE FIRST ONE' with no luck.  Still
                     functions perfectly under all test I can run.

  January 14, 1990:  Added -q option to make it not spout out all of the
         0.14        status reports as it processes the messages.

  January 27, 1990:  Modified TRIMMER so that it will remove all trailing
                     linefeeds or carriage returns from end of origin line
                     before inserting SEEN-BY lines.  This appears to have
         0.15        fixed the problem with the seen-by mess-ups.  I also
                     now do this at the PATH: line to insure that it is also
                     up to (expected) spec.

                     Also added:  Now keeps the same file date/time stamp as
                     was on the file before Trimmer got it.

  January 30, 1990:  Totally re-grouped the source code and went through it
                     with an eye toward compacting and neatening it up. ??
                     made dual purpose functions, using GET/PUT to determine
         0.16        whether we were going in or out.  Also, I now unlink
                     (delete) the old message before writing a new one out,
                     so if your disk is 99.99999% full, it still **SHOULD**
                     run okay, without bombing out.  However, you should
                     still check the return codes.

   August 25, 1990:  First "public" release.  Nothing really changed, just
                     cosmetics and such.  I figured that for a full-blown
         1.00        public release I should at least send out a version
                     number of 1.00 as it is 100% functional right now.  It
                     Actually was functional at 0.16, but I neglected to send
                     it out.

   August 26, 1990:  By popular demand! ;-)   I added an option to stop the
                     keyword search from looking in the text past the tear
         1.01        line (a.k.a. the origin line).  -o {search origin lines}


*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <sys\stat.h>
#include <io.h>
#include <fcntl.h>

#define VERSION "1.01"
#define MYNODE  "1:154/600"

#define PUT  0
#define GET  1
#define WSPACE " \t"
#define CRLF   "\015\012"
#define AREASBBS "AREAS.BBS"
#define READ_MODE "rb"
#define WRITE_MODE "wb"
#define BUFFSIZE 32000
#define FNAMESIZE   115
#define NUM_KEYS 100
#define KEY_LEN  80
#define MAX_SB   500

#define TEAR1     "\012---"
#define TEAR2     "\015---"
#define SEEN1     "\012SEEN-BY:"
#define SEEN2     "\015SEEN-BY:"
#define SEEN_BY   "SEEN-BY: "
#define PATH      "PATH"
#define PATH2     "\001PATH: "

/* ERROR LEVEL DEFINITIONS! */
#define NO_PARAMETERS     5
#define NOT_VALID_AREA    10
#define BAD_NET_NODE      15
#define DISK_WRITE_ERROR  20
#define OUT_OF_MEMORY     25
#define CANT_OPEN_FILE    30
#define STRANGE           99

struct _stamp {
         unsigned int date;
	 unsigned int time;
               };

typedef char FNAME [FNAMESIZE];
typedef char STRING [BUFFSIZE];
typedef char KEY [KEY_LEN];
typedef struct buf {
               STRING storage;
               int    place;
                   } BUFFTYPE;

typedef struct msgstrct {
               char from[36];
               char to  [36];
               char subj[72];
               char date[20];
               int times;  /* no of times read */
               int dest;   /* dest node */
               int orig;   /* orig node */
               int cost;   /* cost to send */
               int orig_net;
               int dest_net;
               struct _stamp _date_arrived;  /* when message arrived */
               struct _stamp _date_written;  /* date when it was wrote */
               /* int caca[4]; obsolete */ /* extra space */
               int reply;        /* previous message */
               int attr;         /* message type */
               int up;           /* next message */
               } MSG;

MSG  header;
KEY  keys[NUM_KEYS];
KEY  names[NUM_KEYS];
KEY  subjects[NUM_KEYS];
int net [MAX_SB];
int node[MAX_SB];
BUFFTYPE buffer;
FNAME mask = "*.MSG";
int  quiet = 0;
int  origins = 0; /* do we search origin lines? */
int  tear = 0;    /* loc. of tear line */
int  path = 0;    /* loc. of path line */
int  seenbys = 0;  /* loc. of seenby line(s) */

struct ftime msgtime;
char progname[80];

int startup(), do_seenby(), add_us ();
void usage(), whereis(), make_seenbys(), addpath();




/*-----------------------------------------------------------------------*/
/*    Startup Function to check command line options                     */
/*-----------------------------------------------------------------------*/

int startup (argc, argv, ournet, ournode, areasname, trimarea, keyfile)
   int argc, *ournet, *ournode;
   char *argv[];
   FNAME areasname, trimarea, keyfile;

{
   int loop;
   FNAME path;
   char *ptr;

   if (toupper(argv[1][1]) == 'H') {
      usage (progname);
      return (0);
      }
   if ((argc < 3) || (argc > 7)) return (0);

   strcpy (trimarea, argv[argc - 2]);  /* area to trim */
   strcpy (keyfile,  argv[argc - 1]);  /* key file */

   strcpy (areasname, AREASBBS);       /* store default areaname */

   ptr = getenv("BINKLEY");
   if (ptr == NULL) ptr = getenv("OPUS");
   if (ptr == NULL) ptr = getenv("MAXIMUS");

   if (ptr == NULL) {
      fprintf (stderr,
      "No path in BINKLEY, OPUS, or MAXIMUS. Using current dir for AREAS.BBS\n");
      ptr = "";
      }
    else
     {
      if (ptr[strlen(ptr) - 1] != '\\') {
         strcpy (path, "\\");
         strcat (path, areasname);
         strcpy (areasname, path);
         };
      };
   addpath (ptr, areasname);

   ptr = argv[argc - 3];
   *ournet = atoi(ptr);    /* gets net up to first non-digit */
   while (isdigit (*ptr))  /* move pointer to first non-digit */
         ptr++;
   if (*ptr != '/') {        /* if this isn't a '/', it's not a net/node */
         fprintf (stderr, "Bad NET/NODE pair.\n");
         exit (BAD_NET_NODE);
                    };
   ptr++;   /* GET past the '/' character */
   *ournode = atoi(ptr);   /* gets node from here to end of string */

   for (loop = 0; loop < (argc - 3); loop++) /* look for '-' things up to
                                                where NET/NODE should be */
      {
         if (argv[loop][0] == '-')
            switch (argv[loop][1]) {
                 case 'q' :
                 case 'Q' :  quiet = 1;
                             break;  /* tell it to shut up. 8^) */
                 case 'A' :
                 case 'a' :  strcpy (areasname, &argv[loop][2]);
                             break;  /* store in areasname from cmd line */
                 case 'M' :
                 case 'm' :  strcpy (mask, &argv[loop][2]);
                             break;  /* store in mask from command line */
                 case 'O' :
                 case 'o' :  origins = 1;   /* please search origin lines */
                             break;         /* for any keywords */

            }; /* switch */
      }
   return (1);

}

/***********************      AREA FUNCTIONS           *******************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***         LOCATE THE AREA NAME IN THE AREAS.BBS FILE AND            ***/
/***            FROM THERE DETERMINE WHERE IT IS ON DISK.              ***/
/*************************************************************************/
/*************************************************************************/

/*-----------------------------------------------------------------------*/
/*    inareas function.  This simply reports if it found the area name   */
/*    in the AREAS.BBS file.  The function to GET the dir uses it's info.*/
/*-----------------------------------------------------------------------*/

int inareas (areaptr, trimarea, workarea)
   FILE *areaptr;
   FNAME trimarea;
   char  workarea[];
{
   int found = -1;
   char *bufptr;

   bufptr = workarea;
   while ((found == -1) && (fgets(workarea, FNAMESIZE, areaptr) != NULL))
      {
         bufptr = workarea;
         bufptr = bufptr + (strspn(bufptr, WSPACE));
                            /* GET past leading whitespace */
         bufptr = strpbrk(bufptr, WSPACE); /* GET TO whitespace */
         bufptr = bufptr + (strspn(bufptr, WSPACE));
                            /* GET past this whitespace   */
         found = instr(bufptr, trimarea);
      };
   return (found);
}

/*-----------------------------------------------------------------------*/
/*    WhereIS function.  Searches AREAS.BBS file to locate directory for */
/*    the location of the message area we are going to be trimming.      */
/*-----------------------------------------------------------------------*/

void whereis (areasname, areaname, arealoc)
   FNAME areasname, areaname, arealoc;
{
   FILE *areaptr;
   FNAME workarea;
   char *ptr;

   areaptr = fopen (areasname, "r");
   if (inareas (areaptr, areaname, workarea) == -1) {
      fprintf (stderr, "Couldn't find %s in the areas.bbs file\n",
                                                      areaname);
      fclose (areaptr);
      exit (NOT_VALID_AREA);
      };
    fclose(areaptr);
 /* at the exit of this, workarea holds line areaname was found in. */
 /* we start at first non-white space character, and copy this into */
 /* areasloc. */

   ptr = workarea;
   ptr = &ptr[strspn(workarea, WSPACE)];
   *(ptr + strcspn(workarea, WSPACE)) = '\0';
   strcpy (arealoc, ptr);
   strcat (arealoc, "\\");
}

/***********************    KEYFILE FUNCTIONS          *******************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***        READ IN THE KEYS, AND FOR SEARCHING THE MESSAGE            ***/
/***               FOR THESE, DEPENDING ON THEIR TYPE.                 ***/
/*************************************************************************/
/*************************************************************************/

/*-----------------------------------------------------------------------*/
/*    getKeys function.  Reads in the keywords from the keyfile.  It     */
/*    handles the names, subjects, or just regular text search words.    */
/*-----------------------------------------------------------------------*/

getkeys (keyfile, keys, num_keys, names, num_names, subjects, num_subjs)
   FNAME keyfile;
   KEY   keys[], names[], subjects[];
   int   *num_keys, *num_names, *num_subjs;
{
   FILE *keyptr;
   char  dummy[KEY_LEN];
   int   loop1, loop2;

   *num_keys = *num_names = *num_subjs = 0;

   if ((keyptr = fopen (keyfile, READ_MODE)) == NULL) {
      fprintf (stderr, "Keyfile couldn't be opened.\n");
      exit (CANT_OPEN_FILE);
   };

   for (loop1 = 0; (loop1 < NUM_KEYS) &&
                    (fgets(dummy, KEY_LEN, keyptr));
                    loop1++)
        {
         for (loop2 = 0; loop2 <= strlen(dummy); loop2++)
            if ((dummy[loop2] == '\n') ||
                (dummy[loop2] == '\r') ||
                (dummy[loop2] == 0x1A)) dummy[loop2] = '\0';
         if (dummy[0] == '^')
            {
               strcpy (names[(*num_names)++], &dummy[1]);
             }
         else if (dummy[0] == '~')
            {
                strcpy (subjects[(*num_subjs)++], &dummy[1]);
            }
         else {
                  strcpy(keys[(*num_keys)++], dummy);
              };
        };
   fclose (keyptr);
}


/*-----------------------------------------------------------------------*/
/*    Search function.  This does the actual search of the keywords.     */
/*    If it is to be found in the text, it calls Instr().                */
/*-----------------------------------------------------------------------*/

int search (filename, nkeys, keys, num_names, names, num_subjs, subjects)
   FNAME filename;
   int   nkeys, num_names, num_subjs;
   KEY   keys[], names[], subjects[];
{
   int found = 0, loop, pos;


   found = 0;

   buffer.place = do_message (filename, buffer.storage, GET, BUFFSIZE);
   /* do_message returns the number of characters it read */

   for (loop = 0; (loop < num_names) && (!found); loop++)
         if (instr(header.from, names[loop]) != -1)
         {
            found = 1;
         }
         else if (instr(header.to  , names[loop]) != -1)
         {
            found = 1;
         };
   for (loop = 0; (loop < num_subjs) && (!found); loop++)
         if (instr(header.subj, subjects[loop]) != -1)
         {
            found = 1;
         }

   for (loop = 0; (loop < nkeys) && (!found); loop++)
         if ((pos = instr(buffer.storage, keys[loop])) != -1)
         {
            if (!origins && (pos >= tear)) /* if we are not looking in the */
               ;                           /* origin lines and we found it */
            else                           /* there, we really didn't find */
               found = 1;                  /* anything we can use, ignore. */
         }
            /* if it's in there, we can abort */
   return (found);
}


/***********************      MISC FUNCTIONS           *******************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***          DO SOME ODDS AND ENDS WORK.  THEY REALLY DON'T           ***/
/***              FIT UNDER ANY OTHER MAJOR HEADING.                   ***/
/*************************************************************************/
/*************************************************************************/

/*-----------------------------------------------------------------------*/
/*    getlow function.  This opens 1.MSG to determine the lowest message */
/*    we should process.  Returns 2 if it can't open 1.MSG at all.       */
/*-----------------------------------------------------------------------*/
int getlow (path)
   char path[];
{
   FNAME msg1;
   FILE  *fptr;
   int tmp, loop, low, intlw, inthi;

   strcpy (msg1, path);
   strcat (msg1, "1.MSG");
   if ((fptr = fopen(msg1, READ_MODE)) == NULL) {
         fprintf (stderr, "Couldn't open %s for High-Water mark.  ", msg1);
         fprintf (stderr, "Starting at 2.MSG\n");
         low = 1; /* any message > 1 will be scanned, including 2 */
         return (low);
         };

   for (loop = 0; loop < 184; loop++) /* skip to 184th character */
      fgetc (fptr); /* just eat a character */

   intlw = (int) getc(fptr);
   inthi = (int) getc(fptr);
   low   = (inthi * 256) + intlw;
   fclose (fptr);
   return (low);
}


/*-----------------------------------------------------------------------*/
/*    addpath function.  This adds the path to the file.  Simply string  */
/*    concatenation, but done in a few places.                           */
/*-----------------------------------------------------------------------*/

void addpath (path, file)
   char path[], file[];
{
   FNAME workarea;

   strcpy (workarea, path);  /* move the path into work area */
   strcat (workarea, file);  /* tack the file name on the path */
   strcpy (file, workarea);  /* now put this all back in the file name */
}


/***********************      FILE FUNCTIONS           *******************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***                     MANIPULATE THE FILES.                         ***/
/***                                                                   ***/
/*************************************************************************/
/*************************************************************************/

/*-----------------------------------------------------------------------*/
/*    Bin_Open function.  This will open the file for the proper mode    */
/*    and access method.   Mostly for portability.                       */
/*-----------------------------------------------------------------------*/


int bin_open (filename, filemode, fileaccess)
    FNAME filename;
   int   filemode;
   unsigned fileaccess;
{
   int result;

   result = open (filename, filemode, fileaccess);
   if (result == -1) {
         fprintf (stderr, "Can't open %s.\n", filename);
         exit (CANT_OPEN_FILE);
         };
   return (result);
}


/*-----------------------------------------------------------------------*/
/*    file_it function.  For portability, this will get/put n bytes      */
/*    from/to a disk file from the memory location handed to it.         */
/*-----------------------------------------------------------------------*/

int file_it (where, storage, len, which_op)
   FILE *where;
   char *storage;
   int  len, which_op;
{
   int loop;

   for (loop = 0; loop < len; loop++)
      switch (which_op) {
         case PUT : {
                    fputc (*(storage + loop), where);
                    break;
                    }
         case GET : {
                    *(storage + loop) = fgetc (where);
                    break;
                    }
         }
}

/*-----------------------------------------------------------------------*/
/*    do_int function.  For portability, this will get/put an integer    */
/*    from/to a file.  Intel/Motorola are different, so I do it.         */
/*-----------------------------------------------------------------------*/

int do_int (where, storage, which_op)
   FILE *where;
   int  *storage, which_op;
{
   int lo, hi;

switch (which_op) {
   case PUT : {
            hi = *storage / 256;
            lo = *storage % 256;

            fputc(lo, where);
            fputc(hi, where);
            return (hi * 256 + lo);
            }
   case GET : {
            *storage = fgetc(where) + (fgetc(where) * 256);
            return (*storage);
            }
   }
}

/*-----------------------------------------------------------------------*/
/*    do_message function.  This reads/puts the message text into/from   */
/*    a buffer for/from the processing.  (Header too.)                   */
/*-----------------------------------------------------------------------*/
int do_message (filename, workarea, which_op, bytes)
   char filename[];
   void *workarea;
   int  which_op, bytes;
{
   int xferred, fd;
   FILE *thefile;

   if (which_op == PUT)
         unlink (filename);

   if ((thefile = fopen(filename,
            ((which_op == GET) ? READ_MODE : WRITE_MODE))) == NULL) {
         fprintf (stderr, "Cannot open %s for %s.\n", filename,
            ((which_op == GET) ? "input" : "output"));
         perror("");
         exit (CANT_OPEN_FILE);
         };
   file_it (thefile, &header.from, 36, which_op);
   file_it (thefile, &header.to, 36, which_op);
   file_it (thefile, &header.subj, 72, which_op);
   file_it (thefile, &header.date, 20, which_op);
   do_int (thefile, &header.times, which_op);
   do_int (thefile, &header.dest, which_op);
   do_int (thefile, &header.orig, which_op);
   do_int (thefile, &header.cost, which_op);
   do_int (thefile, &header.orig_net, which_op);
   do_int (thefile, &header.dest_net, which_op);
   do_int (thefile, &header._date_written.date, which_op);
   do_int (thefile, &header._date_written.time, which_op);
   do_int (thefile, &header._date_arrived.date, which_op);
   do_int (thefile, &header._date_arrived.time, which_op);
   do_int (thefile, &header.reply, which_op);
   do_int (thefile, &header.attr, which_op);
   do_int (thefile, &header.up, which_op);
   fclose (thefile);

   switch (which_op) {
      case GET : {
               fd = bin_open (filename, (O_RDWR | O_BINARY), (S_IFREG));
               getftime (fd, &msgtime);
               lseek (fd, (long) (sizeof(header)), SEEK_SET);
               memset (workarea, 0, bytes);
               xferred = read (fd, workarea, bytes);
               close (fd);
               return (xferred);
               }
      case PUT : {
               fd = bin_open (filename, (O_RDWR | O_APPEND | O_BINARY),
                               (S_IREAD | S_IWRITE));
               xferred = write (fd, workarea, bytes);
               setftime (fd, &msgtime);
               close (fd);
               return (xferred);
              }
      }
};

/***********************   LOCATION SUPPORT FUNCTIONS  *******************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***         LOCATE VARIOUS PARTS OF THE MESSAGES.  THESE              ***/
/***          ARE USED BY THE SEEN-BY AND PATH FUNCTIONS               ***/
/*************************************************************************/
/*************************************************************************/

/*-----------------------------------------------------------------------*/
/*    instr function.  This actually searches the buffer 'bigstr' for the*/
/*    text 'smstr'.  There's always a better search algorithm....        */
/*-----------------------------------------------------------------------*/

int instr(bigstr, smstr)
   char bigstr[], smstr[];
{
   register found, done;
   register char *where, *last;

   where = strchr(bigstr, smstr[0]);
   if (where == NULL) where = strchr(bigstr, toupper(smstr[0]));
   if (where == NULL) {
         return (-1);
         };

   found = 0;
   done  = 0;

   if (strlen(smstr) == 1)
     {   /*  a slip in logic if it's only a 1 char word... */
       found = 1;
       done = 1;
       last = where;
     }

       while (done != 1) {
         last = where;
         found = strnicmp(where, smstr, strlen(smstr));
         ((found == 0) ? (found = 1) : (found = 0));
         if (found != 1) {
               where = strchr(last + 1, smstr[0]);
               if (where == NULL) where = strchr(last + 1,toupper(smstr[0]));
               if (where == NULL) done = 1;
               }
         else done = 1;
      };

   switch (found) {
      case 0 : return (-1);
      case 1 : return (last - bigstr);
      };
}

/*-----------------------------------------------------------------------*/
/*    findlast function.  This locates the last occurance of 'lookfor'   */
/*    in memory at 'workarea', until a '\0' is located, at least.        */
/*-----------------------------------------------------------------------*/

int findlast (workarea, lookfor)
   char workarea[], lookfor[];
{
   int found, old, count = 0, loop;
   char *ptr;

   ptr = workarea;
   found = instr (ptr, lookfor);
   if (found == -1) return (found);
   while (found != -1) {
      count += found;
      ptr += (found + strlen(lookfor)); /* move past found str */
      found = instr(ptr, lookfor);
   };
   return (count); /* we have to add them all up to GET offset from start */
}

/*-----------------------------------------------------------------------*/
/*    get_tear function.  This locates the last tear line in a buffer    */
/*    holding the message text.  Used as a jumping point for SEEN-BY:    */
/*-----------------------------------------------------------------------*/

int get_tear(workarea)
   char workarea[];
{
   int tear_pos;

   tear_pos = findlast (workarea, TEAR1);
         /* findlast looks through the area for the LAST occurance */
   if (tear_pos == -1) {
         tear_pos = findlast (workarea, TEAR2);
         };

   if (tear_pos == -1) {
         return (-1);
         };
      return (tear_pos);
}


/*-----------------------------------------------------------------------*/
/*    get_seenby function.  This locates the start of the SEEN-BY: lines */
/*    in the message.  Starts at the end of the last TEAR line. '---'    */
/*-----------------------------------------------------------------------*/

int get_seenby (workarea, start)
   char workarea[];
   int start;
{
   int seen_by = -1;
   char *ptr;

   ptr = &workarea[start];
   seen_by = (instr (ptr, SEEN1));
            /* instr finds the second in the first, or returns -1 */
   if (seen_by == -1) seen_by = (instr (ptr, SEEN2));
   if (seen_by == -1) {
      return (-1);
   };
   seen_by += start;
   seen_by++;
   return (seen_by);
}

/*-----------------------------------------------------------------------*/
/*    get_path function.  This locates the start of the PATH lines in    */
/*    message.  Starts at the start of the SEEN-BY: lines.               */
/*-----------------------------------------------------------------------*/

int get_path (workarea, start, end)
   char workarea[];
   int start, end;
{
   int hold, path;

   path = instr (&workarea[start], PATH);
   if (path == -1) {  /* not found.  Copy any trailing chars */
      hold = end;
      while ((int) workarea[hold--] < 32)
            ;
      path = hold;
   };
   path += start;
   return (path);
}

/**********************      SEEN-BY FUNCTIONS       *********************/
/*************************************************************************/
/***        THIS SECTION CONTAINS THE ROUTINES NECESSARY TO            ***/
/***         READ, CREATE, AND WRITE THE SEEN-BY AND PATH              ***/
/***                    LINES FOR THE MESSAGES.                        ***/
/*************************************************************************/
/*************************************************************************/


/*-----------------------------------------------------------------------*/
/*    bump function.  This simply moves all net/node numbers up one spot */
/*    so we can insert ourself in the list.                              */
/*-----------------------------------------------------------------------*/

void bump (list, how_many, where, what)
   int list[], how_many, where, what;
{
   int loop;

   for (loop = how_many; loop > where; loop--)
      list[loop] = list[loop - 1];
   list[where] = what;
}


/*-----------------------------------------------------------------------*/
/*    add_us function.  This is the function that determines where we go */
/*    in the SEEN-BY: list, and puts us there.                           */
/*-----------------------------------------------------------------------*/

int add_us (num_seen, ournet, ournode)
   int *num_seen, ournet, ournode;
{
   int hold = 0, loop, added = 0;

   for (loop = 0; loop < *num_seen; loop++)
     if ((ournet == net[loop]) && (ournode == node[loop]))
        {
         added = 0;
         return (added); /* make sure it's a new one! */
        };
   for (loop = 0; loop < *num_seen; loop++)
      {
         if (ournet == net[loop])
        {
         hold = loop;
         for ( ; ; )
         {
            if ((ournode < node[hold]) || (ournet != net[hold]))
               {
                  bump (node, *num_seen, hold, ournode);
                  bump (net,  *num_seen, hold, ournet );
                  (*num_seen)++;
                  added = 1;
                  break;
               }
            hold++;
         }
         break;
        }
      else if (ournet < net[loop])
         {
            bump (node, *num_seen, loop, ournode);
            bump (net,  *num_seen, loop, ournet );
            (*num_seen)++;
            added = 1;
            break;
         }
    }
   if (added == 0) /* must need to go at the end */
      {
         node[(*num_seen)] = ournode;
         net [(*num_seen)] = ournet;
         (*num_seen)++;
         added = 1;
      }
   return (added);
} /* end of function */

/*-----------------------------------------------------------------------*/
/*    grab_seenbys function.  This reads the SEEN-BY/PATH lines from the */
/*    message file into an array of NET/NODE numbers.                    */
/*-----------------------------------------------------------------------*/
int grab_seenbys(start, path, workarea, net, node)
   int  start;
   int  path;
   int net[], node[];
   char workarea[];
{
   int lastnet, num_seen, buffwrk, num;

   lastnet = -1, num_seen = 0;
   buffwrk = start;

   while ((buffwrk < path) && (num_seen < MAX_SB - 1)) {

      if (workarea[buffwrk] <= ' ')
      {
            while ((workarea[buffwrk] <= ' ') && (buffwrk < path))
            {
               buffwrk++;
            };
       }
      else {
         while (!isdigit(workarea[buffwrk])) /* skip to first digit */
            {
               buffwrk++;
            }

         num = atoi (&workarea[buffwrk]);    /* convert to number */

         while (isdigit(workarea[buffwrk]))  /* skip to first NON-digit */
            {
               buffwrk++;
            }
         if (workarea[buffwrk] == '/')  /* this is a NET/NODE pair */
            {
            ++buffwrk;
            lastnet = net[num_seen] = num;
            node[num_seen] = atoi (&workarea[buffwrk]);

            while (isdigit(workarea[buffwrk]))     /* skip past digits */
               {
                  buffwrk++;
               }
            }
         else {
            net [num_seen] = lastnet;
            node[num_seen] = num;
            }
   num_seen++;
      }
}
   for (num = num_seen; num < MAX_SB; num++)
      {
         node[num] = 0;
         net [num] = 0;
      };
   return (num_seen);
}

/*-----------------------------------------------------------------------*/
/*    make_seenbys function.  This builds up a string (SEEN-BY or PATH)  */
/*    of NET/NODE numbers in the array it's handed.                      */
/*-----------------------------------------------------------------------*/

void make_seenbys (which, num_seen, seenby, net, node)
   char which[], seenby[];
   int num_seen, net[], node[];
{
   char *ptr, *p1, *curloc, next[50];
   int lastnet, i, cnt, cnt1;

   lastnet = -100;   /* this is one we won't see.  For initial case */

   ptr = seenby;                 /* start of storage */
   strcpy (ptr, which);          /* either a SEEN-BY: or a PATH */
   cnt = strlen(ptr) + 1;        /* this holds length of line */
   curloc = ptr + strlen(ptr);   /* holds our place in storage */
   for (i = 0; i < num_seen; i++)  /* do all of them */
      {
         if ((net[i] >= 0) && (node[i] > 0)) /* skip negatives */
            {
               if (net[i] == lastnet)  /* just put node number in */
                  {
                     itoa (node[i], next, 10);  /* converts node to ascii */
                     p1 = &next[strlen(next)]; /* skip to end */
                     *p1++ = ' ';               /* put a space & NULL */
                     *p1 = '\0';
                  }
               else {      /* put in the net/node */
                  itoa (net[i], next, 10);  /* convert net to ascii */
                  p1 = &next[strlen(next)];  /* skip to end */
                  *p1++ = '/';               /* throw in that slash */
                  itoa (node[i], p1,   10);   /* put node after slash */
                  p1 = &p1  [strlen(p1  )];  /* skip to end */
                  *p1++ = ' ';               /* put trailer space in */
                  *p1 = '\0';
                  lastnet = net[i];       /* update last net */
                 };
               /* now, the node or net/node has been put in 'next', but
                  we have to now see about putting it in storage space */

               if (cnt + strlen(next) >= 70)   /* this is too long */
                  {  /* since we are starting a new line, we automatically */
                     /* have to put in the full NET/NODE pair */
                     *curloc++ = '\r';  /* throw in a CR/LF */
                     *curloc++ = '\n';
                     cnt1 = 0;      /* line is now zero chars long */
                     strcpy (curloc, which);  /* put SEEN-BY: or PATH in */
                     cnt = strlen(curloc) + 2;  /* length of line */
                     cnt1 = cnt - 2;  /* only length of net/node pairs */
                     curloc += cnt1;  /* move past SEE-BY: or PATH */
                     itoa (net[i], next, 10); /* put net in there */
                     p1 = &next[strlen(next)];
                     *p1++ = '/';         /* now put in out /node */
                     itoa (node[i], p1, 10);
                     p1 = &p1[strlen(p1)];
                     *p1++ = ' ';         /* trailer space and NULL */
                     *p1 = '\0';
                  };
               strcpy (curloc, next);  /* now put the string in storage */
               cnt1 = strlen (next);   /* add in lenght of this line */
               curloc += cnt1;   /* update pointers */
               cnt += cnt1;
             }
         strcpy (curloc, "\r\n\r\n");
       }
}

/*-----------------------------------------------------------------------*/
/*    Do_Seenby function.  This will handle Seen-By/Path processing.  It */
/*    reads them in, inserts us if needed, and re-creates them again.    */
/*-----------------------------------------------------------------------*/
int do_seenby (filename, ournet, ournode)
   FNAME filename;
   int   ournet, ournode;
{
   int fdscr, buffset, start;
   int num_seen, pathnet[MAX_SB], pathnode[MAX_SB], num_paths;
   int added, xferred, loop;
   char seenby[MAX_SB * 7], pathcont[MAX_SB * 7];
   FILE *outfile;

   start = 0;

   buffset = buffer.place;
   tear = get_tear(buffer.storage);
   if (tear == -1) {
         return (STRANGE);
         };
   seenbys = get_seenby(buffer.storage, tear);
   if (seenbys == -1) {
         return (STRANGE);
         };
   start = seenbys;
   path = get_path(buffer.storage, seenbys, buffset);
   if (path == -1) {
         return (STRANGE);
         };
   num_seen  = grab_seenbys(seenbys, path, buffer.storage, net, node);
   num_paths = grab_seenbys(path, buffset, buffer.storage, pathnet, pathnode);
   added = add_us (&num_seen, ournet, ournode);

   if (!added) return(added);  /* if we haven't added anything, don't write */

   make_seenbys(SEEN_BY, num_seen, seenby, net, node);
   make_seenbys (PATH2, num_paths, pathcont, pathnet, pathnode);

   if (buffer.storage[start-1] < ' ')
      {
      start--;
      while (buffer.storage[start] < ' ') {
         start--;
         }  /* skip past any and all junk! */
      }
   start++;  /* move to next available spot before inserting */
   strcpy (&buffer.storage[start], CRLF);
   start += strlen(CRLF);
   strcpy (&buffer.storage[start], seenby);
   buffset = start + strlen(seenby) - 4; /* get by trailing junk in there! */
   path = buffset;
   strcpy (&buffer.storage[path], CRLF);
   path += strlen(CRLF);
   strcpy (&buffer.storage[path], pathcont);
   buffset += strlen(pathcont);

   buffer.place = buffset;

   xferred = do_message (filename, &buffer, PUT, buffer.place);

   if (xferred != buffer.place) {
        fprintf (stderr, "Couldn't write out all of message %s.\n", filename);
        fprintf (stderr, "We only got %d out of %d.\n", xferred, buffer.place);
        exit (DISK_WRITE_ERROR);
     }

   return (added);
}

/***************************   MAIN ENTRY POINT **************************/

/*-----------------------------------------------------------------------*/
/*    MAIN function.    This is where it's all at.                       */
/*-----------------------------------------------------------------------*/

main (argc, argv)
   int   argc;
   char *argv[];
{
   int error, lowmsg, tmp, ournet, ournode, added, new = 0;
   int num_keys, num_names, num_subjs;
   FNAME areasname, keyfile, trimarea, path, arealoc, filename, store;
   struct ffblk *fentry;
   char cvbuf[10], lonum[10], *found;

   strcpy (progname, argv[0]);

   printf ("TRIMMER: FidoNet EchoMail Trimmer (non-destructive)\n");
   printf ("VERSION: %s\n", VERSION);
   printf ("AUTHOR:  Steven M. Palm\n");
   printf ("FIDO:    %s\n", MYNODE);
   printf ("US MAIL: 9183 W. Chester St, #10, Milwaukee, WI 53214\n\n");

   if
   (!startup(argc, argv, &ournet, &ournode, areasname, trimarea, keyfile))
     {
      printf ("use %s -h for help\n", argv[0]);
      exit (NO_PARAMETERS);
   };

   getkeys (keyfile, keys, &num_keys, names, &num_names, subjects, &num_subjs);
   whereis(areasname, trimarea, arealoc);

   if (!(fentry = (struct ffblk *) malloc(sizeof (struct ffblk)))) {
      fprintf (stderr, "Not enough memory!!\n");
      exit (OUT_OF_MEMORY);
   };

   strcpy (path, arealoc);
   lowmsg = getlow(path);
   strcat (path, mask);
   strcpy (lonum, (char *) strstr(mask, "."));
   itoa (lowmsg, cvbuf, 10);
   strcat (cvbuf, lonum);
   strcpy (lonum, cvbuf);

   if ((error = findfirst (path, fentry, 0L)) == -1) {
         sprintf (store, "File mask was %s", path);
         perror (store);
         };

   printf ("Processing Messges in area %s, for %d/%d using keyfile %s.\n",
               trimarea, ournet, ournode, keyfile);
   printf ("Starting at message %d\n\n", lowmsg);

   while (error != -1) {
      strcpy (filename, fentry->ff_name);
      tmp = atoi (filename);
      addpath (arealoc, filename);

      if (tmp > lowmsg) {
         new = 1;
         if (search (filename, num_keys, keys, num_names, names, num_subjs,
                     subjects))
               {
                 if (!quiet)
                   {
                    printf ("MSG in %s not touched. A keyword was found.\n",
                                filename);
                   }
                }
                else
                     {
                        added = do_seenby (filename, ournet, ournode);
                        switch (added) {
                          case 1 : if (!quiet) {
                                     printf ("%d/%d added", ournet, ournode);
                                     printf (" to SEEN-BY's in %s\n",
                                                       filename);
                                      };
                                   break;
                         default : if (!quiet) {
                                     printf ("%d/%d NOT added to SEEN-BY's",
                                                   ournet, ournode);
                                     printf (" in %s. Already there?\n",
                                                    filename);
                                     };
                                   break;
                         };
                     };
            };
          error = findnext(fentry);
    };

   if (new == 0) printf ("\nNo new messages.  Re-Set HighWater "
                         "mark and run again.\n");
   exit (0);
}


/*-----------------------------------------------------------------------*/
/*    usage function.  This prints out the instructions if not enough    */
/*    command line arguments were given to us.                           */
/*-----------------------------------------------------------------------*/

void usage(char *progname)
{
   printf("  %s [<-aAREAS.BBS><-mMASK><-o>] NET/NODE AREANAME SEARCHFILE\n\n",
    progname);
   printf("Where -a will allow you to specify the name and path\n");
   printf("of your AREAS.BBS file.  (note: no spaces!)\n\n");
   printf("-m will allow you to specify an altername mask for the wildcard\n");
   printf("search.  -m*.MSG is the default. (note: no spaces!)\n\n");
   printf("AREANAME is the area you would like to trim.\n\n");
   printf("SEARCHLIST is the name of the file that has the list of keywords\n");
   printf("you want to look for, each one on it's own line. If a keyword is\n");
   printf("prefixed by a tilde '~', only the SUBJECT: line is searched.  In\n");
   printf("a like manner, if it is prefixed by a carat '^' only the TO: and\n");
   printf("FROM: lines are searched.  Otherwise, the message text is searched.\n");
   printf("Use -o on the command line to search origin lines for text too.\n\n");
   printf("Please, send your hate mail to:  %s @ fidonet.org\n", MYNODE);
   exit(0);
}
/*
   This superfluous function was left intact for debugging use only.
      It is not compiled with the program, so it only increases source
      length.  I used it to obtain a HEX dump of the buffer before and
      after the insertion of data to curtail wierd things.

hex_dump ()
{
   int loop, loop2;
   char hex[] = "0123456789ABCDEF";
   char  *position;

   position = buffer.storage;
   printf ("buffer has %d characters.\n", buffer.place);
   for (loop = 0; loop <= (buffer.place / 16) ; loop++)
      {
         for (loop2 = 0; loop2 < 16; loop2++)
            {
            putchar (hex[(position[loop2] / 16)]);
            putchar (hex[(position[loop2] % 16)]);
            putchar (' ');
            };
         for (loop2 = 0; loop2 < 16; loop2++, *position++)
            if ((*position < ' ') || (*position > 'z')) putchar ('.');
         else putchar (*position);
         putchar ('\n');
      }
}
*/
