; DLC v2.48 - Copyright (C) 1991-1993 Robert Presland

; Any line preceeded by a semi-colon (;) is a comment and will be ignored
; as well as any blank lines.  The order of the keywords in this file
; is not important.

;----------------------------------------------------------------------------

; The 'AreaDat' keyword specifies the Maximus control area which specifies
; the file area specifications.  This keyword is required.  You should
; always use fully qualified path names both in the FILEAREA.CTL file
; as well as in any configuration file!

AreaDat C:\MAX\AREA.DAT

;----------------------------------------------------------------------------

; The 'LogFile' keyword specifies in what file you want the log to be written.

LogFile DLC.LOG

;----------------------------------------------------------------------------

; The 'LogLevel' keyword specifies how much information will be entered
; in the log file.  Default is Level 6

LogLevel 3

;----------------------------------------------------------------------------

; The 'BBSLog' keyword specifies a Maximus log file to parse for downloads.
; This keyword is optional and if omitted, DLC will not update any counters.

BBSLog C:\MAX\MAX.LOG

;----------------------------------------------------------------------------

; The 'CounterStyle' keyword specifies which counter delimiter to use.
; If this keyword is omitted, then style 1 will be used.  The various
; styles are as follows:
;
;     Style 1 = [ ]   Style 2 = { }   Style 3 = ( )   Style 4 = < >

CounterStyle 1

;----------------------------------------------------------------------------

; The 'CounterLength' keyword tells DLC how many digits to use in the counter.
; If you specify 4, then there will be 4 characters between the delimiters.
; Numbers will NOT be zero padded however, they will be space padded on
; the left, ie. [   1].  The default is 4 characters.

;CounterLength 3

;----------------------------------------------------------------------------

; The 'DownloadLog' keyword specifies that DLC should create a download
; log of all files downloaded (obtained from the BBSLog specification)
; in the form:
;
;     <name> <file> <protocol> <date> <time>
;
;     JOE_SYSOP FILENAME.EXT Z 01-NOV 12:34:56

;DownloadLog C:\MAX\DL.LOG

;----------------------------------------------------------------------------

; The 'MailerLog' keyword specifies a FrontDoor or Binkley log
; file to parse for files that are sent, and will be treated as
; downloaded.

MailerLog C:\FD\FD.LOG
;MailerLog C:\BINKLEY\BINKLEY.LOG
;----------------------------------------------------------------------------

; The 'IgnoreExt' keyword instructs DLC to ignore all files with the
; specified extension, that is they will not be viewed as downloaded.
; DLC knows enough to exclude the MO?, TU?, WE?, TH?, FR?, SA?, and
; SU? extensions, also the QW? extensions, as well as the standard 
; PKT extension.  You are allowed up to 60 extensions, do NOT include
; the dot when specifying extensions!

IgnoreExt TIC
IgnoreExt RSP
IgnoreExt OUT
IgnoreExt CUT
IgnoreExt REQ
IgnoreExt FLE
IgnoreExt DUT
IgnoreExt HUT
IgnoreExt RPT

;----------------------------------------------------------------------------

; The 'IgnoreMatch' keyword works similar to 'IgnoreExt' except it instructs
; DLC to ignore any file that contains the match as you specify. For example,
; If you said 'IgnoreMatch 001BRE' then DLC would ignore any file that has
; 001BRE anywhere in the file name. So, to ignore files with a BR? extension,
; specify 'IgnoreMatch .BR'.

IgnoreMatch 001BRE

;----------------------------------------------------------------------------

; The 'IgnoreFilesWithTic' keyword instructs DLC to ignore the file transfer
; that immediately preceeds the transfer of a TIC file.

IgnoreFilesWithTic

;----------------------------------------------------------------------------

; The 'AddOrphan' keyword instructs DLC to add to the FILES.BBS (or
; equivalent) any file that was downloaded from that area that is not
; listing in the file already.

;AddOrphan

;----------------------------------------------------------------------------

; The 'SpaceForZero' keyword instructs DLC to use a space for a zero
; count instead of a zero.  That is, DLC will insert a [    ] instead
; of a [   0].  The default is to use a zero instead of a space.

;SpaceForZero

;----------------------------------------------------------------------------

; The 'ZeroPadded' keyword instructs DLC to padd counters with zeros
; instead of spaces, ie. [0001] instead of [   1].  This is in effect
; when adding new counters and updating old ones.  The default is to
; pad with spaces.

;ZeroPadded

;----------------------------------------------------------------------------

; The 'ProcessGif' keyword instructs DLC to insert the GIF template in the
; description of all new GIF files (those without a counter).

; ProcessGif

;----------------------------------------------------------------------------

; The 'GifTemplate' tells DLC what the GIF resolution should look like
; when placed in the file's description.  Everything after the keyword
; will be inserted verbatim except the following translation characters
; which will be translated as follows:

;   %W = Width of GIF in pixels
;   %H = Height of GIF in pixels
;   %C = Number of colours in the GIF

; GifTemplate (%Wx%H, %Cc)

;----------------------------------------------------------------------------

; The 'DLCStatFile' keyword specifies the location and name of the
; database to store the downloaded files information for use with the
; DLCTT utility.

DLCStatFile C:\MAX\DLC\DLC.FIL

;----------------------------------------------------------------------------

; The 'TopTen' keyword specifies the output MECCA file in which to put
; the top ten downloads based on the information in DLC.STA.  To reset
; the counts, just delete DLC.STA.  The default is to not create this
; file.

TopTen C:\MAX\DLC\TTDL.BBS

;----------------------------------------------------------------------------

; The 'Top' keyword specifies how many files to list in the 'TopTen' file.
; This number can be anywhere from 1 to 25, the default is 10.

;Top 15
