{========================================================================}
Function EditLine(LineToEdit : String; MaxLength, Row, Col : Byte) : String;
  Var
    Elc : Char;
    Elb : Byte;
    OverWrite : Boolean;
    CharacterPosition, OffSet : Byte;
  Begin
    CharacterPosition := 1; OverWrite := True; AnsiGotoXY(Row,1+Col);
    OffSet := 0;
    Repeat
      Repeat
        Elb := GetInput;
        If Elb = 0 Then
        Begin
          Elb := GetInput;
          Case Elb Of
            71 : Elc := ^W;
            75 : Elc := ^S;
            77 : Elc := ^D;
            79 : Elc := ^R;
            82 : Elc := ^V;
            83 : Elc := ^G;
          Else
            Elc := #0;
          End;
        End
        Else
        Begin
          Elc := Char(Elb);
        End;
      Until Elc In [^A,^C,^D,^F,^G,^H,^L,^M,^Q,^R,^S,^U,^V,^W,' '..'~'];
      Case Elc Of
        ^A : Begin (* Move left to previous word *)
               If CharacterPosition > 2 Then
               Begin
                 Dec(CharacterPosition);
                 While (LineToEdit[CharacterPosition] = ' ') And (CharacterPosition > 1) Do Dec(CharacterPosition);
               End;
               While (LineToEdit[CharacterPosition] <> ' ') And (CharacterPosition > 1) Do Dec(CharacterPosition);
               If LineToEdit[CharacterPosition] = ' ' Then Inc(CharacterPosition);
               While (CharacterPosition-OffSet) < 1 Do Dec(OffSet);
               AnsiGotoXY(Row,1+Col);
               AnsiClearToEOL;
               Write(Copy(LineToEdit,OffSet+1,79));
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^C : Begin (* UpperCase first character *)
               LineToEdit := CapFirst(LineToEdit);
               AnsiGotoXY(Row,1+Col);
               AnsiClearToEOL;
               Write(Copy(LineToEdit,OffSet+1,79));
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^D : Begin (* Move right one character *)
               If CharacterPosition <= Length(LineToEdit) Then
               Begin
                 Inc(CharacterPosition);
                 If (CharacterPosition-(OffSet+1)) > 79 Then
                 Begin
                   Inc(OffSet);
                   AnsiGotoXY(Row,1+Col);
                   Write(Copy(LineToEdit,OffSet+1,79));
                 End;
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End;
             End;
        ^F : Begin (* Move right to next word *)
               While (LineToEdit[CharacterPosition] <> ' ') And (CharacterPosition <= Length(LineToEdit)) Do
               Begin
                 Inc(CharacterPosition);
               End;
               While (LineToEdit[CharacterPosition] = ' ') And (CharacterPosition <= Length(LineToEdit)) Do
               Begin
                 Inc(CharacterPosition);
               End;
               AnsiGotoXY(Row,CharacterPosition+Col);
               While (CharacterPosition-OffSet) > 79 Do Inc(OffSet);
               AnsiGotoXY(Row,1+Col);
               AnsiClearToEOL;
               Write(Copy(LineToEdit,OffSet+1,79));
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^G : Begin (* Delete character under cursor *)
               If CharacterPosition <= Length(LineToEdit) Then
               Begin
                 Delete(LineToEdit,CharacterPosition,1);
                 AnsiGotoXY(Row,1+Col);
                 AnsiClearToEOL;
                 Write(Copy(LineToEdit,OffSet+1,79));
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End;
             End;
        ^H : Begin (* Delete character to left of cursor *)
               If CharacterPosition > 1 Then
               Begin
                 Dec(CharacterPosition);
                 Delete(LineToEdit,CharacterPosition,1);
                 AnsiGotoXY(Row,1+Col);
                 AnsiClearToEOL;
                 Write(Copy(LineToEdit,OffSet+1,79));
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End;
             End;
        ^L : Begin (* LowerCase entire line *)
               LineToEdit := LowerString(LineToEdit);
               AnsiGotoXY(Row,1+Col);
               AnsiClearToEOL;
               Write(Copy(LineToEdit,OffSet+1,79));
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^R : Begin (* Move to end of line *)
               CharacterPosition := Length(LineToEdit)+1;
               While Copy(LineToEdit,CharacterPosition,1) = ' ' Do Delete(LineToEdit,CharacterPosition,1);
               If CharacterPosition > 79 Then
               Begin
                 OffSet := CharacterPosition-79;
               End
               Else
               Begin
                 OffSet := 0;
               End;
               If OffSet > 0 Then
               Begin
                 AnsiGotoXY(Row,1);
                 Write(Copy(LineToEdit,OffSet+1,79)+' ');
               End;
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^S : Begin (* Move left one character *)
               If CharacterPosition > 1 Then
               Begin
                 Dec(CharacterPosition);
                 If (CharacterPosition-OffSet) < 1 Then
                 Begin
                   Dec(OffSet);
                   AnsiGotoXY(Row,1);
                   Write(Copy(LineToEdit,OffSet+1,79));
                 End;
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End;
             End;
        ^U : Begin (* UpperCase entire line *)
               LineToEdit := UpperString(LineToEdit);
               AnsiGotoXY(Row,1+Col);
               AnsiClearToEOL;
               Write(Copy(LineToEdit,OffSet,79));
               AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
             End;
        ^V : Begin (* Toggle insert and overwrite *)
               If OverWrite Then
               Begin
                 OverWrite := False;
                 AnsiGotoXY(24,1);
                 NewTextColor(Black);
                 NewTextBackground(Cyan);
                 Write('Insert   ');
                 AnsiGotoXY(Row,1+Col);
                 NewTextColor(White);
                 NewTextBackground(Black);
                 If CurrentEntry^.TypeOfRecord = Comment Then NewTextColor(White) Else NewTextColor(Cyan);
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End
               Else
               Begin
                 OverWrite := True;
                 AnsiGotoXY(24,1);
                 NewTextColor(Black);
                 NewTextBackground(Cyan);
                 Write('OverWrite');
                 AnsiGotoXY(Row,1+Col);
                 NewTextColor(White);
                 NewTextBackground(Black);
                 If CurrentEntry^.TypeOfRecord = Comment Then NewTextColor(White) Else NewTextColor(Cyan);
                 AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
               End;
             End;
        ^W : Begin (* Move to begining of line *)
               CharacterPosition := 1;
               If OffSet > 0 Then
               Begin
                 OffSet := 0;
                 AnsiGotoXY(Row,1);
                 Write(Copy(LineToEdit,1,79));
               End;
               AnsiGotoXY(Row,CharacterPosition+Col);
             End;
      Else
        If Elc <> ^M Then
        Begin
          If Elc = ^Q Then
          Begin
            AnsiGotoXY(24,1);
            NewTextColor(Black);
            NewTextBackground(Cyan);
            Write('Quoting  ');
            AnsiGotoXY(Row,1+Col);
            NewTextColor(White);
            NewTextBackground(Black);
            If CurrentEntry^.TypeOfRecord = Comment Then NewTextColor(White) Else NewTextColor(Cyan);
            Elb := GetInput;
            Elc := Char(Elb);
            AnsiGotoXY(24,1);
            NewTextColor(Black);
            NewTextBackground(Cyan);
            If OverWrite Then Write('OverWrite') Else Write('Insert   ');
            AnsiGotoXY(Row,1+Col);
            NewTextColor(White);
            NewTextBackground(Black);
            If CurrentEntry^.TypeOfRecord = Comment Then NewTextColor(White) Else NewTextColor(Cyan);
          End;
          If OverWrite Then
          Begin
            If CharacterPosition <= Length(LineToEdit) Then
            Begin
              LineToEdit[CharacterPosition] := Elc;
              AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
              If (CharacterPosition-(OffSet+1)) < 79 Then Write(Elc);
              Inc(CharacterPosition);
              If (CharacterPosition-(OffSet+1)) > 79 Then
              Begin
                Inc(OffSet);
                AnsiGotoXY(Row,1);
                Write(Copy(LineToEdit,OffSet+1,79));
              End;
              AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
            End
            Else
            Begin
              If Length(LineToEdit) < MaxLength Then
              Begin
                LineToEdit := LineToEdit + Elc;
                AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
                If (CharacterPosition-(OffSet+1)) < 79 Then Write(Elc);
                Inc(CharacterPosition);
                If (CharacterPosition-(OffSet+1)) > 79 Then
                Begin
                  Inc(OffSet);
                  AnsiGotoXY(Row,1);
                  Write(Copy(LineToEdit,OffSet+1,79));
                End;
                AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
              End;
            End;
          End
          Else
          Begin
            If Length(LineToEdit) < MaxLength Then
            Begin
              LineToEdit := Copy(LineToEdit,1,CharacterPosition-1)+Elc+Copy(LineToEdit,CharacterPosition,Length(LineToEdit));
              AnsiGotoXY(Row,1+Col); Write(Copy(LineToEdit,OffSet+1,79)); Inc(CharacterPosition);
              AnsiGotoXY(Row,(CharacterPosition+Col)-OffSet);
            End;
          End;
        End;
      End;
    Until Elc = ^M;
    EditLine := LineToEdit;
  End;
{========================================================================}
Procedure EditDescriptionLine;
  Var
    MaxLength : Byte;
  Begin
    If CurrentEntry^.TypeOfRecord = Comment Then MaxLength := 79 Else MaxLength := 141;
    CurrentEntry^.Description := EditLine(CurrentEntry^.Description,MaxLength,25,0);
  End;
{========================================================================}
Procedure EditDescription;
  Var
    edc : char;
  Begin
    If CurrentEntry^.TypeOfRecord <> Orphan Then
    Begin
      Altered := True;
      AnsiGotoXY(24,1); NewTextColor(Black); NewTextBackground(Cyan);
      Write('OverWrite  ^w/^a/^s Left  ^d/^f/^r Right  ^h/^g Del ^v Toggle Insert            ');
      AnsiGotoXY(25,1); NewTextBackground(Black);
      If CurrentEntry^.TypeOfRecord = Comment Then NewTextColor(White) Else NewTextColor(Cyan);
      AnsiClearToEOL; Write(Copy(CurrentEntry^.Description,1,79));
      EditDescriptionLine;
      AnsiGotoXY(25,1); AnsiClearToEOL;
      If CurrentEntry^.TypeOfRecord = Comment Then
      Begin
        NewTextColor(White);
        AnsiGotoXY(Row,2); AnsiClearToEOL;
        Write(CurrentEntry^.Description);
      End
      Else
      Begin
        NewTextColor(Cyan);
        AnsiGotoXY(Row,33); AnsiClearToEOL;
        Write(Copy(CurrentEntry^.Description,1,48));
      End;
      AnsiGotoXY(24,1);
      NewTextColor(Black);
      NewTextBackground(Cyan);
      Write(Pgmid+'      ^Q=quit ?=help');
      NewTextColor(White);
      NewTextBackground(Black);
      AnsiGotoXY(24,80);
    End;
  End;
{========================================================================}
