Unit MaxAreas;

Interface

Const
  MaxClass = 12;
  MaxOvr = 16;
Type
  ArrayInPtr = ^ArrayInType;
  ArrayInType = Array[1..255] Of Char;
  Override = Record
    Priv : Integer;
    Lock1, lock2 : Word;
    Ch : Char;
    Fill : Byte;
  End;
  AreaRecordType = Record
    Id : Array[1..4] Of Char;
    StructLen : Word;
    AreaNo : Array[1..2] Of Char;
    Name : Array[1..40] Of Char;
    AreaType : Word;
    MsgPath : Array[1..80] Of Char;
    MsgName : Array[1..40] Of Char;
    MsgInfo, MsgBar : Array[1..80] Of Char;
    Origin : Array[1..62] Of Char;
    MsgPriv : Integer;
    MsgLock, Fill1 : Byte;
    OriginAka : Word;
    FilePath, UpPath, FileBar, FilesBbs, FileInfo : Array[1..80] Of Char;
    FilePriv : Integer;
    FileLock, Fill2 : Byte;
    MsgMenuName, FileMenuName : Array[1..13] Of Char;
    Attrib : Array[1..MaxClass] Of Word;
    Movr : Array[1..MaxOvr] Of Override;
    Fovr : Array[1..MaxOvr] Of Override;
    MsgLock1, MsgLock2, FileLock1, FileLock2 : Word;
    KillByAge, KillByNum : Word;
  End;
Var
  AreaPath : String[80];
  StructLen : Word;
  TotalAreas : Word;
  AreaDatOpen : Boolean;
  RecordBuffer : Pointer;

Function OpenMaxArea : Boolean;
Function GetMaxArea(AreaNo : LongInt) : Byte;
Function PutMaxArea(AreaNo : LongInt) : Byte;
Procedure CloseMaxArea;
Function Array2String(ArrayIn : ArrayInPtr) : String;
Procedure String2Array(ArrayOut : ArrayInPtr; InString : String; ArraySize : Byte);

Implementation

Uses
  Crt, Dos;
Var
  DirInfo : SearchRec;
  AreaDat : File;
{========================================================================}
Function OpenMaxArea : Boolean;
  Begin
    If Not AreaDatOpen Then
    Begin
      FindFirst(AreaPath,Archive,DirInfo);
      If DosError <> 0 Then
      Begin
        StructLen := 0;
        TotalAreas := 0;
        AreaDatOpen := False;
      End
      Else
      Begin
        Assign(AreaDat,AreaPath);
        FileMode := 64;
        Reset(AreaDat,1);
        Seek(AreaDat,4);
        BlockRead(AreaDat,StructLen,SizeOf(StructLen));
        TotalAreas := FileSize(AreaDat) Div StructLen;
        GetMem(RecordBuffer,StructLen);
        AreaDatOpen := True;
      End;
    End;
    OpenMaxArea := AreaDatOpen;
  End;
{========================================================================}
Function GetMaxArea(AreaNo : LongInt) : Byte;
  Begin
    If OpenMaxArea Then
    Begin
      If (StructLen*AreaNo) > FileSize(AreaDat) Then
      Begin
        GetMaxArea := 254;
      End
      Else
      Begin
        Seek(AreaDat,StructLen*(AreaNo-1));
        BlockRead(AreaDat,RecordBuffer^,StructLen);
        GetMaxArea := 0;
      End;
    End;
  End;
{========================================================================}
Function PutMaxArea(AreaNo : LongInt) : Byte;
  Begin
    If OpenMaxArea Then
    Begin
      If (StructLen*AreaNo) > FileSize(AreaDat) Then
      Begin
        PutMaxArea := 254;
      End
      Else
      Begin
        Seek(AreaDat,StructLen*(AreaNo-1));
        BlockWrite(AreaDat,RecordBuffer^,StructLen);
        PutMaxArea := 0;
      End;
    End;
  End;
{========================================================================}
Procedure CloseMaxArea;
  Begin
    If AreaDatOpen Then
    Begin
      Close(AreaDat);
      FreeMem(RecordBuffer,StructLen);
      AreaDatOpen := False;
    End;
  End;
{========================================================================}
Function Array2String(ArrayIn : ArrayInPtr) : String;
  Var
    Asx : Byte;
    Ass : String;
  Begin
    Asx := 1;
    While ArrayIn^[Asx] <> #0 Do
    Begin
      Ass[Asx] := ArrayIn^[Asx];
      Inc(Asx);
    End;
    Ass[0] := Char(Asx-1);
    Array2String := Ass;
  End;
{========================================================================}
Procedure String2Array(ArrayOut : ArrayInPtr; InString : String; ArraySize : Byte);
  Var
    Sab : Byte;
  Begin
    For Sab := 1 To ArraySize Do ArrayOut^[Sab] := #0;
    For Sab := 1 To Length(InString) Do ArrayOut^[Sab] := InString[Sab];
  End;
{========================================================================}
Begin
  AreaDatOpen := False;
End.
{========================================================================}
