Program Maximus_File_Manager;

Uses
  Crt, Dos, MaxAreas, Memory, MfmCopy, Screen, Strings;

Const
  Pgmid = 'MFM 1.11b 07jan92 MWBJR Enterprise 1:273/701.0 (215)641-0270';
  Base153A = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ@!#$%&''()-^_`{}~';
  Base153B = '';
  Base153C = '';
  MaxSkip = 20;

Type
  TypeOfRecordType = (Comment,FileRecord,Orphan,Offline);
  ListPtr = ^ListRecord;
  ListRecord = Record
    NextEntry, PrevEntry : ListPtr;
    TypeOfRecord : TypeOfRecordType;
    FileName : String[12];
    FileSize, FileDate : LongInt;
    Description : String[144];
    Tagged : Boolean;
  End;
  AreaPtr = ^AreaRecord;
  AreaRecord = Record
    NextEntry, PrevEntry : AreaPtr;
    AreaPath, Name : String[40];
    Changed : Boolean;
  End;
  S8 = String[8];

Var
  Gcx : Char;
  Gbx : Byte;
  Counter, Row, AreaCounter, OffSet, Columns, ColumnPos : Byte;
  Result : Word;
  FileList, NewFileList : Text;
  DirInfo : SearchRec;
  Date : DateTime;
  Month, Day : String[2];
  Year : String[4];
  AreaMask : String[20];
  FileAreaPath : String[80];
  WorkString : String;
  NumberOfEntries, NumberOfAreaEntries, NumberOfFiles : Word;
  D : DirStr;
  N : NameStr;
  E : ExtStr;
  Altered, FilesBbs : Boolean;
  FirstEntry, LastEntry, NewEntry, OldEntry, TopEntry, NextPrintEntry,
  CurrentEntry, StackEntry, KillEntry, BeginSort, EndSort : ListPtr;
  FirstAreaEntry, LastAreaEntry, NewAreaEntry,
  OldAreaEntry, CurrentAreaEntry, ChooseAreaEntry : AreaPtr;
  StringToFind : String[12];
  FreeSpace, SizeOfFiles : LongInt;
  FreeSpaceString : String[6];
  OkToAddToList, Changed, MfmRunFb, AreaChanged : Boolean;
  Base153 : String[153];
  SkipList : Array[1..MaxSkip] Of String[12];
{========================================================================}

{$I DISPLAY.PAS}
{$I SETUP.PAS}
{$I HELP.PAS}
{$I EDIT.PAS}
{$I ADOPTINS.PAS}
{$I PUSHPOP.PAS}
{$I SAVEKILL.PAS}
{$I QUIT.PAS}
{$I AREA.PAS}
{$I COPYMOVE.PAS}
{$I SORT.PAS}
{$I RENFIND.PAS}
{$I VIEWFILE.PAS}

{========================================================================}
Procedure ParseCommandLine;
  Var
    x : Byte;
    FileAreaPathOk, AreaPathOk, OutputSelected : Boolean;
  Begin
    ReDirectTo := StandardIO; FileAreaPath := ''; Columns := 5; ColumnPos := 16;
    FileAreaPathOk := False; AreaPathOk := False; OutputSelected := False;
    MfmRunFb := False; AreaChanged := False;
    Assign(Input,''); Reset(Input);
    Assign(Output,''); Rewrite(Output);
    WriteLn(Pgmid); WriteLn;
    If ParamCount = 0 Then
    Begin
      ReDirectTo := Console;
      OutputSelected := True;
      AssignCrt(Input); Reset(Input);
      AssignCrt(Output); Rewrite(Output);
      Fsplit(Fexpand(ParamStr(0)),D,N,E);
      AreaPath := D+'AREA.DAT';
      GetAreaTable;
      If NumberOfAreaEntries < Columns Then Columns := NumberOfAreaEntries;
      SetupScreen;
      FileAreaPath := ChooseArea;
      If (FileAreaPath = 'QUIT') Or (FileAreaPath = 'QUITQUICK') Then
      Begin
        Halt(250);
      End;
    End
    Else
    Begin
      For x := 1 To ParamCount Do
      Begin
        If Copy(UpperString(ParamStr(x)),1,2) = '-A' Then
        Begin
          AreaPathOk := True;
          AreaPath := Copy(UpperString(ParamStr(x)),3,Length(ParamStr(x))-2);
          If Length(AreaPath) > 0 Then
          Begin
            FindFirst(AreaPath,Archive,DirInfo);
            If DosError <> 0 Then
            Begin
              If Copy(AreaPath,Length(AreaPath),1) <> '\' Then AreaPath := AreaPath + '\';
              FindFirst(AreaPath+'AREA.DAT',Archive,DirInfo);
              If DosError <> 0 Then
              Begin
                WriteLn('AREA.DAT not found in '+AreaPath+' !');
                Halt(1);
              End
              Else
              Begin
                AreaPath := AreaPath + 'AREA.DAT';
              End;
            End;
          End;
        End;
        If Copy(UpperString(ParamStr(x)),1,2) = '-C' Then
        Begin
          OutputSelected := True;
          If Copy(ParamStr(x),3,1) = '0' Then
          Begin
            ReDirectTo := Console;
            AssignCrt(Input); Reset(Input);
            AssignCrt(Output); Rewrite(Output);
          End;
          If Copy(ParamStr(x),3,1) = '1' Then
          Begin
            ReDirectTo := ComPort1;
            Assign(Input,'Com1'); Reset(Input);
            Assign(Output,'Com1'); Rewrite(Output);
          End;
          If Copy(ParamStr(x),3,1) = '2' Then
          Begin
            ReDirectTo := ComPort2;
            Assign(Input,'Com2'); Reset(Input);
            Assign(Output,'Com2'); Rewrite(Output);
          End;
          If Copy(ParamStr(x),3,1) = '9' Then
          Begin
            ReDirectTo := StandardIO;
            Assign(Input,''); Reset(Input);
            Assign(Output,''); Rewrite(Output);
          End;
        End;
        If Copy(UpperString(ParamStr(x)),1,2) = '-P' Then
        Begin
          FileAreaPathOk := True;
          FileAreaPath := Copy(UpperString(ParamStr(x)),3,Length(ParamStr(x))-2);
          If Length(FileAreaPath) > 0 Then
          Begin
            If Copy(FileAreaPath,Length(FileAreaPath),1) <> '\' Then FileAreaPath := FileAreaPath + '\';
            FindFirst(FileAreaPath+'*.*',AnyFile,DirInfo);
            If DosError <> 0 Then
            Begin
              WriteLn('Directory '+FileAreaPath+' not found!');
              Halt(1);
            End;
          End;
        End;
        If Copy(UpperString(ParamStr(x)),1,2) = '-K' Then
        Begin
          Val(Copy(ParamStr(x),3,1),Columns,Result);
          If Columns < 3 Then Columns := 3;
          If Columns > 8 Then Columns := 8;
        End;
        If Copy(UpperString(ParamStr(x)),1,2) = '-R' Then
        Begin
          MfmRunFb := True;
        End;
      End;
      If Columns = 3 Then ColumnPos := 25;
      If Columns = 4 Then ColumnPos := 20;
      If Columns = 5 Then ColumnPos := 16;
      If Columns = 6 Then ColumnPos := 14;
      If Columns = 7 Then ColumnPos := 12;
      If Columns = 8 Then ColumnPos := 10;
      If (Not AreaPathOk) Then
      Begin
        Fsplit(Fexpand(ParamStr(0)),D,N,E);
        AreaPath := D+'AREA.DAT';
      End;
      GetAreaTable;
      If NumberOfAreaEntries < Columns Then Columns := NumberOfAreaEntries;
      If (Not OutputSelected) Then
      Begin
        ReDirectTo := Console;
        OutputSelected := True;
        AssignCrt(Input); Reset(Input);
        AssignCrt(Output); Rewrite(Output);
      End;
      SetupScreen;
      If (Not FileAreaPathOk) Then
      Begin
        FileAreaPath := ChooseArea;
        If (FileAreaPath = 'QUIT') Or (FileAreaPath = 'QUITQUICK') Then
        Begin
          Halt(250);
        End;
      End;
    End;
  End;
{========================================================================}
Procedure BuildSkipList;
  Var
    Bslb : Byte;
    InFile : Text;
  Begin
    For Bslb := 1 To MaxSkip Do SkipList[Bslb] := 'ACBDEFGHIJKL';
    Fsplit(Fexpand(ParamStr(0)),D,N,E);
    FindFirst(D+'MFM-SKIP.LST',AnyFile,DirInfo);
    If DosError = 0 Then
    Begin
      Assign(InFile,D+'MFM-SKIP.LST');
      Reset(InFile);
      Bslb := 1;
      While (Not Eof(InFile)) And (Bslb < MaxSkip) Do
      Begin
        ReadLn(InFile,SkipList[Bslb]);
        Inc(Bslb);
      End;
      Close(InFIle);
    End;
  End;
{========================================================================}
Begin
  Altered := False; BeginSort := NIL; EndSort := NIL;
  Base153 := Base153A + Base153B + Base153C;
  ParseCommandLine; BuildSkipList;
  NumberOfEntries := 0; BuildList;
  StringToFind := '';
  If NumberOfEntries = 0 Then
  Begin
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write('This area contains no files!');
    Repeat
      FileAreaPath := ChooseArea;
      NumberOfEntries := 0; BuildList;
      If NumberOfEntries = 0 Then
      Begin
        AnsiGotoXY(25,1); AnsiClearToEOL;
        Write('This area contains no files!');
      End;
    Until NumberOfEntries > 0;
  End;
  If NumberOfEntries > 0 Then
  Begin
    Row := 1; CurrentEntry := FirstEntry; TopEntry := FirstEntry; DisplayScreen;
    Repeat
      Gcx := UpCase(FileAreaPath[1]);
      AnsiGotoXY(24,1);
      NewTextColor(Black); NewTextBackground(Cyan);
      FreeSpace := DiskFree(Ord(Gcx)-64) Div 1024;
      AnsiClearToEol;
      Write(' Number of files = '+MyStr(NumberOfFiles,3)
            +'   Size of files = '+Bytes(SizeOfFiles Div 1024)
            +'   Free space = '+Bytes(FreeSpace)
            +'   ? = Help');
      NewTextColor(White); NewTextBackground(Black);
      AnsiGotoXY(25,1);
      AnsiClearToEol;
      Write(FileAreaPath);
      AnsiGotoXY(24,80);
      Gbx := GetInput;
      Gcx := Upcase(Chr(Gbx));
      If Gbx = 0 Then
      Begin
        Gbx := GetInput;
        Case Gbx Of
          31 : Begin         { ALT-S }
                 ShellToDos;
                 Gcx := ^@;
               End;
          33 : Begin         { ALT-F }
                 CallShez;
                 Gcx := ^@;
               End;
          38 : Begin         { ALT-L }
                 CallList;
                 Gcx := ^@;
               End;
          44 : Begin         { ALT-Z }
                 CallVpic;
                 Gcx := ^@;
               End;
          47 : Begin         { ALT-V }
                 ViewFile;
                 Gcx := ^@;
               End;
          72 : Gcx := '8';
          80 : Gcx := '2';
          73 : Gcx := '9';
          81 : Gcx := '3';
          71 : Gcx := '7';
          79 : Gcx := '1';
        End;
      End;
      Case Gcx Of
        ^A  : AdoptAllOrphans;
        ^B  : FindString('B');
        ^D  : FindString('D');
        ^F  : FindString('F');
        ^Q  : Begin
                If Altered Then SaveList;
                RemoveAreaList;
                Halt(0);
              End;
        ^X  : Begin
                If CurrentEntry^.PrevEntry <> NIL Then
                  Begin
                    CurrentEntry^.Description := CurrentEntry^.PrevEntry^.Description;
                    NextPrintEntry := CurrentEntry;
                    DisplayRecord(Row);
                    DisplayCurrentLocation;
                  End;
              End;
        ' ' : Begin
                CurrentEntry^.Tagged := (Not CurrentEntry^.Tagged);
                LineDown;
                If CurrentEntry^.NextEntry = NIL Then DisplayCurrentLocation;
              End;
        '8' : LineUp;
        '2' : LineDown;
        '9' : PageUp;
        '3' : PageDown;
        '7' : TopOfList;
        '1' : BottomOfList;
        '#' : MassMove;
        '$' : MassCopy;
        'A' : AdoptAbandon(1);
        'C' : CopyFile;
        'D' : ChangeFileDate;
        'E' : EditDescription;
        'F' : BeginSort := CurrentEntry;
        'I' : InsertBlank;
        'K' : PushRecord(KillEntry);
        'L' : EndSort := CurrentEntry;
        'M' : MoveFile;
        'N' : ChooseNewArea;
        'Q' : Quit;
        'R' : RenameFile;
        'S' : SortList;
        'T' : SortListTime;
        'U' : PopRecord(KillEntry,'B');
        'W' : SaveList;
        '<' : PushRecord(StackEntry);
        '>' : PopRecord(StackEntry,'A');
        ',' : PushRecord(StackEntry);
        '.' : PopRecord(StackEntry,'B');
        '[' : StackPrev(StackEntry);
        ']' : StackNext(StackEntry);
        ';' : ShowStack(StackEntry);
        '{' : StackPrev(KillEntry);
        '}' : StackNext(KillEntry);
        ':' : ShowStack(KillEntry);
        '!' : ReDrawScreen;
        '?' : Help;
      End;
    Until Gcx = #255;
  End;
End.
{========================================================================}
