{========================================================================}
Procedure PushRecord(Var TempEntry : ListPtr);
  Begin
    If (CurrentEntry^.PrevEntry <> NIL) Or (CurrentEntry^.NextEntry <> NIL) Then
    Begin
      If CurrentEntry^.FileName <> 'FILES.BBS' Then
      Begin
        If CurrentEntry^.TypeOfRecord In [Orphan,FileRecord] Then Dec(NumberOfFiles);
        SizeOfFiles := SizeOfFiles-CurrentEntry^.FileSize;
      End;
      Altered := True;
      OldEntry := CurrentEntry;
      If CurrentEntry^.PrevEntry = NIL Then
      Begin
        CurrentEntry^.NextEntry^.PrevEntry := NIL;
        CurrentEntry := CurrentEntry^.NextEntry;
        TopEntry := CurrentEntry;
        FirstEntry := CurrentEntry;
      End
      Else
      Begin
        If CurrentEntry^.NextEntry = NIL Then
        Begin
          CurrentEntry^.PrevEntry^.NextEntry := NIL;
          CurrentEntry := CurrentEntry^.PrevEntry;
          LastEntry := CurrentEntry;
          If TopEntry^.PrevEntry <> NIL Then
          Begin
            TopEntry := TopEntry^.PrevEntry;
          End
          Else
          Begin
            Dec(Row);
          End;
        End
        Else
        Begin
          CurrentEntry^.PrevEntry^.NextEntry := CurrentEntry^.NextEntry;
          CurrentEntry^.NextEntry^.PrevEntry := CurrentEntry^.PrevEntry;
          CurrentEntry := CurrentEntry^.NextEntry;
          If TopEntry = OldEntry Then TopEntry := CurrentEntry;
        End;
      End;
      If TempEntry = NIL Then
      Begin
        TempEntry := OldEntry;
        TempEntry^.PrevEntry := TempEntry;
        TempEntry^.NextEntry := TempEntry;
      End
      Else
      Begin
        If TempEntry^.PrevEntry = TempEntry Then
        Begin
          OldEntry^.PrevEntry := TempEntry;
          OldEntry^.NextEntry := TempEntry;
          TempEntry^.PrevEntry := OldEntry;
          TempEntry^.NextEntry := OldEntry;
          TempEntry := OldEntry;
        End
        Else
        Begin
          OldEntry^.PrevEntry := TempEntry;
          OldEntry^.NextEntry := TempEntry^.NextEntry;
          TempEntry^.NextEntry^.PrevEntry := OldEntry;
          TempEntry^.NextEntry := OldEntry;
          TempEntry := OldEntry;
        End;
      End;
      Dec(NumberOfEntries);
      DisplayScreen;
    End;
  End;
{========================================================================}
Procedure PopRecord(Var TempEntry : ListPtr; BeforeOrAfter : Char);
  Begin
    If TempEntry <> NIL Then
    Begin
      If TempEntry^.FileName <> 'FILES.BBS' Then
      Begin
        If TempEntry^.TypeOfRecord In [Orphan,FileRecord] Then Inc(NumberOfFiles);
        SizeOfFiles := SizeOfFiles+TempEntry^.FileSize;
      End;
      OldEntry := TempEntry;
      If TempEntry^.PrevEntry = TempEntry Then
      Begin
        TempEntry := NIL;
      End
      Else
      Begin
        TempEntry^.PrevEntry^.NextEntry := TempEntry^.NextEntry;
        TempEntry^.NextEntry^.PrevEntry := TempEntry^.PrevEntry;
        TempEntry := TempEntry^.PrevEntry;
      End;
      If BeforeOrAfter = 'B' Then
      Begin
        If CurrentEntry^.PrevEntry = NIL Then
        Begin
          OldEntry^.PrevEntry := CurrentEntry^.PrevEntry;
          OldEntry^.NextEntry := CurrentEntry;
          CurrentEntry^.PrevEntry := OldEntry;
          CurrentEntry := OldEntry;
          TopEntry := CurrentEntry;
          FirstEntry := CurrentEntry;
        End
        Else
        Begin
          OldEntry^.PrevEntry := CurrentEntry^.PrevEntry;
          OldEntry^.NextEntry := CurrentEntry;
          CurrentEntry^.PrevEntry^.NextEntry := OldEntry;
          CurrentEntry^.PrevEntry := OldEntry;
          CurrentEntry := OldEntry;
        End;
      End
      Else
      Begin
        If CurrentEntry^.NextEntry = NIL Then
        Begin
          OldEntry^.NextEntry := CurrentEntry^.NextEntry;
          OldEntry^.PrevEntry := CurrentEntry;
          CurrentEntry^.NextEntry := OldEntry;
        End
        Else
        Begin
          OldEntry^.NextEntry := CurrentEntry^.NextEntry;
          OldEntry^.PrevEntry := CurrentEntry;
          CurrentEntry^.NextEntry^.PrevEntry := OldEntry;
          CurrentEntry^.NextEntry := OldEntry;
        End;
      End;
      Inc(NumberOfEntries);
      DisplayScreen;
    End;
  End;
{========================================================================}
Procedure ShowStack(Var TempEntry : ListPtr);
  Begin
    If TempEntry <> NIL Then
    Begin
      NextPrintEntry := TempEntry;
      DisplayRecord(25);
      AnsiGotoXY(24,80);
    End;
  End;
{========================================================================}
Procedure StackPrev(Var TempEntry : ListPtr);
  Begin
    If TempEntry <> NIL Then
    Begin
      TempEntry := TempEntry^.PrevEntry;
      ShowStack(TempEntry);
    End;
  End;
{========================================================================}
Procedure StackNext(Var TempEntry : ListPtr);
  Begin
    If TempEntry <> NIL Then
    Begin
      TempEntry := TempEntry^.NextEntry;
      ShowStack(TempEntry);
    End;
  End;
{========================================================================}
