{========================================================================}
Procedure RemoveAreaList;
  Var
    BatFile : Text;
  Begin
    If MfmRunFb And AreaChanged Then
    Begin
      Assign(BatFile,D+'MFMRUNFB.BAT');
      ReWrite(BatFile);
      Write(BatFile,'FB AREA.DAT');
    End;
    CurrentAreaEntry := FirstAreaEntry;
    While CurrentAreaEntry^.NextEntry <> NIL Do
    Begin
      OldAreaEntry := CurrentAreaEntry;
      If MfmRunFb And AreaChanged And CurrentAreaEntry^.Changed Then
      Begin
        Write(BatFile,' '+CurrentAreaEntry^.Name);
      End;
      CurrentAreaEntry := CurrentAreaEntry^.NextEntry;
      Dispose(OldAreaEntry);
    End;
    If MfmRunFb And AreaChanged And CurrentAreaEntry^.Changed Then
    Begin
      Write(BatFile,' '+CurrentAreaEntry^.Name);
    End;
    Dispose(CurrentAreaEntry);
    If MfmRunFb And AreaChanged Then Close(BatFile);
  End;
{========================================================================}
Procedure Quit;
  Var Qc : Char;
  Begin
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write('Are you sure? ');
    Repeat
      Gbx := GetInput;
      Qc := Upcase(Chr(Gbx));
    Until Qc In ['N','Y'];
    Write(Qc);
    If Qc = 'N' Then
    Begin
      AnsiGotoXY(25,1); AnsiClearToEOL;
      Exit;
    End;
    If Altered Then SaveList;
    RemoveAreaList;
    NewTextColor(White); NewTextBackground(Black);
    AnsiClearScreen;
    Halt(0);
  End;
{========================================================================}
Procedure ChangeFileDate;
  Var
    Cdc : Char;
    Year, Month, Day, DayOfWeek, Hour, Minute, Second, Sec100 : Word;
    FileToDate : File;
    DateTimeString : String[17];
  Begin
    If CurrentEntry^.TypeOfRecord = FileRecord Then
    Begin
      AnsiGotoXY(25,1); AnsiClearToEOL;
      Write('Change date to current, special or abort? (C/S/A) ');
      Repeat
        Gbx := GetInput;
        Cdc := Upcase(Chr(Gbx));
      Until Cdc In ['C','S','A'];
      Write(Cdc);
      If Cdc In ['C','S'] Then
      Begin
        Case Cdc Of
          'C' : Begin
                  GetDate(Year, Month, Day, DayOfWeek);
                  GetTime(Hour, Minute, Second, Sec100);
                  Date.Year := Year; Date.Month := Month; Date.Day := Day;
                  Date.Hour := Hour; Date.Min := Minute; Date.Sec := Second;
                  PackTime(Date, CurrentEntry^.FileDate);
                End;
          'S' : Begin
                  AnsiGotoXY(25,1); AnsiClearToEOL;
                  DateTimeString := GetDateString(CurrentEntry^.FileDate)+' '+GetTimeString(CurrentEntry^.FileDate);
                  Write(DateTimeString);
                  DateTimeString := EditLine(DateTimeString,17,25,0);
                  AnsiGotoXY(25,40); Write(DateTimeString);
                  CurrentEntry^.FileDate := GetPackedTime(Copy(DateTimeString,1,8),Copy(DateTimeString,10,8));
                End;
        End;
        Assign(FileToDate,FileAreaPath+CurrentEntry^.FileName);
        Reset(FileToDate);
        SetFTime(FileToDate,CurrentEntry^.FileDate);
        Close(FileToDate);
        NextPrintEntry := CurrentEntry;
        DisplayRecord(Row); DisplayCurrentLocation;
      End;
      AnsiGotoXY(24,80);
    End;
  End;
{========================================================================}
