Unit Screen;

Interface

Uses Crt, Dos;

Type
  ReDirectToType = (Console,ComPort1,ComPort2,StandardIO);
Var
  ReDirectTo : RedirectToType;

Function GetInput : Byte;
Procedure NewTextColor(NewColor : byte);
Procedure NewTextBackground(NewColor : Byte);
Procedure AnsiClearScreen;
Procedure AnsiClearToEOL;
Procedure AnsiGotoXY(X, Y : Byte);

Implementation
{========================================================================}
Function GetInput : Byte;
  Var
    Msr : Registers;
    NoInputPending : Boolean;
  Begin
    If ReDirectTo In [Console,StandardIO] Then
    Begin
      Msr.ah := $07;
      MsDos(Msr);
      GetInput := Msr.al;
    End
    Else
    Begin
      NoInputPending := True;
      While NoInputPending Do
      Begin
        Msr.ax := $0300;
        If RedirectTo = ComPort1 Then Msr.dx := 0 Else Msr.dx := 1;
        Intr($14,Msr);
        If (Msr.ax And $0080) <> $0080 Then Halt(255);
        If (Msr.ax And $0100) = $0100 Then NoInputPending := False;
      End;
      Msr.ax := $0200;
      If RedirectTo = ComPort1 Then Msr.dx := 0 Else Msr.dx := 1;
      Intr($14,Msr);
      GetInput := Msr.al;
    End;
  End;
{========================================================================}
Procedure NewTextColor(NewColor : byte);
  Var
    NewColorAnsi : String[6];
    Flash : Boolean;
  Begin
    If ReDirectTo = Console Then
    Begin
      TextColor(NewColor);
    End
    Else
    Begin
      If NewColor > 128 Then
      Begin
        NewColor := NewColor - 128;
        Flash := True;
      End
      Else
      Begin
        Flash := False;
      End;
      Case NewColor of
        0 : NewColorAnsi := '30'; {BLACK}
        1 : NewColorAnsi := '34'; {BLUE}
        2 : NewColorAnsi := '32'; {GREEN}
        3 : NewColorAnsi := '36'; {CYAN}
        4 : NewColorAnsi := '31'; {RED}
        5 : NewColorAnsi := '35'; {MAGENTA}
        6 : NewColorAnsi := '33'; {BROWN}
        7 : NewColorAnsi := '37'; {LIGHTGRAY}
        8 : NewColorAnsi := '1;30'; {BLACK}
        9 : NewColorAnsi := '1;34'; {BLUE}
        10: NewColorAnsi := '1;32'; {GREEN}
        11: NewColorAnsi := '1;36'; {CYAN}
        12: NewColorAnsi := '1;31'; {RED}
        13: NewColorAnsi := '1;35'; {MAGENTA}
        14: NewColorAnsi := '1;33'; {BROWN}
        15: NewColorAnsi := '1;37'; {LIGHTGRAY}
      End;
      If Flash Then NewColorAnsi := '5;'+NewColorAnsi Else NewColorAnsi := '0;'+NewColorAnsi;
      Write(^[+'['+NewColorAnsi+'m');
    End;
  End;
{========================================================================}
Procedure NewTextBackground(NewColor : Byte);
  Var
    NewColorAnsi : String[6];
  Begin
    If ReDirectTo = Console Then
    Begin
      TextBackground(NewColor);
    End
    Else
    Begin
      Case NewColor of
        0 : NewColorAnsi := '40'; {BLACK}
        1 : NewColorAnsi := '44'; {BLUE}
        2 : NewColorAnsi := '42'; {GREEN}
        3 : NewColorAnsi := '46'; {CYAN}
        4 : NewColorAnsi := '41'; {RED}
        5 : NewColorAnsi := '45'; {MAGENTA}
        6 : NewColorAnsi := '43'; {BROWN}
        7 : NewColorAnsi := '47'; {LIGHTGRAY}
      End;
      Write(^[+'['+NewColorAnsi+'m');
    End;
  End;
{========================================================================}
Procedure AnsiClearScreen;
  Begin
    If ReDirectTo = Console Then ClrScr Else Write(^[+'[2J');
  End;
{========================================================================}
Procedure AnsiClearToEOL;
  Begin
    If ReDirectTo = Console Then ClrEol Else Write(^[+'[K');
  End;
{========================================================================}
Procedure AnsiGotoXY(X, Y : Byte);
  Var
    Xpos, Ypos : String[2];
  Begin
    If ReDirectTo = Console Then
    Begin
      GotoXY(Y,X);
    End
    Else
    Begin
      Str(X,Xpos); Str(Y,Ypos);
      Write(^[+'['+Xpos+';'+Ypos+'H');
    End;
  End;
{========================================================================}
End.
