Unit Strings;

Interface

  Type
    ArrayInPtr = ^ArrayInType;
    ArrayInType = Array[1..255] Of Char;

  Function MyStr(InVal : LongInt; MyStrLen : Byte) : String;
  Function LtrimRtrim(InString : String) : String;
  Function UpperString(InString : String) : String;
  Function LowerString(InString : String) : String;
  Function CapFirst(InString : String) : String;
  Function InvertString(InString : String) : String;
  Function RPos(StringToFind,StringToSearch : String) : Byte;
  Function RCopy(InString : String; StartPosition,EndPosition : Byte) : String;

Implementation

  Var
    x : Byte;
    TempString : String;
{========================================================================}
Function MyStr(InVal : LongInt; MyStrLen : Byte) : String;
  Var
    OutString : String;
  Begin
    Str(InVal:MyStrLen,OutString);
    MyStr := OutString;
  End;
{========================================================================}
Function LtrimRtrim(InString : String) : String;
  Begin
    While (Copy(InString,1,1) = ^I) Or (Copy(InString,1,1) = ' ') Do Delete(InString,1,1);
    While (Copy(InString,Length(InString),1) = ^I) Or
          (Copy(InString,Length(InString),1) = ' ')
          Do Delete(InString,Length(InString),1);
    LtrimRtrim := InString;
  End;
{========================================================================}
Function LoCase(InChar : Char) : Char;
  Begin
    If InChar In ['A'..'Z'] Then LoCase := Chr(Ord(InChar)+32) Else LoCase := InChar;
  End;
{========================================================================}
Function UpperString(InString : String) : String;
  Begin
    For x := 1 To Length(InString) Do InString[x] := UpCase(InString[x]);
    UpperString := InString;
  End;
{========================================================================}
Function LowerString(InString : String) : String;
  Begin
    For x := 1 To Length(InString) Do InString[x] := LoCase(InString[x]);
    LowerString := InString;
  End;
{========================================================================}
Function CapFirst(InString : String) : String;
  Begin
    InString := LowerString(InString);
    InString[1] := UpCase(InString[1]);
    CapFirst := InString;
  End;
{========================================================================}
Function InvertString(InString : String) : String;
  Begin
    TempString := '';
    For x := Length(InString) DownTo 1 Do TempString := TempString+InString[x];
    InvertString := TempString;
  End;
{========================================================================}
Function RPos(StringToFind,StringToSearch : String) : Byte;
  Begin
    RPos := Pos(InvertString(StringToFind),InvertString(StringToSearch));
  End;
{========================================================================}
Function RCopy(InString : String; StartPosition,EndPosition : Byte) : String;
  Begin
    InString := Copy(InvertString(InString),StartPosition,EndPosition);
    Rcopy := InvertString(InString);
  End;
{========================================================================}
Begin
End.