
/* This file contains all the definitions needed to access the routines in */
/*  the object file i_f_rtn.obj.  Include this in your source file with    */
/*  the line:   #include "i_f_rtn.h"     and you'll be cooking with gas!   */

/* ------------------------ Function Definitions ------------------------- */

int indexed_file(int *file_handle,int operation,char passed_string[],unsigned char key_no);
                                                        /* The main function. */
/* The first argument is a user-program-defined integer variable which is set */
/*  by the routine when a file is opened.  One variable should be defined for */
/*  each file opened (such as "int ar-file,in-file;").  The next argument is  */
/*  the function code (such as I_F_OPEN_WRITE).  The next is a pointer to the */
/*  file name string or record array defined in the user's program.  Last is  */
/*  the key number.  The first two arguments must always be defined; the      */
/*  record string and key arguments may be replaced by "" and 0 when they are */
/*  not relevant.  See the function codes below for the last two arguments'   */
/*  requirements.                                                             */


extern long i_f_next_file_attribute(char reset_flag);
/* If this function is called with an argument of 1 it returns the first      */
/*  value in the I_F_FILE_ATTRIBUTES string; an argument of 0 returns the     */
/*  next, etc.; -1 is returned when no more exist.  This function can only be */
/*  called when that string is set, usually by the function code              */
/*  I_F_REPORT_ATTRIBUTES.  It is provided for the programmers' convenience.  */
/*  The first attribute is the record length (0 for variable); the second is  */
/*  the number of keys; then, for each key, are 3 numbers:  position, length, */
/*  duplicates flag (0 for none; non-zero for duplicates allowed).            */

/* ----------------------- Routine's Functions ------------------------------ */

/* These are the file operations. */
#define I_F_CLOSE               0
    /* Requires neither the 3rd nor 4th (key) arguments be defined. */
#define I_F_OPEN_READ           1
    /* 3rd argument is pointer to filename string; 4th irrelevant. */
#define I_F_OPEN_WRITE          2  /* (This requires I_F_FILE_ATTRIBUTES set) */
    /* 3rd argument is pointer to filename string; 4th irrelevant. */
#define I_F_OPEN_IO             3
    /* 3rd argument is pointer to filename string; 4th irrelevant. */
#define I_F_CLOSE_ALL           4
    /* 3rd and 4th arguments unneeded. */

/* These are the record operations.  All require the 3rd argument to be a  */
/*  pointer to an array of char in memory, which is the record area.       */
#define I_F_READ               16  /* 4th arg. should be the key # to read. */
#define I_F_START              17  /* 4th arg. is key to start by. */
#define I_F_READNEXT           18  /* 4th arg. is irrelevant. */
#define I_F_READPREV           19  /* (This is not currently implemented) */
#define I_F_WRITE              20  /* 4th arg. is irrelevant. */
#define I_F_REWRITE            21  /* 4th arg. is irrelevant. */
#define I_F_DELETE             22  /* 4th arg. is irrelevant. */

#define I_F_REPORT_ATTRIBUTES  50  /* This sets the string I_F_FILE_ATTRIBUTES.*/


/* ------------------------ Error Codes Returned ------------------------ */

#define I_F_SUCCESS                 0
#define I_F_ERROR_KEYNOTFOUND       1
#define I_F_ERROR_KEYEXISTS         2
#define I_F_ERROR_BADOPERATION     16
#define I_F_ERROR_BADHANDLE        17
#define I_F_ERROR_BADKEY           18
#define I_F_ERROR_BADFILENAME      19
#define I_F_ERROR_BADATTRIBUTES    20
#define I_F_ERROR_BADREVLEVEL      21
#define I_F_ERROR_OUTOFMEMORY      50
#define I_F_ERROR_SHAREWARE_LIMITS 51
#define I_F_ERROR_INTERNAL         98
#define I_F_ERROR_FILECORRUPTED    99


/* ------------------------- Attribute Variables --------------------------*/

extern unsigned short I_F_RECORD_LENGTH;
/* If the record length specified in I_F_FILE_ATTRIBUTES is 0, then this  */
/*  variable should be set before ANY write/rewrite operation and checked */
/*  after any read operation.  WARNING: the file engine uses this variable*/
/*  internally; make sure you set/check it before/after EVERY operation;  */
/*  don't assume that it has remained unchanged since you used it last!   */

extern char I_F_FILE_ATTRIBUTES[128];
/* The user gives key info., etc. here.  Format: numbers seperated by spaces. */
/*  First no. is fixed record length or 0.  The next number is the # of keys. */
/*  Then, for each key, read 3 numbers (position, length, and duplicates).    */

extern char I_F_DIRECTION;
/* This variable determines which direction start, read, and read-next     */
/*  operations search when setting the new "current record pointer"; it    */
/*  determines in which direction the file is to be accessed.  A 0 value   */
/*  represents backwards access and non-zero means forward access.  Note   */
/*  that one of these operations (start, read, or read-next must be called */
/*  each time the direction is changed for the direction change to take    */
/*  effect...                                                              */

