
#include <time.h>

void set_baud_rate(int, int);
int request_status(int);
int initialize_driver(int);
void deinitialize_driver(int);
void raise_lower_dtr(int, int);
void flush_output_buffer(int);
void flow_control(int, int);
int read_block(int, char *, int);
int write_block(int, char *, int);

void write_string(int, char *);
void write_byte(int, int);
void delay(int);


char text11[] = { "\n"
	"1. Enter the phone number you wish to call, followed by a RETURN.\n"
	"   You may use the \"-\" for clarity if you wish. EXAMPLE: 555-1212 (rtn)\n"
	"\n"
	"2. Wait about five seconds and call " };

char text12[] = { " again.\n"
	"\n"
	"   NOTE:\n"
	"   If you are calling a voice line, don't forget to pick up the reciever\n"
	"   and turn off the MODEM after the phone starts to ring.\n"
	"\n"
	"   If you're calling another BBS line, everthing will work the same as\n"
	"   it does when you call this system.\n"
	"\n"
	"\n"
	"Enter the number you wish to call: <555-1212 c/r> " };

char text21[] = {
	"\n"
	"Now hang up, wait five seconds, and call " };

char text22[] = { " again.\n"
	"\n\n" };   

char help[] = {
	"\n"
	"	CALLF <port> <phone #> <set> <reset>\n"
	"\n"
	"	<port> is 1=COM1 or 2=COM2\n"
	"	<phone #> is your phone number for them to call back.\n"
	"	<set> is the phone code to set call forwarding.  Ex: ATDT72#,\n"
	"	<reset> is the phone code to reset call forwarding.  Ex: ATDT73#\n"
	"\n" };


main(argc, argv)
  int argc;
  char *argv[];
{
	int i;
	int port;
	char phone[9];

	printf("Call Forwarding by Daniel Hilderbrand.  343/5\n");

	if (argc < 5 )
	{
		printf(help);
		exit(1);
	}

	if ((argv[1][0] < '1') || (argv[1][0] > '2'))
	{
		printf("\nInvalid port number.  Must be 1=com1 or 2=com2\n");
		printf(help);
		exit(1);
	}

	port = argv[1][0] - '0' - 1;
	printf("port %d\n", port);

	if (initialize_driver(port) < 28)
	{
		printf("This driver is not a high enuf version.\n");
		raise_lower_dtr(port, 0);
		deinitialize_driver(port);
		exit(1);
	}

	flow_control(port, 0);
/*	set_baud_rate(port, 0x83); */

	write_string(port, text11);
	write_string(port, argv[2]);
	write_string(port, text12);

	if (input_phone_number(port, phone) < 8)
	{
		if ((request_status(port) & 0x0080) != 0)
		{
			write_string(port, "\n	Invalid phone number - try again\n");
			delay(5);
			flush_output_buffer(port); 
		}
		raise_lower_dtr(port, 0);
		exit(0);
	}

	write_string(port, text21);
	write_string(port, argv[2]);
	write_string(port, text22);

	delay(5);
/*	flush_output_buffer(port); */
	raise_lower_dtr(port, 0);


/*
**    Now do call forwarding stuff.
*/

	for (i=0; i<2; i++)
	{
		delay(2);
		raise_lower_dtr(port, 1);
		delay(1);

		write_string(port, argv[3]);
		write_string(port, phone);
		write_byte(port, 13);
		printf("\n");

		delay(7);
		flush_output_buffer(port); 
		raise_lower_dtr(port, 0);
	}

	delay(70);

	for (i=0; i<2; i++)
	{
		delay(1);
		raise_lower_dtr(port, 1);
		delay(1);

		write_string(port, argv[4]);
		write_byte(port, 13);
		printf("\n");

		delay(7);
		flush_output_buffer(port); 
		raise_lower_dtr(port, 0);
	}

	deinitialize_driver(0);
}

/*
**    Get phone number.
*/
int input_phone_number(port, ptr)
  int port;
  char *ptr;
{
	int c;
	int len;
	c = 0;
	len = 0;

	while (1)
	{
		while(read_block(port, ((char *) &c), 1) <= 0)
			if ((request_status(port) & 0x0080) == 0)
				return(0);

		if (len == 3)
		{
			*ptr++ = '-';
			len++;
			write_block(port, "-", 1);
			printf("-");
		}

		switch (c)
		{
		  case 13:
			*ptr = 0;
			write_byte(port, 13);
			write_byte(port, 10);
			return(len);

		  case 8:
		  case 127:
			if (len > 0)
			{
				write_byte(port, 8);
				write_byte(port, ' ');
				write_byte(port, 8);
				len--;
				ptr--;
			}
			break;

		  case '0':
			if ((len > 0) && (len < 8))
			{
				*ptr++ = c;
				len++;
				write_byte(port, c);
			}		  	
			break;

		  case '1':
			if ((len > 0) && (len < 8))
			{
				*ptr++ = c;
				len++;
				write_byte(port, c);
			}		  	
			break;

		  default:
			if ((c >= '0') && (c <= '9') && (len < 8))
			{
				*ptr++ = c;
				len++;
				write_byte(port, c);
			}
		}
	}
}

void delay(sec)
  int sec;
{
	int i;
	long last_time;

	for(i=0; i<sec; i++)
	{
		last_time = ((long) time(0));
		while(last_time == ((long) time(0)))
			;
	}
}



void write_string(port, ptr)
  int port;
  char *ptr;
{
	while (*ptr != 0)
		if (*ptr == '\n')
		{
			write_byte(port, 13);
			write_byte(port, 10);
			ptr++;
		}
		else
			write_byte(port, *ptr++);
}

void write_byte(port, c)
  int port, c;
{
	while (write_block(port, ((char *) &c), 1) != 1)
		if ((request_status(port) & 0x0080) == 0)
			break;
	printf("%c", c);
}
