;
TITLE	CRASH.ASM
;
COMMENT *

	Purpose:	Attempts to determine the health of your system
	(whether or not its hung up). It reboots if it determines that
	the system is in bad shape.

	The program also produces a complete crash-dump of the stack,
	program registers, interrupt-controller mask, and interrupt-
	table contents should the operator hit CTL-ALT-DEL.

	Created:	19-MAR-1989		Richard B. Johnson

	Modified:	20-MAR-1989	V1.01	Richard B. Johnson
	Added code to display why the system crashed. Displays the
	SS:SP and CS:IP in hex-ASCII if it was caused by an overflow.

	Also displays:
		Unexpected interrupt.
		Runaway program counter.
		Disk error.
		Parity error.
		Power failure.

	22-MAR-1989			V1.02	Richard B. Johnson
	Added code to fill all of memory with a FAR jump to the crash
	routine (CRASH0). Any program that EXECUTES memory that doesn't
	belong to it will now crash/reboot the system.

	22-MAR-1989			V1.03	Richard B. Johnson
	Added a parity-check vector to the CRASH code. Instead of getting
	a 'PARITY CHECK 1 or PARITY CHECK 2', message, the system will
	now reboot.

	26-MAR-1989			V1.04	Richard B. Johnson
	Changed all the prompts to start with "CRASH-I-..." just like
	a VAX.

	Added routines to give a register dump on all crashes except
	those caused by disk errors.

	Added routines to display disk error parameters should a disk-
	failure cause the crash.

	Added an additional NOP to the FAR crash-calls that memory is
	being loaded with. This should help synchronization.

	Added routines to send the crash information to the printer if
	it is on and operational. None of the BIOS routines are used for
	this. The printer-code is maintained within the checksummed TSR.

	26-MAR-1989			V1.05	Richard B. Johnson
	Added routines to display the time and date of the crash. Since
	the system clock is likely corrupt during a crash, a complete
	internal time-keeping routine is included within the code. This
	time-keeping routine even "understands" day/month/year rollover
	(which DOS doesn't) and even compensates for leap-years.

	28-MAR-1989			V1.06	Richard B. Johnson
	Added routine to obtain the printer-port base-address from
	the BIOS segment during installation. Some printer-cards have
	addresses different than I hard-coded earlier.

	29-MAR-1989			V1.07	Richard B. Johnson
	Added routine to print a time-stamp hourly on the printer (only).
	This should help tell the last time the system was okay.

	29-MAR-1989			V1.08	Richard B. Johnson
	Added routines to detect and display a power-failure. This is
	done by checking for a DSR bit from any of four communications-
	adapter ports. It is assumed that a user will have his modem
	connected to interruptible power, while the computer is fed
	from a non-interruptible standby power supply.

	29-MAR-1989			V1.09	Richard B. Johnson
	Added routines to display the stack-contents before the crash.
	Added routine to write to the printer the time when CRASH is
	installed.

	30-MAR-1989			V1.10	Richard B. Johnson
	Added routines to display the interrupt controller mask and
	the contents of the interrupt table at the time of the crash.

	31-MAR-1989			V1.11	Richard B. Johnson
	Added routines to intercept CTL-ALT-DEL to produce an "operator"
	shutdown. A complete crash-dump is displayed and sent to the
	printer.

	02-APR-1989			V1.12	Richard B. Johnson

	Added routines to print the process being executed.
	Added routines to print the last DOS function call.

	Added routines to allow the user to remove various print-outs
	from the defaults. Commands may be entered on the command-line
	with any/all/no delimiters in any order. The commands may be in
	upper or lower case and they may be abbreviated.

		NOTIME		{ Don't print the hourly time-stamp }
		NOPROGRAM	{ Don't print program being executed }
		NODUMP		{ Don't produce a dump on Ctrl-Alt-Del }
		NOTABLE		{ Don't print the interrupt table }
		NOMASK		{ Don't print the interrupt mask }
		NOSTACK		{ Don't print the stack contents }
		NOREGISTERS	{ Don't print the register contents }
		NOPOWERFAIL	{ Don't monitor power-failure }
		NOBBS		{ Don't monitor BBS operation }
	
	Example:
	CRASH/notime/noprog/nodump/notable/nopow/nostack/noregis

	03-APR-1989			V1.13	Richard B. Johnson
	Added code to print when TSRs are installed.
	Added code to increase the time resolution
	Corrected the spelling of the word 'depth' in the stack display.

	04-APR-1989			V1.14	Richard B. Johnson
	Added code to improve the NMI "memory-parity" routines. Program
	now attempts to find the failing memory location.

	05-APR-1989			V1.15	Richard B. Johnson
	Added code to provide pagination and a heading on the printer-
	listing.

	Changed the method of filling memory with FAR CALLS to the CRASH
	routine. It may have been possible to overwrite the code with the
	previous routine.

	Increased the printer time-out by adding an outside loop-counter.
	Some characters were getting smashed with long listings

	06-APR-1989			V1.16	Richard B. Johnson
	Added code to monitor and log BBS operation. Code records each
	ring and the times that the modem carrier is detected or goes off.
	In the event that 10 rings go unanswered, the system will reboot.

	10-APR-1989			V1.17	Richard B. Johnson
	Changed the disk-parameter display to decimal instead of hex-ASCII.
	Previously, there was only a hex-conversion routine. The decimal
	conversion routine was added when pagination was added so it may
	now be used to display disk-parameters as well

	11-APR-1989			V1.18	Richard B. Johnson
	Added code to reset the ring counter [RINGS] every time a new
	program is executed or an old one is terminated. This should prevent
	multiple-reboots if the BBS software is slow in coming up and a
	persistent caller keeps trying to log on.

	03-JUL-1989			V1.19	Richard B. Johnson
	Added code to read interrupt-table configuration from a disk file.
	This allows the program to run on a machine that uses non-standard
	interrupts.

	Note:	This program must be linked as a '.COM' file!
	MASM CRASH;
	LINK CRASH;
	EXE2BIN CRASH.EXE CRASH.COM
	DEL CRASH.EXE
*
;
VERS	STRUC
	DB	'V1.19'			; Version number here.
@VERS	DB	' '
VERS	ENDS
;
LOGO1	STRUC
	DB	'System CRASH monitor'
@LOGO1	DB	' '
LOGO1	ENDS
;
LOGO2	STRUC
	DB	'Created 19-MAR-1989  '
	DB	'Richard B. Johnson'
@LOGO2	DB	' '
LOGO2	ENDS
;
;	Where the system keeps it's parameters.
;
BIOS	SEGMENT	AT 40H
	ORG	0
COM_1	DW	?			; Base address of com adapter ports
COM_2	DW	?
COM_3	DW	?
COM_4	DW	?
	ORG	8
PRN1	DW	?			; Base address of first printer.
PRN2	DW	?
PRN3	DW	?
PRN4	DW	?
	ORG	17H
KBD_FLG	DB	?			; Keyboard flag
	ORG	72H
RST_FLG	DW	?			; Reset flag
BIOS	ENDS
;
CR	EQU	0DH
LF	EQU	0AH
MS_DOS	EQU	21H
INT_CTL	EQU	21H			; Interrupt control mask port
MOD_STA	EQU	6			; Offset to 8250 modem-status port
CTL_SHF	EQU	00000100B		; Control-shift mask
DSR	EQU	00100000B		; Data-set ready
RI	EQU	01000000B		; Ring indicator
RLSD	EQU	10000000B		; Received line signal det
KBD_DAT	EQU	60H			; Port for keyboard data
KBD_CTL	EQU	61H			; Port for keyboard control
PORT_B	EQU	61H			; Parity detect control port
PAR_MON	EQU	62H			; Parity monitor  port
;
;	Bit-maps for print-outs
;
NOTIME	EQU	0000000000000001B	; No time
NOPROG	EQU	0000000000000010B	; Don't show program
NODUMP	EQU	0000000000000100B	; Don't dump on CTL-ALT-DEL
NOTABL	EQU	0000000000001000B	; Don't show interrupt table
NOMASK	EQU	0000000000010000B	; Don't show interrupt mask
NOSTAC	EQU	0000000000100000B	; Don't show stack
NOREGI	EQU	0000000001000000B	; Don't show registers
NOPOWE	EQU	0000000010000000B	; Don't show power failure
NOBBSM	EQU	0000000100000000B	; Don't monitor ring/carrier
;
FAR_JMP	STRUC
	DB	90H			; Help synchronize (NOP)
	DB	90H			; Help synchronize (NOP)
	DB	90H			; Help synchronize (NOP)
	DB	0EAH			; Jmp far
FAR_OFF	DW	?			; Offset
FAR_SEG	DW	?			; Segment
FAR_JMP	ENDS
;
;	MACRO to save register contents. Stack may be destroyed so we
;	can't use it.
;
SAV_ALL	MACRO
	MOV	WORD PTR CS:[_AX],AX	; Save working register
	MOV	WORD PTR CS:[_DS],DS	; And segment address
	MOV	AX,CS			; Make addressable
	MOV	DS,AX
	MOV	WORD PTR [_BX],BX
	MOV	WORD PTR [_CX],CX
	MOV	WORD PTR [_DX],DX
	MOV	WORD PTR [_SI],SI
	MOV	WORD PTR [_DI],DI
	MOV	WORD PTR [_ES],ES
	MOV	WORD PTR [_BP],BP
	MOV	WORD PTR [_SS],SS
	MOV	WORD PTR [_SP],SP
	MOV	BP,SP			; Set up index
	MOV	AX,[BP]			; Get IP
	MOV	WORD PTR [_IP],AX	; Save
	MOV	AX,[BP+2]		; Get CS
	MOV	WORD PTR [_CS],AX	; Save
ENDM
;
;	Fills a string so embedded index-WORD is on a WORD boundary.
;
EVEN_ADR	MACRO
	ORG	(($ - BEGIN ) + 1) AND 0FFFEH
ENDM
;
;	Creates an incrementing WORD between variable-length strings on
;	a WORD boundary so CMPSW works.
;
INDEX = 0
IND_WRD	MACRO
	ORG ( ( ($ - BEGIN) + 1) AND 0FFFEH )
	DW	INDEX SHL 8
	INDEX = INDEX + 1
ENDM
;
;	Set up local segments and stack.
;
SET_SEG	MACRO
	MOV	AX,CS			; Get code segment
	MOV	DS,AX			; Into data
	MOV	ES,AX			;  extra
	MOV	SS,AX			;   and stack
	MOV	SP,100H			; Set up local stack
ENDM
;
;	Save interrupt-controller mask. Also mask all hardware interrupts.
;
SAV_MSK	MACRO
	IN	AL,INT_CTL		; Save controller mask
	MOV	BYTE PTR CS:[INT_MSK],AL ; Save in our code-segment
	MOV	AL,11111111B		; Mask everyting
	OUT	INT_CTL,AL		; Disable interrupt controller
ENDM
;
BOOT_BLIND	MACRO
	MOV	AX,0FFFFH		; Segment
	PUSH	AX			; Push on the stack
	INC	AX			; Offset = 0
	PUSH	AX			; Push on the stack
	RETF				; Far 'return' to boot code
ENDM
;
PSEG	SEGMENT	PARA PUBLIC 'CODE'
BEGIN	EQU	$
	ASSUME	CS:PSEG, DS:PSEG, ES:PSEG, SS:NOTHING
	ORG	100H
MAIN	PROC	NEAR
START	EQU	$
STK_TOP	LABEL	WORD			; Where to start local stack
	JMP	INIT
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
MAIN	ENDP
;
;	Local Terminate vector, patched to INT 20H
;
INT_20H	PROC	FAR
	MOV	BYTE PTR CS:[FNAME],0	; Put in a terminator.
	MOV	BYTE PTR CS:[RINGS],0	; Reset the ring count
	JMP	DWORD PTR CS:[OLD_TRM]	; Continue to old address
INT_20H	ENDP
;
;	Local DOS interrupt, patched to INT 21H
;
INT_21H	PROC	FAR
	STI				; A software interrupt turn on
	CLD				; Forwards
	MOV	BYTE PTR CS:[DOS],AH	; Save last DOS function
	CMP	AH,4BH			; Execute a process?
	JZ	EXEC			; Yes
	CMP	AH,31H			; Keep process?
	JZ	EXEC			; Yes
	CMP	AH,4CH			; Terminate a process?
	JZ	TERMIN			; Yes
	CMP	AH,0			; Terminate a process?
	JZ	TERMIN			; Yes
	JMP	DWORD PTR CS:[OLD_DOS]	; Continue to DOS vector
TERMIN:	MOV	BYTE PTR CS:[FNAME],0	; Put in a terminator.
	MOV	BYTE PTR CS:[RINGS],0	; Reset the ring counter
	JMP	DWORD PTR CS:[OLD_DOS]	; Continue to DOS vector
;
EXEC:	PUSH	CX			; Save only registers used
	PUSH	SI
	PUSH	DI
	PUSH	ES			; Save dist segment
;
	PUSH	CS
	POP	ES			; ES = CS
	CMP	AH,31H			; Keep process?
	JZ	KEEP			; Yes.
	MOV	CX,64			; Max characters to move
	MOV	DI,OFFSET FNAME		; Filename string for EXEC
	MOV	SI,DX			; File name
	REP	MOVSB
KEEP:	CALL	SHO_EXE			; Show the process
;
NOSHOW:	POP	ES			; Restore registers used
	POP	DI
	POP	SI
	POP	CX
	MOV	BYTE PTR CS:[RINGS],0	; Reset the ring counter
	JMP	DWORD PTR CS:[OLD_DOS]
INT_21H	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show new program being executed.
;
SHO_EXE	PROC	NEAR
	TEST	WORD PTR CS:[MODE],NOPROG
	JZ	X1			; Yes, Show program
	RET				; No, exit

X1:	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	BP
	PUSH	DS
;
	PUSH	CS
	POP	DS			; CS = DS
	PUSH	AX			; Save function code
	CALL	MAK_TIM			; Update the time-stamp
	MOV	SI,OFFSET SYS		; Point to 'SYSTEM'
	CALL	PPRN			; Write to printer
	MOV	SI,OFFSET DAT		; New time/date stamp string
	CALL	PPRN			; Write to printer
	MOV	SI,OFFSET PRCNAM	; Point to process name
	POP	AX			; Restore function code
	CMP	AH,31H			; Keep process?
	JNZ	NOKEEP			; No, keep the first string.
	MOV	SI,OFFSET CREPRC	; Point to 'create' process
	CALL	PPRN			; Write to printer
	MOV	SI,OFFSET FNAME		; Point to file-name
NOKEEP:	CALL	PPRN			; Write to printer
	MOV	SI,OFFSET CRLF		; New line
	CALL	PPRN			; Write to printer
;
	POP	DS
	POP	BP
	POP	DX
	POP	BX
	POP	AX
	RET
SHO_EXE	ENDP
;
;	Show something about the process being executed.
;
SHO_PRC	PROC
	MOV	SI,OFFSET PRCNAM	; Point to process name
	CALL	PROMPT			; Write to screen/printer
	MOV	SI,OFFSET DOSFUN	; Point to DOS function string
	CALL	PROMPT			; Write to screen/printer
	MOV	AL,BYTE PTR [DOS]	; Pick up the last DOS function
	CMP	AL,62H			; Check limits
	JA	SHOPEX			; Not in the list
	CBW
	MOV	CX,DLEN			; Length of each string
	XOR	DX,DX			; Clear
	MUL	CX			; Calculate offset into table
	MOV	SI,OFFSET FUNCTS	; Offset of table
	ADD	SI,AX			; New offset
	MOV	BYTE PTR [SI+DLEN],0	; Put in a stopper.
	CALL	PROMPT
SHOPEX:	RET
SHO_PRC	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Local time interrupt. Patched to INT 1CH.
;
LCL_TIM	PROC	FAR
	CMP	BYTE PTR CS:[BUSY],0	; See if we are re-entering
	JZ	NOBUSY			; No.
	JMP	DWORD PTR CS:[OLD_TIM]	; Continue to old vector
;
NOBUSY:	MOV	BYTE PTR CS:[BUSY],0FFH	; Set busy flag
	CLD
	MOV	WORD PTR CS:[SS_SAV],SS	; Save stack-segment
	MOV	WORD PTR CS:[SP_SAV],SP	; Save stack-pointer
	PUSH	CS
	POP	SS			; SS = CS
	MOV	SP,OFFSET STK_TOP	; Set up local stack
	STI				; Allow interrupts
;
	PUSH	AX			; Free up a working register
	PUSH	DS			; Save data-segment
	PUSH	CS			; Establish addressability
	POP	DS			; DS = CS
	SUB	WORD PTR [CNTR],1000	; 18.2159 Ticks/ second
	JNC	DONE1			; Not one-second yet
	ADD	WORD PTR [CNTR],18216	; One-second, update
	CALL	CHK_PWR			; Check for a power-failure
	CALL	CHK_MOD			; Check modem status
	INC	BYTE PTR [SECS]		; Bump the seconds count
	CMP	BYTE PTR [SECS],60	; Check limit
	JC	DONE1
	MOV	BYTE PTR [SECS],0	; Zero the seconds
	INC	BYTE PTR [MINS]		; Bump the minutes count
	CMP	BYTE PTR [MINS],60	; Check upper limit
	JC	DONE1
	MOV	BYTE PTR [MINS],0	; Zero the minutes
	INC	BYTE PTR [HOUR]
	CMP	BYTE PTR [HOUR],24	; Check limits
	JC	DONE0			; Even hours
	MOV	BYTE PTR [HOUR],0	; Zero the hours
	INC	BYTE PTR [DAY]		; Bump the day
	MOV	AL,BYTE PTR [MON]	; Get current month
	DEC	AL			; January (1) becomes zero
	XOR	AH,AH			; Zero high byte
	PUSH	BX			; Save
	MOV	BX,OFFSET MONTHS	; Point to table
	XLAT				; Find # days in the month.
	POP	BX
	CMP	BYTE PTR [DAY],AL	; Check upper limit
	JBE	DONE0
	MOV	BYTE PTR [DAY],1	; First day of next month
	INC	BYTE PTR [MON]		; Bump the month
	CMP	BYTE PTR [MON],12	; Check year limit
	JBE	DONE0
	MOV	BYTE PTR [MON],1	; First month of new year
	INC	BYTE PTR [YRS]		; Bump the year
DONE0:	CALL	TIM_STP			; Write time-stamp to printer.
DONE1:	POP	DS
	POP	AX
	CLI				; No interrupts
	MOV	SS,WORD PTR CS:[SS_SAV]	; Restore user stack
	MOV	SP,WORD PTR CS:[SP_SAV]
	MOV	BYTE PTR CS:[BUSY],0	; Free up busy-flag
	STI				; Allow interrupts
	JMP	DWORD PTR CS:[OLD_TIM]	; Continue to old vector
LCL_TIM	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Check for a power failure. This is NOT a fatal error! DS has been
;	set when this procedure is entered. AX has been saved.
;
CHK_PWR	PROC	NEAR
	TEST	WORD PTR [MODE],NOPOWE	; Do we want to do this?
	JZ	X6			; Yes
	RET				; No
;
X6:	CMP	WORD PTR [CHK_PRT],0	; Do we have a check-port?
	JZ	PASS			; No, forget the routine
;
	PUSH	DX			; Save register used
	MOV	DX,WORD PTR [CHK_PRT]	; Pick up power-fail port
	IN	AL,DX			; Get modem status
	AND	AL,DSR			; Check the bit
	CMP	BYTE PTR [LASTDSR],AL	; Same last time?
	MOV	BYTE PTR [LASTDSR],AL	; Set new status
	JZ	NODET			; Yes, ignore.
;
	PUSH	BX			; Now save all the rest
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	MOV	AX,CS
	MOV	ES,AX
;
	CALL	MAK_TIM			; Make new time-stamp
	MOV	SI,OFFSET SYS		; Point ti 'SYSTEM-I' prompt
	CALL	PPRN			; Print to printer
	MOV	SI,OFFSET DAT		; Point to the date
	CALL	PPRN			; Print to printer
	MOV	SI,OFFSET PRP15		; Assume power failure
	CMP	BYTE PTR [LASTDSR],0	; Check the bit
	JZ	DISP			; It is a failure
	MOV	SI,OFFSET PRP16		; No, its restored
DISP:	CALL	PPRN			; Write message
	MOV	SI,OFFSET PRP17		; Point to 'SYSTEM-W'
	CALL	PPRN			; Write message
;
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	POP	BX
;
NODET:	POP	DX			; Restore registers used
PASS:	RET
CHK_PWR	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Check the modem status.
;
CHK_MOD	PROC	NEAR
	TEST	WORD PTR [MODE],NOBBSM	; Do we want to do this?
	JZ	X9			; Yes
	RET				; No
;
X9:	CMP	WORD PTR [CHK_PRT],0	; Do we have a check-port?
	JZ	PASSR			; No, forget the routine
;
	PUSH	DX			; Save register used
	MOV	DX,WORD PTR [CHK_PRT]	; Pick up modem-status port
	IN	AL,DX			; Get modem status
	AND	AL,RI			; Check the bit
	CMP	BYTE PTR [LASTRNG],AL	; Same last time?
	MOV	BYTE PTR [LASTRNG],AL	; Set new status
	JZ	NODETR			; Yes, ignore.
	CMP	BYTE PTR [LASTRNG],0	; Not ringing?
	JZ	NODETR
	INC	BYTE PTR [RINGS]	; Number of rings
	CALL	SHO_RNG			; Write to the printer
;
NODETR:	MOV	DX,WORD PTR [CHK_PRT]	; Pick up modem-status port
	IN	AL,DX			; Get modem status
	AND	AL,RLSD			; Check the bit
	CMP	BYTE PTR [LASTCAR],AL	; Same last time?
	MOV	BYTE PTR [LASTCAR],AL	; Set new status
	JZ	NODETC			; Yes, ignore.
	CALL	SHO_CAR			; Show the carrier
NODETC:	CMP	BYTE PTR [LASTCAR],0	; See if the carrier is off
	JZ	CAROFF			; Yes it is.
	MOV	BYTE PTR [RINGS],0	; Carrier's on, zero the ring-count
CAROFF:	POP	DX			; Restore registers used
PASSR:	RET
CHK_MOD	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show that the modem is ringing.
;
SHO_RNG	PROC	NEAR
	PUSH	BX			; Now save all the rest
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	MOV	AX,CS
	MOV	ES,AX
;
	CALL	MAK_TIM			; Make new time-stamp
	MOV	SI,OFFSET SYS		; Point ti 'SYSTEM-I' prompt
	CALL	PPRN			; Print to screen /printer
	MOV	SI,OFFSET DAT		; Point to the date
	CALL	PPRN			; Print to screen /printer
	MOV	SI,OFFSET PRP22		; Point to 'Ring detected'
	CALL	PPRN			; Write message
;
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	RET
SHO_RNG	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show the modem carrier either on or off.
;
SHO_CAR	PROC	NEAR
	PUSH	BX			; Now save all the rest
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	MOV	AX,CS
	MOV	ES,AX
;
	CALL	MAK_TIM			; Make new time-stamp
	MOV	SI,OFFSET SYS		; Point ti 'SYSTEM-I' prompt
	CALL	PPRN			; Print to screen /printer
	MOV	SI,OFFSET DAT		; Point to the date
	CALL	PPRN			; Print to screen /printer
	MOV	SI,OFFSET PRP23		; Assume 'Carrier detected'
	CMP	BYTE PTR [LASTCAR],0	; See if its on or off
	JNZ	CARON			; Its on
	MOV	SI,OFFSET PRP24		; Point to 'Carrier failed'
CARON:	CALL	PPRN			; Write message
;
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	RET
	RET
SHO_CAR	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Write time-stamp to the printer. Upon entry, DS is been set to CS,
;	AX has been saved on the stack.
;
TIM_STP	PROC	NEAR
	TEST	WORD PTR [MODE],NOTIME	; Do we want to log the time?
	JZ	X7			; Yes
	RET
;
X7:	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	BP
;
	MOV	AX,CS
	MOV	ES,AX			; Set segment
	CALL	MAK_TIM			; Make the time-stamp
	MOV	SI,OFFSET SYS		; Point ti 'SYSTEM-I' prompt
	CALL	PPRN			; Print to printer
	MOV	SI,OFFSET DAT		; Point to the date
	CALL	PPRN			; Print to printer
	MOV	SI,OFFSET CRLF		; Point to CR/LF
	CALL	PPRN			; Make new line.
;
	POP	BP
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
PASSBY:	RET
TIM_STP	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Main Interrupt routine. This is patched to the clock interrupt at
;	INT 08. After checking health, it continues to main DOS routines.
;
INTER	PROC	FAR
	CLD
	PUSH	BP
	MOV	BP,SP			; Set up index
	PUSH	AX			; Assume we still have a stack!
;
;	First we'll check to see if we really have a stack! The stack could
;	be in ROM or in nonexistant memory and thus not writable.
;
	MOV	AX,0FFFFH		; Set all bits
	PUSH	AX			; Save on stack
	PUSH	BP			; Push something else on the stack
	POP	AX			; Pop the stack
	POP	AX			; Level stack
	CMP	AX,0FFFFH		; Did it work?
	JNZ	BAD			; No, not a writable stack!
					; Stack is writable
	MOV	AL,20H			; Reset hardware controller
	OUT	20H,AL
	STI				; Allow interrupts
;
;	Now we'll check to see where the stack is. The stack segment is
;	never less than 40H in the IBM and the stack-pointer must have
;	started at 0FFFEH (even address) or lower before the interrupt.
;
	MOV	AX,SS			; Get stack segment
	CMP	AX,40H			; Check where segment is
	JC	BAD			; SS < 40H (never)
	MOV	AX,SP			; Get offset
	CMP	AX,12			; Check stack debth
	JC	BAD			; Must have crashed.
	CMP	AX,0FFFEH - 10		; INT = 6 bytes
					; PUSH BP = 2 bytes
					; PUSH AX = 2 bytes
	JA	BAD			; Can't be a good stack.
;
;	Let's check the code-segment and instruction-pointer.
;	The code-segment is never less than 40H and it must not
;	be above RAM unless in ROM! We check to be certain it's
;	not in screen memory!
;
;	If the instruction-pointer is within 32 bytes of the end of the
;	segment, we assume that the system is sick.
;
					; BP = Pushed BP
					; BP + 2 = IP
					; BP + 4 = CS
					; BP + 6 = FLAGS
	MOV	AX,[BP+4]		; Get code segment
	CMP	AX,40H			; CS < 40H (never)
	JB	BAD
	CMP	AX,0A000H		; Is it in RAM
	JB	NOSCR			; Yes
	CMP	AX,0C000H		; Is it in ROM?
	JAE	NOSCR			; Yes
	JMP	SHORT BAD		; Bad, CS is in the screen segment.
NOSCR:	MOV	AX,[BP+2]		; Get offset
	CMP	AX,0FFFFH - 32		; Top of CS?
	JNC	BAD
;
;	Now we'll check the instruction that will be executed after this
;	interrupt. We'll look for bad opcodes. There are several
;
	PUSH	DS			; Need some addressability
	PUSH	BX			; Need an index register
	MOV	DS,[BP+4]		; Code segment
	MOV	BX,[BP+2]		; Offset of next instruction
	MOV	AL,BYTE PTR [BX]	; Get next instruction
	POP	BX			; Restore these registers.
	POP	DS
;
	CMP	AL,0F1H
	JZ	BAD
	CMP	AL,0C1H
	JZ	BAD
	CMP	AL,0D6H
	JZ	BAD
	CMP	AL,60H			; Anything below 60H is okay
	JB	GOOD
	AND	AL,10010000B		; 60H - 6FH are bad opcodes.
	JNZ	GOOD
BAD:	JMP	SHORT CRASH		; Crash/reboot the system.
GOOD:	CMP	BYTE PTR CS:[RINGS],10	; 10 or more modem rings?
	JNC	CRASH			; Yes, crash the system.
	POP	AX
	POP	BP
	JMP	DWORD PTR CS:[OLD_INT]	; Continue to old vector
INTER	ENDP
;
;	Sick puppy. Reboot the system.
;
CRASH	PROC	NEAR
	POP	AX			; Level stack, restore registers
	POP	BP
	CLD				; Forwards
	SAV_ALL				; Save all the registers
	SAV_MSK				; Save interrupt controller mask
	SET_SEG				; Set up segments/stack
	CALL	CRC			; Check the program
	JZ	CR_OK			; Its okay
	BOOT_BLIND			; Can't trust the code
;
CR_OK:	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show time of crash
	MOV	DI,OFFSET PCT		; Point to ASCII text
	MOV	AX,WORD PTR [_CS]	; Pick up saved code-segment
	CALL	HEXW			; Convert to Hex-ASCII
	INC	DI			; Get by the ":"
	MOV	AX,WORD PTR [_IP]	; Pick up the saved program counter
	CALL	HEXW			; Convert to Hex-ASCII
;
	MOV	DI,OFFSET STK		; Point to ASCII text
	MOV	AX,WORD PTR [_SS]	; Pick up saved stack-segment
	CALL	HEXW			; Convert to Hex-ASCII
	INC	DI			; Get by the ":"
	MOV	AX,WORD PTR [_SP]	; Pick up the saved stack-pointer
	CALL	HEXW			; Convert to Hex-ASCII
;
	MOV	SI,OFFSET PRP1		; Point to string that was built
	CALL	PROMPT			; Write to screen
	CMP	BYTE PTR [RINGS],10	; Check the ring-count
	JC	BBS_OK			; Did not fail to respond
	MOV	SI,OFFSET PRP25		; Point to 'BBS failed'
	CALL	PROMPT			; Write to screen/printer
BBS_OK:	CALL	SHO_PRC			; Show the process
	CALL	SHO_REG			; Show other registers
	CALL	SHO_STK			; Show the stack
	CALL	SHO_MSK			; Show interrupt mask
	CALL	SHO_TAB			; Show interrupt table
;
	MOV	SI,OFFSET PRP0		; Point to "rebooting"
	CALL	PROMPT			; Print to screen
	CALL	TIMER
	JMP	BOOT			; Reboot the machine
CRASH	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	This is the NMI, parity-check vector. Replaces the BIOS routines.
;	Does not loop through.
;
NMI	PROC	FAR
	PUSH	AX			; Save register
	IN	AL,PAR_MON		; Check parity monitor port
	TEST	AL,11000000B		; See if parity-bits are set
	POP	AX			; Restore register
	JNZ	CRASH3			; Got a parity problem
	IRET				; Return to caller
;
CRASH3:	CLD
	SAV_ALL				; Save all the registers
	SAV_MSK				; Save interrupt controller mask
	SET_SEG				; Set up segments/stack
	CALL	CRC			; Check the program
	JZ	CR3_OK
	BOOT_BLIND			; Can't trust the code
;
CR3_OK:	CALL	CHK_MEM			; Try to isolate the memory area
	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show the time
	MOV 	SI,OFFSET PRP5		; Point to 'parity'
	CALL	PROMPT			; Print to screen
	CALL	SHO_PRC			; Show the process
	CALL	SHO_REG			; Show all the registers
	CALL	SHO_STK			; Show the stack contents
;
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
NMI	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Check all RAM, looking for the area that caused a parity error.
;	If the area is found, write the segment/offset to label ES:PARLOC.
;
CHK_MEM	PROC	NEAR
	XOR	AL,AL
	OUT	0A0H,AL			; Disable trap
	IN	AL,PORT_B		; Get control-word
	OR	AL,00110000B		; Disable parity-check
	OUT	PORT_B,AL
	AND	AL,11001111B		; Enable parity-check
	OUT	PORT_B,AL
	MOV	DI,OFFSET PARLOC	; Just in case we find it.
;
	PUSH	DS			; Save data segment
	XOR	AX,AX			; Cheap zero
	MOV	DS,AX			; Into data-segment
BLOOP:	MOV	CX,0FFFFH		; 64 k -1
	XOR	SI,SI			; Start at offset zero
CHKPAR:	LODSB				; Get the byte (thorw it away)
	IN	AL,PAR_MON		; Check for bad parity
	AND	AL,11000000B
	JNZ	BADPAR			; Bad parity was found
	LOOP	CHKPAR			; Not found, continue
	MOV	AX,DS			; Get current segment
	ADD	AX,1000H		; Next segment
	MOV	DS,AX			; Into data-segment
	CMP	AX,0A000H		; End of memory?
	JC	BLOOP			; Not yet
	JMP	SHORT NO_BAD		; Can't find the bad memory!
;
BADPAR:	MOV	AX,DS			; Cet current data-segment
	CALL	HEXW			; Convert to a hex-ASCII word
	MOV	AL,':'			; Delimiter
	STOSB				; Into dest string
	MOV	AX,SI			; Pick up index
	DEC	AX			; Was one location less
	CALL	HEXW			; Convert to hex-ASCII
	XOR	AL,AL			; Cheap zero
	STOSB				; Put in a stopper
;
NO_BAD:	POP	DS			; Restore data segment
	RET
CHK_MEM	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Runaway program counter causes this crash/reboot.
;
CRASH0	PROC	NEAR
	CLD				; Forwards
	SAV_ALL				; Save all the registers
	SAV_MSK				; Save interrupt controller mask
	SET_SEG				; Set up segments/stack
	CALL	CRC			; Check the program
	JZ	CR0_OK
	BOOT_BLIND			; Can't trust the code
;
CR0_OK:	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show the time
	MOV 	SI,OFFSET PRP4		; Point to 'runaway'
	CALL	PROMPT			; Print to screen
	CALL	SHO_PRC			; Show the process
	CALL	SHO_REG			; Show all the registers
	CALL	SHO_STK			; Show the stack contents
	CALL	SHO_MSK			; Show interrupt mask
	CALL	SHO_TAB			; Show interrupt table
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
CRASH0	ENDP
;
;	Operator shutdown causes this crash/reboot.
;
CRASH5	PROC	NEAR
	TEST	WORD PTR CS:[MODE],NODUMP ; Do we want to produce a crash-dump
	JZ	X8			; Yes
	JMP	BOOT			; Just boot the system
;
X8:	CLD				; Forwards
	SAV_ALL				; Save all the registers
	SAV_MSK				; Save interrupt controller mask
	SET_SEG				; Set up segments/stack
	CALL	CRC			; Check the program
	JZ	CR5_OK
	BOOT_BLIND			; Can't trust the code
;
CR5_OK:	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show the time
	MOV 	SI,OFFSET OPER		; Point to 'Operator'
	CALL	PROMPT			; Print to screen
	CALL	SHO_PRC			; Show the process
	CALL	SHO_REG			; Show all the registers
	CALL	SHO_STK			; Show the stack contents
	CALL	SHO_MSK			; Show interrupt mask
	CALL	SHO_TAB			; Show interrupt table
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
CRASH5	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Unexpected software-interrupt causes this crash/reboot.
;
CRASH1	PROC	NEAR
	CLD				; Forwards
	SAV_ALL				; Save all the registers
	SAV_MSK				; Save interrupt controller-mask
	SET_SEG				; Set up segments/stack
	CALL	CRC			; Check the program
	JZ	CR1_OK
	BOOT_BLIND			; Can't trust the code
;
CR1_OK:	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	MOV	BX,WORD PTR [_IP]	; Pick up caller's program-counter
	PUSH	DS			; Save momentarily
	MOV	DS,WORD PTR [_CS]	; Pick up caller's code-segment
	MOV	AL,BYTE PTR [BX-1]	; Get INT number
	POP	DS
	MOV	DI,OFFSET INT_NO	; Where to PUT hex-ASCII
	CALL	HEXB			; Put in string
	CALL	SHO_TIM			; Show the time
	MOV 	SI,OFFSET PRP3		; Point to 'unexpected interrupt'
	CALL	PROMPT			; Print to screen
	CALL	SHO_PRC			; Show the process
	CALL	SHO_REG			; Show the registers
	CALL	SHO_STK			; Show the stack contents
	CALL	SHO_MSK			; Show interrupt mask
	CALL	SHO_TAB			; Show interrupt table
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
CRASH1	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Disk error causes this crash/reboot.
;
CRASH2	PROC	NEAR
	CLI				; No interrupts
	CLD				; Forwards
	MOV	BX,AX			; Save error code
	MOV	AL,11111111B		; Mask everyting
	OUT	INT_CTL,AL		; Disable interrupt controller
	SET_SEG				; Set up segments/stack
	MOV	WORD PTR [CX_SAV],CX	; Save drive parameters
	MOV	WORD PTR [DX_SAV],DX
	PUSH	BX			; Save error code
	CALL	CRC			; Check the program
	POP	BX			; Restore error code
	JZ	CR2_OK
	BOOT_BLIND			; Can't trust the code
;
CR2_OK:	PUSH	BX			; Save error code
	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show the time
	CALL	SHO_PRC			; Show the process
	POP	AX			; Restore error-code
	CALL	SHO_DSK			; Show the disk errors
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
CRASH2	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Attempt to FORMAT the disk causes this crash/reboot.
;
CRASH4	PROC	NEAR
	CLI				; No interrupts
	CLD				; Forwards
	MOV	BX,AX			; Save error code
	MOV	AL,11111111B		; Mask everyting
	OUT	INT_CTL,AL		; Disable interrupt controller
	SET_SEG				; Set up segments/stack
	MOV	WORD PTR [CX_SAV],CX	; Save drive parameters
	MOV	WORD PTR [DX_SAV],DX
	PUSH	BX			; Save error code
	CALL	CRC			; Check the program
	POP	BX			; Restore error code
	JZ	CR4_OK
	BOOT_BLIND			; Can't trust the code
;
CR4_OK:	PUSH	BX			; Save error code
	MOV	AX,0002H		; Reset screen mode
	PUSHF
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	CALL	SHO_TIM			; Show the time
	MOV	SI,OFFSET PRP12		; Point to 'Attempt to format'
	CALL	PROMPT			; Write to screen
	CALL	SHO_PRC			; Show executing process
	POP	AX			; Restore error-code
	XOR	AH,AH			; Show no error
	CALL	SHO_DSK			; Show the disk errors
	MOV	SI,OFFSET PRP0		; Point to 'crashed'
	CALL	PROMPT			; Print to screen
	CALL	TIMER			; Wait a few seconds
	JMP	BOOT			; Reboot the machine
CRASH4	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
TIMER	PROC	NEAR
	XOR	CX,CX			; Get a zero
	MOV	DX,28			; Outside loop
TIM1:	NOP				; Timing loop (timer is disabled)
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LOOP	TIM1
	MOV	AH,14			; Dumb terminal
	MOV	AL,196			; ASCII to print
	MOV	BX,7			; Normal attribute
	PUSHF				; Dummy 'INT'
	CALL	DWORD PTR [OLD_VID]	; Reset video controller.
	DEC	DX			; Outside loop
	JNZ	TIM1
	RET
TIMER	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Convert WORD in AX to HEX-ASCII pointed to by DI.
;
HEXW	PROC	NEAR
	PUSH	AX			; Save word
	MOV	AL,AH			; Get high byte first
	CALL	HEXB			; Convert
	POP	AX			; Restore word
	JMP	HEXB			; Convert, implied return
HEXW	ENDP
;
HEXB	PROC	NEAR
	PUSH	AX			; Save, need low nibble later
	SHR	AL,1			; Move high nibble into low position
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	CALL	HEX0
	POP	AX			; Restore for low nibble
HEX0:	AND	AL,00001111B		; Mask high bits
	ADD	AL,90H			; This is an old Intel trick
	DAA				;  to convert to hex
	ADC	AL,40H
	DAA
	STOSB
	RET
HEXB	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Local disk vector.
;
DISK	PROC	FAR
	CMP	AH,5			; Format track?
	JZ	FORMAT			; Yes
	CMP	AH,7			; Format drive?
	JNZ	NOFMT			; No
FORMAT:	CMP	DL,80H			; See if a hard-disk
	JB	NOFMT			; No, allow floppies
	JMP	CRASH4			; Yes, Crash the system
;
NOFMT:	CMP	AH,2			; Read sectors
	JZ	DISKRW			; Yes, check return status
	CMP	AH,3			; Write sectors
	JZ	DISKRW			; Yes, check return status
	CMP	AH,4			; Verify sectors
	JZ	DISKRW			; Yes, check return status
	JMP	DWORD PTR CS:[OLD_DSK]	; Continue to old vector.
DISKRW:	PUSHF				; Make dummy 'INT'
	CALL	DWORD PTR CS:[OLD_DSK]	; Call old disk vector
	JC	ERROR
	MOV	BYTE PTR CS:[COUNT],0	; Reset the error count
RETURN:	RET	2			; Return to caller
ERROR:	INC	BYTE PTR CS:[COUNT]	; Bump the error count
	CMP	BYTE PTR CS:[COUNT],5	; Max errors allowed
	JC	RETURN			; Still okay
	JMP	CRASH2			; Crash/reboot the system
	DB	'Copyright(C) 1989 Richard B. Johnson'
SIG_LEN	EQU	$ - DISK
DISK	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	New keyboard vector to check for CTL-ALT-DEL
;
KBD	PROC	FAR
	PUSH	AX			; Save registers used
	PUSH	DS
	MOV	AX,BIOS			; Get BIOS data segment
	MOV	DS,AX			; Into current
	ASSUME	DS:BIOS
	TEST	BYTE PTR [KBD_FLG],CTL_SHF
	JZ	KBD_OK			; Not CTL-SHIFT state
	IN	AL,KBD_DAT		; Keyboard port
	CMP	AL,53H			; See if delete key
	JNZ	KBD_OK			; No, go on to other routines
	IN	AL,KBD_CTL		; Cet control port
	OR	AL,10000000B		; Reset bit for keyboard
	OUT	KBD_CTL,AL		; Send to control port
;
	POP	DS			; Restore segment
	POP	AX			; Restore Register
	JMP	CRASH5			; Go to crash routine

KBD_OK:	POP	DS			; Restore registers used
	POP	AX
	ASSUME	DS:PSEG
	JMP	DWORD PTR CS:[OLD_KBD]	; Go to old routine
KBD	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
PROMPT	PROC	NEAR
	LODSB				; Get byte addressed by SI
	TEST	AL,AL			; Check for nul
	JZ	PEXIT			; End of string
	CALL	OUT_PRN			; Output to printer
	MOV	AH,14			; Dumb terminal mode
	MOV	BX,7			; Normal page/attribute
	PUSHF				; Dummy 'INT"
	CALL	DWORD PTR [OLD_VID]	; Write character to screen
	JMP	SHORT PROMPT		; Continue for whole string
PEXIT:	RET
PROMPT	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Print string addressed by SI to the printer (only) until a nul.
;
PPRN	PROC	NEAR
	LODSB				; Get byte addressed by SI
	TEST	AL,AL			; Check for nul
	JZ	PXIT			; End of string
	CALL	OUT_PRN			; Output to printer
	JMP	SHORT PPRN		; Continue for whole string
PXIT:	RET
PPRN	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Send a form-feed and print a heading on the printer
;
HEAD	PROC	NEAR
	MOV	AL,12			; Get a form-feed
	CALL	PRN_OUT			; Send it out
HEAD_NF	PROC	NEAR
	PUSH	CX			; Save any count
	PUSH	SI			; Save string location
	MOV	BYTE PTR [LINES],60	; Set first so no re-entry
	MOV	AX,WORD PTR [PAGES]	; Pick up the pages
	INC	WORD PTR [PAGES]	; Ready next page number
	MOV	DI,OFFSET PAGEN		; Point to ASCII string
	CALL	ASCIIB			; Convert to ASCII
	XOR	AL,AL			; Get a zero
	STOSB				; Put in a stopper
	MOV	CX,78			; Active columns without a wrap
	MOV	AX,DI			; Get last location of string
	SUB	AX,OFFSET PAGEP		; AX = length of 'PAGEP' string
	SUB	CX,AX			; Correct count
SPACES:	MOV	AL,' '
	CALL	PRN_OUT			; Print the spaces
	LOOP	SPACES			; Continue to extend the string
;
	MOV	SI,OFFSET PAGEP		; Point to the pages number
	CALL	PPRN			; Print the string
	MOV	SI,OFFSET CRLF
	CALL	PPRN
	POP	SI			; Restore string location
	POP	CX			; Restore count
	MOV	AL,LF			; Original line-feed
	RET
HEAD_NF	ENDP
HEAD	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Convert binary in AX to ASCII addressed by DI. Suppress leading
;	zeros and insert a comma after the thousands.
;
ASCIIB	PROC	NEAR
	MOV	BX,AX			; Copy to BX
	MOV	AH,'0'			; Leading-zero flag
	MOV	DX,10000		; Start with 10-thousands
	CALL	SBBTR			; Subtract them out
	MOV	DX,1000			; Next, subtract thousands
	CALL	SBBTR
	CMP	AH,'0'			; See is anything printer
	JZ	NOCOMA			; No, don't place a comma
	MOV	AL,','			; Yes, put in a comma
	STOSB
NOCOMA:	MOV	DX,100			; Get hundreds
	CALL	SBBTR			; Subtract them out
	MOV	DX,10			; Get tens
	CALL	SBBTR			; Subtract them out
	MOV	AL,BL			; Get what is left
	ADD	AL,'0'			; Add ASCII bias
	JMP	SHORT PLACE		; Store in string
;
SBBTR:	MOV	AL,'0'-1		; Start with ASCII-bias -1
SBBL:	INC	AL			; ASCII loop-counter
	SUB	BX,DX			; Subtract constant
	JNC	SBBL			; Continue
	ADD	BX,DX			; One too many, add back
	CMP	AH,AL			; Leading-zero flag
	JZ	LBLK			; Leave blank
	OR	AH,0FFH			; Set leading=zero flag
PLACE:	STOSB				; Put ASCII in the string
LBLK:	RET
ASCIIB	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Output to the printer, checking for line overflow.
;
OUT_PRN	PROC	NEAR
	CMP	AL,LF			; Check for end of line
	JNZ	PRN_OUT			; Not yet
	DEC	BYTE PTR [LINES]	; Bump the line-count
	JNZ	PRN_OUT			; No heading yet
	CALL	HEAD			; Print a heading
;
;	Printer output. Output the byte in AL to the first printer.
;
PRN_OUT	PROC	NEAR
	PUSH	AX			; Save the byte
	PUSH	BX
	PUSH	CX			; Save the count
	MOV	DX,WORD PTR [PRN_PRT]	; Printer port
	OUT	DX,AL			; Output the byte
	INC	DX			; Point to the status port
	MOV	BX,4			; Outside timer
OUTER:	XOR	CX,CX			; Inside timer
;
PRN0:	IN	AL,DX
	AND	AL,10000000B		; Printer busy?
	JNZ	STROBE			; No
	LOOP	PRN0			; Yes, continue
	DEC	BX			; Bump outer loop
	JNZ	OUTER
	JMP	SHORT TIMOUT
;
STROBE:	INC	DX			; Strobe port
	MOV	AL,00001101B		; Set the strobe high
	OUT	DX,AL
	MOV	AL,00001100B		; Set the strobe low
	OUT	DX,AL
;
TIMOUT:	POP	CX			; Restore the count
	POP	BX
	POP	AX			; Save the byte
	RET
PRN_OUT	ENDP
OUT_PRN	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
CRC	PROC	NEAR
	XOR	BX,BX			; Get a zero
	MOV	AH,BH			; Get a zero
	MOV	SI,OFFSET START		; Point to first byte
	MOV	CX,OFFSET END_CHK - START ; Point to last location to check
CHK0:	LODSB				; Get memory byte
	ADD	BX,AX			; Keep count
	ROL	BX,CL			; Confuse everything
	LOOP	CHK0			; Check all bytes
	CMP	BX,WORD PTR [CHK_SUM]	; See if checksum okay
	MOV	WORD PTR [CHK_SUM],BX	; If its used to initialize
	RET
CRC	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Display the register contents to the screen.
;
SHO_REG	PROC	NEAR
	TEST	WORD PTR [MODE],NOREGI	; Do we want to show registers?
	JZ	X2			; Yes
	RET				; No
X2:	MOV	SI,OFFSET _AX		; First word to convert to hex-ASCII
	MOV	DI,OFFSET AX_INF	; Where to build the string
	MOV	CX,REG_CNT		; Number of registers to display
SHO_CV:	LODSW				; Get register contents
	CALL	HEXW			; Convert to hex-ASCII
	ADD	DI,7			; Offset to next ASCII string
	LOOP	SHO_CV
	MOV	SI,OFFSET PRP6		; Point to the string
	JMP	PROMPT			; Implied return
SHO_REG	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show the contents to the stack.
;
SHO_STK	PROC	NEAR
	TEST	WORD PTR [MODE],NOSTAC	; Do we want to show the stack?
	JZ	X3			; Yes
	RET				; No
;
X3:	MOV	SI,OFFSET PRP18		; Point to 'Stack dump'
	CALL	PROMPT			; Write to screen/printer
	MOV	DI,OFFSET TOP		; Where to build the string
	MOV	BX,0FFFEH		; First even address
	TEST	WORD PTR [_SP],00001H	; Check for odd address
	JZ	STKWRD			; Even address is okay
	MOV	SI,OFFSET WARSTK	; Point to stack warning
	CALL	PROMPT			; Write to screen/printer
	MOV	BX,0FFFDH		; First odd address
STKWRD:	MOV	CX,80			; Max debth to view
	PUSH	DS			; Save segment
	MOV	DS,WORD PTR [_SS]	; Pick up old segment
;
MKSTR:	MOV	AX,0A0DH		; CR/LF backwards
	STOSW				; Into the string
	MOV	AX,BX			; Get current address
	CALL	HEXW			; Convert to hex-ASCII
	MOV	AX,'= '			; Delimiter
	STOSW				; ' =' backwards
	STOSB				; ' '	space
	MOV	AX,WORD PTR [BX]	; Get contents
	DEC	BX
	DEC	BX			; Next word
	CALL	HEXW			; Convert to hex-ASCII
	CMP	BX,WORD PTR ES:[_SP]	; Check debth
	JC	STRDN			; String has been built
	LOOP	MKSTR			; Continue
;
	PUSH	DS			; Save segment
	PUSH	CS
	POP	DS			; DS = CS
	MOV	SI,OFFSET PRP20
	MOV	CX,LENP20
	REP	MOVSB
	MOV	BX,WORD PTR [_SP]	; Get the stack pointer again
	POP	DS			; Restore segment
;
	ADD	BX,40			; Fourty words
	MOV	CX,41			; One extra
	JMP	SHORT MKSTR		; Continue with the string
;
STRDN:	POP	DS			; Restore register
	MOV	BYTE PTR [DI],0		; Put in the stopper
	MOV	SI,OFFSET TOP		; Where the string was built
	CALL	PROMPT			; Write to screen/printer
	RET
SHO_STK	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show the disk error. The error status is in AH.
;
SHO_DSK	PROC	NEAR
	PUSH	AX			; Save error code
	MOV	SI,OFFSET PRP10		; Point to 'disk' error
	CALL	PROMPT			; Print to screen
	POP	AX			; Restore error code
	XOR	AL,AL			; Low byte is zero
	MOV	CX,TAB_LEN		; Length of the search
	MOV	DI,OFFSET DERROR	; Where to search for the string
	REPNZ	SCASW			; Scan for the word
	MOV	SI,DI			; Set up index
	JZ	FINDOK			; Found the error code
	MOV	SI,OFFSET UNDEF		; Not found, point to 'undefined'
FINDOK:	CALL	PROMPT
	MOV	AX,WORD PTR [DX_SAV]	; DH = head, DL = drive
	PUSH	AX			; Save
	MOV	DI,OFFSET PHDRV		; ASCII string destination
	XOR	AH,AH			; Zero high byte
	CALL	HEXB			; Convert to hex-ASCII
	MOV	AL,'H'			; Show it's hex
	STOSB				; Into string
	POP	AX			; Restore head/drive
	MOV	AL,AH			; Get head number
	MOV	DI,OFFSET HD		; ASCII string destination
	XOR	AH,AH			; Zero high byte
	CALL	ASCIIB			; Convert to decimal-ASCII
	MOV	AX,WORD PTR [CX_SAV]	; Get Cylinder / sector
	PUSH	AX			; Save Cylinder / sector
	AND	AL,00111111B		; Mask off MSB of cylinder.
	MOV	DI,OFFSET SECT		; Point to 'sector' in string
	XOR	AH,AH			; Zero high byte
	CALL	ASCIIB			; Convert to decimal-ASCII
	POP	AX			; Restore Cylinder /sector
	AND	AL,11000000B		; Mask off sector number
	ROL	AL,1			; 10000001B
	ROL	AL,1			; 00000011B
	XCHG	AH,AL			; 00000011 11111111 B
	MOV	DI,OFFSET CYL		; Point to cylinder in text
	CALL	ASCIIB			; Convert to decimal-ASCII
	MOV	SI,OFFSET PRP11		; Point to disk parameters
	CALL	PROMPT
	RET
SHO_DSK	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Convert byte in AL to decimal-ASCII 00 to 99. Store ASCII in
;	string addressed by DI.
;
ASCII	PROC	NEAR
	XOR	AH,AH			; Reset high byte
	AAM				; 0011H becomes 0101H
	ADD	AX,'00'			; Add in ASCII bias
	XCHG	AH,AL			; Swap to store the WORD
	STOSW				; Store in the string
	RET
ASCII	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show interrupt-controller mask. Controller is addressed at
;	port 21H.
;
SHO_MSK	PROC	NEAR
	TEST	WORD PTR [MODE],NOMASK	; Do we want to show it?
	JZ	X4			; Yes
	RET
;
X4:	MOV	AL,BYTE PTR [INT_MSK]	; Get saved interrupt mask.
	MOV	DI,OFFSET MSK
	CALL	CVT_BIN			; Convert to binary
	MOV	SI,OFFSET CTR_MSK
	CALL	PROMPT
	RET
SHO_MSK	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Convert binary in AL to ASCII addressed by DI.
;
CVT_BIN	PROC	NEAR
	MOV	BL,AL			; Save binary byte
	MOV	CX,8			; Bytes to check
CVT_0:	MOV	AL,'0'			; Assume a zero
	RCL	BL,1			; Rotate the byte
	ADC	AL,0			; Pick up carry
	STOSB				; Save ASCII
	LOOP	CVT_0
	RET
CVT_BIN	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show the interrupt table contents.
;
SHO_TAB	PROC	NEAR
	TEST	WORD PTR [MODE],NOTABL	; Do we want to show this?
	JZ	X5			; Yes
	RET
;
X5:	MOV	DI,OFFSET TOP		; Where to build the string
	XOR	SI,SI			; Offset zero of INT table
	MOV	CX,0100H		; Length of the table.
;
TABS0:	PUSH	CX			; Save the count
	MOV	AX,0A0DH		; CR/LF backwards
	STOSW				; Into string
	MOV	AX,'NI'			; 'IN' Backwards
	STOSW
	MOV	AX,' T'			; 'T ' Backwards
	STOSW
	MOV	AX,SI			; Pick up offset
	SHR	AX,1			; Div/2
	SHR	AX,1			; Div/4
	MOV	BX,AX			; Save interrupt number
	CALL	HEXB			; Convert to hex-ASCII
	MOV	AX,'= '			; ' =' Backwards
	STOSW
	STOSB				; And a space
;
	PUSH	DS			; Save segment
	XOR	AX,AX			; Cheap zero
	MOV	DS,AX			; Into segment
	LODSW				; Get offset
	MOV	DX,AX
	LODSW				; Get segment
	POP	DS			; Restore segment
;
	MOV	BYTE PTR [LCL],0	; Assume its not local
	CMP	AX,WORD PTR [LCL_CS]	; Loaded code-segment
	JNZ	NOLOC
	MOV	BYTE PTR [LCL],0FFH	; Show its a local call
NOLOC:	CALL	HEXW			; Show segment
	MOV	AL,':'			; Get delimiter
	STOSB				; Save in string
	MOV	AX,DX			; Get offset
	CALL	HEXW			; Convert to hex-ASCII
;
	MOV	AH,BL			; Interrupt number in AH
	XOR	AL,AL			; Zero low byte
;
	PUSH	SI			; Save index to 'INT' table
	PUSH	DI			; Save index to 'TOP' buffer
	MOV	DI,OFFSET INT00		; Start of the table
	MOV	CX,INT_LEN		; Size of the table
	REPNZ	SCASW			; Search the table
	MOV	SI,DI			; Just in case its found
	POP	DI			; Restore index to 'TOP' buffer
	JNZ	BLNK			; Not found in the table
;
COPY:	LODSB				; Get byte from table
	TEST	AL,AL			; See if its a nul
	JZ	BLNK			; Yes
	STOSB				; No, put in the buffer
	JMP	SHORT COPY		; Continue for all bytes
;
BLNK:	CMP	BYTE PTR [LCL],0	; Local segment?
	JZ	ENDTAB			; No
	MOV	SI,OFFSET LCL_PRP	; Yes, point to string
	MOV	CX,LCL_LEN		; String length
	REP	MOVSB			; Copy
;
ENDTAB:	POP	SI			; Restore index to INT table
	POP	CX			; Restore count
	LOOP	TABS0			; Continue
;
	MOV	BYTE PTR [DI],0		; Terminator
	MOV	SI,OFFSET PRP21		; Point to 'inter tab' prompt
	CALL	PROMPT			; Write to screen/printer
	MOV	SI,OFFSET TOP		; Point to string we built
	CALL	PROMPT			; Write to screen/printer
	RET
SHO_TAB	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Show the time of the crash.
;
SHO_TIM	PROC	NEAR
	CALL	MAK_TIM			; Make the time-stamp string
	MOV	SI,OFFSET DATE		; Location of the string we built
	CALL	PROMPT			; Write to screen
	RET
SHO_TIM	ENDP
;
;	Make a time-stamp string.
;
MAK_TIM	PROC	NEAR
	MOV	DI,OFFSET DAT		; Point to the day/month/year string
	MOV	AL,BYTE PTR [DAY]	; Pick up the day
	CALL	ASCII			; Convert to ASCII
	MOV	AL,'-'			; Put in the delimitor
	STOSB
	MOV	AL,BYTE PTR [MON]	; Pick up month
	DEC	AL			; Make january zero
	CBW
	MOV	BX,AX
	SHL	BX,1			; Times two
	ADD	BX,AX			; Times three
	MOV	SI,OFFSET MONS		; Point to string of months
	ADD	SI,BX			; Calc offset
	MOV	CX,3			; Bytes to move
	REP	MOVSB
	MOV	AL,'-'
	STOSB
	MOV	AL,BYTE PTR [YRSH]	; Pick up 19 or 20 of years
	CALL	ASCII			; Convert to ASCII
	MOV	AL,BYTE PTR [YRS]	; Get the low byte of years
	CALL	ASCII			; Convert to ASCII
;
	MOV	SI,OFFSET HOUR		; Where the time is stored
	MOV	DI,OFFSET _HR		; Where to build the string
	MOV	CX,3			; Strings to parse
PARSE0:	LODSB				; Pick up time
	CALL	ASCII			; Convert to ASCII
	MOV	AL,':'
	STOSB				; Insert delimiter
	LOOP	PARSE0
	MOV	BYTE PTR [DI-1],'.'	; Insert terminator
	MOV	AX,18216		; Tick constant
	SUB	AX,WORD PTR [CNTR]	; Subtract present ticks
	XOR	DX,DX			; Ready for divide
	MOV	CX,182			; Truncated tick-constant
	DIV	CX			; Hundreths of seconds
	CALL	ASCII			; Convert
	MOV	AX,DX			; Get remainder
	SHR	AX,1			; Div/2 (we wish div/1.8)
	MOV	DX,AX			; Save X/2
	SHR	AX,1			; X/4
	SHR	AX,1			; X/8
	SHR	AX,1			; X/16
	SHR	AX,1			; X/32
	ADD	AX,DX
	CALL	ASCII			; Convert to ASCII
	MOV	BYTE PTR [DI-1],0	; Insert terminator
	RET
MAK_TIM	ENDP
;
;	Reboot the machine.
;
BOOT	PROC	NEAR
	MOV	AX,BIOS			; Pick up BIOS segment
	MOV	DS,AX			; Into data segment
	ASSUME	DS:BIOS
	MOV    WORD PTR [RST_FLG],1234H	; Tell BIOS not to check mem.
	ASSUME	DS:PSEG
	MOV	AX,0FFFFH		; Segment
	PUSH	AX			; Push on the stack
	INC	AX			; Offset = 0
	PUSH	AX			; Push on the stack
	RETF				; Far 'return' to boot code
BOOT	ENDP
;
;	Attempt to isolate code/data against a runaway IP.
;
REPT	8
	NOP
	JMP	CRASH0
ENDM
;
;	Data areas below.
;
OLD_INT	LABEL	DWORD			; Old int 8
OLD_OFF	DW	?			; Int 8 offset
OLD_SEG	DW	?			; Int 8 segment
OLD_VID	LABEL	DWORD			; Old video ROM vector
VID_OFF	DW	?			; ROM BIOS Video Offset
VID_SEG	DW	?			; ROM BOIS Video segment
OLD_DSK	LABEL	DWORD			; Old Disk vector
DSK_OFF	DW	?			; Old disk offset
DSK_SEG	DW	?			; Old Disk segment.
OLD_TIM	LABEL	DWORD			; Old user tick
TIM_OFF	DW	?			; Offset
TIM_SEG	DW	?			; Segment
OLD_KBD	LABEL	DWORD			; Old keyboard intr. vector
KBD_OFF	DW	?			; Kbd offset
KBD_SEG	DW	?			; Kbd segment
OLD_DOS	LABEL	DWORD			; Old MS_DOS vector
DOS_OFF	DW	?			; DOS offset
DOS_SEG	DW	?			; DOS segment
OLD_TRM	LABEL	DWORD			; Old Terminate vector
TRM_OFF	DW	?			; DOS terminate offset
TRM_SEG	DW	?			; DOS terminate segment
PRN_PRT	DW	?			; Base port of printer.
CHK_PRT	DW	0			; Selected port to check.
MODE	DW	0			; What to show. (bit-mapped)
;
PRP0	DB	CR,LF
	DB	'SYSTEM-F-FATAL,   Fatal bugcheck.'
	DB	CR,LF
	DB	'CRASH-I-REBOOT,   Rebooting...',CR,LF,12,0
PRP1	DB	CR,LF
	DB	'CRASH-F-PROGRAM,  Program counter at '
PCT	DB	'0000:0000'
	DB	CR,LF
	DB	'CRASH-F-STACK,    Stack at '
STK	DB	'0000:0000',0
PRP3	DB	CR,LF
	DB	'CRASH-F-UNEXINT,  Unexpected interrupt, INT '
INT_NO	DB	'00',0
PRP4	DB	CR,LF
	DB	'CRASH-F-RUNAWAY,  Runaway program-counter.',0
PRP5	DB	CR,LF
	DB	'CRASH-F-MEMPAR,   Memory parity error at '
PARLOC	DB	'unknown location.',0
PRP6	DB	CR,LF
	DB	'CRASH-I-REGDMP,   Register dump:'
	DB	CR,LF
	DB	'AX = '
AX_INF	DB	'0000'
	DB	CR,LF
	DB	'BX = '
	DB	'0000'
	DB	CR,LF
	DB	'CX = '
	DB	'0000'
	DB	CR,LF
	DB	'DX = '
	DB	'0000'
	DB	CR,LF
	DB	'SI = '
	DB	'0000'
	DB	CR,LF
	DB	'DI = '
	DB	'0000'
	DB	CR,LF
	DB	'BP = '
	DB	'0000'
	DB	CR,LF
	DB	'DS = '
	DB	'0000'
	DB	CR,LF
	DB	'ES = '
	DB	'0000'
	DB	CR,LF
	DB	'CS = '
	DB	'0000'
	DB	CR,LF
	DB	'IP = '
	DB	'0000'
	DB	CR,LF
	DB	'SS = '
	DB	'0000'
	DB	CR,LF
	DB	'SP = '
	DB	'0000'
	DB	0
;
PRP10	DB	CR,LF
	DB	'CRASH-F-DISKERR,  Disk error, ',0
PRP11	DB	CR,LF
	DB	'CRASH-I-DISKPAR,  Disk parameters:'
	DB	CR,LF
	DB	' Physical drive : '
PHDRV	DB	'   '
	DB	CR,LF
	DB	'       Cylinder : '
CYL	DB	'     '
	DB	CR,LF
	DB	'           Head : '
HD	DB	'   '
	DB	CR,LF
	DB	'         Sector : '
SECT	DB	'   '
	DB	0
;
PRP12	DB	CR,LF
	DB	'CRASH-F-FORMAT,   Attempt to low-level format fixed disk.'
	DB	0
PRP15	DB	CR,LF
	DB	'SYSTEM-W-PWRFAIL, Power failure.',0
PRP16	DB	CR,LF
	DB	'SYSTEM-I-PWRRES,  Power restored.',0
PRP17	DB	CR,LF
	DB	'SYSTEM-W-CONT,    Continuing...'
	DB	CR,LF,0
PRP18	DB	CR,LF
	DB	'CRASH-I-STKDMP,   Stack dump:',0
SYS	DB	CR,LF
	DB	'SYSTEM-I-TIME,    Time    ',0
CRLF	DB	CR,LF,0
PRP20	DB	CR,LF
	DB	'CRASH-I-DUMTERM,  Dump terminated at 80-word depth.'
LENP20	EQU	$ - PRP20
PRP22	DB	CR,LF
	DB	'SYSTEM-I-MODRING, Modem ring detected.'
	DB	CR,LF,0
PRP23	DB	CR,LF
	DB	'SYSTEM-I-MODCARD, Modem carrier detected.'
	DB	CR,LF,0
PRP24	DB	CR,LF
	DB	'SYSTEM-I-MODCART, Modem carrier terminated.'
	DB	CR,LF,0
PRP25	DB	CR,LF
	DB	'CRASH-F-BBSNOANS, BBS system failed to answer modem.'
WARSTK	DB	CR,LF
	DB	'CRASH-W-STKBYTE,  Stack is on a BYTE boundary.',0
OPER	DB	CR,LF
	DB	'CRASH-I-OPCRASH,  Operator initiated shutdown.',0
DOSFUN	DB	CR,LF
	DB	'CRASH-I-DOSFUNC,  Last DOS function: ',0
CREPRC	DB	CR,LF
	DB	'SYSTEM-I-CREPRC,  Creating permanent process: ',0
;
	EVEN_ADR
DERROR	DW	0000H
	DB	'No error occurred'
	EVEN_ADR
	DW	0100H
	DB	'Bad disk I/O command'
	EVEN_ADR
	DW	0200H
	DB	'Bad address mark'
	EVEN_ADR
	DW	0300H
	DB	'Write-protect violation'
	EVEN_ADR
	DW	0400H
	DB	'Record not found'
	EVEN_ADR
	DW	0500H
	DB	'Controller reset failed'
	EVEN_ADR
	DW	0700H
	DB	'Bad drive parameters'
	EVEN_ADR
	DW	0800H
	DB	'DMA overrun'
	EVEN_ADR
	DW	0900H
	DB	'DMA bounds error'
	EVEN_ADR
	DW	0B00H
	DB	'Bad track flag detected'
	EVEN_ADR
	DW	1000H
	DB	'Bad CRC on disk read'
	EVEN_ADR
	DW	1100H
	DB	'ECC error'
	EVEN_ADR
	DW	2000H
	DB	'Disk controller failed to respond'
	EVEN_ADR
	DW	4000H
	DB	'Bad seek'
	EVEN_ADR
	DW	8000H
	DB	'Time-out error'
	EVEN_ADR
	DW	0BB00H
UNDEF:	DB	'Undefined error'
	EVEN_ADR
	DW	0FF00H
	DB	'Sense drive status failure'
	DB	0
TAB_LEN	EQU	($ - DERROR) / 2	; WORD length of the table
;	Translate table for the length of each month.
;
MONTHS	DB	31	; Jan
FEB	DB	28	; Feb (will be adjusted for leap-year)
	DB	31	; Mar
	DB	30	; Apr
	DB	31	; May
	DB	30	; Jun
	DB	31	; Jul
	DB	31	; Aug
	DB	30	; Sep
	DB	31	; Oct
	DB	30	; Nov
	DB	31	; Dec
;
;	Table of ASCII strings for each day of the month.
;
MONS	DB	'JAN'
	DB	'FEB'
	DB	'MAR'
	DB	'APR'
	DB	'MAY'
	DB	'JUN'
	DB	'JUL'
	DB	'AUG'
	DB	'SEP'
	DB	'OCT'
	DB	'NOV'
	DB	'DEC'
LCL	DB	?
LCL_CS	DW	?
EVEN
INT00:	IND_WRD
	DB	'   Divide error',0
	IND_WRD
	DB	'   Single-step',0
	IND_WRD
	DB	'   Non-maskable',0
	IND_WRD
	DB	'   INT',0
	IND_WRD
	DB	'   INTO',0
	IND_WRD
	DB	'   Print screen',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   IRQ0 (clock tick)',0
	IND_WRD
	DB	'   IRQ1 (keyboard)',0
	IND_WRD
	DB	'   IRQ2 (Reserved)',0
	IND_WRD
	DB	'   IRQ3 (COM2)',0
	IND_WRD
	DB	'   IRQ4 (COM1)',0
	IND_WRD
	DB	'   IRQ5 (hard disk)',0
	IND_WRD
	DB	'   IRQ6 (floppies)',0
	IND_WRD
	DB	'   IRQ7 (parallel port)',0
	IND_WRD
	DB	'   Screen output',0
	IND_WRD
	DB	'   Equip. check',0
	IND_WRD
	DB	'   Memory size',0
	IND_WRD
	DB	'   Disk drives',0
	IND_WRD
	DB	'   Serial I/O',0
	IND_WRD
	DB	'   Extended mem.',0
	IND_WRD
	DB	'   Keyboard',0
	IND_WRD
	DB	'   Printer',0
	IND_WRD
	DB	'   ROM BASIC',0
	IND_WRD
	DB	'   Disk boot',0
	IND_WRD
	DB	'   Get/set time',0
	IND_WRD
	DB	'   Break key',0
	IND_WRD
	DB	'   Timer ticks',0
	IND_WRD
	DB	'   Video tables',0
	IND_WRD
	DB	'   Floppy param.',0
	IND_WRD
	DB	'   Graphics set 2',0
	IND_WRD
	DB	'   DOS terminate',0
	IND_WRD
	DB	'   DOS functions',0
	IND_WRD
	DB	'   Base exit addr.',0
	IND_WRD
	DB	'   Control-C abort',0
	IND_WRD
	DB	'   Fatal error',0
	IND_WRD
	DB	'   Abs. disk read',0
	IND_WRD
	DB	'   Abs. disk write',0
	IND_WRD
	DB	'   Term./stay Reserved',0
	IND_WRD
	DB	'   Keyboard loop',0
	IND_WRD
	DB	'   Fast CON out',0
	IND_WRD
	DB	'   Network check',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Net./print spooler',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Floppy re-vect.',0
	IND_WRD
	DB	'   Fixed disk param.',0
	IND_WRD
	DB	'   ECA orig. video vect.',0
	IND_WRD
	DB	'   ECA init. param.',0
	IND_WRD
	DB	'   ECA graph. char.',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Fixed disk param. 2',0
	IND_WRD
	DB	'   Reserved',0
	IND_WRD
	DB	'   Cordless keyboard xlate',0
	IND_WRD
	DB	'   Scan-code xlate table',0
	IND_WRD
	DB	'   User alarm',0
INT_LEN	EQU	($ - INT00) /2		; Words to scan
LCL_PRP	DB	'   (*)'
LCL_LEN	EQU	$ - LCL_PRP
;
PRP21	DB	CR,LF
	DB	'CRASH-I-INTRTAB,  Interrupt table: ',0
CTR_MSK	DB	CR,LF
	DB	'CRASH-I-ICTLMSK,  Interrupt  mask: '
MSK	DB	'00000000'
	DB	CR,LF
	DB	'                                   '
	DB	'||||||||________ IRQ0 (INT 08H)',CR,LF
	DB	'                                   '
	DB	'|||||||_________ IRQ1 (INT 09H)',CR,LF
	DB	'                                   '
	DB	'||||||__________ IRQ2 (INT 0AH)',CR,LF
	DB	'                                   '
	DB	'|||||___________ IRQ3 (INT 0BH)',CR,LF
	DB	'                                   '
	DB	'||||____________ IRQ4 (INT 0CH)',CR,LF
	DB	'                                   '
	DB	'|||_____________ IRQ5 (INT 0DH)',CR,LF
	DB	'                                   '
	DB	'||______________ IRQ6 (INT 0EH)',CR,LF
	DB	'                                   '
	DB	'|_______________ IRQ7 (INT 0FH)',CR,LF
	DB	0
;
;	Table of DOS functions.
;
FUNCTS	DB	'00 (Prog term)  '
	DB	'01 (Kbd input)  '
	DB	'02 (CON output) '
	DB	'03 (AUX input)  '
	DB	'04 (AUX output) '
	DB	'05 (PRN output) '
	DB	'06 (CON I/O dir)'
	DB	'07 (CON in no/e)'
	DB	'08 (CON in no/e)'
	DB	'09 (CON string) '
	DB	'0A (Buffer kbd) '
	DB	'0B (CON status) '
	DB	'0C (CON flush)  '
	DB	'0D (Disk reset) '
	DB	'0E (Select disk)'
	DB	'0F (Open file)  '
	DB	'10 (Close file) '
	DB	'11 (Search 1st) '
	DB	'12 (Search next)'
	DB	'13 (Delete file)'
	DB	'14 (Read seq)   '
	DB	'15 (Write seq)  '
	DB	'16 (Create file)'
	DB	'17 (Rename)     '
	DB	'18 (Reserved)   '
	DB	'19 (Cur disk)   '
	DB	'1A (Set DTA)    '
	DB	'1B (Get Alloc)  '
	DB	'1C (Alloc spec) '
	DB	'1D (Reserved)   '
	DB	'1E (Reserved)   '
	DB	'1F (Reserved)   '
	DB	'20 (Reserved)   '
	DB	'21 (Read rand)  '
	DB	'22 (Write rand) '
	DB	'23 (File size)  '
	DB	'24 (Set record) '
	DB	'25 (Set vector) '
	DB	'26 (Create PSP) '
	DB	'27 (Block read) '
	DB	'28 (Block write)'
	DB	'29 (Parse fname)'
	DB	'2A (Get date)   '
	DB	'2B (Set date)   '
	DB	'2C (Get time)   '
	DB	'2D (Set time)   '
	DB	'2E (Set verify) '
	DB	'2F (Get DTA)    '
	DB	'30 (Get version)'
	DB	'31 (Keep proc)  '
	DB	'32 (Reserved)   '
	DB	'33 (Ctrl-C chk) '
	DB	'34 (In DOS flag)'
	DB	'35 (Get vector) '
	DB	'36 (Disk space) '
	DB	'37 (Char opers) '
	DB	'38 (Country inf)'
	DB	'39 (Create dir) '
	DB	'3A (Delete dir) '
	DB	'3B (Change dir) '
	DB	'3C (Create file)'
	DB	'3D (Open file)  '
	DB	'3E (Close file) '
	DB	'3F (Read file)  '
	DB	'40 (Write file) '
	DB	'41 (Delete file)'
	DB	'42 (Move index) '
	DB	'43 (Change mode)'
	DB	'44 (I/O control)'
	DB	'45 (Dupl handle)'
	DB	'46 (Force dupl) '
	DB	'47 (Get direct) '
	DB	'48 (Alloc mem)  '
	DB	'49 (Free alloc) '
	DB	'4A (Set memory) '
	DB	'4B (Exec prog)  '
	DB	'4C (Exit to DOS)'
	DB	'4D (Return code)'
	DB	'4E (Find first) '
	DB	'4F (Find next)  '
	DB	'50 (Reserved)   '
	DB	'51 (Reserved)   '
	DB	'52 (Reserved)   '
	DB	'53 (Reserved)   '
	DB	'54 (Get verify) '
	DB	'55 (Reserved)   '
	DB	'56 (Rename file)'
	DB	'57 (File da/tim)'
	DB	'58 (Reserved)   '
	DB	'59 (Extnd error)'
	DB	'5A (Unique file)'
	DB	'5B (Temp file)  '
	DB	'5C (Lock/unlock)'
	DB	'5D (Reserved)   '
	DB	'5E (Mach stats) '
	DB	'5F (Redirect)   '
	DB	'60 (Reserved)   '
	DB	'61 (Reserved)   '
@LAST	DB	'62 (Get PSP)    '
DLEN	EQU	$ - @LAST
;
;	This is where the time-string will be built.
;
DATE	DB	CR,LF			; Static string
	DB	'CRASH-I-TIME,     Time    ' ; Static string
END_CHK	EQU	$			; Don't checksum the variables
DAT	DB	'00-JAN-1989'		; Dynamic from here down
	DB	'  '
_HR	DB	'00:'
	DB	'00:'
	DB	'00.'
	DB	'00'
	DB	'00',0
;
;	Other dynamic stuff, not checksummed.
;
PAGEP	DB	'CRASH System Monitor '
	VERS	<>			; Plug in version number.
	DB	'  Page '
PAGEN	DB	'16,384',0		; Page number goes here
LINES	DB	60			; Lines on a page
PAGES	DW	1			; Page-count
CHK_SUM	DW	0			; Program checksum.
LASTDSR DB	?			; Last DSR status for power-fail
LASTRNG	DB	?			; Last modem ring-indicator
LASTCAR	DB	?			; Last modem carrier indicator
RINGS	DB	?			; Number of rings.
BUSY	DB	0			; Interrupt busy flag
COUNT	DB	0			; Disk error count (outside checksum)
CX_SAV	DW	?			; Drive parameters
DX_SAV	DW	?			;   ""    ""
SP_SAV	DW	?			; Store user-stack address
SS_SAV	DW	?
_AX	DW	0			; Saved register values.
_BX	DW	0			; Indexed... don't change order!
_CX	DW	0
_DX	DW	0
_SI	DW	0
_DI	DW	0
_BP	DW	0
_DS	DW	0
_ES	DW	0
_CS	DW	0			; Interrupted program's code-segment
_IP	DW	0			; Interrupted program's instr. pointer
_SS	DW	0			; Interrupted program's stack segment
_SP	DW	0			; interrupted program's stack pointer
REG_CNT	EQU	($ - _AX) / 2		; Number of registers
INT_MSK	DB	?			; Saved interrupt mask
DOS	DB	?			; Last dos function called
;
PRCNAM	DB	CR,LF
	DB	'SYSTEM-I-EXEPROC, Executing process: '
FNAME	DB	'SYSTEM'
	DB	64 DUP (0)
;
;	Indexed... Don't change the order!
;
HOUR	DB	?			; Hours (0-23)
MINS	DB	?			; Minutes (0-59)
SECS	DB	?			; Seconds (0-59)
DAY	DB	?			; Day (1-31)
MON	DB	?			; Month (1-12)
YRS	DB	?			; Low part of year  (..89)
YRSH	DB	?			; High part of year (19..)
CNTR	DW	?			; Clock-tick counter
;
TOP	EQU	$
;
;	Iniitialization code. This space is used only once then given up.
;
INIT	PROC	NEAR
	CALL	MAP_CMD			; Map command-line
	JCXZ	INIT1			; No command-line
	CALL	CHK_CMD			; Check command-line
;
INIT1:	MOV	AX,3510H		; Get Video vector
	INT	MS_DOS
	MOV	WORD PTR [VID_OFF],BX
	MOV	WORD PTR [VID_SEG],ES
;
	MOV	AX,3509H		; Get Keyboard vector
	INT	MS_DOS
	MOV	WORD PTR [KBD_OFF],BX
	MOV	WORD PTR [KBD_SEG],ES
;
	MOV	AX,3508H		; Get clock vector
	INT	MS_DOS
	MOV	WORD PTR [OLD_OFF],BX
	MOV	WORD PTR [OLD_SEG],ES
;
	MOV	AX,351CH		; Get timer vector
	INT	MS_DOS
	MOV	WORD PTR [TIM_OFF],BX
	MOV	WORD PTR [TIM_SEG],ES
;
	MOV	AX,3521H		; Get DOS vector
	INT	MS_DOS
	MOV	WORD PTR [DOS_OFF],BX
	MOV	WORD PTR [DOS_SEG],ES
;
	MOV	AX,3520H		; Get DOS terminate vector
	INT	MS_DOS
	MOV	WORD PTR [TRM_OFF],BX
	MOV	WORD PTR [TRM_SEG],ES
;
	MOV	AX,3513H		; Get disk vector
	INT	MS_DOS
	MOV	WORD PTR [DSK_OFF],BX
	MOV	WORD PTR [DSK_SEG],ES
;
	MOV	DI,BX			; ES:DI = Disk vector
	MOV	SI,OFFSET DISK		; DS:SI points to local code
	MOV	CX,SIG_LEN		; Bytes to check
	REPZ	CMPSB			; Check for a duplicate
;
	PUSH	CS
	POP	ES			; ES = CS
	JNZ	PATCH0			; Not installed, can patch
;
	MOV	DX,OFFSET INST		; Point to 'installed' message
	MOV	AH,9			; Print string function
	INT	MS_DOS
;
	MOV	AX,4C00H		; DOS exit, no errors
	INT	MS_DOS
;
PATCH0:	PUSH	DS			; Save the segment
	MOV	AX,BIOS			; Pick up BIOS segment
	MOV	DS,AX			; Into data-segment
	ASSUME	DS:BIOS
	MOV	AX,WORD PTR [PRN1]	; Pick up first printer base address
	POP	DS			; Restore data segment
	ASSUME	DS:PSEG
	MOV	WORD PTR [PRN_PRT],AX	; Plug into our data-seg
;
;	Check for a Communications adapter port that has a DSR bit
;	set high. If one is found, from now-on, it will be used to
;	detect a power-failure and modem carrier.
;
	MOV	DI,OFFSET COM1		; Where to copy adapter ports
	MOV	CX,4			; Maximum ports allowed
	PUSH	DS			; Save the segment
	MOV	AX,BIOS			; BIOS segment
	MOV	DS,AX			; Into the segment
	ASSUME	DS:BIOS
	MOV	SI,OFFSET COM_1		; Point to first port
	REP	MOVSW			; Copy to our ES
	POP	DS			; Restore segment
	ASSUME	DS:PSEG
	MOV	CX,4			; Possible ports
	MOV	SI,OFFSET COM1		; First port
CHK_DSR:
	LODSW				; Pick up port address
	TEST	AX,AX			; Check for a zero
	JZ	NOPRT			; No port
	MOV	DX,AX
	ADD	DX,MOD_STA		; Offset to modem status
	IN	AL,DX			; Get modem status
	MOV	AH,AL			; Save a copy of status
	AND	AL,DSR			; Check for DSR bit
	JNZ	FDPRT			; Found the bit set
	LOOP	CHK_DSR			; Check all ports
	JMP	SHORT NOPRT
FDPRT:	MOV	BYTE PTR [LASTDSR],AL	; This is what we expect with power
	MOV	AL,AH			; Get a copy of modem-status
	AND	AL,RLSD			; Mask off carrier-det
	MOV	BYTE PTR [LASTCAR],AL	; Save for last carrier reference
	MOV	AL,AH			; Get copy of modem-status
	AND	AL,RI			; Ring-indicator status
	MOV	BYTE PTR [LASTRNG],AL	; Save for ring-reference
	MOV	WORD PTR [CHK_PRT],DX	; Save modem-status port
;
NOPRT:	MOV	AX,2500H		; Patch INT 0
	MOV	DX,OFFSET CRASH		; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2502H		; Patch INT 2 (NMI)
	MOV	DX,OFFSET NMI		; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2503H		; Patch INT 3
	MOV	DX,OFFSET CRASH1	; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2504H		; Patch INT 4
	MOV	DX,OFFSET CRASH1	; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2506H		; Patch INT 6
	MOV	DX,OFFSET CRASH1	; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2507H		; Patch INT 7
	MOV	DX,OFFSET CRASH1	; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2508H		; Patch INT 8
	MOV	DX,OFFSET INTER		; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2509H		; Patch INT 9 (kbd)
	MOV	DX,OFFSET KBD		; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,2513H		; Patch Disk vector
	MOV	DX,OFFSET DISK		; DS:DX = new vector
	INT	MS_DOS
;
	MOV	AX,251CH		; Vector to patch
	MOV	DX,OFFSET LCL_TIM	; Local time
	INT	MS_DOS			; Patch the vector
;
	MOV	AX,2521H		; Set DOS vector
	MOV	DX,OFFSET INT_21H	; Vector to patch
	INT	MS_DOS
;
	MOV	AX,2520H		; Set DOS terminate vector
	MOV	DX,OFFSET INT_20H	; Vector to patch
	INT	MS_DOS
	PUSH	CS
	POP	ES			; ES=CS
;
;	Fill any unused interrupt-table entries with a vector to CRASH code.
;
	CALL	OPEN			; Open the configuration file
	JNC	OPN_OK			; File was found
	MOV	DX,OFFSET SKIP		; Not found, print message
	MOV	AH,9
	INT	MS_DOS
	JMP	SHORT JUMPER
OPN_OK:	CALL	READ			; Read the file into memory
	CALL	CLOSE			; Close the file
	CALL	SET_INT			; Set up interrupts
;
;	Fill all memory above the crash-monitor with a FAR JMP to the
;	'runaway PC' routine. ES distroyed.
;
JUMPER:	MOV	WORD PTR [FILL.FAR_OFF],OFFSET CRASH0
	MOV	WORD PTR [FILL.FAR_SEG],CS
	MOV	AX,OFFSET PRG_END	; Get the end of the program
	SHR	AX,1			; Div/2
	SHR	AX,1			; Div/4
	SHR	AX,1			; Div/8
	SHR	AX,1			; Div/16
	MOV	BX,CS			; Get present code-segment
	ADD	AX,BX			; Next paragraph
	MOV	ES,AX			; Set the segment
	XOR	DI,DI			; Offset zero
;
LOOPF:	CMP	DI,(0FFFEH - FILL_LEN)	; Near the end of a segment?
	JNC	NEXTS			; Next segment
	MOV	SI,OFFSET FILL		; Instruction to fill memory with
	MOV	CX,FILL_LEN		; Length of the string
	REP	MOVSB			; Fill
	JMP	SHORT LOOPF
;
NEXTS:	MOV	AX,ES			; Get segment address
	ADD	AX,1000H		; Incr segment address
	MOV	ES,AX			; New 64k block
	XOR	DI,DI			; Offset zero
	CMP	AX,0A000H		; End of RAM?
	JC	LOOPF			; No, continue
;
	PUSH	CS
	POP	ES			; ES = CS
;
;	Set TSR time to DOS time once. From now-on, CRASH will maintain
;	its own time and date.
;
	MOV	AH,2CH			; Get time
	INT	MS_DOS
	MOV	BYTE PTR [HOUR],CH
	MOV	BYTE PTR [MINS],CL
	MOV	BYTE PTR [SECS],DH
;
	MOV	AH,2AH			; Get date
	INT	MS_DOS
	MOV	BYTE PTR [MON],DH
	MOV	BYTE PTR [DAY],DL
	MOV	BX,CX			; Save year
;
;	Check for leap-year (divisable by 4 with no overflow).
;
	ROR	CX,1			; Div/2
	JC	CYSET			; Was a carry, get out
	ROR	CX,1			; Div/4
	CMC
	ADC	BYTE PTR [FEB],0	; Feb becomes 29 days in a leap-year
;
;	Adjust for BYTE-decimal manipulation later.
;
CYSET:	MOV	AX,BX			; Get year, 1980 - 2089
	XOR	DX,DX			; Ready for division
	MOV	CX,100			; Div/100
	DIV	CX
	MOV	BYTE PTR [YRSH],AL	; AL = 19 - 20 save high decimal
	XOR	DX,DX			; Remove remainder
	MUL	CX			; AX = 1900 - 2000
	SUB	BX,AX			; BX = 0 - 99
	MOV	BYTE PTR [YRS],BL	; Save low decimal
;
	MOV	AX,CS
	MOV	WORD PTR [LCL_CS],AX	; Set CS for crash-compare
	CALL	CRC			; Checksum (CRC) the code
	MOV	SI,OFFSET CRLF		; Send CR/LF to the printer
	CALL	PPRN
	CALL	HEAD			; Print the heading
;
	MOV	SI,OFFSET PRP19		; Point to 'monitor installed'
	CALL	PPRN			; Write to printer
	CALL	TIM_STP			; Write the time-stamp
;
	MOV	DX,OFFSET LOGO		; Point to sign-on message
	MOV	AH,9			; Print string function
	INT	MS_DOS			; Print to screen
;
;	Terminate and stay-resident. Initialization-code is thrown away.
;
	MOV	DX,OFFSET TOP		; Last code to save
	SHR	DX,1			; Div/2
	SHR	DX,1			; Div/4
	SHR	DX,1			; Div/8
	SHR	DX,1			; Div/16
	INC	DX			; Round up
	MOV	AX,3100H
	INT	MS_DOS
	JMP	$			; Fatal trap
INIT	ENDP
;
SET_INT	PROC	NEAR
	MOV	CX,WORD PTR [BYTES]	; Get number of bytes in the file
	JCXZ	QUIT			; Nothing in the file
	MOV	SI,OFFSET BUFFER	; Point to file buffer
SETALL:	CALL	NXT_LIN			; Get a new line
	JCXZ	QUIT			; No more lines
	CALL	CVTHBIN			; Convert any hex-ASCII to binary
	TEST	AL,AL			; Check for a zero
	JZ	SETALL			; Continue
	MOV	AH,25H			; Set vector function
	MOV	DX,OFFSET CRASH1	; Location to patvh
	INT	MS_DOS			; Patch it
	JMP	SHORT SETALL		; Get more
QUIT:	RET
SET_INT	ENDP
;
OPEN	PROC	NEAR
	MOV	DX,OFFSET FNAMEB	; Point to file-name
	XOR	CX,CX			; Normal file
	MOV	AX,3D00H		; Open for reading
	INT	MS_DOS			; Open the file
	MOV	WORD PTR [HANDLE],AX	; Save handle
	RET
OPEN	ENDP
;
READ	PROC	NEAR
	MOV	BX,WORD PTR [HANDLE]	; Get file handle
	MOV	CX,8192			; Max size to read
	MOV	DX,OFFSET BUFFER	; Where to put the data
	MOV	AX,3F00H		; Read the file
	INT	MS_DOS
	MOV	WORD PTR [BYTES],AX	; Save bytes actually read
	RET
READ	ENDP
;
CLOSE	PROC	NEAR
	MOV	BX,WORD PTR [HANDLE]	; Get the file access word
	MOV	AX,3E00H		; Close the file
	INT	MS_DOS
	RET
CLOSE	ENDP
;
;	Convert hex-ASCII pointed to by SI to binary returned in AL.
;
CVTHBIN	PROC	NEAR
	XOR	AH,AH			; Zero accumulator
CVT0:	LODSB				; Get byte
	CMP	AL,'z'			; Check limit
	JA	CVT1			; Not a lower-case letter
	CMP	AL,'a'
	JB	CVT1			; Not a lower-case letter
	AND	AL,95			; Map to upper case
CVT1:	SUB	AL,'0'			; Remove ASCII bias
	JC	DONE			; Out of range
	CMP	AL,9			; Check upper limit
	JBE	CVT2			; Within range
	SUB	AL,'A'-'9'-1		; Subtract hex char bias
	CMP	AL,0AH			; Check lower limit
	JC	DONE			; Out of range
	CMP	AL,0FH			; Check upper limit
	JA	DONE			; Out of range
CVT2:	SHL	AH,1			; Times 2
	SHL	AH,1			; Times 4
	SHL	AH,1			; Times 8
	SHL	AH,1			; Times 16
	ADD	AH,AL			; Add new to accumulator
	JMP	SHORT CVT0		; Get another byte
;
DONE:	MOV	AL,AH			; Copy from accumulator
	RET
CVTHBIN	ENDP
;
;	Scan CX bytes pointed to by SI, looking for a Line-feed. Return with
;	the address of the byte following the line-feed in SI. If CX = zero,
;	no more linefeeds were found.
;
NXT_LIN	PROC	NEAR
	MOV	DI,SI			; ES:DI used for the search
	MOV	AL,LF			; Character to find
	REPNZ	SCASB			; Look for the byte
	MOV	SI,DI			; Point to next byte
	RET
NXT_LIN	ENDP
;
LOGO	DB	CR,LF
	DB	(80 -   (@LOGO1 + @VERS))/2 DUP (' ')
	LOGO1	<>
	VERS	<>
	DB	CR,LF
	DB	(80 - @LOGO2) /2  DUP (' ')
	LOGO2	<>
	DB	CR,LF
	DB	'$'
;
PRP19	DB	CR,LF
	DB	'SYSTEM-I-CRASH,   Crash monitor installed.',0
;
FILL	LABEL	BYTE
	FAR_JMP	<>
FILL_LEN	EQU	$ - FILL
	ORG	(($ - BEGIN) + 16 ) AND 0FFF0H	; Paragraph boundary.
PRG_END	EQU	$
;
;	Map Command-line to upper case and put in buffer BUFF.
;	CX = Bytes typed upon return.
;
MAP_CMD	PROC	NEAR
	MOV	DI,OFFSET BUFF		; Where to put the string
	MOV	SI,80H			; Get command line
	LODSB				; Get bytes typed
	CBW
	MOV	CX,AX			; Use as a count
	JCXZ	MAP_EX			; No bytes typed
	DEC	CX			; Count for the space
	JNZ	MAP_DO			; Map command line to upper case
MAP_EX:	RET
;
MAP_DO:	PUSH	CX			; Save the count
	INC	SI			; Get past the space or delimiter
MAP_IN:	LODSB				; Get byte
	CMP	AL,'z'			; Check range
	JA	MAP_ST			; Not a lower case letter
	CMP	AL,'a'			; Check low range
	JB	MAP_ST			; Not a lower case letter
	AND	AL,95			; Reset lower-case bits
MAP_ST:	STOSB
	LOOP	MAP_IN
	POP	CX			; Restore byte count
	RET
MAP_CMD	ENDP
;
;	Search for a substring within a string.
;	Upon entry:
;		     DS:SI = String location
;			CX = String length
;			DX = Sub-string location
;			BX = Sub-string length
;	Upon exit:
;			ZR if string found
;		     ES:DI =  End of the substring within the string.
SCANS	PROC	NEAR
	PUSH	CX			; Save string length
	MOV	DI,DX			; Substring location
	MOV	CX,BX			; Substring length
	REPZ	CMPSB			; Compare strings
	POP	CX			; Restore string length
	JZ	SCANSF			; Substring was found.
	LOOP	SCANS			; Continue for string length
	INC	CX			; Make NZ
SCANSF:	RET
SCANS	ENDP
;
;	Check entered command-line
;
CHK_CMD	PROC	NEAR
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD0
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD0
	OR	WORD PTR [MODE],NOTIME	; Set the mode flag.
NOCMD0:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD1
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD1
	OR	WORD PTR [MODE],NOPROG	; Set the mode flag.
NOCMD1:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD2
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD2
	OR	WORD PTR [MODE],NODUMP	; Set the mode flag.
NOCMD2:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD3
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD3
	OR	WORD PTR [MODE],NOTABL	; Set the mode flag.
NOCMD3:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD4
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD4
	OR	WORD PTR [MODE],NOMASK	; Set the mode flag.
NOCMD4:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD5
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD5
	OR	WORD PTR [MODE],NOSTAC	; Set the mode flag.
NOCMD5:
	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD6
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD6
	OR	WORD PTR [MODE],NOREGI	; Set the mode flag.
;
NOCMD6:	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD7
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD7
	OR	WORD PTR [MODE],NOPOWE	; Set the mode flag.
;
NOCMD7:	MOV	SI,OFFSET BUFF		; Point to the buffer
	PUSH	CX			; Save string length
	MOV	DX,OFFSET CMD8
	MOV	BX,CMD_LEN
	CALL	SCANS			; Scan the string
	POP	CX			; Restore the string length
	JNZ	NOCMD8
	OR	WORD PTR [MODE],NOBBSM	; Set the mode flag.
NOCMD8:	RET
CHK_CMD	ENDP
;
INST	DB	CR,LF
	DB	'CRASH-F-INSTALL,  CRASH has already been installed!'
	DB	CR,LF
	DB	'$'
;
;	Communications adapter ports. Keep contiguous. Used only during
;	initialization.
;
COM1	DW	?
COM2	DW	?
COM3	DW	?
COM4	DW	?
;
;	Used only during initialization.
;
HANDLE	DW	?			; File control handle
BYTES	DW	?			; Bytes in the file
FNAMEB	DB	'CRASH.CFG',0		; Configuration file
SKIP	DB	CR,LF,'CRASH.CFG file not found. '
	DB	'Skipping interrupt redirection.$'
;
;	List of command-line entries.
;
CMD0	DB	'NOTI'
CMD1	DB	'NOPR'
CMD2	DB	'NODU'
CMD3	DB	'NOTA'
CMD4	DB	'NOMA'
CMD5	DB	'NOST'
CMD6	DB	'NORE'
CMD7	DB	'NOPO'
CMD8	DB	'NOBB'
CMD_LEN	EQU	$ - CMD8
BUFF	LABEL	BYTE
BUFFER LABEL	BYTE
PSEG	ENDS
	END	MAIN
