
/*

CNet-BBS users can type "TOTALS" at any prompt and see just how big
and impressive your system really is...

> Totals as of: Monday, Jan 24, 1994
>
> Active Users:    553                  Public Msgs Posted: 91,728
> Total Calls : 32,673                  Public Msgs Online: 39,404
>
> Doors Run   : 62,274                  Email Msgs Sent   :  3,288
> Doors Online:     38                  Email Msgs Online :    520
>
> Files U/Led : 16,578 @ 1,318meg       Text Items Read   :  2,995
> Files D/Led : 12,901 @ 1,190meg       Text Items Online :    232
> Files Online: 15,090 @ 1,238meg       Phone Lines       :     12

Aligns columns and inserts commas.

Can be run from the CLI.
(You can re-director output to a file for creating valuable,
informative zzzBBSads, for a change.)

Can also be run online.

Add your own custom header/footer lines.

CLI installation:
   1) Copy Totals.rexx TO Rexx:
   2) Edit the variables marked as "SysOp-settable", shown below.
   3) Add "alias tot rx rexx:Totals.rexx 0" to your s:shell-startup file.
                                         ^
                 This should be a port # that is alread loaded.
CLI> tot
CLI> tot >t:zzzTotals        (A valuable, informative BBSad for a change)
CLI> rx  >t:zzzBBS rexx:Totals.rexx 0
   (You might want to run that as a nightly CONFIG/EVENT DOS-CMD event.)


Online installation:
   1) Copy Totals.rexx TO Rexx:
   2) Edit the variables marked as "SysOp-settable", shown below.
   3) Add the following line onto the END of the list in CNet:BBSMENU marked
      as "2; Available Everwhere":
         TOTals | {#0 Rexx:Totals.rexx}

If you wish to automatically show your system-totals to all callers,
add the line "{#0 rexx:Totals.rexx}" into the files called
"SysText:sys.info" and "SysText:sys.start".

$VER: Totals.rexx v1.0 Mon 24-Jan-94 22:12:54
   First public release.
   Written/tested with CNet-BBS v3.01beta.
   Sent to user #520.

Bill Beogelein
Box 530441
Livonia, MI 48153
BBS 810-473-2020, Fido 1:2410/207

Ignore:
   lz u CNet3:CNetTotals.LHA pfiles:rexx/Totals.rexx a:zzzBBS
   lz u CNet3:CNetTotals.LHA CNet2:Totals.rules SysText:sys.start SysText:sys.info
   Copy CNet3:CNetTotals.LHA UP:

Future Plans:
   Make sure port exists.

*/

/********* Start of SysOp-settable variables **********/

col0 = 3         /* Indent whole display by x spaces                */

col1 = 5         /* Width of column #1 (left side column)           */
col2 = 3         /* Width of column #2 (mid column, megs ULed/DLed) */
col3 = 6         /* Width of column #3 (right side column)          */

kilo = 1000      /* Compute megabytes based on K=1000 or K=1024?    */
PhoneLines = 2   /* Number of phone lines installed (0-99)          */

        /* Text to display before and after showing totals from CLI */
CLIheader = "Amiga ShareWare HeadQuarters BBS, 1-810-473-2020, 1:2410/207 ..."
CLIfooter = "*** EOF ***"

          /* Text to display before and after showing totals online */
BBSheader = ""
BBSfooter = ""

/********** End of SysOp-settable variables *********/

options results
parse arg port

YES = (1==1)
NO  = (1==0)

cli = NO; LF = "n1"
if( port ~="" ) then       /* Run from CLI using port #n */
do
   cli=YES
   LF = '0a'x
   address value "CNETREXX" || port
end

'getUser' 2400092; ActUsers       = right(commas(RESULT), col1)
'getUser' 2400100; TotalCalls     = right(commas(RESULT), col1)

'getUser' 2400888; DoorsRun       = right(commas(RESULT), col1)
'getUser' 2400948; DoorsOnline    = right(commas(RESULT), col1)

'getUser'      96; FilesULed      = right(commas(RESULT), col1)
'getUser'      97; MegsULed       = right(commas(RESULT%kilo), col2)

'getUser'      98; FilesDLed      = right(commas(RESULT), col1)
'getUser'      99; MegsDLed       = right(commas(RESULT%kilo), col2)

'getUser' 2400956; FilesOnline    = right(commas(RESULT), col1)
'getUser' 2400960; MegsOnline     = right(commas(RESULT%kilo), col2)

'getUser' 2400876; a=RESULT
'getUser' 2400880; PubMsgsPost    = right(commas(a+RESULT), col3)
'getUser' 2400936; a=RESULT
'getUser' 2400940; PubMsgsOnline  = right(commas(a+RESULT), col3)

'getUser' 2400868; EmailsSent     = right(commas(RESULT), col3)
'getUser' 2400928; EmailsOnline   = right(commas(RESULT), col3)

'getUser' 2400884; TextItemsRead  = right(commas(RESULT), col3)
'getUser' 2400944; TextItemsOnline= right(commas(RESULT), col3)

/******************** Not yet in use **********************************
loport  =  0     /* The lowest  port # that should be counted (0)  */
hiport  = 30     /* The highest port # that should be counted (99) */

TDlines = 1      /* Increase the port-count by X.                      */
                 /* (For lines that are loaded/unloaded with TrapDoor) */
loaded=TDlines; used=0; free=0;
do port=loport to hiport
   address value "CNETREXX" || port
   if() then loaded=loaded+1
   if() then used  =used+1
   if() then free  =free+1
end
**********************************************************************/

if(cli) then
do
   call show(" ")
   if( CLIheader~="" ) then call show(CLIheader LF)
end
else
do
   call show("@4")           /* Turn off "MORE?" prompts */
   if( BBSheader~="" ) then call show(BBSheader LF)
end

dat = date('WEEKDAY') || "," left(date('MONTH'), 3) left(date(), 2) || "," left(date('SORTED'), 4)
call show("Totals as of:" dat LF)

call show("Active Users:" ActUsers    Spc1() "Public Msgs Posted:" PubMsgsPost)
call show("Total Calls :" TotalCalls  Spc1() "Public Msgs Online:" PubMsgsOnline LF)

call show("Doors Run   :" DoorsRun    Spc1() "Email Msgs Sent   :" EmailsSent)
call show("Doors Online:" DoorsOnline Spc1() "Email Msgs Sent   :" EmailsOnline LF)

call show("Files U/Led :" FilesULed   "@" MegsULed   "megs" Spc2() "Text Items Read   :" TextItemsRead)
call show("Files D/Led :" FilesDLed   "@" MegsDLed   "megs" Spc2() "Text Items Online :" TextItemsOnline)
call show("Files Online:" FilesOnline "@" MegsOnline "megs" Spc2() "Phone Lines       :" right(PhoneLines, col3))

if(cli) then
do
   call show(" ")
   if( CLIfooter~="" ) then call show(CLIfooter LF)
end
else
do
   if( BBSfooter ~="" ) then do; call show(" "); call show(BBSfooter); end
end

exit     /*** End of main ***/

Commas:     PROCEDURE
   parse arg num
   num = right(num, 30)    /* pad the left with spaces to inc of 3 */
   str = ""

   len=length(num)
   do i=len-2 to 1 by -3             /* 94577 94,577 */
      a = substr(num, i, 3)          /* 12345        */
      if(a="") then leave
      str = a || "," || str
   end
return strip(left(str, length(str)-1))   /* remove trailing "," */

Spc0: return copies(" ", col0)
Spc1: return copies(" ", 24-col1)
Spc2: return copies(" ", 16-col1-col2)

Show:
   parse arg str
   if(cli) then
      say        Spc0() || str
   else
      'transmit' Spc0() || str
return

/*** EOF pfiles:rexx/Totals.rexx 810-473-2020 ***/
