program DG_Stat;
{ --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --

DigiChannel PC/8e Status Program.

I intend to try running this program from one DesqView window while receiving 
a file from WildCat IM in another window.                    December 28, 1993

Requires DigiBoard's DigiChannel PC/8e hardware and XIDOS5.SYS device driver
to be installed on your PC.

  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- }
uses DOS;

type
  namestring = array[1..8] of char;

var
   Tdx, Rdx, i  : integer;
   xmitbuffsz, recvbuffsz : integer;
   regs : registers;
   name : ^namestring;
   stat, notetext : string;
   TestResult : word;

procedure WriteBin(n:integer);
  var i: integer;
begin
  for i := 0 to 7 do
    write( (n and ($80 shr i)) shr (7 - i) );
end { WriteBin };

procedure WriteHex(dec_num:longint);
{Write a 4-digit hex number.  Dec_Num<65,536 decimal.}
var
        x : real;
        h4, h3, h2, h1 : longint;
        c4, c3, c2, c1 : string[1];
        hex_str : string[4];
BEGIN
  if Dec_Num>=65536
  then
    write('****') { Error! }
  else
  begin

   x:=Dec_Num;
   if x<=0 then h4 := 0
          else h4 := trunc(x/4096);

   x:=x-h4*4096;
   if x<=0 then h3 := 0
          else h3 := trunc(x/256);

   x:=x-h3*256;
   if x<=0 then h2 := 0
          else h2 := trunc(x/16);

   x:=x-h2*16;
   if x<=0 then h1 := 0
           else h1 := trunc(x);

   hex_str := '0000';

   if h4>$0F
   then hex_str := '****'
   else
   begin
       
     if h4<=9
             then str(h4:1,c4)
             else c4 := chr(h4-10+ord('A'));
     {hex_str := concat(hex_str,c4);}
     hex_str[1] := c4[1];

     if h3<=9
             then str(h3:1,c3)
             else c3 := chr(h3-10+ord('A'));
     {hex_str := concat(hex_str,c3);}
     hex_str[2] := c3[1];
     if h2<=9
             then str(h2:1,c2)
             else c2 := chr(h2-10+ord('A'));
     {hex_str := concat(hex_str,c2);}
     hex_str[3] := c2[1];

     if h1<=9
             then str(h1:1,c1)
             else c1 := chr(h1-10+ord('A'));
     {hex_str := concat(hex_str,c1);}
     hex_str[4] := c1[1];

   end;
   write(hex_str);
  end;
end;

procedure write_date;
{ Example for GetDate }
const
  days : array [0..6] of String[9] =
    ('Sunday','Monday','Tuesday',
     'Wednesday','Thursday','Friday',
     'Saturday');
var
  y, m, d, dow : Word;
begin
  GetDate(y,m,d,dow);
  Write(days[dow],', ',
          m:0, '/', d:0, '/', y:0);
end;

procedure write_time;
{ Example for GetTime }
var
  h, m, s, hund : Word;
function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;
begin
  GetTime(h,m,s,hund);
  Write('  ',LeadingZero(h),':',
          LeadingZero(m),':',LeadingZero(s),
          '.',LeadingZero(hund));
end;



BEGIN

writeln('DG_Stat Version 1.01 - Copyright 1993 Computer Magic, Andover, Minnesota-');
writeln('-------------------------------------------------------------------------');
writeln;
writeln('This program uses the DigiCHANNEL Universal DOS Device Driver functions');
writeln('in the XIDOS5.SYS device driver for interrupt 14h.');
writeln;
write('The Date is: '); write_date; writeln;
write('The Time is: '); write_time; writeln;
TestResult := 0;
writeln;

  write('Enter Channel for which to obtain status information: ');
        readln(Tdx); writeln(Tdx);
  write('Note: '); readln(notetext); writeln(notetext);
  writeln;

  { Get Board & Channel Information -Function 06h }
  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $00;  { Subfunction: Get Port Name }
  intr($14,regs);
  writeln(' Get Board & Channel Information - Function 06h');
  writeln('     Subfunction 00h, Get Port Name');
  if regs.ah=$FF {error}
    then begin
           writeln('Tdx Port Name Error.');
           TestResult := 1;
         end;
  writeln('Tdx Highest Function Supported: ',regs.al);
  name := ptr(regs.es,regs.bx);
  write('Tdx Port Name: ');
  writeln(name^[1],name^[2],name^[3],name^[4],
          name^[5],name^[6],name^[7],name^[8] );
  writeln;

  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $01;  { Subfunction: Driver Information }
  intr($14,regs);
  writeln(' Get Board & Channel Information - Function 06h');
  writeln('     Subfunction 01h, Driver Information');
  if regs.ah=$ff then begin
                        writeln('Driver Info Error.');
                        TestResult := 1;
                      end;
  writeln('Total Channels supported: ',regs.ax);
  write  ('          Driver Version: '); WriteHex(regs.bx); writeln;
  writeln('            Total Boards: ',regs.cx);
  writeln('        Lowest Channel #: ',regs.dx);
  writeln('       Highest Channel #: ',regs.ax+regs.dx-1);
  writeln;

  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $02;  { Subfunction: Board Information }
  regs.bx := 0;    {              Board # 0         }
  intr($14,regs);
  writeln(' Get Board & Channel Information - Function 06h');
  writeln('     Subfunction 02h, Board Information');
  writeln('            Board Number: 0');
  if regs.ah=$ff then writeln('Board Info Error.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  writeln('               Board IRQ: ',regs.ah);
  write  ('              Board Type: ',regs.al,' (');writeHex(regs.al);writeln(')');
  write  ('                          '); writebin(regs.al); writeln(' binary');
  write  ('              Board Name: ');
        case regs.al of
          $00: writeln(' unknown.');
          $01: writeln(' COM/Xi.');
          $02: writeln(' MC/Xi.');
          $03: writeln(' PC/Xe.');
          $04: writeln(' PC/Xi.');
          $05: writeln(' PC/Xm.');
        end { case };
  writeln;
  write  ('        Board memory seg: ',regs.bx,' (');writeHex(regs.bx);writeln(')');
  writeln('        Board # Channels: ',regs.cx);
  write  ('  Board I/O Port Address: ',regs.dx,' (');writeHex(regs.dx);writeln(')');
  writeln('     Board first Channel: ',regs.SI);
  writeln;

  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $ff;  { Subfunction: Driver Name }
  intr($14,regs);
  writeln(' Get Board & Channel Information - Function 06h');
  writeln('     Subfunction FFh, Driver Name');
  write  ('   Driver Version Number: ',regs.ax,' (');writeHex(regs.ax);writeln(')');
  writeln(' Driver # Chnl Supported: ',regs.cx);
  name := ptr(regs.es,regs.bx);
  write(  '             Driver Name: ');
  writeln(name^[1],name^[2],name^[3],name^[4],
          name^[5],name^[6],name^[7],name^[8] );
  writeln;

  { EBIOS Presence Test - Function F4h }
  regs.dx := tdx;
  regs.ah := $f4;
  intr($14,regs);
  writeln('  EBIOS Presence Test - Function F4h ');
  if (regs.ax=$0000) then writeln('             EBIOS Functions Present.');
  if (regs.ah=$FF)   then writeln('             EBIOS Functions NOT Present.');
  writeln;

  { Alternate Status Check - Function 08h }
  regs.dx := tdx;
  regs.ah := $08;
  intr($14,regs);
  writeln('Alternate Status Check - Function 08h');
  write  ('                   Flags: ');writeHex(regs.flags);writeln(' hex');
  write  ('  Next Char in In Buffer: ');writeHex(regs.al);writeln(' hex');
  write  ('             Line Status: ');writeHex(regs.ah);writeln(' hex');
  write  ('                          ');writebin(regs.ah);writeln(' binary');
    if (regs.ah and $01 = $01) 
  then writeln('                          Data available in receive buffer.')
  else writeln('                          Receive buffer empty.');
    if (regs.ah and $02 = $02) 
  then writeln('                          Overrun Error while reading.');
    if (regs.ah and $04 = $04) 
  then writeln('                          Parity Error.');
    if (regs.ah and $08 = $08) 
  then writeln('                          Framing Error.');
    if (regs.ah and $10 = $10) 
  then writeln('                          Break Interrupt (AL=00h, NUL)');
    if (regs.ah and $20 = $20) 
  then writeln('                          Xmit Holding Reg: xmit buffer not full.')
  else writeln('                          Xmit Holding Reg: xmit buffer full.');
    if (regs.ah and $40 = $40) 
  then writeln('                          Xmit Shift Reg: xmit buffer not full.')
  else writeln('                          Xmit Shift Reg: xmit buffer full.');
    if (regs.ah and $80 = $80) 
  then writeln('                          Timeout Error - no data in input buffer.');
  writeln;

  { Input Queue Check - Function 0Ah }
  regs.dx := tdx;
  regs.ah := $0a;
  intr($14,regs);                { : }
  writeln(' Input Queue Check - Function 0Ah');
  writeln('Number chars inpt buffer: ',regs.ax);
  write  ('            Error if FFh: ');writeHex(regs.dh);writeln(' hex.');
  writeln;

  { Input Byte Count - Function 15h }
  regs.dx := tdx;
  regs.ah := $15;
  intr($14,regs);                { : }
  writeln('Input Byte Count - Function 15h');
  writeln('Bytes waiting in Receive Buffer: ',regs.ax);
  writeln;
  
  { Transmit Buffer Free Space - Function 12h }
  regs.dx := tdx;
  regs.ah := $12;
  intr($14,regs);                { : }
  writeln('Transmit Buffer Free Space - Function 12h');
  writeln('Bytes free in Transmit Buffer: ',regs.ax);
  writeln;
  
  { Get Channel Parameters - Function 0Ch }
  regs.dx := tdx;
  regs.ah := $0c;
  intr($14,regs);
  writeln('Get Channel Parameters - Function 0Ch');
  write  ('Tdx Software Flow Control: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('                           ');writebin(regs.ah);writeln(' binary');
  if regs.ah=$ff 
  then begin
         writeln('Tdx Channel Parameter Error.');
         TestResult := 1;
       end
  else begin
         if (regs.ah and $01 = $01) then writeln('         (XON/XOFF enabled)');
         if (regs.ah and $02 = $02) then writeln('         (XON/XOFF inactive)');
         write  ('Tdx Hardware Flow Control: ',regs.al,' (');writeHex(regs.al);writeln(')');
         if (regs.al and $01 = $01) then writeln('         (DTR enabled)');
         if (regs.al and $02 = $02) then writeln('         (RTS enabled)');
         if (regs.al and $10 = $10) then writeln('         (CTS enabled)');
         if (regs.al and $20 = $20) then writeln('         (DSR enabled)');
         if (regs.al and $80 = $80) then writeln('         (DCD enabled)');
                writeln('               Tdx Parity: ',regs.bh);
                write  ('                           ');writebin(regs.bh);writeln(' binary');
         case regs.bh of
           $00: writeln('                           (No Parity)');
           $01: writeln('                           (Odd Parity)');
           $02: writeln('                           (Even Parity)');
         end { case };
         writeln('            Tdx Stop Bits: ',regs.bl+1);
         write  ('     Tdx Character Length: ',regs.ch);
         case regs.ch of
           $00: writeln(' (5 bits)');
           $01: writeln(' (6 bits)');
           $02: writeln(' (7 bits)');
           $03: writeln(' (8 bits)');
         end { case };
           write  ('            Tdx Baud Rate: ',regs.cl,' (');writeHex(regs.cl);writeln(')');
           write  ('                           ');writebin(regs.cl);writeln(' binary');
           write  ('                           ');
         case regs.cl of
          $00: writeln(' 110 baud.');
          $01: writeln(' 150 baud.');
          $02: writeln(' 300 baud.');
          $03: writeln(' 600 baud.');
          $04: writeln(' 1200 baud.');
          $05: writeln(' 2400 baud.');
          $06: writeln(' 4800 baud.');
          $07: writeln(' 9600 baud.');
          $08: writeln(' 19200 baud.');
          $09: writeln(' 38400 baud.');
          $0a: writeln(' 57600 baud.');
          $0b: writeln(' 76800 baud.');
          $0c: writeln(' 115200 baud.');
          $0d: writeln(' 50 baud.');
          $0e: writeln(' 75 baud.');
          $0f: writeln(' 134 baud.');
          $10: writeln(' 200 baud.');
          $11: writeln(' 1800 baud.');
         end;
       end;
  writeln;

  { Get Status - Function 03h }
  regs.dx := tdx;
  regs.ah := $03;
  intr($14,regs);
  writeln('Get Status - Function 03h');
  write  ('Tdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('                 ');writebin(regs.ah);writeln(' binary');
  if (regs.ah and $01 = $01) then writeln('                 Data in receive buffer.')
                             else writeln('                 Receive Buffer Empty.');
  if (regs.ah and $20 = $20) then writeln('                 Transmit Holding Buffer Not Full.')
                             else writeln('                 Transmit Holding Buffer Full.');
  if (regs.ah and $40 = $40) then writeln('                 Transmit Shift Register Not Full.')
                             else writeln('                 Transmit Shift Register Full.');
  if (regs.ah = $FF)         then writeln('                 Transmit Status Error.');
  write  ('Tdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');
  write  ('                  ');writebin(regs.al);writeln(' binary');
  if (regs.al and $01 = $01) then writeln('                 Delta CTS.')
                             else writeln('                 CTS unchanged.');
  if (regs.al and $02 = $02) then writeln('                 Delta DSR.')
                             else writeln('                 DSR unchanged.');
  if (regs.al and $04 = $04) then writeln('                 Trailing Edge RI active.')
                             else writeln('                 Trailing Edge RI unchanged.');
  if (regs.al and $08 = $08) then writeln('                 Delta DCD.')
                             else writeln('                 DCD unchanged.');
  if (regs.al and $10 = $10) then writeln('                 CTS active.')
                             else writeln('                 CTS inactive.');
  if (regs.al and $20 = $20) then writeln('                 DSR active.')
                             else writeln('                 DSR inactive.');
  if (regs.al and $40 = $40) then writeln('                 RI active.')
                             else writeln('                 RI inactive.');
  if (regs.al and $80 = $80) then writeln('                 DCD active.')
                             else writeln('                 DCD inactive.');
  writeln;

  { Get Water Marks and Buffer Size - Function 1Bh }
  regs.dx := tdx;
  regs.ah := $1B;
  regs.al := $00; { subfunction: get Transmit Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 00h - Get Transmit Low Water Mark.');
  writeln('     Xmit Low Water Mark: ', regs.ax);
  writeln('        Xmit Buffer Size: ',regs.bx);
  if regs.dh=$ff then writeln('                          Xmit Buffer Error.');

  regs.dx := tdx;
  regs.ah := $1B;
  regs.al := $01; { subfunction: Get Receive Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 01h - Get Receive Low Water Mark.');
  writeln('     Recv Low Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');
  
  regs.dx := tdx;
  regs.ah := $1B;
  regs.al := $02; { subfunction: Get Receive High Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('    Recv High Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');
  
  writeln;
  writeln('                 ----- END OF DG_STAT REPORT  -----');
  writeln;
  halt(TestResult);
END.