
(*
 * dirov - produce an overview of a DIRCOUNT formatted area summary
 *
 *)

(* --------------------------------------------------------- *)
function remove_commas(s: string): string;
var
   i: integer;
   t: string;
begin
   t := '';
   for i := 1 to length(s) do
      case s[i] of
         '0'..'9':
            t := t + s[i];
      end;
   remove_commas := t;
end;


(* --------------------------------------------------------- *)
function atoi(s: string): longint;
var
   i: integer;
   l: longint;
begin
   s := remove_commas(s);
   val(s,l,i);
   atoi := l;
end;


(* --------------------------------------------------------- *)
function insert_commas(s: string): string;
var
   i: integer;
begin
   i := length(s);
   while i > 3 do
   begin
      dec(i,3);
      insert(',',s,i+1);
   end;

   insert_commas := s;
end;


(* --------------------------------------------------------- *)
function itoa (n: longint): string;
var
   tstr:          string;

begin
   str(n, tstr);
   itoa := insert_commas(tstr);
end;


(* --------------------------------------------------------- *)
function itoan(n: longint; width: integer): string;
var
   s: string;
begin
   s := itoa(n);
   while length(s) < width do
      s := ' ' + s;
   itoan := s;
end;


(* --------------------------------------------------------- *)
function ljust(s: string; width: integer): string;
begin
   s := copy(s,1,width);
   while length(s) < width do
      s := s + ' ';
   ljust := s;
end;


(* --------------------------------------------------------- *)
function center(s: string; width: integer): string;
var
   i: integer;
begin
   s := copy(s,1,width);
   i := (width - length(s)) div 2;
   while i > 0 do
   begin
      s := ' ' + s;
      dec(i);
   end;
   center := s;
end;


(* --------------------------------------------------------- *)
function cjust(s: string; width: integer): string;
var
   i: integer;
begin
   s := copy(s,1,width);
   i := (width - length(s)) div 2;
   while i > 0 do
   begin
      s := ' ' + s;
      dec(i);
   end;
   while length(s) < width do
      s := s + ' ';
   cjust := s;
end;

(* --------------------------------------------------------- *)
var
   boardname:  string;
   confname:   string;
   line:       string;
   oline:      string;
   fd:         text;
   i,deswid,k:      integer;

begin
   if paramcount <> 2 then
   begin
      writeln('Usage: DIROV sumfile descwidth >outfile');
      writeln('Produces an overview of a report file generated by DIRCOUNT');
      writeln('Parameters:');
      writeln('   sumfile specifies the input file, as produced by DIRCOUNT');
      writeln('   descwidth specifies the maximum width of descriptions');
      writeln('   outfile specifies the output file for the overview');
      halt;
   end;

   assign(fd,paramstr(1));
   reset(fd);

   val(paramstr(2),deswid,k);

   readln(fd);
   readln(fd,boardname);

   readln(fd,confname);
   while copy(confname,1,1) = ' ' do
      delete(confname,1,1);

   if confname[1] = '[' then
   begin
      delete(confname,1,1);
      dec(confname[0]);
   end;

   while length(confname) < 40 do
      confname := confname + ' ';

   if (deswid > 35) or (deswid < 1) then
      deswid := 35;

   repeat
      readln(fd,line);

      if (length(line) = 73) and (line[6] in ['0'..'9']) then
      begin
         for i := 1 to length(line) do
            if line[i] = '' then
               line[i] := ' ';
         oline := copy(line,4,3) + '-' + copy(line,12,deswid+1);

         while oline[length(oline)] = ' ' do
            dec(oline[0]);

         if length(oline) > deswid+4 then
         begin
            oline[deswid+3] := '.';
            oline[deswid+4] := '.';
            oline[0] := chr(deswid+4);
         end;

         writeln(oline);
      end;

   until eof(fd);
   close(fd);
end.

