/*
                             Fasort.cmd
                             August 29, 1993
                             Kim Bergman

File Areas Sort.

Alphabetizes lines in files.bbs.  Reads fasort.cfg to obtain a list of
directories.  Each directory should have a files.bbs that needs occassional
sorting.  Strips EOF too.

*/
"@echo off"
say " "

arg nexdir switch

if nexdir="" then do
   configfil="fasort.cfg"
   j=lines(configfil)
   if j=0 then do
    say " "
    say "Fasort.cmd error:  Can't read Fasort.cfg, aborting."
    say " "
    exit
   end

   do while lines(configfil)>0
    nexdir=linein(configfil)
    if left(nexdir,1)<>"%" then do
      call sortit nexdir
    end
   end /* do */
   j=stream(configfil,c,"close")
end
else do
   call sortit nexdir
end  /* Do */

if nexdir<>"/N" & switch<>"/N" then fbp.exe
say "Fasort.cmd done."
exit

sortit:  procedure

/* Accepts the fullpathname to a directory containing a files.bbs as the
only parameter, sorts the files.bbs into ascending order, strips EOF char 
if exists */

arg profilnam       /* the path to the directory that has the files.bbs */

tempfile=profilnam||"\tempfile.txt"
profilnam=profilnam||"\files.bbs"
say "Sorting "||profilnam

j=lines(tempfile)
if j>0 then do
 j=stream(tempfile,c,"close")
 del tempfile
end

i=0
j=lines(profilnam)
do while j>0                     /* if file is not empty then read it into array  */
  i=i+1
  curlin.i=linein(profilnam)
 j=lines(profilnam)
end                                /*  while j>0 read file into array   */

j=stream(profilnam,c,"close")

/* sort the array with bubble sort */
do until sorted="TRUE"
 sorted="TRUE"
  do k=1 to (i-1)
   j=k+1
   if curlin.k>curlin.j then do
    temp=curlin.k
    curlin.k=curlin.j
    curlin.j=temp
    sorted="FALSE"
   end  /* if curlin.k>curlin.k+1  */
  end /* do  k=1 to (i-1) */
end                                 /* do until sorted=true */


do k=1 to i
 r=lineout(tempfile,curlin.k)
end

r=stream(tempfile,c,"close")
del profilnam
ren tempfile files.bbs

return



