
/*
   FMSTRUCT.H

   File structures for FMail 0.94
   Copyright (C) 1993 Folkert J. Wijnstra. All rights reserved.

   All information in this document is subject to change at any time
   without prior notice!

   Strings are NUL terminated arrays of char type.
   Path names are \ terminated.
*/


/* ********** General structures ********** */

typedef char archiverInfo[48];
typedef char pathType[48];

typedef struct
{
   unsigned zone;
   unsigned net;
   unsigned node;
   unsigned point; } nodeNumType;

typedef struct
{
   nodeNumType nodeNum;
   unsigned    fakeNet; } nodeFakeType;



/* ********** FMAIL.CFG ********** */

#define MAX_AKAS   11
#define MAX_UPLREQ 16

typedef nodeFakeType akaListType[MAX_AKAS];

typedef struct
{
   unsigned useEMS       :  1; /* BIT 0 */
   unsigned checkBreak   :  1; /* BIT 1 */
   unsigned swap         :  1; /* BIT 2 */
   unsigned swapEMS      :  1; /* BIT 3 */
   unsigned swapXMS      :  1; /* BIT 4 */
   unsigned              :  1;
   unsigned monochrome   :  1; /* BIT 6 */
   unsigned commentFFD   :  1; /* BIT 7 */
   unsigned PTAreasBBS   :  1; /* BIT 8 */
   unsigned commentFRA   :  1; /* BIT 9 */
   unsigned keepReceipt  :  1; /* BIT 10 */
   unsigned incBDRRA     :  1; /* BIT 11 */
   unsigned keepRequest  :  1; /* BIT 12 */
   unsigned              :  2;
   unsigned RA2          :  1; /* BIT 15 */  } genOptionsType;

typedef struct
{
   unsigned removeNetKludges : 1; /* Bit 0 */
   unsigned                  : 1;
   unsigned checkPktDest     : 1; /* Bit 2 */
   unsigned areaMgrPwdChange : 1; /* Bit 3 */
   unsigned packetPwdChange  : 1; /* Bit 4 */
   unsigned                  : 3;
   unsigned dupDetection     : 1; /* Bit 8 */
   unsigned ignoreMSGID      : 1; /* Bit 9 */
   unsigned                  : 1; /* Bit 10 */
   unsigned                  : 1; /* Bit 11 */
   unsigned persNetmail      : 1; /* Bit 12 */
   unsigned privateImport    : 1; /* Bit 13 */
   unsigned keepExpNetmail   : 1; /* Bit 14 */
   unsigned killEmptyNetmail : 1; /* Bit 15 */  } mailOptionsType;

typedef struct
{
   unsigned sortNew      : 1; /* bit  0   */
   unsigned sortSubject  : 1; /* bit  1   */
   unsigned updateChains : 1; /* bit  2   */
   unsigned reTear       : 1; /* bit  3   */
   unsigned              : 1; /* bit  4   */
   unsigned              : 1; /* bit  5   */
   unsigned removeRe     : 1; /* bit  6   */
   unsigned removeLfSr   : 1; /* bit  7   */
   unsigned scanAlways   : 1; /* bit  8   */
   unsigned scanUpdate   : 1; /* bit  9   */
   unsigned multiLine    : 1; /* bit 10   */
   unsigned              : 1; /* bit 11   */
   unsigned quickToss    : 1; /* bit 12   */
   unsigned              : 2; /* bit 13-14 */
   unsigned sysopImport  : 1; /* bit 15   */ } mbOptionsType;

typedef struct
{
   unsigned active      : 1; /* Bit  0 */
   unsigned tinySeenBy  : 1; /* Bit  1 */
   unsigned security    : 1; /* Bit  2 */
   unsigned             : 1; /* Bit  3 */
   unsigned private     : 1; /* Bit  4 */
   unsigned impSeenBy   : 1; /* Bit  5 */
   unsigned checkSeenBy : 1; /* Bit  6 */
   unsigned             : 1; /* Bit  7 */
   unsigned local       : 1; /* Bit  8 */
   unsigned             : 1; /* Bit  9 */
   unsigned passThrough : 1; /* Bit 10 */
   unsigned             : 3; /* Bit 11-13 */
   unsigned arrivalDate : 1; /* Bit 14 */
   unsigned sysopRead   : 1; /* Bit 15 */     } defaultOptionsType;

typedef struct
{
   unsigned addPlusPrefix :  1; /* BIT 0 */
   unsigned               :  3;
   unsigned unconditional :  1; /* BIT 4 */
   unsigned               : 11;    } uplOptType;

typedef struct /* NOT USED YET */
{
   nodeNumType node;
   char        program[9];
   char        password[17];
   char        fileName[13];
   char        fileType;
   long        groups;
   char        originAka;
   uplOptType  options;
   char        reserved[9];  } uplinkReqType;

typedef struct
{
   char            versionMajor;
   char            versionMinor;
   long            creationDate;
   unsigned long   key;
   unsigned long   reservedKey;
   unsigned long   relKey1;
   unsigned long   relKey2;
   char            reserved0[24];
   akaListType     akaList;
   nodeFakeType    reservedAka[16-MAX_AKAS];
   unsigned        netmailBoard[MAX_AKAS];
   unsigned        reservedNet[16-MAX_AKAS];
   genOptionsType  genOptions;
   mbOptionsType   mbOptions;
   mailOptionsType mailOptions;
   unsigned        maxPktSize;
   unsigned        logLevel;
   unsigned        mailer;
   unsigned        bbsProgram;
   unsigned        maxBundleSize;
   unsigned        extraHandles; /* 0-235 */
   unsigned        autoRenumber;
   unsigned        bufSize;
   unsigned        ftBufSize;
   unsigned        allowedNumNetmail;
   char            reserved1[72];
   unsigned        colorSet;
   char            sysopName[36];
   unsigned        defaultArc;
   char            reserved2[24];
   char            tearType;
   char            tearLine[25];
   pathType        summaryLogName;
   unsigned        recBoard;
   unsigned        badBoard;
   unsigned        dupBoard;
   char            topic1[16];
   char            topic2[16];
   pathType        bbsPath;
   pathType        netPath;
   pathType        sentPath;
   pathType        rcvdPath;
   pathType        inPath;
   pathType        outPath;
   pathType        securePath;
   pathType        logName;
   pathType        swapPath;
   pathType        semaphorePath;
   pathType        pmailPath;
   pathType        areaMgrLogName;
   pathType        autoRAPath;
   pathType        autoFolderFdPath;
   pathType        autoAreasBBSPath;
   pathType        autoGoldEdAreasPath;
   archiverInfo    unArc;
   archiverInfo    unZip;
   archiverInfo    unLzh;
   archiverInfo    unPak;
   archiverInfo    unZoo;
   archiverInfo    unArj;
   archiverInfo    unSqz;
   archiverInfo    reservedUnArc;
   archiverInfo    arc;
   archiverInfo    zip;
   archiverInfo    lzh;
   archiverInfo    pak;
   archiverInfo    zoo;
   archiverInfo    arj;
   archiverInfo    sqz;
   archiverInfo    reservedArc;
   char            defaultOriginLine[59];
   defaultOptionsType
                   defaultOptions;
   unsigned        defaultDays;
   unsigned        defaultMsgs;
   unsigned        defaultReadSecRA;
   char            defaultReadFlagsRA[4];
   unsigned        defaultWriteSecRA;
   char            defaultWriteFlagsRA[4];
   unsigned        defaultSysopSecRA;
   char            defaultSysopFlagsRA[4];
   char            defaultAttrRA;
   char            defaultMsgKindsRA;
   unsigned        defaultAttrSBBS;
   char            defaultReplyStatSBBS;
   unsigned        defaultDaysRcvd;
   unsigned        defaultMinAgeSBBS;
   char            reserved3[200];
   char            qwkNameSBBS[11][13];
   unsigned        minAgeSBBS[11];
   unsigned        daysRcvdAKA[11];
   char            replyStatSBBS[11];
   unsigned        attrSBBS[11];
   char            groupDescr[26][27];
   char            reserved4[9];
   char            msgKindsRA[11];
   char            attrRA[11];
   unsigned        readSecRA[11];
   char            readFlagsRA[11][4];
   unsigned        writeSecRA[11];
   char            writeFlagsRA[11][4];
   unsigned        sysopSecRA[11];
   char            sysopFlagsRA[11][4];
   unsigned        daysAKA[11];
   unsigned        msgsAKA[11];
   char            descrAKA[11][51];
   char            reserved[3072];
   uplinkReqType   uplinkReq[MAX_UPLREQ];   } configType;



/* ********** FMAIL.AR ********** */

#define MAX_AREAS    512
#define MAX_FORWARD   64

#define ECHONAME_LEN_OLD  25
#define ECHONAME_LEN      51
#define COMMENT_LEN       51
#define ORGLINE_LEN       59

typedef char echoNameType[ECHONAME_LEN];

typedef struct
{
   unsigned active      : 1; /* Bit  0 */
   unsigned tinySeenBy  : 1; /* Bit  1 */
   unsigned security    : 1; /* Bit  2 */
   unsigned             : 1; /* Bit  3 */
   unsigned private     : 1; /* Bit  4 */
   unsigned impSeenBy   : 1; /* Bit  5 */
   unsigned checkSeenBy : 1; /* Bit  6 */
   unsigned             : 1; /* Bit  7 */
   unsigned local       : 1; /* Bit  8 */
   unsigned             : 1; /* Bit  9 */
   unsigned reserved    : 1; /* Bit 10 */
   unsigned             : 3; /* Bit 11-13 */
   unsigned arrivalDate : 1; /* Bit 14 */
   unsigned sysopRead   : 1; /* Bit 15 */   } areaOptionsType;

typedef struct
{
   char            areaNameOld[ECHONAME_LEN_OLD];
   char            comment[COMMENT_LEN];
   long            group;
   unsigned        board;
   unsigned        address;
   unsigned        alsoSeenBy;
   char            reserved1[8];
   areaOptionsType options;
   unsigned        outStatus;
   unsigned        days;
   unsigned        msgs;
   unsigned	   daysRcvd;
   char            reserved2[2];
   unsigned        readSecRA;
   char            flagsRdRA[4];
   unsigned        writeSecRA;
   char            flagsWrRA[4];
   unsigned        sysopSecRA;
   char            flagsSysRA[4];
   char            attrRA;
   char            msgKindsRA;
   unsigned        attrSBBS;
   char            replyStatSBBS;
   echoNameType    areaName;
   char            qwkName[13];
   unsigned        minAgeSBBS;
   char            reserved3[2];
   char            originLine[ORGLINE_LEN];
   nodeNumType     export[MAX_FORWARD];  } rawEchoType;



/* ********** FMAIL.BDE ********** */

#define MAX_BAD_ECHOS 50

typedef struct
{
   echoNameType badEchoName;
   nodeNumType  srcNode;
   int          destAka;      } badEchoType;



/* ********** FMAIL.NOD ********** */

#define MAX_NODEMGR 256

typedef struct
{
   unsigned fixDate     : 1; /* Bit 0 */
   unsigned tinySeenBy  : 1; /* Bit 1 */
   unsigned             : 1; /* Bit 2 */
   unsigned ignorePwd   : 1; /* Bit 3 */
   unsigned active      : 1; /* Bit 4 */
   unsigned             : 3;
   unsigned             : 1; /* Bit 8 */
   unsigned             : 3;
   unsigned forwardReq  : 1; /* Bit 12 */
   unsigned remMaint    : 1; /* Bit 13 */
   unsigned allowRescan : 1; /* Bit 14 */
   unsigned notify      : 1;   } nodeOptionsType;

typedef struct
{
   nodeNumType     node;
   char            reserved1[2];
   unsigned        capability;
   unsigned        archiver;
   nodeOptionsType options;
   unsigned long   groups;
   unsigned        outStatus;
   char            reserved2[32];
   char            password[18];
   char            packetPwd[10];
   char            reserved[10];
   char            sysopName[36];   } nodeInfoType;



/* ********** FMAIL.PCK ********** */

#define PACK_STR_SIZE 64
#define MAX_PACK      64

typedef char packEntryType[PACK_STR_SIZE];
typedef packEntryType packType[MAX_PACK];

