#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>

int ucpos(char *searchtag,char *fulltag)
{
    int i,j,lensrch;

    lensrch = strlen(searchtag);
    if (lensrch) {
	j = strlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! strnicmp(searchtag,&fulltag[i],lensrch))
		return(i);
	}
	return(-1);
    }
    return(0);
}

int pos(char *searchtag,char *fulltag)
{
    int i,j,lensrch;

    lensrch = strlen(searchtag);
    if (lensrch) {
	j = strlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! strncmp(searchtag,&fulltag[i],lensrch))
		return(i);
	}
	return(-1);
    }
    return(0);
}


void split_fname(char *fullname,char *path,char *fname)
{
    int k, ch, j;
    char hold[80];

    k = (-1);
    j = 0;
    while (ch = fullname[++k]) {
	if ((ch==':')||(ch=='\\')||(ch=='/'))
	    j = (k+1);
    }
    if (j) {
	strcpy(fname,&fullname[j]);
	strcpy(hold,fullname);
	hold[j] = 0;
	strcpy(path,hold);
    }
    else {
	strcpy(hold,fullname);
	path[0] =
	  hold[12] = 0;
	strcpy(fname,hold);
    }
}

int strip_nl(char *s,int imax)
{
    int j, lmax;

    lmax = imax - 1;
    j = 0;
    while ((s[j]) && (s[j] != '\n') && (s[j] != '\r') && (j < lmax))
	j++;
    s[j] = 0;
    return(j);
}

int fgets_p(char *s,int imax,FILE *f)
{
    char *p;
    int slen, buffmax;

    buffmax = imax - 3;
    p = fgets(s,buffmax,f);
    if ((p == NULL) || (s[0] == 26)) {
	s[0] = 0;
	return(-1);
    }
    slen = strip_nl(s,imax);
    return(slen);
}

static char cdrom_main_path[80];
static char cdrom_idx_fname[80];
static int cdrom_drive_letter;
static FILE *cdrom_idx;
static FILE *gtdir_bbs;
static int asterisk_format;
static char output_path[80];
static char files_bbs_path[80];
static FILE *files_bbs;
static int files_bbs_open;

typedef char string80[84];

static int descript_cnt = 0;
static string80 descript[19];

void get_gtdir_desc(FILE *gtdir,char *path,char *directory_name)
{
    char work[128], temp[200];
    int access_level, j;

    for (j=0; j<descript_cnt; j++)
	printf("\n%s",descript[j]);
    printf("\n\nEnter description: ");
    gets(work);
    sprintf(temp,"%s,,%s%s.DIR,CD",path,files_bbs_path,directory_name);
    fprintf(gtdir,"z %-52s %s\n",temp,work);
    descript_cnt = 0;
}

void store_descript(char *s)
{
    if (descript_cnt > 18)
	return;
    strncpy(descript[descript_cnt],s,80);
    descript[descript_cnt][80] = 0;
    descript_cnt++;
}

int is_directory_line(char *buffer,char *directory_path)
{
    int i, j, k;
    char work[264];

    if (!strncmp(buffer,"**",2)) {
	asterisk_format = 1;
	store_descript(buffer);
	j = ucpos(cdrom_main_path,buffer);
	if (j > 3)
	    goto ProcessDIR;
	return(0);
    }
    if (!strnicmp(buffer,"DIR",3)) {
	j = pos(" ",buffer);
	if (j++ > 2) {
ProcessDIR:
	    k = strlen(buffer);
	    if (j < k) {
		directory_path[0] = cdrom_drive_letter;
		directory_path[1] = ':';
		directory_path[2] = '\\';
		directory_path[3] = 0;
		strcpy(work,&buffer[j]);
		i = pos(" ",work);
		if (i < 0)
		    i = pos("\t",work);
		if (i > 0)
		    work[i] = 0;
		strcat(directory_path,work);
		for (j=0; directory_path[j]; j++) {
		    if (directory_path[j] == '/')
			directory_path[j] = '\\';
		}
		j--;
		if (directory_path[j] == '\\')
		    directory_path[j] = 0;
		strupr(directory_path);
		return(1);
	    }
	}
    }
    return(0);
}

int process_cdrom_idx(FILE *cdrom,FILE *gtdir)
{
    char buffer[264], files_path[80], directory_name[80], work[132];
    char prior_files_path[80];
    int search_for_directory, slen, tear_line, ch, j;

    files_bbs = NULL;
    descript_cnt =
      tear_line =
	files_bbs_open =
	  asterisk_format =
	    prior_files_path[0] = 0;
    search_for_directory = 1;
    while (!feof(cdrom)) {
	slen = fgets_p(buffer,260,cdrom);
	if (slen < 0)
	    goto IsDir_Exit;
	if (!slen)
	    memset(buffer,0,32);
	if (search_for_directory) {
	    files_path[0] = 0;
	    if (is_directory_line(buffer,files_path)) {
		if (files_path[0]) {
		    search_for_directory = 0;
		    strcpy(prior_files_path,files_path);
		    printf("\n\nProcessing directory: %s\n",files_path);
		    split_fname(files_path,work,directory_name);
		    sprintf(work,"%s%s.DIR",output_path,directory_name);
		    files_bbs = fopen(work,"wt");
		    if (files_bbs == NULL) {
			printf("\nERROR: cannot write to %s\n\n",work);
			return(1);
		    }
		    files_bbs_open = 1;
		    tear_line = 0;
		    fprintf(files_bbs,"\n");
		    if (asterisk_format) {
			for (j=0; j<descript_cnt; j++) {
			    ch = descript[j][0];
			    if ((ch=='*')||(!ch)||(ch==' ')||(ch=='\t'))
				fprintf(files_bbs,"%s\n",descript[j]);
			    else
				fprintf(files_bbs," %s\n",descript[j]);
			}
		    }
		}
	    }
	}
	else {
	    ch = buffer[0] & 0xff;
	    if (tear_line) {
		if (ch >= ' ') {
		    fprintf(files_bbs,"%s\n",buffer);
		    store_descript(buffer);
		}
		if ((! ch) || (ch <= ' ')) {
		    search_for_directory = 1;
		    if (files_bbs_open) {
			fprintf(files_bbs,"\n\n");
			fclose(files_bbs);
			files_bbs_open = 0;
			get_gtdir_desc(gtdir,prior_files_path,directory_name);
		    }
		}
	    }
	    else {
		if (asterisk_format) {
		    if ((ch >= 'A') && (ch <= 'Z')) {
			tear_line = 1;
			goto  SkipOtherChecks;
		    }
		    if ((ch >= 'a') && (ch <= 'z')) {
			tear_line = 1;
			goto  SkipOtherChecks;
		    }
		    if ((ch=='=')||(ch=='-')||(ch=='_')||(ch==196)||(ch == 205))
			tear_line = 1;
SkipOtherChecks:
		    ch = ' ';
		    goto ProcessAboveTheTear;
		}
		if ((ch=='=')||(ch=='-')||(ch=='_')||(ch==196)||(ch == 205)) {
		    tear_line = 1;
		    memset(buffer,'-',78);
		    buffer[78] = 0;
		    fprintf(files_bbs,"%s\n",buffer);
		}
		else {
ProcessAboveTheTear:
		    if (ch > ' ')
			fprintf(files_bbs," %s\n",buffer);
		    else
			fprintf(files_bbs,"%s\n",buffer);
		}
		store_descript(buffer);
	    }
	}
    }
IsDir_Exit:
    if (files_bbs_open) {
	fprintf(files_bbs,"\n\n");
	fclose(files_bbs);
	files_bbs_open = 0;
	get_gtdir_desc(gtdir,prior_files_path,directory_name);
    }
    return(0);
}

void slash_it(char *s)
{
    int j;

    j = strlen(s) - 1;
    if (j >= 0) {
	if (s[j] != '\\')
	    strcat(s,"\\");
    }
}

void massage(char *s)
{
    char work[132];

    while (s[0] == ' ') {
	strcpy(work,&s[1]);
	strcpy(s,work);
    }
    strupr(s);
}

int main(void)
{
    int return_code, j;
    char work[128];

    return_code = 0;
    printf("\nEnter the drive letter of the CD-ROM     : ");
    gets(work);
    massage(work);
    cdrom_drive_letter = work[0];
    printf(  "Enter the name of the CD-ROM index file  : ");
    gets(work);
    massage(work);
    strcpy(cdrom_idx_fname,work);
    printf(  "Which CD-ROM directory is the index for? : ");
    gets(work);
    massage(work);
    j = strlen(work) - 1;
    if (j > 0) {
	if (work[j] == '\\') {
	    work[j] = '/';
	}
	else {
	    if (work[j++] != '/') {
		work[j++] = '/';
		work[j] = 0;
	    }
	}
    }
    strcpy(cdrom_main_path,work);
    printf(  "Enter the path to the FILES.BBS storage  : ");
    work[0] = 0;
    gets(work);
    massage(work);
    if (work[0]) {
	strcpy(files_bbs_path,work);
    }
    else {
	getcwd(files_bbs_path,70);
    }
    slash_it(files_bbs_path);
    printf(  "Where do you want me to put the output   : ");
    work[0] = 0;
    gets(work);
    massage(work);
    if (work[0]) {
	strcpy(output_path,work);
    }
    else {
	getcwd(output_path,70);
    }
    slash_it(output_path);
    cdrom_idx = fopen(cdrom_idx_fname,"rt");
    if (cdrom_idx == NULL) {
	printf("\nERROR: cannot open file: %s",cdrom_idx_fname);
	return_code = 1;
	goto Main_Exit;
    }
    sprintf(work,"%sGTDIR.CD",output_path);
    gtdir_bbs = fopen(work,"wt");
    if (gtdir_bbs == NULL) {
	printf("\nERROR: cannot create file: %s",work);
	return_code = 1;
	goto Main_Exit;
    }
    return_code = process_cdrom_idx(cdrom_idx,gtdir_bbs);
    fclose(cdrom_idx);
    fclose(gtdir_bbs);
Main_Exit:
    return(return_code);
}
