#include <stdio.h>
#include <process.h>
#include <dos.h>
#include <time.h>
#include <string.h>
#include <conio.h>

#define TIMER   0x00000070L

typedef unsigned long longint;

void main(int,char *[]);

int dv_found                        = 0;
int crtmode                         = 0;
int Ctrl_C                          = 0;

static void (interrupt far *old_timer)(void);

void set_int_vector(unsigned long vaddr,unsigned long value)
{
    _disable();
    *((unsigned long far *) vaddr) = value;
    _enable();
}

unsigned long get_int_vector(unsigned long vaddr)
{
    unsigned long result;

    _disable();
    result = *((unsigned long far *) vaddr);
    _enable();
    return(result);
}

static int carrier_cycle       = 0;

void interrupt far monitor(void)
{
    if (++carrier_cycle < 18)    /******  18 ticks is about 1 second.  *****/
	goto TIMEX;
    carrier_cycle = 0;
TIMEX:
    (*old_timer)();
}

unsigned gt_swap(unsigned b1,unsigned b2)
{
    return( ((b1 << 8) | b2) );
}

void shape_cursor(unsigned st,unsigned en)
{
    union REGS regs;

    if (crtmode == 7) {
        st += 5;
        en += 5;
    }
    regs.x.ax = 0x0100;
    regs.x.cx = gt_swap(st,en);
    int86(0x10,&regs,&regs);
}

void cursor_off(void)
{
    union REGS regs;

    regs.x.ax = 0x0100;
    regs.x.cx = 0x2000;
    int86(0x10,&regs,&regs);
}

void cursor_on(void)
{
    shape_cursor(6,7);
}

int detect_dv(void)
{
    unsigned scr_seg;
    union REGS regs;
    struct SREGS sregs;

    scr_seg = 0xb800;
    if (crtmode == 7)
	scr_seg = 0xb000;
    segread(&sregs);
    sregs.es = scr_seg;
    regs.x.di = 0;
    regs.x.cx = 0x4445;
    regs.x.dx = 0x5351;
    regs.x.ax = 0x2b01;
    intdosx(&regs,&regs,&sregs);
    if (regs.h.al == 0xff)
        return(0);
    return(1);
}

void YieldTime(void)
{
    union REGS regs;

    if (dv_found) {
        regs.x.ax = 0x1000;
        int86(0x15,&regs,&regs);
        return;
    }
    if (_osmajor>4) {
        regs.x.ax = 0x1680;
        int86(0x2F,&regs,&regs);
    }
}

void real_time(unsigned long *t)
{
    union REGS regs;

    regs.x.ax = 0x2c00;
    intdos(&regs,&regs);
    *t = (((unsigned long) regs.h.ch) * 360000L)
       + (((unsigned long) regs.h.cl) * 6000L)
       + (((unsigned long) regs.h.dh) * 100L)
       +  ((unsigned long) regs.h.dl);
}

unsigned long elapsed(unsigned long start)
{
    unsigned long curr;

    real_time(&curr);
    while (curr < start)
        curr += 4320000L;
    return((curr - start));
}

int get_char(void)
{
    int keychar;

    if (Ctrl_C) {
        keychar = 11;
        Ctrl_C = 0;
    }
    else {
        keychar = (-1);
        if (kbhit()) {
            if ((keychar = getch()) == 3)
                keychar = 11;
        }
    }
    return(keychar);
}

int _cdecl c_break(void)
{
    Ctrl_C = 1;
    return(-1);
}

void main(int argc,char *argv[])
{
    int k, damt, win_found;
    union REGS regs;
    unsigned long delta, begin;
    int bhour, bminute, ehour, eminute, x, y, rescode;
    char currtime[30], starttargettime[30], stoptargettime[30];
    struct time time_now;

    Ctrl_C =
      rescode = 0;
    ctrlbrk(c_break);
    old_timer = (void far *) get_int_vector(TIMER);
    set_int_vector(TIMER,(unsigned long) monitor);
    if (argc < 2) {
        printf(  "\nUsage: DELAY n");
        printf("\n\n          Where 'n' is the desired number of milleseconds.");
        printf("\n\n   Or: DELAY -xx:xx -yy:yy");
        printf("\n\n          Where the delay program will delay until the indicated");
          printf("\n          time window arrives.  '-xx:xx' is the beginning time and");
	  printf("\n          '-yy:yy' is the ending time of the window.");
        printf("\n\nDELAY is DESQview(tm) aware.");
        printf("\n");
        rescode = 1;
        goto Prog_Exit;
    }
    regs.x.ax = 0x0f00;
    int86(0x10,&regs,&regs);
    crtmode = (regs.x.ax & 0x00ff);
    win_found = 0;
    dv_found = detect_dv();
    if (!dv_found) {
        regs.x.ax = 0x1600;
        int86(0x2F,&regs,&regs);
        if ((regs.h.al>2)&&(regs.h.al<0x80))
            win_found = 1;
    }
    damt = 500;
    if ((dv_found)||(win_found))
        damt = 0;
    cursor_off();
    if (argv[1][0] == '-') {
        clrscr();
        sscanf(&argv[1][1],"%i",&bhour);
        bminute = k = 0;
        while ((argv[1][k] != ':') && (argv[1][k]))
	    k++;
        if (argv[1][k++] == ':')
	    sscanf(&argv[1][k],"%i",&bminute);
        ehour = bhour;
        eminute = bminute;
        if (argc > 2) {
            sscanf(&argv[2][1],"%i",&ehour);
            eminute = k = 0;
            while ((argv[1][k] != ':') && (argv[2][k]))
  	        k++;
            if (argv[2][k++] == ':')
	        sscanf(&argv[2][k],"%i",&eminute);
        }
        printf("\n");
        flushall();
        x = wherex();
        y = wherey();
        do {
            YieldTime();
            if (get_char() == 11) {
                rescode = 2;
                goto Prog_Exit;
            }
	    gettime(&time_now);
	    sprintf(currtime,"%2d:%02d:%02d",time_now.ti_hour,time_now.ti_min,time_now.ti_sec);
            if (get_char() == 11) {
                rescode = 2;
                goto Prog_Exit;
            }
	    flushall();
	    gotoxy(x,y);
            if (get_char() == 11) {
                rescode = 2;
                goto Prog_Exit;
            }
	    printf("Current time: %s",currtime);
	    currtime[6] = 0;
	    sprintf(starttargettime,"%2d:%02d",bhour,bminute);
	    sprintf(stoptargettime,"%2d:%02d",ehour,eminute);
            if (get_char() == 11) {
                rescode = 2;
                goto Prog_Exit;
            }
            printf("\nWaiting for : %s",starttargettime);
	    if ((ehour != bhour) || (eminute != bminute)) {
	        printf(" to %s",stoptargettime);
            }
	    delay(damt);
        } while (((strcmp(currtime,starttargettime)) < 0) || ((strcmp(currtime,stoptargettime) > 0)));
        printf("\n\nThe time has arrived!\n");
    }
    else {
        sscanf(argv[1],"%I",&delta);
        delta = delta / 10L;
        real_time(&begin);
        while (elapsed(begin) < delta) {
            if (get_char() == 11) {
                rescode = 2;
                goto Prog_Exit;
            }
	    YieldTime();
	    delay(damt);
        }
    }
Prog_Exit:
    cursor_on();
    set_int_vector(TIMER,(unsigned long) old_timer);
    exit(rescode);
}
