#define CREATE 0
#define OPEN 1
#define CLOSE 2
#define ADD 3
#define READ 4
#define PURGE 5
#define APPEND 6
#define HASH_READ 7
#define DELETE 8
#define UNDELETE 9
#define STICKY_BIT       0x0001
#define EXPORTED_BIT     0x0002
#define QWK_NETWORK_BIT  0x0004
#define REGISTER register int
#define MAX_CALLER 0x7FFFFFFFL
#define MAX_PID 32

typedef unsigned long LONGINTEGER;
typedef unsigned char BOOLEAN;
typedef unsigned char STRING;
typedef unsigned char BYTE;
typedef unsigned int  INTEGER;

extern void _fastcall ccitt_crc_calc(unsigned);
extern void _fastcall ccitt_crc32_calc(unsigned);

struct old_user_record {
    char      old_user_deleted;
    STRING    old_user_name[31];
    int       old_user_msg_number;
    STRING    old_user_date[9];
    int       old_user_credit;
    STRING    old_user_time[9];
    int       old_user_charges;
    int       old_user_times_on;
    char      old_user_banned;
    char      old_user_expert;
    char      old_user_more;
    STRING    old_user_home[31];
    STRING    old_user_password[21];
    STRING    old_user_phone[11];
    char      old_user_privel;
    char      old_user_day_calls;
    int       old_user_accum_time;
};

typedef struct idx_record {
    BOOLEAN   hash_del_flg;
    BOOLEAN   hash_re_used;
    INTEGER   hash_code;
    INTEGER   hash_ptr;
} IDX_RECORD;

typedef struct user_record {                       /*  OFFSETS  */
    BOOLEAN      user_deleted;                     /*      0    */
    STRING       user_name[31];                    /*      1    */
    STRING       user_first_date[9];               /*     32    */
    STRING       user_first_time[6];               /*     41    */
    STRING       user_last_date[9];                /*     47    */
    STRING       user_last_time[6];                /*     56    */
    INTEGER      user_credit;                      /*     62    */
    INTEGER      user_charges;                     /*     64    */
    INTEGER      user_times_on;                    /*     66    */
    BOOLEAN      user_banned;                      /*     68    */
    BOOLEAN      user_expert;                      /*     69    */
    BOOLEAN      user_more;                        /*     70    */
    STRING       user_home[31];                    /*     71    */
    STRING       user_phone[11];                   /*    102    */
    STRING       user_password[21];                /*    113    */
    char         user_privel;                      /*    134    */
    INTEGER      user_day_calls;                   /*    135    */
    INTEGER      user_accum_time;                  /*    137    */
    char         user_protocol;                    /*    139    */
    INTEGER      user_screen_lgth;                 /*    140    */
    INTEGER      user_upload_k;                    /*    142    */
    INTEGER      user_upload_files;                /*    144    */
    INTEGER      user_dnload_k;                    /*    146    */
    INTEGER      user_dnload_files;                /*    148    */
    LONGINTEGER  user_caller_no;                   /*    150    */
    INTEGER      user_hash_code;                   /*    154    */
    STRING       user_cb_handle[10];               /*    156    */
    INTEGER      user_expire_date;                 /*    166    */
    int          user_time_bank;                   /*    168    */
    INTEGER      user_day_dnload_k;                /*    170    */
    int          user_day_time_deposits;           /*    172    */
    int          user_day_time_withdrawals;        /*    174    */
} USER_RECORD;

struct msg_record {
    BOOLEAN        msg_deleted;
    INTEGER        msg_number;
    STRING         msg_sender[31];
    STRING         msg_addressee[31];
    STRING         msg_topic[31];
    STRING         msg_date[9];
    int            msg_dest_net;
    STRING         msg_time[6];
    BYTE           msg_weekday;
    BYTE           msg_flags;             /*   0x01 - STICKY BIT         */
					  /*   0x02 - EXPORTED BIT       */
					  /*   0x04 - QWK NETWORK BIT    */
    char           msg_filler;
    int            msg_dest_node;
    BYTE           msg_perm_priv;
    BYTE           msg_received;
    INTEGER        msg_reply_no[3];
    INTEGER        msg_orig_no;
};

typedef struct {
    BOOLEAN        user_msg_deleted;
    INTEGER        user_msg_prior_read;
    INTEGER        user_msg_highest_scan;
    LONGINTEGER    user_msg_caller_no;
    INTEGER        user_msg_hash_code;
    BOOLEAN        user_msg_banned;
    INTEGER        user_msg_marked[2];
} USER_MSG_RECORD;

typedef struct {                              /*       Active Flag        */
    INTEGER        pid_active;                /*                          */
    STRING         pid_name[20];              /*   0 = Inactive           */
    STRING         pid_program[14];           /*   1 = Waiting for call   */
    STRING         pid_function[32];          /*   2 = Caller Online      */
    STRING         pid_callername[32];        /*   3 = Terminal Mode      */
    STRING         pid_curr_msg_path[64];
    STRING         pid_curr_file_path[64];
    BYTE           pid_xnumber;
    BOOLEAN        pid_xmessage_ready;
    STRING         pid_xmessage[80];
    char           pid_cb_handle[10];
    char           pid_filler[64];
} PID_RECORD;

typedef struct {
    int                  dram_status;          /*  0=Closed,  1=Open  */
    int                  record_locking;       /*  0=No Lock, 1=Lock  */
    int                  dat_handle;
    LONGINTEGER          datfpos;
    int                  dat_lock_active;
    LONGINTEGER          dat_lock_offset;
    LONGINTEGER          dat_lock_lgth;
    int                  idx_handle;
    LONGINTEGER          idxfpos;
    int                  idx_lock_active;
    LONGINTEGER          idx_lock_offset;
    LONGINTEGER          idx_lock_lgth;
    int                  dat_recsize;
    int                  dat_keypos;
    int                  dat_keytype;
    STRING               string_key[80];          /*    Type 0,2   */
    LONGINTEGER          binary_key;              /*    Type 1     */
    INTEGER              hash_key;
    STRING               dram_path[80];
    STRING               dram_fname[16];
    USER_RECORD far      *user_rec;               /*    Type 0 & 2   */
    USER_MSG_RECORD far  *user_msg_rec;           /*    Type 1       */
    IDX_RECORD far       *idx_rec;
} DRAM;

typedef struct {
    BOOLEAN   files_deleted;
    STRING    files_name[31];
    STRING    files_path[61];
    long      files_size;
    char      files_month;
    char      files_day;
    int       files_year;
    BYTE      files_privel[8];
    BOOLEAN   files_offline;
    BOOLEAN   files_cdrom;
    BOOLEAN   files_free_area;
} FILES_RECORD;

int dram(int,DRAM far *);
int dram_create(DRAM far *,int);
int dram_open(DRAM far *,int);
int dram_read(DRAM far *,int);
int dram_add(DRAM far *,int);
int dram_close(DRAM far *,int);
int dram_delete(DRAM far *,int);
int dram_undelete(DRAM far *,int);
void idx_expand(DRAM far *);
int re_org(DRAM far *,int);
void backup_idx(DRAM far *);
int fexist(STRING *);
int dexist(STRING *);
DRAM far *allocate_fcb(void);
void release_fcb(DRAM far *);
void lock_dat(DRAM far *,LONGINTEGER,LONGINTEGER);
void lock_idx(DRAM far *,LONGINTEGER,LONGINTEGER);
void unlock_dat(DRAM far *);
void unlock_idx(DRAM far *);
int readfile(int,STRING far *,int);
int writefile(int,STRING far *,int);
int seekfile(int,LONGINTEGER,int);
int o_mode(int);
int createfile(char *);
int closefile(int,char *);
void prt_error(char *,char *);
LONGINTEGER elapsed(LONGINTEGER);
void real_time(LONGINTEGER *);
void dram_slasher(DRAM far *);
void lock_g(int,LONGINTEGER,LONGINTEGER);
void unlock_g(int,LONGINTEGER,LONGINTEGER);

extern STRING   copyright1[];
extern STRING   copyright2[];
extern INTEGER  begin_prime;
extern INTEGER  prime[];
extern INTEGER  crc_reg_lo;
extern INTEGER  crc_reg_hi;
