#include "define.h"
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include "futil.h"

extern INTEGER hash_max;
extern INTEGER hash_crc;
extern INTEGER hash_value;
extern INTEGER delta_hash;
extern INTEGER hash_first;

extern INTEGER delta_calc(void);
extern INTEGER next_hash(void);

/*****

	The function 'dexist()' is used to test if a directory exists.
	The return values are 1 if it exists, and 0 if not.

*****/
int dexist(STRING *dname)
{
    char far *dta_addr;
    int error, slen;
    char temp[144];
    char local_dta[82];

    dta_addr = getdta();
    strcpy(temp,dname);
    slen = strlen(temp) - 1;
    if (temp[slen] == '\\')
	temp[slen] = 0;
    strcat(temp,"\\*.*");
    error = findfirst(temp,(struct ffblk *) local_dta,(FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC));
    setdta(dta_addr);
    return((! error));
}

#ifdef HOST
/*****

	The function 'idx_expand()' is used to re-hash the entire HASH
	TABLE.  This becomes required when the hash table becomes too
	full and collisions are too common.  The table size is automatically
	chosen from the table of prime numbers.  The fcb must be open prior
	to entry.

*****/
void idx_expand(DRAM far *fcb)
{
    LONGINTEGER odxfpos, odxflen, ndxfpos;
    INTEGER j, k;
    INTEGER omax;
    int ndx_handle;
    char temp1[80], temp2[80];
    STRING odx_file[80];
    STRING ndx_file[80];
    IDX_RECORD ndx_rec;
    IDX_RECORD far *xp;

    lock_dat(fcb,0L,fcb->dat_recsize);
    xp = fcb->idx_rec;
    dram_slasher(fcb);
    FARstrcpy((char far *)temp1,(char far *)fcb->dram_path);
    FARstrcpy((char far *)temp2,(char far *)fcb->dram_fname);
    sprintf((char *) odx_file,"%s%s.IDX",temp1,temp2);
    sprintf((char *) ndx_file,"%s%s.NDX",temp1,temp2);
    close(fcb->idx_handle);
    fcb->idx_handle = _open((char *) odx_file,o_mode(O_RDWR));
    odxflen = filelength(fcb->idx_handle);
    hash_max = omax = ((INTEGER) (odxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    if (omax >= 65000U)
	goto Reox;
    k = 0;
    while ((omax >= prime[k]) && (prime[k] < 65521U))
	k++;
    hash_max = prime[k];
    ndx_handle = createfile((char *) ndx_file);
    FARmemset((char far *) xp,0,sizeof(IDX_RECORD));
    for (j = 0; j <= hash_max; j++)
	writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    closefile(ndx_handle,(char *) ndx_file);
    ndx_handle = _open((char *) ndx_file,o_mode(O_RDWR));
    seekfile(fcb->idx_handle,0L,SEEK_SET);
    readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    seekfile(ndx_handle,0L,SEEK_SET);
    writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    for (j = 1; j <= omax; j++) {
	odxfpos = (((LONGINTEGER) j) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	seekfile(fcb->idx_handle,odxfpos,SEEK_SET);
	readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	if ((xp->hash_ptr) && (!(xp->hash_re_used))) {
	    hash_crc = xp->hash_code;
	    hash_value = hash_crc % hash_max;
	    ndxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	    seekfile(ndx_handle,ndxfpos,SEEK_SET);
	    readfile(ndx_handle,(STRING far *) &ndx_rec,sizeof(IDX_RECORD));
	    if (ndx_rec.hash_ptr) {
		delta_hash = delta_calc();
		hash_first = hash_value;
		do {
		    next_hash();
		    ndxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
		    seekfile(ndx_handle,ndxfpos,SEEK_SET);
		    readfile(ndx_handle,(STRING far *) &ndx_rec,sizeof(IDX_RECORD));
		} while ((ndx_rec.hash_ptr) && (ndxfpos != hash_first));
	    }
	    seekfile(ndx_handle,ndxfpos,SEEK_SET);
	    writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	}
    }
    close(ndx_handle);
    close(fcb->idx_handle);
    backup_idx(fcb);
    fcb->idx_handle = _open((char *) odx_file,o_mode(O_RDWR));
Reox:
    unlock_dat(fcb);
}
#endif
