#include "define.h"
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <alloc.h>
#include <sys\stat.h>
#include <errno.h>
#include "futil.h"

#ifdef DEBUG
    extern void stack_probe(void);
#endif

#ifdef HOST
extern INTEGER crc_reg_hi;
extern INTEGER begin_prime;
#endif
extern INTEGER hash_value;
extern INTEGER delta_hash;
extern INTEGER hash_first;
extern INTEGER hash_crc;
extern INTEGER search;
extern INTEGER hash_max;

extern STRING dat_file[];
extern STRING idx_file[];
extern STRING dat_rec[];

#ifdef HOST
extern void start_hash(void);
extern INTEGER next_hash(void);
extern INTEGER crc_calc(DRAM far *);
/*****

	The function 'fetch_dat_rec()' is called to read a data record from
	the CTL file based on the current value in the 'hash_ptr' variable.

	   fcb ..... an open DRAM fcb.

*****/
void fetch_dat_rec(DRAM far *fcb)
{
    fcb->datfpos = (((LONGINTEGER) fcb->idx_rec->hash_ptr) * ((LONGINTEGER) fcb->dat_recsize));
    seekfile(fcb->dat_handle,fcb->datfpos,SEEK_SET);
    readfile(fcb->dat_handle,(STRING far *) dat_rec,fcb->dat_recsize);
}

/*****

	The function 'mov_test()' is used to manipulate the keys of a
	USER.CTL data record and test to see if the desired record has
	been located.  The fcb must be filled with the desired string_key
	and the 'p' paramter must point to a valid USER_RECORD just read
	from disk.

*****/
int mov_test(DRAM far *fcb,USER_RECORD far *p)
{
    STRING string_key2[80];
    int cmp;

    FARmemmove((char far *) p,(char far *) dat_rec,fcb->dat_recsize);
    FARstrcpy((char far *) string_key2,(char far *) (p->user_name));
    strupr((char *) string_key2);
    cmp =  FARstrcmp((char far *) string_key2,(char far *) (fcb->string_key));
    return(! cmp);
}

int dram_search(
    DRAM far *fcb,
    USER_RECORD far *p,
    IDX_RECORD  far *xp,
    int chk,
    int hash_read
    )
{
    int rdamt;
    STRING string_key2[80];

    start_hash();
    do {
	fcb->idxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	rdamt = readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	if ((!(xp->hash_ptr)) || (rdamt < sizeof(IDX_RECORD)))
	    search = 0;
	else {
	    if (hash_crc == xp->hash_code) {
		fetch_dat_rec(fcb);
		if (chk) {
		    if (!(fcb->dat_keytype)) {
			FARmemmove((char far *) p,(char far *) dat_rec,(fcb->dat_recsize));
			if (hash_read) {
			    if (fcb->binary_key == p->user_caller_no)
				return(1);
			}
			else {
			    FARstrcpy((char far *) string_key2,(char far *) (p->user_name));
			    strupr((char *) string_key2);
			    if (!(FARstrcmp((char far *) string_key2,(char far *) (fcb->string_key))))
				return(1);
			}
			goto S1_loop;
		    }
		    if (fcb->dat_keytype == 1) {
			FARmemmove((char far *) (fcb->user_msg_rec),(char far *) dat_rec,(fcb->dat_recsize));
			if (fcb->binary_key == fcb->user_msg_rec->user_msg_caller_no)
			    return(1);
		    }
		}
		else {
		    if (mov_test(fcb,p))
			return(1);
		}
	    }
S1_loop:
	    search = next_hash();
	}
    } while (search);
    return(0);
}

/*****

	The function 'dram_undelete()' can be used to undelete a record in
	the USER.CTL file.  Since deleted records are re-used, there is no
	guarantee that this function will work!  The fcb must be open and
	the desired string_key must be filled prior to entry.

*****/
int dram_undelete(DRAM far *fcb,int func)
{
    int res;
    LONGINTEGER idxflen;
    USER_RECORD far *p;
    IDX_RECORD  far *xp;

    res = (-1);
    if ((! fcb->dram_status) || (fcb->dat_keytype != 0))
	return(res);
    p = fcb->user_rec;
    xp = fcb->idx_rec;
    lock_dat(fcb,0L,fcb->dat_recsize);
    lock_idx(fcb,0L,sizeof(IDX_RECORD));
    idxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (idxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    hash_crc = crc_calc(fcb);
    if (!(dram_search(fcb,p,xp,0,0)))
	goto unDex;
    res = 0;
    if (p->user_deleted) {
	p->user_deleted = 0;
	seekfile(fcb->dat_handle,fcb->datfpos,SEEK_SET);
	writefile(fcb->dat_handle,(STRING far *) p,(fcb->dat_recsize));
    }
    if (xp->hash_del_flg) {
	xp->hash_del_flg = 0;
	seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	writefile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    }
unDex:
    unlock_idx(fcb);
    unlock_dat(fcb);
    return(res);
}

/*****

	The function 'dram_delete()' can be called to delete a record from
	the USER.CTL file.  The fcb must be open and contain a valid
	string_key entry.

*****/
int dram_delete(DRAM far *fcb,int func)
{
    int res;
    LONGINTEGER idxflen;
    USER_RECORD far *p;
    IDX_RECORD  far *xp;

    res = (-1);
    if ((! fcb->dram_status) || (fcb->dat_keytype != 0))
	return(res);
    p  = fcb->user_rec;
    xp = fcb->idx_rec;
    lock_dat(fcb,0L,fcb->dat_recsize);
    lock_idx(fcb,0L,sizeof(IDX_RECORD));
    idxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (idxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    hash_crc = crc_calc(fcb);
    if (!(dram_search(fcb,p,xp,0,0)))
	goto Dex;
Del:
    if (p->user_banned)
	res = 1;
    else {
	p->user_deleted = 1;
	seekfile(fcb->dat_handle,fcb->datfpos,SEEK_SET);
	writefile(fcb->dat_handle,(STRING far *) p,(fcb->dat_recsize));
	xp->hash_del_flg = 1;
	seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	writefile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	res = 0;
    }
Dex:
    unlock_idx(fcb);
    unlock_dat(fcb);
    return(res);
}

/*****

	The function 'dram_read()' can be used to read records from either
	the USER.CTL or USER_MSG.CTL files.  The fcb must be open and the
	valid keys must be filled in prior to entry.  The 'hash_read' flag
	is used when you wish to supply a hash code rather than a key.

*****/
int dram_read(DRAM far *fcb,int hash_read)
{
    int res;
    LONGINTEGER idxflen;
    USER_RECORD far *p;
    IDX_RECORD  far *xp;

    res = (-1);
    if (! fcb->dram_status)
	return(res);
    p  = fcb->user_rec;
    xp = fcb->idx_rec;
    lock_dat(fcb,0L,fcb->dat_recsize);
    lock_idx(fcb,0L,sizeof(IDX_RECORD));
    idxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (idxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    if (hash_read)
	hash_crc = fcb->hash_key;
    else
	hash_crc = crc_calc(fcb);
    if (!(dram_search(fcb,p,xp,1,hash_read)))
	goto L1rx;
F1fnd:
    res = dat_rec[0];
L1rx:
    unlock_idx(fcb);
    unlock_dat(fcb);
    return(res);
}
#endif

/*****

	The function 'fexist()' is used to test if a file exists.
	The return values are 1 if it exists, and 0 if not.  The 'fname'
	parameter may contain wildcards, since the 'findfirst()' library
	function is used to test for existence.

*****/
int fexist(STRING *fname)
{
    char far *dta_addr;
    int error, res;
    char local_dta[80];

    dta_addr = getdta();
    error = findfirst(fname,(struct ffblk *) local_dta,(FA_RDONLY|FA_HIDDEN|FA_SYSTEM));
    setdta(dta_addr);
    res = (error == 0);
    return(res);
}

#ifdef HOST
/*****

	The function 'backup_idx()' is used to create BAK versions of the
	IDX file pointed to by the fcb parameter.  The IDX file should not
	be open when this procedure is called.  This is used to save the
	original IDX file prior to re-hashing the thing.  A re-hash is done
	when it is required to expand the HASH TABLE.  This is done on-the-fly.

*****/
void backup_idx(DRAM far *fcb)
{
    STRING wrk[128], temp[80];
    STRING fn[80];

    dram_slasher(fcb);
    FARstrcpy((char far *)fn,(char far *)fcb->dram_path);
    FARstrcat((char far *)fn,(char far *)fcb->dram_fname);
    sprintf((char *) wrk,"%s.BAK",fn);
    if (fexist(wrk)) {
	sprintf((char *) wrk,"DEL %s.BAK",fn);
	system_g((char *) wrk);
    }
    FARstrcpy((char far *)temp,(char far *)fcb->dram_fname);
    sprintf((char *) wrk,"REN %s.IDX %s.BAK",fn,temp);
    system_g((char *) wrk);
    sprintf((char *) wrk,"REN %s.NDX %s.IDX",fn,temp);
    system_g((char *) wrk);
}
#endif

void real_time(LONGINTEGER *t)
{
    union REGS regs;

    regs.x.ax = 0x2c00;
    intdos(&regs,&regs);
    *t = (((LONGINTEGER) regs.h.ch) * 360000L)
       + (((LONGINTEGER) regs.h.cl) * 6000L)
       + (((LONGINTEGER) regs.h.dh) * 100L)
       +   ((LONGINTEGER) regs.h.dl);
}

LONGINTEGER elapsed(LONGINTEGER start)
{
    LONGINTEGER curr;

#ifdef DEBUG
    stack_probe();
#endif
    real_time(&curr);
    while (curr < start)
	curr += 4320000L;
    return((curr - start));
}
