#include "define.h"
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <alloc.h>
#include <sys\stat.h>
#include <errno.h>
#include "futil.h"

#ifdef DEBUG
    extern void stack_probe(void);
#endif

#ifdef HOST
extern INTEGER crc_reg_hi;
extern INTEGER begin_prime;
#endif
extern INTEGER hash_value;
extern INTEGER delta_hash;
extern INTEGER hash_first;
extern INTEGER hash_crc;
extern INTEGER search;
extern INTEGER hash_max;

extern STRING dat_file[];
extern STRING idx_file[];
extern STRING dat_rec[];

/*****

	The function 'o_mode()' returns an O_FLAG to be used with an
	_open command.  If DOS 2.xx is in use, then the O_FLAG returned
	unchanged, otherwise it is OR'd with SH_DENYNO, then returned.

	   omd ..... requested O_FLAG.

*****/
int o_mode(int omd)
{
    int md;

    md = omd;
    if (_osmajor > 2)
	md |= O_DENYNONE;
    return(md);
}

/*****

	The function 'crc_calc' takes an open DRAM fcb and calculates
	the CRC-16 from the 'string_key' contained in the fcb.

	   fcb ..... a open DRAM fcb which must have a valid string_key
		     in it.

*****/
#ifdef HOST
INTEGER crc_calc(DRAM far *fcb)
{
    REGISTER k;
    STRING far *s;

    s = fcb->string_key;
    crc_reg_lo =
      crc_reg_hi = 0;
    FARstrupr((char far *) s);
    for (k = 0; s[k]; k++)
	ccitt_crc_calc(s[k]);
    ccitt_crc_calc(0);
    ccitt_crc_calc(0);
    return(crc_reg_hi);
}

void dram_slasher(DRAM far *fcb)
{
    REGISTER k;

    if (fcb->dram_path[0]) {
	k = FARstrlen((char far *) (fcb->dram_path)) - 1;
	if (k > 0) {
	    if (fcb->dram_path[k] != '\\')
		FARstrcat((char far *) (fcb->dram_path),(char far *) "\\");
	}
    }
}

/*****

	The function 'build_filenames()' takes a DRAM fcb and
	constructs full pathname file names for both the IDX and CTL
	files.  The fcb must have the filenames and required pathname
	filled in prior to call.  The fcb should not be open, but it
	should be allocated and required information supplied.

	   fcb ..... an allocated, but unopened, DRAM fcb, which must
		     contain valid pathname and filename information.

*****/
void build_filenames(DRAM far *fcb)
{
    dram_slasher(fcb);
    FARstrcpy((char far *)dat_file,(char far *)fcb->dram_path);
    FARstrcat((char far *)dat_file,(char far *)fcb->dram_fname);
    strcpy(idx_file,dat_file);
    strcat(dat_file,".CTL");
    strcat(idx_file,".IDX");
}

/*****

	The function 'open_files()' is used to open both the IDX and CTL
	files based on a valid DRAM fcb.

	   fcb ..... an allocated, but unopened, DRAM fcb.  The function
		     'build_filenames()' must have been called prior to
		     this function.

*****/
int open_files(DRAM far *fcb)
{
    fcb->idx_handle = _open(idx_file,o_mode(O_RDWR));
    fcb->dat_handle = _open(dat_file,o_mode(O_RDWR));
    if ((fcb->dat_handle > 0) && (fcb->idx_handle > 0)) {
	fcb->dram_status = 1;
	return(0);
    }
    return(1);
}

/*****

	The function 'dram_create()' will create new CTL and IDX files,
	and then open the fcb prior to returning to the caller.  If files
	are prior existing, this function will error.

	   fcb ..... an allocated, but unopen, DRAM fcb.  Must have
		     concerning the files filled in.  Such as the names,
		     pathname, key-type, etc.  See SYSOP.C for example
		     of usage.

*****/
int dram_create(DRAM far *fcb,int func)
{
//                         unsigned j;
    long idx_size;
    int chunk_size;
    IDX_RECORD far *xp;
    char buffer[2050];

    xp = fcb->idx_rec;
    if (! fcb->dram_status) {
	build_filenames(fcb);
	if (_osmajor > 2) {
	    fcb->dat_handle = creatnew(dat_file,0);
	    fcb->idx_handle = creatnew(idx_file,0);
	}
	else {
	    fcb->dat_handle = _creat(dat_file,0);
	    fcb->idx_handle = _creat(idx_file,0);
	}
	if ((fcb->dat_handle > 0) && (fcb->idx_handle > 0)) {
	    chunk_size = 2048;
	    idx_size =
		((long)(begin_prime + 1)) * ((long)(sizeof(IDX_RECORD)));
	    memset(buffer,0,chunk_size);
	    FARmemset((char far *) xp,0,sizeof(IDX_RECORD));
	    while (idx_size >= chunk_size) {
		writefile(fcb->idx_handle,(STRING far *) buffer,chunk_size);
		idx_size -= chunk_size;
	    }
	    if (idx_size > 0) {
		chunk_size = (int) idx_size;
		writefile(fcb->idx_handle,(STRING far *) buffer,chunk_size);
	    }
//          for (j = 0; j <= begin_prime; j++)
//              writefile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	    memset(dat_rec,0,fcb->dat_recsize);
	    writefile(fcb->dat_handle,(STRING far *) dat_rec,fcb->dat_recsize);
	    closefile(fcb->idx_handle,idx_file);
	    closefile(fcb->dat_handle,dat_file);
	    return((open_files(fcb)));
	}
    }
    return(2);
}

/*****

	The function 'dram_open()' will open a DRAM fcb which has been
	prior allocated and initialized.

	   fcb ..... an allocated, but unopen, DRAM fcb.  Must have
		     concerning the files filled in.  Such as the names,
		     pathname, key-type, etc.  See SYSOP.C for example
		     of usage.

*****/
int dram_open(DRAM far *fcb,int func)
{
    if (! fcb->dram_status) {
	build_filenames(fcb);
	return((open_files(fcb)));
    }
    return(3);
}

/*****

	The DRAM technique is based upon HASH TABLE lookup.  The function
	'delta_calc()' is used to calculate the offset used when a collison
	is detected in a hash chain.

	Before calling this routine, the 'hash_crc' and 'hash_max' must
	have been set.  The 'hash_crc' contains the CRC-16 of the base
	key, and 'hash_max' contains the size of the HASH TABLE (which
	must be a prime number).

*****/
INTEGER delta_calc(void)
{
    INTEGER k;

    if (!(k = (hash_crc >> 8) % hash_max))
	k = 1;
    return(k);
}

/*****

	Read the comments above for the function 'delta_calc()', much of
	this is pertinent for this function also.  The 'start_hash()'
	function is used to initialize some variables, valid values must
	be provided for 'hash_crc' and 'hash_max' prior to entry.

*****/
void start_hash(void)
{
    hash_first = hash_value = hash_crc % hash_max;
    delta_hash = delta_calc();
    search = 1;
}

/*****

	The function 'next_hash()' is used when a collison occurs.  It
	calculates the next position in the HASH TABLE to be examined.

	The functions 'start_hash()' must have been executed properly
	before entry to this routine.

*****/
INTEGER next_hash(void)
{
    hash_value = (hash_value + delta_hash) % hash_max;
    if (hash_first == hash_value)
	return(0);
    return(1);
}
#endif
