/*
**   FAR utilities to aid in using the MEDIUM memory model
*/
#include "define.h"
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include "futil.h"

#ifdef DEBUG
    extern void stack_probe(void);
#endif

void FARmemset(char far *s,int bv,int slen)
{
    int j;

#ifdef DEBUG
    stack_probe();
#endif
    for (j=0;j<slen;j++)
	s[j]=bv;
}

void FARmemmove(char far *d,char far *s,int slen)
{
    int j;

#ifdef DEBUG
    stack_probe();
#endif
    for (j=0;j<slen;j++)
	d[j]=s[j];
}

int FARstrlen(char far *s)
{
    int k;

#ifdef DEBUG
    stack_probe();
#endif
    k=0;
    while (s[k])
	k++;
    return(k);
}

void FARstrupr(char far *s)
{
    int k;

#ifdef DEBUG
    stack_probe();
#endif
    k=0;
    while (s[k] = toupper(s[k]))
	k++;
}

void FARstrcpy(char far *d,char far *s)
{
    int k;

#ifdef DEBUG
    stack_probe();
#endif
    k=0;
    while (d[k] = s[k])
	k++;
}

void FARcopy(char far *d,char far *s,int st,int sl)
{
    int j, k;

#ifdef DEBUG
    stack_probe();
#endif
    k = st - 1;
    for (j=0;j<sl;j++) {
        if (!(d[j] = s[k++]))
            return;
    }
    d[sl]=0;
}

void FARcopy_p(char far *d,char far *s,int en)
{
    int i, j;

#ifdef DEBUG
    stack_probe();
#endif
    j = en - 1;
    for (i=0; i<j; i++) {
	if (!(d[i] = s[i]))
	    return;
    }
    d[j]=0;
}

int FARstrcmp(char far *s1,char far *s2)
{
    int i;

#ifdef DEBUG
    stack_probe();
#endif
    i=0;
    while (s1[i] == s2[i]) {
	if (! s1[i++])
	    return(0);
    }
    i = s1[i] - s2[i];
    return(i);
}

void FARstrcat(char far *s1,char far *s2)
{
    int k, j;

#ifdef DEBUG
    stack_probe();
#endif
    k = j = 0;
    while (s1[k])
        k++;
    while (s1[k++] = s2[j++])
	;
}

/*****
long FARatol(s)
char far *s;
{
    char w[22];

    FARcopy_p((char far *) w,s,20);
    return(atol(w));
}
*****/

int FARatoi(char far *s)
{
    char w[16];

    FARcopy_p((char far *) w,s,10);
    return(atoi(w));
}

/*****
void FARinsert(addstring,newstring,index)
char far *addstring;
char far *newstring;
int  index;
{
    char temp[512];
    int k;

    temp[0] = 0;
    if ((! newstring[0]) || (index > FARstrlen(newstring)))
	;
    else  {
        k = index - 1;
        FARcopy_p((char far *) temp,&newstring[k],510);
        newstring[k] = 0;
    }
    FARstrcat(newstring,addstring);
    FARstrcat(newstring,(char far *) temp);
}
*****/

void FARdelete(char far *destin,int start,int size)
{
    int j,m,k;

#ifdef DEBUG
    stack_probe();
#endif
    if (k = FARstrlen(destin)) {
	j = start - 1;
	destin[j] = 0;
        m = j + size;
	if (m < k)
            FARstrcpy(&destin[j],&destin[m]);
    }
}

int FARstrncmp(char far *s1,char far *s2,int mlen)
{
    int k,j;

    k=0;
    while ((k < mlen) && (!(j=(s1[k] - s2[k])))) {
       if (! s1[k++])
	   return(0);
    }
    return(j);
}

int FARpos(char far *searchtag,char far *fulltag)
{
    int i,j;
    int lensrch;

#ifdef DEBUG
    stack_probe();
#endif
    if (lensrch = FARstrlen(searchtag)) {
	j = FARstrlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! FARstrncmp(searchtag,&fulltag[i],lensrch))
		return(i);
        }
	return(-1);
    }
    return(0);
}
