#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <conio.h>
#include "dram.h"

LONGINTEGER loops_per_ms;
int pidfile;
PID_RECORD pid_table[MAX_PID];
int monitor_mode;
int verbose_mode;

void main(int,char *[]);
void view_pids(char *);
void prt_pid(int,PID_RECORD *);
void monitor_pids(char *);
int testEQ(PID_RECORD *,PID_RECORD *);

int line_count = 0;

void prt_pid(k,prec)
int k;
PID_RECORD *prec;
{
    (*prec).pid_name[15]=0;
    (*prec).pid_program[12]=0;
    (*prec).pid_function[20]=0;
    (*prec).pid_callername[20]=0;
    line_count++;
    printf("\n%2d  %-15s  %d  %-12s %-20s %s",
	      k,
	      (*prec).pid_name,
              (*prec).pid_active,
	      (*prec).pid_program,
              (*prec).pid_function,
              (*prec).pid_callername
	  );
    if (verbose_mode) {
	if ((*prec).pid_callername[0])
	    printf("\n       CB HANDLE ... %s",(*prec).pid_cb_handle);
	printf(    "\n       MSG BASE .... %s",(*prec).pid_curr_msg_path);
	printf(    "\n       FILE AREA ... %s",(*prec).pid_curr_file_path);
	line_count += 3;
    }
}

int testEQ(p1,p2)
PID_RECORD *p1;
PID_RECORD *p2;
{
    if ((*p1).pid_active != (*p2).pid_active)
	return(0);
    if (strcmp((*p1).pid_program,(*p2).pid_program))
	return(0);
    if (strcmp((*p1).pid_function,(*p2).pid_function))
	return(0);
    if (strcmp((*p1).pid_callername,(*p2).pid_callername))
	return(0);
    return(1);
}

void monitor_pids(pstr)
char *pstr;
{
    register int k;
    int pmin, pmax, exloop;
    long sadr;
    PID_RECORD pidrec;

    pmin = 0;
    pmax = MAX_PID;
    if (pstr[0]) {
	pmin = atoi(pstr);
	pmax = pmin + 1;
    }
    if (pmin < 0)
	pmin = 0;
    if (pmax > MAX_PID)
	pmax = MAX_PID;
    printf("\nEnter monitor mode.  Press [Esc] to exit.\n");
    exloop = 0;
    do {
        for (k = pmin; k < pmax; k++) {
	    if (kbhit()) {
	        if (getch() == 27) {
		    exloop = 1;
		    goto Lx;
		}
	    }
	    sadr = (((long) k) * ((long) sizeof(PID_RECORD)));
            seekfile(pidfile,sadr,SEEK_SET);
	    readfile(pidfile,(void far *) &pidrec,sizeof(PID_RECORD));
	    if (testEQ(&pidrec,&pid_table[k])) {}
	    else {
	        memcpy((void *) &pid_table[k],(void *) &pidrec,sizeof(PID_RECORD));
		printf("\a");
 	        if (pidrec.pid_active) {
	            prt_pid(k,&pid_table[k]);
                }
	        else {
		    printf("\n%2d     (* inactive *)",k);
		    line_count++;
		}
	    }
        }
	for (k=0; k<400; k++) {
	    delay(5);
	    if (kbhit()) {
	        if (getch() == 27)
		    exloop = 1;
	    }
	}
Lx:
        ;
    } while (! exloop);
    printf("\n");
}

void view_pids(pstr)
char *pstr;
{
    register int k;
    int pmin, pmax, y;
    long sadr;
    char ws[82];
    PID_RECORD pidrec;

    line_count = 0;
    pmin = 0;
    pmax = MAX_PID;
    if (pstr[0]) {
	pmin = atoi(pstr);
	pmax = pmin + 1;
    }
    if (pmin < 0)
	pmin = 0;
    if (pmax > MAX_PID)
	pmax = MAX_PID;
    printf("\nPID    PID Name     Act   Program       Function            Caller Name  ");
    printf("\n--- --------------- --- ------------ -------------------- ---------------");
    line_count += 2;
    for (k = pmin; k < pmax; k++) {
	sadr = (((long) k) * ((long) sizeof(PID_RECORD)));
	seekfile(pidfile,sadr,SEEK_SET);
	readfile(pidfile,(void far *) &pidrec,sizeof(PID_RECORD));
	memcpy((void *) &pid_table[k],(void *) &pidrec,sizeof(PID_RECORD));
	if (pidrec.pid_active) {
	    prt_pid(k,&pid_table[k]);
        }
	else {
	    printf("\n%2d     (* inactive *)",k);
	    line_count++;
	}
	if (line_count > 21) {
	    line_count = 0;
	    printf("\n\n");
	    y = wherey() - 1;
	    gotoxy(1,y);
	    printf("More? ");
	    gets(ws);
	    gotoxy(1,y--);
	    clreol();
	    gotoxy(1,y);
	    strupr(ws);
	    if (ws[0] == 'N') 
		break;
	}
    }
    printf("\n");
    if (monitor_mode)
	monitor_pids(pstr);
}

void main(argc,argv)
int argc;
char *argv[];
{
    register int k, ch;
    char param[80];

    monitor_mode = 0;
    verbose_mode = 0;
    param[0] = 0;
    printf("PidView v1.1.  Copyright (c) 1989.  P&M Software Co.\n");
    if (argc < 2) {
        printf("\nPidView usage:  pidview  [pid#]  [/m]  [/v]\n");
	printf("\n    Where:");
	printf("\n       pid# .. PID# to display, defaults to ALL.");
	printf("\n       /m .... Monitor Mode.");
	printf("\n       /v .... Verbose Mode.\n");
    }
    for (k = 1; k < argc; k++) {
	switch (argv[k][0]) {
	    case '/':
	    case '-':
	    case '+':
                if ((ch = toupper(argv[k][1])) == 'M')
		    monitor_mode = 1;
		if (ch == 'V')
		    verbose_mode = 1;
		break;
	    default:
	        strcpy(param,argv[k]);
		break;
	}
    }
    pidfile = _open("PID_FILE.BBS",o_mode(O_RDWR));
    if (pidfile > 0) {
	view_pids(param);
	_close(pidfile);
    }
}

