#include "define.h"
#include <io.h>
#include <string.h>
#include <alloc.h>
#include <ctype.h>
#include "globals.h"
#include "util_bw.h"

void insert(byte *addstring,byte *newstring,int index)
{
    int k;
    int slen;
    register int i, m;
    byte temp[528];

#ifdef DEBUG
    stack_probe();
#endif
    temp[0] = 0;
    slen = strlen(newstring);
    if ((! slen) || (index > slen))
	goto ConcatSTR;
    k = index - 1;
    m = 0;
    for (i=k; ((i<=slen) && (m<512)); i++)
	temp[m++] = newstring[i];
    temp[m] = 0;
    newstring[k] = 0;
ConcatSTR:
    strcat(newstring,addstring);
    strcat(newstring,temp);
}

void delete(byte *destin,int start,int size)
{
    int j, m, k;

#ifdef DEBUG
    stack_probe();
#endif
    if (k = strlen(destin)) {
	j = start - 1;
	destin[j] = 0;
	m = j + size;
	if (m < k)
	    strcpy(&destin[j],&destin[m]);
    }
}

int pos(byte *searchtag,byte *fulltag)
{
    int i, j, lensrch;

#ifdef DEBUG
    stack_probe();
#endif
    if (lensrch = strlen(searchtag)) {
	j = strlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! strncmp(searchtag,&fulltag[i],lensrch))
		return(i);
	}
	return(-1);
    }
    return(0);
}

int ucpos(byte *searchtag,byte *fulltag)
{
    int i, j, lensrch;

#ifdef DEBUG
    stack_probe();
#endif
    if (lensrch = strlen(searchtag)) {
	j = strlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! strnicmp(searchtag,&fulltag[i],lensrch))
		return(i);
	}
	return(-1);
    }
    return(0);
}

byte *copy(byte *destin,byte *source,int start,int index)
{
#ifdef DEBUG
    stack_probe();
#endif
    copy_p(destin,&source[(start - 1)],(index + 1));
    return(destin);
}
