#include "define.h"
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <io.h>
#include <stdarg.h>
#include "globals.h"
#include "util_bw.h"

extern byte *Boolean(int);
extern unsigned install43(void);
extern unsigned install25(void);
extern void _cdecl rbmove(unsigned,unsigned,unsigned,int,int,int,int);
extern void _cdecl fbmove(unsigned,unsigned,unsigned,int,int,int,int);
extern void _cdecl video_wr(unsigned,unsigned,int,int);
extern void _fastcall bvideo(int);
extern int detect_vga(void);
extern int detect_ega(void);

extern char kbd_status;
extern unsigned char last_line;

#define Ofs(ptr) ((unsigned)((unsigned long) ptr))

int crtmode;
screen_array_ptr scr_ptr;
int current_text_attr           = 7;
char cursor_blanked             = 0;
int curr_thickness              = SKINNY_CURSOR;
unsigned scr_minus1             = 24;
unsigned scr_numrows            = 25;
unsigned original_length        = 25;
char bios_video[6]              = "FALSE";

int current_background;
int current_foreground;
unsigned scr_seg         = 0xb000;
int max_window_ofs       = 3998;   /***  (25 * 160 - 2)  ***/
int max_x_coord          = 80;
int max_y_coord          = 25;
int min_x_coord          = 1;
int min_y_coord          = 1;
int carriage_return_ofs  = 0;
int no_retrace_wait      = 1;
int original_crtmode;
int ega_found;
int vga_found;
int mda_found;
int cga_found;
int dv_found;
int dos_major_version;
int dos_minor_version;
int yield_idle_time;
int windoze_found;
int dv_major_version;
int dv_minor_version;
int win_major_version;
int win_minor_version;
unsigned long low_deferred;
unsigned long hi_deferred;
int deferred_update;

void put_into_scrollback(int);
unsigned calc_ofs(unsigned,unsigned);
extern void wf_video_status(int, int);
extern void cleanup(unsigned,unsigned);
extern unsigned BiosScrLen(void);
extern void set43(void);
extern void reset43(void);
extern void wf_initvideo(void);
void shape_cursor(int);
void cursor_off(void);
void cursor_on(void);
void set_color(int,int);
void get_color(int *,int *);
void get_xy(unsigned *,unsigned *);
void getxy(unsigned *,unsigned *);
void GGotoXY(unsigned,unsigned);
int wf_wherex(void);
int wf_wherey(void);
int x_coord(unsigned);
int y_coord(unsigned);
unsigned xy_to_ofs(unsigned *,unsigned *);
void tell_dv(int far *,int far *);
void begin_deferred_dv_update(void);
void end_deferred_dv_update(void);
void wf_clreol(void);
unsigned GX(int);
unsigned GY(int);
void wf_gotoxy(int,int);
void wf_window(int,int,int,int);
void wf_write_at(int,int,char *);
void wf_write(char *);
void carriage_return(unsigned *,unsigned *);
void teletype_biosvideo_wrt(int);
void wf_puts(char *);
void wf_puts_far(char far *);
void scroll_dv(void);
void tell_dv_line(int);
void wf_scroll_right(int);
void wf_scroll_left(int);
void wf_inschar(unsigned,unsigned,unsigned,int);
void wf_delchar(unsigned,unsigned,int);
void wf_printf(char *,...);
void wf_printf_at(int,int,char *,...);
void conditional_cursor_off(void);
void conditional_cursor_on(void);
void wf_scroll(void);

unsigned calc_ofs(unsigned x,unsigned y)
{
#ifdef DEBUG
    stack_probe();
#endif
    return( ((y * 160) - 162 + (x << 1)) );
}

void shape_cursor(int thickness)
{
    union REGS regs;
    unsigned char info_byte;
    unsigned char far *bios_ram;

    bios_ram = (unsigned char far *) 0x00000487L;
    info_byte = *bios_ram;
    if (mda_found) {
	regs.x.cx = 0x0b0c;
	if (thickness == BLOCK_CURSOR)
	    regs.h.ch = 0;
	goto Curs;
    }
    regs.x.cx = 0x0607;
    if (thickness == BLOCK_CURSOR)
	regs.h.ch = 0;
    if (ega_found) {
	if (scr_numrows > 25)  {
	    *bios_ram = (info_byte | 0x01);
	    regs.x.cx = 0x0600;
	    if (thickness == BLOCK_CURSOR)
		regs.x.cx = 0x001e;
	}
    }
Curs:
    curr_thickness = thickness;
    regs.x.ax = 0x0100;
    int86(0x10,&regs,&regs);
    *bios_ram = info_byte;
}

void cursor_off(void)
{
    union REGS regs;

    regs.x.cx = 0x2000;
    regs.x.ax = 0x0100;
    int86(0x10,&regs,&regs);
    cursor_blanked = TRUE;
}

void cursor_on(void)
{
    shape_cursor(curr_thickness);
    cursor_blanked = FALSE;
}

void set_color(int f,int b)
{
    current_foreground = (f & 0x8F);
    current_background = (b & 0x07);
    current_text_attr = (current_background << 4) | current_foreground;
}

void get_color(int *f,int *b)
{
    *f = current_foreground;
    *b = current_background;
}

//      get x,y absolute coordinates

void get_xy(unsigned *x,unsigned *y)
{
    union REGS regs;

    regs.h.bh = 0x00;
    regs.x.ax = 0x0300;
    int86(0x10,&regs,&regs);
    *x = regs.h.dl + 1;
    *y = regs.h.dh + 1;
}

//      get x,y coordinates relative to active windows

void getxy(unsigned *x,unsigned *y)
{
    unsigned gx, gy;

    get_xy(&gx,&gy);
    *x = gx - min_x_coord + 1;
    *y = gy - min_y_coord + 1;
}

//      gotoxy with absolute screen coordinates ***/

void GGotoXY(unsigned x,unsigned y)
{
    union REGS regs;

    regs.h.dh = y - 1;
    regs.h.dl = x - 1;
    regs.h.bh = 0x00;
    regs.x.ax = 0x0200;
    int86(0x10,&regs,&regs);
}

int wf_wherex(void)
{
    unsigned x, y;

    get_xy(&x,&y);
    return( x - min_x_coord + 1 );
}

int wf_wherey(void)
{
    unsigned x, y;

    get_xy(&x,&y);
    return( y - min_y_coord + 1 );
}

int x_coord(unsigned scr_ofs)
{
    return(((scr_ofs / 2) % 80) + 1);
}

int y_coord(unsigned scr_ofs)
{
    return((scr_ofs / 160) + 1);
}

unsigned xy_to_ofs(unsigned *x,unsigned *y)
{
    get_xy(x,y);
    return( calc_ofs(*x,*y) );
}

void tell_dv(int far *beg_scr_ptr,int far *end_scr_ptr)
{
    unsigned num;
    union REGS regs;
    struct SREGS sregs;

    if (! dv_found)
	return;
    if (deferred_update) {
	if ( ((unsigned long) beg_scr_ptr) < low_deferred )
	    low_deferred = (unsigned long) beg_scr_ptr;
	if ( ((unsigned long) end_scr_ptr) > hi_deferred )
	    hi_deferred = (unsigned long) end_scr_ptr;
	return;
    }
    if (!(num = (int)(((unsigned long) end_scr_ptr) - ((unsigned long) beg_scr_ptr))))
	return;
    segread(&sregs);
    regs.x.cx = num + 1;
    sregs.es = scr_seg;
    regs.x.di = Ofs(beg_scr_ptr);
    regs.x.ax = 0xff00;
    int86x(0x10,&regs,&regs,&sregs);
}

void begin_deferred_dv_update(void)
{
    if (! dv_found)
	return;
    deferred_update = 1;
    hi_deferred = (unsigned long) scr_ptr;
    low_deferred = hi_deferred + max_window_ofs;
}

void end_deferred_dv_update(void)
{
    if ((! dv_found) || (! deferred_update))
	return;
    deferred_update = 0;
    if (hi_deferred > low_deferred) {
	if ((Ofs(low_deferred)) > 0)
	    low_deferred -= 2;
	tell_dv( ((int far *) low_deferred), ((int far *) hi_deferred) );
    }
}

void wf_clreol(void)
{
    int i;
    unsigned scr_ofs;
    unsigned x, y, max_x, ox, oy;
    union wb_scr_char s;
    int far *stop_sp;
    int far *start_sp;

    max_x = max_x_coord + 1;
    s.byt.wf_attr = current_text_attr;
    s.byt.wf_char = ' ';
    if (bios_video[0] == 'F') {
	scr_ofs = xy_to_ofs(&x,&y);
	start_sp = MK_SCR_PTR(scr_ofs);
	for (i=x; i<max_x; i++) {
	    video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
	    scr_ofs += 2;
	}
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	get_xy(&x,&y);
	ox = x - 1;
	oy = y - 1;
	max_x--;
	for (i=ox; i<max_x; i++)
	    scr_wr(i,oy,s.wrd.wf_character);
	GGotoXY(x,y);
    }
}

void wf_clrscr(void)
{
    union REGS regs;
    int y;

    if ((!win.depth)&&(scrollback_array_ptr != NULL)) {
        for (y=0; y<max_y_coord; y++)
            put_into_scrollback(y);
    }
    regs.h.bh = (unsigned char) current_text_attr;
    regs.h.ch = min_y_coord - 1;
    regs.h.cl = min_x_coord - 1;
    regs.h.dh = max_y_coord - 1;
    regs.h.dl = max_x_coord - 1;
    regs.x.ax = 0x0600;
    int86(0x10,&regs,&regs);
    wf_gotoxy(1,1);
}

unsigned GX(int x)
{
    return( min_x_coord + x - 1 );
}

unsigned GY(int y)
{
    return( min_y_coord + y - 1 );
}

void wf_gotoxy(int x,int y)
{
    GGotoXY( GX(x), GY(y) );
}

void wf_window(int x1,int y1,int x2,int y2)
{
    min_x_coord = x1;
    min_y_coord = y1;
    max_x_coord = x2;
    max_y_coord = y2;
    carriage_return_ofs = (min_x_coord << 1) - 2;
    max_window_ofs = calc_ofs(max_x_coord,max_y_coord);
    wf_gotoxy(1,1);
}

void wf_write_at(int x,int y,char *str)
{
    int i;
    unsigned scr_ofs;
    union wb_scr_char s;
    unsigned cx, cy, ox, oy;
    int far *stop_sp;
    int far *start_sp;

    i = 0;
    s.byt.wf_attr = current_text_attr;
    if (bios_video[0] == 'F') {
	scr_ofs = calc_ofs(x,y);
	start_sp = MK_SCR_PTR(scr_ofs);
	while (s.byt.wf_char = str[i++]) {
	   video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
	   scr_ofs += 2;
	}
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	get_xy(&cx,&cy);
	ox = x - 1;
	oy = y - 1;
	while (s.byt.wf_char = str[i++]) {
	    scr_wr(ox++,oy,s.wrd.wf_character);
	    if (ox > 79) {
		ox = 0;
		oy++;
	    }
	}
	GGotoXY(cx,cy);
    }
}

void wf_write(char *str)
{
    int i, ch;
    union wb_scr_char s;
    unsigned x, y, scr_ofs;
    int far *stop_sp;
    int far *start_sp;

#ifdef DEBUG
    stack_probe();
#endif
    i = 0;
    if (bios_video[0] == 'F') {
	s.byt.wf_attr = current_text_attr;
	scr_ofs = xy_to_ofs(&x,&y);
	start_sp = MK_SCR_PTR(scr_ofs);
	while (s.byt.wf_char = str[i++]) {
	    video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
	    scr_ofs += 2;
	}
	GGotoXY( x_coord(scr_ofs), y_coord(scr_ofs) );
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	while (ch = str[i++])
	    teletype_biosvideo_wrt(ch);
    }
}

void carriage_return(unsigned *scr_ofs,unsigned *x)
{
    *scr_ofs = (*scr_ofs / 160) * 160 + carriage_return_ofs;
    *x = min_x_coord;
}

void teletype_biosvideo_wrt(int ch)
{
    union wb_scr_char s;
    unsigned x, y;

    s.byt.wf_attr = current_text_attr;
    s.byt.wf_char = ch;
    get_xy(&x,&y);
    switch (ch) {
	case '\r':
	    x = min_x_coord;
	    break;
	case '\n':
	    y++;
	    break;
	case '\b':
	    if (x > min_x_coord)
		x--;
	    break;
	default:
	    bvideo(s.wrd.wf_character);
	    if (++x > max_x_coord) {
		x = min_x_coord;
		y++;
	    }
    }
    if (y > max_y_coord) {
	wf_scroll();
	y = max_y_coord;
    }
    GGotoXY(x,y);
}

void wf_putch(int ch)
{
    unsigned scr_ofs;
    union wb_scr_char s;
    unsigned x, y;
    int far *stop_sp;
    int far *start_sp;

#ifdef DEBUG
    stack_probe();
#endif
    if (bios_video[0] == 'F') {
	scr_ofs = xy_to_ofs(&x,&y);
	start_sp = MK_SCR_PTR(scr_ofs);
	s.byt.wf_attr = current_text_attr;
	s.byt.wf_char = ch;
	switch (ch) {
	    case '\r':
		carriage_return(&scr_ofs,&x);
		break;
	    case '\n':
		scr_ofs += 160;
		break;
	    case '\b':
		if (x > min_x_coord) {
		    scr_ofs -= 2;
		    x--;
		}
		break;
	    default:
		video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
		if (++x > max_x_coord) {
		    carriage_return(&scr_ofs,&x);
		    scr_ofs += 160;
		}
		else {
		    scr_ofs += 2;
		}
	}
	if (scr_ofs > max_window_ofs) {
	    wf_scroll();
	    scr_ofs -= 160;
	}
	GGotoXY( x_coord(scr_ofs), y_coord(scr_ofs) );
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	teletype_biosvideo_wrt(ch);
    }
}

void wf_puts(char *str)
{
    int i, ch;
    union wb_scr_char s;
    unsigned x, y, scr_ofs;
    int far *stop_sp;
    int far *start_sp;

#ifdef DEBUG
    stack_probe();
#endif
    i = 0;
    if (bios_video[0] == 'F') {
	s.byt.wf_attr = current_text_attr;
	scr_ofs = xy_to_ofs(&x,&y);
	start_sp = MK_SCR_PTR(scr_ofs);
	while (s.byt.wf_char = str[i++]) {
	    switch (s.byt.wf_char) {
		case '\r':
		    carriage_return(&scr_ofs,&x);
		    break;
		case '\n':
		    scr_ofs += 160;
		    break;
		case '\b':
		    if (x > min_x_coord) {
			scr_ofs -= 2;
			x--;
		    }
		    break;
		default:
		    video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
		    if (++x > max_x_coord) {
			carriage_return(&scr_ofs,&x);
			scr_ofs += 160;
		    }
		    else {
			scr_ofs += 2;
		    }
	    }
	    if (scr_ofs > max_window_ofs) {
		wf_scroll();
		scr_ofs -= 160;
	    }
	}
	GGotoXY( x_coord(scr_ofs), y_coord(scr_ofs) );
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	while (ch = str[i++])
	    teletype_biosvideo_wrt(ch);
    }
}

void wf_puts_far(char far *str)
{
    int i, ch;
    union wb_scr_char s;
    unsigned x, y, scr_ofs;
    int far *stop_sp;
    int far *start_sp;

#ifdef DEBUG
    stack_probe();
#endif
    i = 0;
    if (bios_video[0] == 'F') {
	s.byt.wf_attr = current_text_attr;
	scr_ofs = xy_to_ofs(&x,&y);
	start_sp = MK_SCR_PTR(scr_ofs);
	while (s.byt.wf_char = str[i++]) {
	    switch (s.byt.wf_char) {
		case '\r':
		    carriage_return(&scr_ofs,&x);
		    break;
		case '\n':
		    scr_ofs += 160;
		    break;
		case '\b':
		    if (x > min_x_coord) {
			scr_ofs -= 2;
			x--;
		    }
		    break;
		default:
		    video_wr(scr_seg,scr_ofs,s.wrd.wf_character,no_retrace_wait);
		    if (++x > max_x_coord) {
			carriage_return(&scr_ofs,&x);
			scr_ofs += 160;
		    }
		    else {
			scr_ofs += 2;
		    }
	    }
	    if (scr_ofs > max_window_ofs) {
		wf_scroll();
		scr_ofs -= 160;
	    }
	}
	GGotoXY( x_coord(scr_ofs), y_coord(scr_ofs) );
	stop_sp = MK_SCR_PTR(scr_ofs);
	tell_dv(start_sp,stop_sp);
    }
    else {
	while (ch = str[i++])
	    teletype_biosvideo_wrt(ch);
    }
}

void scroll_dv(void)
{
    unsigned src_ofs, dest_ofs;

    if (dv_found) {
	src_ofs  = calc_ofs(min_x_coord,min_y_coord);
	dest_ofs = calc_ofs(max_x_coord,max_y_coord);
	tell_dv(MK_SCR_PTR(src_ofs),MK_SCR_PTR(dest_ofs));
    }
}

void tell_dv_line(int y)
{
    unsigned src_ofs, dest_ofs;

    if (dv_found) {
	src_ofs  = calc_ofs(min_x_coord,(unsigned) y);
	dest_ofs = calc_ofs(max_x_coord,(unsigned) y);
	tell_dv(MK_SCR_PTR(src_ofs),MK_SCR_PTR(dest_ofs));
    }
}

void wf_scroll_right(int num_chars)
{
    int dest_ofs, src_ofs, mlen, mdepth;
    union wb_scr_char s;

    s.byt.wf_attr = current_text_attr;
    s.byt.wf_char = ' ';
    dest_ofs = calc_ofs(max_x_coord,min_y_coord);
    src_ofs  = dest_ofs - (num_chars << 1);
    mlen   = (int)(max_x_coord - min_x_coord + 1 - num_chars);
    mdepth = (int)(max_y_coord - min_y_coord + 1);
    rbmove(scr_seg,
	   dest_ofs,
	   src_ofs,
	   mlen,
	   s.wrd.wf_character,
	   num_chars,
	   mdepth);
    scroll_dv();
}

void wf_scroll_left(int num_chars)
{
    int dest_ofs, src_ofs;
    union wb_scr_char s;

    s.byt.wf_attr = current_text_attr;
    s.byt.wf_char = ' ';
    dest_ofs = calc_ofs(min_x_coord,min_y_coord);
    src_ofs  = dest_ofs + (num_chars << 1);
    fbmove(scr_seg,
	   dest_ofs,
	   src_ofs,
	   ((int)(max_x_coord - min_x_coord + 1 - num_chars)),
	   s.wrd.wf_character,
	   num_chars,
	   ((int)(max_y_coord - min_y_coord + 1)));
    scroll_dv();
}

void wf_inschar(unsigned gx,unsigned gy,unsigned ch,int num_chars)
{
    int i, oy, max_x;
    union wb_scr_char s;
    int c1, c2, mlen;
    unsigned dest_ofs, src_ofs;

    s.byt.wf_attr = current_text_attr;
    s.byt.wf_char = ch;
    if (bios_video[0] == 'F') {
	dest_ofs = calc_ofs(max_x_coord,gy);
	src_ofs  = dest_ofs - (num_chars << 1);
	mlen = (int)(max_x_coord - gx + 1 - num_chars);
	rbmove(scr_seg,
	       dest_ofs,
	       src_ofs,
	       mlen,
	       s.wrd.wf_character,
	       num_chars,
	       1);
	tell_dv_line(gy);
	return;
    }
    max_x = max_x_coord - num_chars + 1;
    oy = gy - 1;
    c1 = max_x_coord - 1;
    c2 = c1 - num_chars;
    for (i = gx; i < max_x; i++)
	scr_wr(c1--,oy,scr_rd(c2--,oy));
    for (c2 = 0; c2 < num_chars; c2++)
	scr_wr(c1--,oy,s.wrd.wf_character);
}

void wf_delchar(unsigned x,unsigned y,int num_chars)
{
    int c1, c2;
    unsigned dest_ofs, src_ofs;
    int oy, gx, gy, max_x, i;
    union wb_scr_char s;

    gy = GY(y);
    gx = GX(x);
    if (bios_video[0] == 'F') {
	s.byt.wf_attr = current_text_attr;
	s.byt.wf_char = ' ';
	dest_ofs = calc_ofs(gx,gy);
	src_ofs  = dest_ofs + (num_chars << 1);
	fbmove(scr_seg,
	       dest_ofs,
	       src_ofs,
	       ((int)(max_x_coord - gx + 1 - num_chars)),
	       s.wrd.wf_character,
	       num_chars,
	       1);
	tell_dv_line(gy);
	return;
    }
    max_x = max_x_coord - num_chars + 1;
    oy = gy - 1;
    c1 = gx - 1;
    c2 = c1 + num_chars;
    for (i = gx; i < max_x; i++)
	scr_wr(c1++,oy,(scr_rd(c2++,oy)));
    c2 = c1;
    for (i = 0; i < num_chars; i++)
	scr_wr(c1++,oy,(((scr_rd(c2++,oy)) & 0xff00) | 0x0020));
    wf_gotoxy(x,y);
}

void wf_printf(char *fmt,...)
{
    va_list argptr;
    char str[1936];

    va_start(argptr,fmt);
    vsprintf(str,fmt,argptr);
    va_end(argptr);
    wf_puts(str);
}

void wf_printf_at(int x,int y,char *fmt,...)
{
    va_list argptr;
    char str[1936];

    va_start(argptr,fmt);
    vsprintf(str,fmt,argptr);
    va_end(argptr);
    wf_gotoxy(x,y);
    wf_puts(str);
}

void conditional_cursor_off(void)
{
    union REGS regs;

    if (! cursor_blanked) {
	regs.x.cx = 0x2000;
	regs.x.ax = 0x0100;
	int86(0x10,&regs,&regs);
    }
}

void conditional_cursor_on(void)
{
    if (! cursor_blanked)
	shape_cursor(curr_thickness);
}

void wf_delline(void)
{
    union REGS regs;
    unsigned x, y;

    get_xy(&x,&y);
    regs.h.bh = (unsigned char) current_text_attr;
    regs.h.ch = y - 1;
    regs.h.cl = min_x_coord - 1;
    regs.h.dh = max_y_coord - 1;
    regs.h.dl = max_x_coord - 1;
    regs.x.ax = 0x0601;
    int86(0x10,&regs,&regs);
}

void wf_insline(void)
{
    union REGS regs;
    unsigned x, y;

    get_xy(&x,&y);
    regs.h.bh = (unsigned char) current_text_attr;
    regs.h.ch = y - 1;
    regs.h.cl = min_x_coord - 1;
    regs.h.dh = max_y_coord - 1;
    regs.h.dl = max_x_coord - 1;
    regs.x.ax = 0x0701;
    int86(0x10,&regs,&regs);
}

void move_scrollback_row(screen_array_ptr ptr,int ToScreen,int sb_row,int scr_row)
{
    int x, gy;

    if (ToScreen) {
	for (x=0; x<80; x++)
	    (*scr_ptr)[scr_row][x] = (*ptr)[sb_row][x];
        gy = scr_row + 1;
        tell_dv_line(gy);
        return;
    }
    for (x=0; x<80; x++)
	(*ptr)[sb_row][x] = (*scr_ptr)[scr_row][x];
}

void put_into_scrollback(int scr_row)
{
    move_scrollback_row((screen_array_ptr) scrollback_array_ptr,0,scrollback_end,scr_row);
    if (++scrollback_end > sb_highest) {
        scrollback_end = 0;
        scrollback_start = (-1);
    }
}

int get_from_scrollback(int scr_row,int *sb_cnt)
{
    int k;

    if ((k = scrollback_curr - 1) < 0)
        k = sb_highest;
    if ((k==scrollback_start)||(k==scrollback_end))
        return(1);
    scrollback_curr = k;
    wf_gotoxy(1,1);
    wf_insline();
    move_scrollback_row((screen_array_ptr) scrollback_array_ptr,1,scrollback_curr,scr_row);
    (*sb_cnt)--;
    return(0);
}

int rev_scrollback(int scr_row,int *sb_cnt)
{
    int k_row;

    if (scrollback_curr == scrollback_end)
        return(1);
    if (++scrollback_curr > sb_highest)
        scrollback_curr = 0;
    wf_gotoxy(1,1);
    wf_delline();
    if (*sb_cnt >= 0) {
        move_scrollback_row((screen_array_ptr) &(mother_ptr->screen_image),1,*sb_cnt,scr_row);
    }
    else {
        if ((k_row = scrollback_curr + last_line - 1) > sb_highest)
            k_row -= (sb_highest + 1);
        move_scrollback_row((screen_array_ptr) scrollback_array_ptr,1,k_row,scr_row);
    }
    (*sb_cnt)++;
    return(0);
}

void wf_scroll(void)
{
    unsigned x, y;

    get_xy(&x,&y);
    wf_gotoxy(1,1);
    if (scrollback_array_ptr != NULL)
        put_into_scrollback(0);
    wf_delline();
    GGotoXY(x,y);
}
