/* Various selection routines */

#include "msgg.h"
#include "twindow.h"
#include "keys.h"
#include "headedit.h"



word pascal select_mess (void) {

	char s[7];
	static char prompt[40];
	int returncode;
	WINDOW *wnd;
	FIELD *fld;

	wnd=establish_window(3,maxy-7,5,46);
	set_border(wnd,3);
	set_title(wnd," Message Selection ");
	set_colors(wnd,BORDER,7,0,0);
	display_window(wnd);
	wcursor(wnd,0,0);
	wprintf(wnd," F10 to change or ESC to abort");
Again:
	sprintf(s,"%u",messno);
	sprintf(prompt,"Message #(1-%u):",nomess);
	wprompt(wnd,2,2,prompt);
	fld=establish_field(wnd,25,2,msk5,s,'N');
    field_window(fld,"messages  ",40,6);
	prep_template(wnd);
AskOver:
	returncode=data_entry(wnd);
	if (returncode==ESC) {
		delete_window(wnd);
		return messno;
	}
	if (returncode!=F10) goto AskOver;
	if ((word)atol(s)<1 || (word)atol(s)>nomess) {
		error_message(" Invalid ");
		nopause();
		goto AskOver;
	}
	delete_window(wnd);
	messno=(word)atol(s);
	return messno;
}



word pascal select_area () {

	char s[13];
	int  returncode;
	register word x;
	WINDOW *wnd;
	FIELD *fld;

Again:
	wnd=establish_window(3,maxy-7,7,36);
	set_border(wnd,3);
	set_title(wnd," Area Selection ");
	set_colors(wnd,ALL,BLACK,WHITE,BRIGHT);
	set_colors(wnd,TITLE,BLACK,WHITE,DIM);
	set_colors(wnd,BORDER,WHITE,BLACK,BRIGHT);
	display_window(wnd);
	wcursor(wnd,0,0);
	wprintf(wnd," F10 to change or ESC to abort\n");
	wprintf(wnd,"\n  Current: %s",area_attr());
	sprintf(s,"%u",areano);
	init_template(wnd);
	wprompt(wnd,1,4,"Area #/name:");
	fld=establish_field(wnd,20,4,msk12,s,'A');
	field_window(fld,"areas     ",40,6);
	prep_template(wnd);
AskOver:
	returncode=data_entry(wnd);
	if (returncode==ESC) {
		delete_window(wnd);
		return areano;
	}
	if (returncode!=F10) goto AskOver;
	delete_window(wnd);
	rstrip(s);
	lstrip(s);
	if ((word)atol(s)<1 && *s=='0') {
		find_area();
		return areano;
	}
	if ((word)atol(s)>4095) goto Again;
	if((word)atol(s)==0) {
		for (x=0;x<maxareas;x++) {
			if (!stricmp(marea[x].name,s)) {
				sprintf(s,"%u",marea[x].number);
			}
		}
	}
	if((word)atol(s)) {
		nomess=check_area((word)atol(s));
		areano=(word)atol(s);
	}
	find_area();
	if (nomess) messno=1;
	else messno=0;
	get_mess(0);
	return areano;
}

void pascal switch_dirs (void) {

  int s;
  register word x;
  WINDOW *wnd;

  if(!nodirs) {
    error_message(" No directories from which to select! ");
    pause();
    return;
  }
  wnd=establish_window(6,0,nodirs+2,80);
  set_border(wnd,1);
  set_title(wnd," Select default msg path ");
  set_colors(wnd,BORDER,7,0,0);
  clear_message();
  set_help("paths     ",65,13);
  display_window(wnd);
    clear_window(wnd);
    wcursor(wnd,0,0);
    if (nodirs) for (x=0;x<nodirs;x++) {
        if(*dirs[x])wprintf(wnd,"\n%s",dirs[x]);
        else wprintf(wnd,"\nDEFAULT DIR");
    }
ReDo:
    s=get_selection(wnd,1,NULL);
    switch (s) {
        case 0:     break;
        case 1:     if(s<nodirs+1 && s>0) {
                        save_lastread();
                        strcpy(path,dirs[s-(1)]);
                        load_lastread();
						if(marea){
							for(x=0;x<maxareas;x++) {
								if(marea[x].name) free(marea[x].name);
							}
							farfree((void far *)marea);
						}
                        load_areas();
                        currarea=&nullarea;
                        find_area();
                        nomess=check_area(areano);
						if(messno>nomess)messno=nomess;
                    }
                    else {
                        bell();
                        goto ReDo;
                    }
    }
    delete_window(wnd);
}




void pascal select_name (void) {

  int s;
  register word x;
  WINDOW *wnd;

  wnd=establish_window(6,0,noalias+2,40);
  set_border(wnd,1);
  set_title(wnd," Select default name ");
  set_colors(wnd,BORDER,7,0,0);
  clear_message();
  set_help("names      ",65,13);
  display_window(wnd);
	clear_window(wnd);
	wcursor(wnd,0,0);
	if (noalias) for (x=0;x<noalias && x<(maxy-2);x++) {
		wprintf(wnd,"\n%s",alias[x]);
	}
ReDo:
	s=get_selection(wnd,1,NULL);
	switch (s) {
		case 0:	    break;
		default:    if (s>(noalias+1)) {
						bell();
						goto ReDo;
					}
					strcpy(name,alias[s-(1)]);
	}
	delete_window(wnd);
}




void pascal select_address (void) {

  int s;
  register word x;
  char total;
  WINDOW *wnd;

  wnd=establish_window(6,0,noaddress+2,70);
  set_border(wnd,1);
  set_title(wnd," Select default address ");
  set_colors(wnd,BORDER,7,0,0);
  clear_message();
  set_help("addresses ",65,13);
  display_window(wnd);
ReDo:
	total=0;
	clear_window(wnd);
	wcursor(wnd,0,0);
	if (noaddress) for (x=0;x<noaddress && x<(maxy-2);x++) {
		wprintf(wnd,"\n%u:%u/%01u.%01u@%s",address[x]->zone,address[x]->net,address[x]->node,address[x]->point,address[x]->domain);
		total++;
	}
	s=get_selection(wnd,1,NULL);
	switch (s) {
		case 0:	    break;
		default:    if (s>total || s<1) {
						bell();
						goto ReDo;
					}
					curaddress.zone=address[s-1]->zone;
					curaddress.net=address[s-1]->net;
					curaddress.node=address[s-1]->node;
					curaddress.point=address[s-1]->point;
					strcpy(curaddress.domain,address[s-1]->domain);
					break;
	}
	delete_window(wnd);
}

