/*
**
** SelectADD   1993 Bob Maple/The Brazilian
**
** Any programs derived from this source code are
** prohibited from release unless the modified source
** code is released as well.
**
** This is an extremely messy-looking loop which handles multiple
** sets of circumstances.  Be careful.
** 
*/


void CallHost		( UBYTE c     );
void ShutDown		( char *spawn );
void OpenInterface	( long, char *);
void CloseInterface 	( UBYTE Level );
long FileLen  		( char *FName );
char *GivePath		( char *Pathname, char *Filename );
short CheckForUser	( void 	      );

struct	MsgPort		*replyp;	/* Some commnunication details ...	*/
struct	CPort		*cport;
struct	CMessage	 cmess;

struct	MainPort	*myp;		/* Pointer to CNet port--ALL info!	*/
struct	PortData	*z;		/* Pointer to current port; Mostly user */

struct	Library		*CNetBase=NULL;	/* Pointer to CNet library		*/

char	*verStr 	= "$VER: SelectADD 3.1 (10.10.93)";     /* Version string */



void main( int argc, char **argv )
{
  FILE		*FP;			/* For _select3	       */
  struct	SelectType FileAdd;	/* To fill in from VDE */
  short		Res;			/* Result from VDE     */
  short		OnLinePort;		/* Port # if On-Line   */
  long		SelectSize;		/* For select file     */
  char		FileName[80];		/* Path to user's dir  */
  char		*FilePath;		/* Where is it?        */

  char		*StatText[2] = { "That user's select list is full!\n",
  				 "File added to user's select list.\nw1" };



  OpenInterface( argc, argv[1] );	/* If it gets past here, successfull	*/


  if( myp->s2 < 2800 ) {

      PutText( "\nSorry!  This utility is only compatible with CNet version 2.90 or greater.\n" );
      CloseInterface( 1 );
  }

                         /* Program Begins Here */
                         /***********************/


  memset( &FileAdd, 0L, sizeof( struct SelectType ) );    /* Turn all off! */

  FileAdd.Size  	= FileAdd.Base		= FileAdd.Number    = 0;
  FileAdd.SDownFiles  	= FileAdd.SDownBytes	= 0;

	/* 'Base' deals with files selected from a subboard on your
	   BBS.. we're not doing that here, so we set to 0.  The SDown
	   values deal with the accounting system, and we're not concerned
	   with that here either.
	*/

  FileAdd.AutoKill	= FALSE;
  FileAdd.ByteDownload	= FileAdd.FileDownload	= 0;
  FileAdd.Title[0]	= FileAdd.Location[0]	= NULL;

  sprintf( z->ABuffer, "\f\n%s\n(c) 1993 The Brazilian (bmaple@burner.com)\n", &verStr[6] );
  PutA   ();
  
  if( argc == 3 )
      strcpy( z->InBuffer, argv[2] );
  else
      EnterLine( 20, 8+16+128, "\ncaWho would you like to send a file to?\ncf: cb" );

  if( FindAccount( z->InBuffer, &z->user2 ) ) {		/* Pull user */

    /* Keep sending files to the same user until 'EXIT' button is hit */
    
    do {

      Res = VisualDataEditor( "postfile", &FileAdd, sizeof( struct SelectType ));

      if( FileAdd.AutoKill == TRUE )	/* VDE only deals with TRUE/FALSE but	*/
          FileAdd.AutoKill = 3;		/* the value CNet needs here is 3. 	*/

      if( Res != 2 ) {			/* If they DIDN'T hit exit..		*/
      
          FilePath     = GivePath( FileAdd.Location, FileAdd.Title );
          FileAdd.Size = FileLen ( FilePath );

          if( FileAdd.ByteDownload == -1 )
              FileAdd.ByteDownload = FileAdd.Size;

          OnLinePort = CheckForUser();		/* Check all 100 ports for user */

          if( OnLinePort >= 0 ) {
          
              short NumSel;

              sprintf( z->ABuffer, "\ncb%s ceis currently on port cb%dce.\n",
                       z->user2.Handle, OnLinePort );
              PutA   ();

              NumSel = myp->PortZ[OnLinePort]->NoSelected;    /* # files he has	*/

              if( NumSel < myp->gc.nselect ) {     	 /* Can he select more?	*/

                    /* Copy the struct right into his select list! */

                    memcpy( (char *)&myp->PortZ[OnLinePort]->Select[ NumSel ],
                            (char *)&FileAdd, sizeof( struct SelectType ) );
                    myp->PortZ[OnLinePort]->NoSelected++;
 
                    PutText( StatText[1] );		/* File added!		*/
              }
              else {
     
                    PutText( StatText[0] );		/*   Can't select more!	*/
                    Res = 2;				/* Fake an exit from VDE*/
              }
          }


          else {					/* User ISN'T on-line	*/
 
              sprintf( FileName, "mail:users/%s/_select3", z->user2.UUCP );

              if( (FP = fopen( FileName, "a" )) ) {	/* Look at select list  */

                  SelectSize = FileLen( FileName );
 
                  /* The following if statement makes sure that the user can still
                     select more files, by dividing the file size by the size of
                     a SelectType structure (giving us the number of files on his
                     list).
                  */
 
                  if( (SelectSize / sizeof( struct SelectType )) < myp->gc.nselect ) {

                      fwrite( (char *)&FileAdd, sizeof( struct SelectType ), 1, FP );
                      fclose( FP );

                      PutText( StatText[1] );
                  }
                  
                  else {
          
                      PutText( StatText[0] );		/*   Can't select more!	*/
                      Res = 2;				/*         Fake an exit */
                  }
              }

              else {					/* Can't open his file	*/
        
                  PutText( "\nc9Couldn't open user's select list!\n" );
                  Res = 2;					/* Fake an exit */
              }

          }


      }
    } while( Res != 2 );
  }

  CloseInterface( 1 );			/* Close down communications with CNet	*/
}


short CheckForUser( void )
{
  short	i;
  
  for( i = 0; i < 100; i++ ) {
  
       if( myp->PortZ[i] ) {
       
           if( myp->PortZ[i]->user1.IDNumber == z->user2.IDNumber &&
               myp->PortZ[i]->Carrier ) {
               
               return( i );
           }
       }
  }
  
  return( -1 );
}


void OpenInterface( long argc, char *argv )
{
	if( argc<2 || !(cport = (struct CPort *)FindPort( argv )) ) {
		printf("This is a CNet C program.\n");
		exit(0);
	}

	if( !(replyp = CreatePort( 0,0 )))
		exit(0);

	cmess.cn_Message.mn_ReplyPort   = replyp;
	cmess.cn_Message.mn_Length      = sizeof( struct CMessage );
	cmess.cn_Message.mn_Node.ln_Name= "cstuff";

	if( cport->ack != 30 ) {	/* right CNet version running? */
	    cport->ack = 1;
	    CloseInterface( 0 );
	}

	cport->ack = 0;

	z	=	cport->zp;
	myp	=	cport->myp;

	if( !(CNetBase = OpenLibrary( "cnet.library",0 )) )
            CloseInterface( 1 );

}


void CloseInterface( UBYTE Level )	/* 1=W/O ShutDown, !1 = W/ShutDown */
{
	if( Level == 1 )	ShutDown    ( NULL );
	if( CNetBase )		CloseLibrary( CNetBase );

	DeletePort( replyp );
	exit      ( 0 );
}


void ShutDown( char *spawn )
{
  if( spawn )  strcpy( z->CSpawn, spawn );
  CallHost( 0 );
}

void CallHost( UBYTE c )
{
  cmess.command = c;
  PutMsg  ( (struct MsgPort *)cport, (struct Message *)&cmess );
  WaitPort( replyp );
  GetMsg  ( replyp );
}

void PutText( char *text )
{
  cmess.arg1 = (ULONG)text;
  CallHost( 1 );
}

void PutA( void )
{
  PutText( z->ABuffer );
}

int EnterLine( UBYTE len, USHORT flags, char *prompt )
{
  cmess.arg1 = (ULONG)len;	/* how many chars max to input	*/
  cmess.arg2 = (ULONG)flags;	/* 1=UpperCase			*/
  cmess.arg3 = (ULONG)prompt;	/* text to print before input	*/
  CallHost( 2 );		/* result is in z->InBuffer	*/
  return  ( (int)strlen( z->InBuffer ));
}

short FindAccount( char *a, struct UserData *b )
{
  cmess.arg1 = (ULONG)a;
  cmess.arg2 = (ULONG)b;
  CallHost( 20 );
  return  ( (short)cmess.result );
}



/* file: the ".vde" filename, without the .VDE!
   data: pointer to the structure you are going to edit
   size: structure length in bytes

   returns: TRUE if structure has been changed
	    FALSE otherwise
*/

short VisualDataEditor( char *file, void *data, long size )
{
  cmess.arg1 = (ULONG)file;
  cmess.arg2 = (ULONG)data;
  cmess.arg3 = (ULONG)size;
  CallHost( 40 );
  return  ( (short)cmess.result );
}


/* This function takes the Pathname and Filename and combines them
** appropriately for the purpose of file I/O;  C-Net actualy takes them
** separately when dealing with select lists, but we need a whole pathname
** to look at it's size, etc.
*/

char *GivePath( char *Pathname, char *Filename )
{
   static char CompleteName[121];


   if( Pathname[ strlen( Pathname ) - 1 ] == '/' )  /* '/' already there? */
     return( CompleteName );

   if( Pathname[ strlen( Pathname ) - 1 ] != ':' )
	sprintf( CompleteName, "%s/%s", Pathname, Filename );
   else
   	sprintf( CompleteName, "%s%s",  Pathname, Filename );
   	
   return ( CompleteName );
}


long FileLen( char *FName )    /* Returns the length of a file, 0 if error. */
{
  long	FileSize = 0;
  FILE  *FP;


  if( (FP = fopen( FName, "r" )) ) {
  
    fseek      ( FP, 0, 2 );
    FileSize = ftell( FP );
    fclose     ( FP );
  
  }

  return( FileSize );
}
