#include "msgapi.h"
#include "typedefs.h"


/* Structure of SQUISH.STA:

   {
     struct _areahdr ah;              (area tossed/scanned to)
     struct _nodrhdr nh[ah.n_nodes];  (one record for each node in area)
   }
   ...
*/

/* Statistics for this area. Used internally by sstat. */

struct _statarea
{
  dword in_msgs;                /* Total # of msgs received in this area    */
  dword in_bytes;               /* Total # of bytes received in this area   */
};

/* Area header structure, as written to the disk */

struct _areahdr
{
  #define AH_TAGLEN 30
  char tag[AH_TAGLEN];
  dword in_msgs;
  dword in_bytes;
  word n_nodes;
};


/* Linked list of statistics information which parallels the linked         *
 * list of nodes to scan, 'scan[]'.  Used internally by sstat               */

struct _statlist
{
  NETADDR node;                 /* Address of this node                     */

  dword out_msgs;               /* Total # of msgs sent to this node        */
  dword out_bytes;              /* Total # of bytes sent to this node       */
  struct _statlist *next;
};

/* Stats information, as written to disk */

struct _nodehdr
{
  NETADDR node;                 /* Address of this node                     */

  dword out_msgs;               /* Total # of msgs sent to this node        */
  dword out_bytes;              /* Total # of bytes sent to this node       */
};



