'Revision History
'
'12-AUG-88: Revision 1.0.   Initial release
'21-NOV-88: Revision 1.1.   Added ability to sort via SORTF
'01-JUN-89: Revision 1.2.   Changed to user defined record type to speed read
'                           of PCB 14.x USERS file; dropped support of PCB 12.x
'01-AUG-89: Revision 1.3.   Added alternate output file format for input to
'                           database programs
'02-AUG-89: Revision 1.3.1. Added visual progress tracking
'09-FEB-90: Revision 1.3.2. Cosmetic changes
'15-APR-92: Revision 1.4.   Added expiration date field
'20-APR-92: Revision 1.5.   Redid main display screen; bug fixes
'02-MAY-92: Revision 1.6.   Dealt with math problem for ratios greater than
'                           3265 and CINT function.
'
'Set up the constants used in the program
'
CONST TRUE = -1, FALSE = 0
'
'Create a new record type for random access disk I/O
'Record type to read the PCB 14.x USERS file
'
TYPE PCB
   NAM AS STRING * 25
   CITY AS STRING * 24
   PASS AS STRING * 12
   BPHONE AS STRING * 13
   HPHONE AS STRING * 13
   LDATE AS STRING * 6
   LTIME AS STRING * 5
   EXPERT AS STRING * 1
   PROT AS STRING * 1
   JUNK1 AS STRING * 1
   LDIR AS STRING * 6
   SEC AS STRING * 1
   NTIMES AS INTEGER
   PLEN AS STRING * 1
   UPL AS INTEGER
   DOW AS INTEGER
   DDOW AS STRING * 8
   UCMT AS STRING * 30
   SCMT AS STRING * 30
   ETIME AS INTEGER
   EXPT AS STRING * 6
   SEXPSEC AS STRING * 1
   AREA AS STRING * 1
   JUNK2 AS STRING * 15
   TBDOW AS STRING * 8
   TBUPL AS STRING * 8
   DELETE AS STRING * 1
   LMSG AS STRING * 4
   JUNK3 AS STRING * 171
END TYPE
'
'Mainline code
'
CLS
PRINT "USEREP - PCBoard 14.x User File Report Generator, Version 1.6"
PRINT "Copyright (C) 1988 - 1992, S. David Klein"
PRINT " "
ON ERROR GOTO ERHERE
DIM ARG$(10)
FL$ = "1"
OPEN "I", 1, "USEREP.CFG"
INPUT #1, US$
US$ = UCASE$(US$)
INPUT #1, REP$
REP$ = UCASE$(REP$)
INPUT #1, FTYP$
FTYP$ = UCASE$(FTYP$)
CLOSE #1
PRINT "Reading USERS file:     "; US$
PRINT "Writing report to file: "; REP$
PRINT " "
FL$ = "2"
PRINT "Beginning initial scan of USERS file..."
PRINT
OPEN US$ FOR INPUT ACCESS READ SHARED AS #1
CLOSE #1
FL$ = "3"
KILL REP$
MAIN:
DIM USR AS PCB
OPEN US$ FOR RANDOM ACCESS READ SHARED AS #1 LEN = 400
NREC = LOF(1) / 400
OPEN "O", 2, "REPORT.$$$"
I = 0
PRINT "Processing user record #";
REP:
I = I + 1
IF I > NREC GOTO FINIS1
GET #1, I, USR
LOCATE , 25
PRINT I;
IF USR.UPL = 0 THEN R = USR.DOW ELSE R = USR.DOW / USR.UPL
SELECT CASE FTYP$
   CASE "C"
      PRINT #2, RTRIM$(USR.NAM); ",";
      PRINT #2, MID$(USR.LDATE, 3, 2) + "-" + RIGHT$(USR.LDATE, 2) + "-" + LEFT$(USR.LDATE, 2); ",";
      PRINT #2, MID$(USR.EXPT, 3, 2) + "-" + RIGHT$(USR.EXPT, 2) + "-" + LEFT$(USR.EXPT, 2); ",";
      PRINT #2, LTRIM$(STR$(ASC(USR.SEC))); ",";
      PRINT #2, LTRIM$(STR$(USR.NTIMES)); ",";
      PRINT #2, LTRIM$(STR$(CVSMBF(USR.LMSG))); ",";
      PRINT #2, LTRIM$(STR$(USR.UPL)); ",";
      PRINT #2, LTRIM$(STR$(USR.DOW)); ",";
      IF R < 1000 THEN PRINT #2, LTRIM$(STR$((CINT(R * 10)) / 10)) ELSE PRINT #2, LTRIM$(STR$(CINT(R)))
   CASE "M"
      PRINT #2, CHR$(34); RTRIM$(USR.NAM); CHR$(34); ",";
      PRINT #2, CHR$(34); MID$(USR.LDATE, 3, 2) + "-" + RIGHT$(USR.LDATE, 2) + "-" + LEFT$(USR.LDATE, 2); CHR$(34); ",";
      PRINT #2, CHR$(34); MID$(USR.EXPT, 3, 2) + "-" + RIGHT$(USR.EXPT, 2) + "-" + LEFT$(USR.EXPT, 2); CHR$(34); ",";
      PRINT #2, CHR$(34); LTRIM$(STR$(ASC(USR.SEC))); CHR$(34); ",";
      PRINT #2, CHR$(34); LTRIM$(STR$(USR.NTIMES)); CHR$(34); ",";
      PRINT #2, CHR$(34); LTRIM$(STR$(CVSMBF(USR.LMSG))); CHR$(34); ",";
      PRINT #2, CHR$(34); LTRIM$(STR$(USR.UPL)); CHR$(34); ",";
      PRINT #2, CHR$(34); LTRIM$(STR$(USR.DOW)); CHR$(34); ",";
      IF R < 1000 THEN PRINT #2, CHR$(34); LTRIM$(STR$((CINT(R * 10)) / 10)); CHR$(34) ELSE PRINT #2, CHR$(34); LTRIM$(STR$(CINT(R))); CHR$(34)
   CASE ELSE
      PRINT #2, USR.NAM; "";
      PRINT #2, TAB(27); MID$(USR.LDATE, 3, 2) + "-" + RIGHT$(USR.LDATE, 2) + "-" + LEFT$(USR.LDATE, 2); "";
      PRINT #2, TAB(36); MID$(USR.EXPT, 3, 2) + "-" + RIGHT$(USR.EXPT, 2) + "-" + LEFT$(USR.EXPT, 2); "";
      PRINT #2, TAB(45); USING "###"; ASC(USR.SEC);
      PRINT #2, "";
      PRINT #2, TAB(51); USING "####"; USR.NTIMES;
      PRINT #2, "";
      PRINT #2, TAB(57); USING "######"; CVSMBF(USR.LMSG);
      PRINT #2, "";
      PRINT #2, TAB(64); USING "####"; USR.UPL;
      PRINT #2, "";
      PRINT #2, TAB(69); USING "####"; USR.DOW;
      PRINT #2, "";
      PRINT #2, TAB(74); USING "###.#"; R
END SELECT
GOTO REP
FINIS1:
CLOSE #1
CLOSE #2
PRINT " "
PRINT "Initial scan of USERS file completed."
PRINT " "
IF FTYP$ = "C" OR FTYP$ = "M" THEN GOTO SKIP
CMDLIN$ = COMMAND$
IN = FALSE
NUMARG = 0
   FOR I = 1 TO LEN(CMDLIN$)
      C$ = MID$(CMDLIN$, I, 1)
         IF (C$ <> " " AND C$ <> CHR$(9)) THEN
            IF NOT IN THEN
               NUMARG = NUMARG + 1
               IF NUMARG > 3 THEN EXIT FOR
               IN = TRUE
            END IF
            ARG$(NUMARG) = C$
         ELSE
            IN = FALSE
         END IF
   NEXT I
   IF ARG$(1) <> "" THEN
      SK$ = UCASE$(ARG$(1))
      GOTO PART1
   END IF
PRINT "You can sort by two of eight categories: 1) Last Date On"
PRINT "                                         2) Expiration Date"
PRINT "                                         3) Security"
PRINT "                                         4) # Times On"
PRINT "                                         5) Last Msg. Read"
PRINT "                                         6) # Uploads"
PRINT "                                         7) # Downloads"
PRINT "                                         8) Ratio of DL/UL"
PRINT "Or you can choose not to sort."
PRINT "Enter the primary sort key (1 - 8) or N for no sort: ";
SK$ = UCASE$(INPUT$(1))
PRINT SK$
PART1:
   IF SK$ = "N" THEN
      NAME "REPORT.$$$" AS "REPORT.$$1"
      GOTO SKIP
   END IF
   IF ARG$(2) <> "" THEN
      SL$ = UCASE$(ARG$(2))
      GOTO PASS
   END IF
PRINT "Enter the secondary sort key (1 - 8) or N for no secondary key: ";
SL$ = UCASE$(INPUT$(1))
PRINT SL$
PASS:
   IF SL$ = SK$ THEN
      PRINT "The sort keys cannot be identical.  Skipping secondary key"
      SL$ = "N"
   END IF
   IF ARG$(3) <> "" THEN
      SM$ = UCASE$(ARG$(3))
      GOTO PASS1
   END IF
PRINT "Ascending sort is default.  Type  D  if you want descending sort: ";
SM$ = UCASE$(INPUT$(1))
PRINT SM$
PASS1:
SELECT CASE SK$
   CASE "1"
      SS1$ = " /+33,2 /+27,2 /+30,2"
   CASE "2"
      SS1$ = " /+42,2 /+36,2 /+39,2"
   CASE "3"
      SS1$ = " /+45,3"
   CASE "4"
      SS1$ = " /+49,6"
   CASE "5"
      SS1$ = " /+56,7"
   CASE "6"
      SS1$ = " /+64,4"
   CASE "7"
      SS1$ = " /+69,4"
   CASE "8"
      SS1$ = " /+74,5"
   CASE ELSE
      PRINT "Your primary key is invalid.  Skipping sort."
      NAME "REPORT.$$$" AS "REPORT.$$1"
      GOTO SKIP
END SELECT
SELECT CASE SL$
   CASE "1"
      SS2$ = " /+33,2 /+27,2 /+30,2"
   CASE "1"
      SS2$ = " /+42,2 /+36,2 /+39,2"
   CASE "3"
      SS2$ = " /+45,3"
   CASE "4"
      SS2$ = " /+49,6"
   CASE "5"
      SS2$ = " /+56,7"
   CASE "6"
      SS2$ = " /+64,4"
   CASE "7"
      SS2$ = " /+69,4"
   CASE "8"
      SS2$ = " /+74,5"
   CASE "N"
      SS2$ = " "
   CASE ELSE
      PRINT "Your secondary key is invalid.  Using primary key only."
      SS2$ = " "
END SELECT
IF SM$ = "D" THEN SS3$ = " /R" ELSE SS3$ = " "
PRINT " "
PRINT "Shelling to SORTF..."
COMLIN$ = "SORTF REPORT.$$$ REPORT.$$1 " + SS1$ + SS2$ + SS3$ + " /Q"
SHELL COMLIN$
KILL "REPORT.$$$"
SKIP:
PRINT "Beginning final report generation...";
   IF FTYP$ = "C" OR FTYP$ = "M" THEN
      NAME "REPORT.$$$" AS REP$
      GOTO FINIS
   END IF
OPEN "O", 1, REP$
PRINT #1, ""
PRINT #1, "NAME                     LST DATE  EXP   SEC TIMESLST MSG# UP# DNRATIO"
PRINT #1, "                          ON SYS   DATE  LEV  ON   READ  LOADLOADDL/UL"
PRINT #1, ""
OPEN "I", 2, "REPORT.$$1"
FOR I = 1 TO NREC
IF FIX(I / 25) = I / 25 THEN PRINT ".";
LINE INPUT #2, A$
PRINT #1, A$
NEXT I
CLOSE #1
CLOSE #2
KILL "REPORT.$$1"
FINIS:
PRINT
PRINT "Program run completed."
END
ERHERE:
SELECT CASE FL$
   CASE "1"
      IF ERR = 52 OR ERR = 53 THEN
         PRINT "ERR-F, Fatal Error: File Not Found"
         PRINT " "
         PRINT "Make sure the configuration file, USEREP.CFG, exists in"
         PRINT "   the current directory."
         PRINT "Program execution halting."
         RESUME FINIS
      END IF
   CASE "2"
      IF ERR = 52 OR ERR = 53 THEN
         PRINT "ERR-F, Fatal Error: File Not Found"
         PRINT " "
         PRINT "The USERS file specified in USEREP.CFG does not exist."
         PRINT "Edit USEREP.CFG so that your USERS file is specified on line 2."
         PRINT "Program execution halting."
         RESUME FINIS
      END IF
   CASE "3"
      IF ERR = 52 OR ERR = 53 THEN RESUME MAIN
END SELECT
   END
   IF ERR = 62 THEN
      PRINT "ERR-F, Fatal Error - Attempt to read past end of file"
      PRINT " "
      PRINT "The configuration file, USEREP.CFG, is incomplete."
      PRINT "Edit USEREP.CFG to ensure that it has the required 3 lines."
      PRINT "Program execution halting."
      RESUME FINIS
   END IF
   IF ERR = 64 THEN
      PRINT "ERR-F, Fatal Error - Bad File Name"
      PRINT " "
      PRINT "One of the file names specified in USEREP.CFG is invalid."
      PRINT "Change that name to a valid DOS file name."
      PRINT "Program execution halting."
      RESUME FINIS
   END IF
PRINT "ERR-F, Fatal Error - Unspecified error encountered"
PRINT " "
PRINT "Error code = "; ERR
PRINT "Program execution halting."
RESUME FINIS

