#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include <process.h>
#include <sys\stat.h>
#include <time.h>
#include <ctype.h>
#include <io.h>
#include <conio.h>
#include <dir.h>
#include <alloc.h>

#include    "vardec.h"  /* yours */
#include    "userrec.h" /* mine  */

extern  configrec     syscfg;         /* holds info from config.dat */
extern  mailu         u,              /* holds mailu */
                      temp;           /* this one changes as program runs */
extern  int           local,          /* flag for local usage */
                      ansi,           /* flag for ansi usage */
                      nowrite,        /* write user files ? */
                      logoff,         /* should the door logoff */
                      batch,          /* batch mode enabled ? */
                      max_subs;       /* either 32 or 64 */
        userrec       user;           /* the DEADLY userrec */
                        
extern void delmail(int);
extern void realmain(int argc, char *argv[]);
extern short cd_to(char *);
extern void print_ansi(char *);
extern void print(int, char *);
extern void carrier_dropped(char *);

/* set-up the stack */
unsigned _stklen = 64000;

/*===================================================================*/
void numsubs(void)
{
        /* distinguish between 32 and 64 subs for WWIV4.21a+ */
        
        if (syscfg.userreclen == sizeof(userrec))
                max_subs = MAX_SUBS;
        else
                max_subs = 32;

}
/*===================================================================*/
void convert_to(void)
{
        /* transfers your userrec info into my mailu structure */
        int i;
        
        strcpy(u.name, user.name);
        u.screenlines     = user.screenlines;
        u.sl              = user.sl;
        u.dsl             = user.dsl;
        u.waiting         = user.waiting;
        u.age             = user.age;
        u.ar              = user.ar;
        u.dar             = user.dar;
        u.restrict        = user.restrict;
        u.msgpost         = user.msgpost;
        u.posttoday       = user.posttoday;
        u.daten           = user.daten;
        u.postnet         = user.postnet;

        for (i = 0; i < 33; i++)        
                u.qscnptr[i]  = user.qscnptr[i];

        if (max_subs > 32)
                for (i = 0; i < (max_subs - 32); i++)
                        u.qscnptr2[i] =  user.qscnptr2[i];

        /* make copy into change structure */
        temp = u;

}
/*===================================================================*/
void convert_from(void)
{
        /* transfers my mailu info to your userrec structure */
        /* BTW: WWIVMail/QWK only updates these fields, so the entire
           userrec doesn't need to be updated */
        int i;
        
        user.waiting         = temp.waiting;
        user.msgpost         = temp.msgpost,
        user.posttoday       = temp.posttoday;
        user.postnet         = temp.postnet;

        /* restore original qscn sub tags */
        for (i = 0; i < 33; i++)        
                user.qscnptr[i]  = temp.qscnptr[i];
        if (max_subs > 32)
                for (i = 0; i < (max_subs - 32); i++)
                        user.qscnptr2[i] =  temp.qscnptr2[i];

        /* put changes into stadard mailu */
        u = temp;
}
/*===================================================================*/
void read_user_info(int *user_num, char *cur_baud, char *com_speed)
{
        /* opens user file and chain.txt to get info for userrec */

        long pos;
        int userfile, advance;
        char line[80];
        FILE *chain;

        /* local mode */
        if(local){
                /* local batch mode => ANSI and SYSOP */
                if (batch) {
                        ansi = 1;
                        *user_num = 1;
                } else {
                        printf("\n");
                        printf("Please Enter User Number:");
                        gets(line);
                        *user_num = (int)atoi(line);
                        printf("Do You Have Local ANSI ? (Y/N)");
                        gets(line);
                        /* turn on/off ansi graphic output */
                        if(strcmp(strupr(line),"Y") == 0)
                        ansi = 1;
                        else
                        ansi = 0;
                }
                strcpy(cur_baud, "KB");
				strcpy(com_speed, "0");
        /* remote user */
        } else {
                if (batch) {
                        *user_num = 1;
                        ansi = 1;
                } else {
                        /* line 1 of chain.txt has user number */
                        chain = fopen("chain.txt", "r");
                        fgets(line,80,chain);
                        *user_num = (int)atoi(line);
                
                        /* skip on down to ansi support line */
                        for(advance = 1; advance < 14; advance++)
                                fgets(line, 80, chain);
                        ansi = atoi(line);

                        /* skip on down to current baud rate */
                        for(advance = 1; advance < 7; advance++)
                                fgets(line, 80, chain);
                        strcpy(cur_baud, "");
                        strncat(cur_baud, line, strlen(line) - 1);

                        /* skip on down to current com_speed */
                        for(advance = 1; advance < 12; advance++)
                                fgets(line, 80, chain);
                        strcpy(com_speed, "");
                        strncat(com_speed, line, strlen(line) - 1);

                        fclose(chain);
                }
        }
 
        /* actually open the user file */
        sprintf(line, "%sUSER.LST", syscfg.datadir);
        userfile = open(line, O_RDWR | O_BINARY);
        pos = (syscfg.userreclen * (long)*user_num);
        if (lseek(userfile, pos, SEEK_SET) != -1L) {
                if (read(userfile, (void *)&user, syscfg.userreclen) > 0) {
                        convert_to();
                } else
                        *user_num = 0;
        }

        /* 0 = fail upon return */
        close(userfile);
}
/*===================================================================*/
void write_user(int user_num, char *main_dir, int clean)
{
        /* Open the user file and update the last read pointers */

        int userfile;
        long pos;
        char s[81];

        cd_to(main_dir);

        /* Deletes E-Mail and Updates Pointers */
        print_ansi(normal);
        if ((nowrite == 0) && clean) {
                delmail(user_num);
        }
        convert_from();
        sprintf(s,"%sUSER.LST",syscfg.datadir);
        userfile = open(s,O_RDWR | O_BINARY);
        if (userfile > 0) {
                pos = (syscfg.userreclen * (long)user_num);
                lseek(userfile, pos, SEEK_SET);
                if (nowrite == 0)
                        write(userfile, (void *)&user, syscfg.userreclen);
                close(userfile);
        }
        cd_to(syscfg.tempdir);
        if (logoff)
                carrier_dropped(main_dir);

}
/*===================================================================*/
void user_ssm(int un)
{
        /* tells a user that he/she has one more piece of
           short message to read */

        char s[80];
        int userfile;
        unsigned long pos;
        userrec tempuser;
        
        sprintf(s, "%sUSER.LST", syscfg.datadir);
        userfile = open(s, O_RDWR | O_BINARY);
        if (userfile > 0) {
                pos = (long)(syscfg.userreclen * un);
                lseek(userfile, pos, SEEK_SET);
                read(userfile, (void *)&tempuser, syscfg.userreclen);
                if (nowrite == 0) {
                        lseek(userfile, pos, SEEK_SET);
                        tempuser.sysstatus |= sysstatus_smw;
                        write(userfile, (void *)&tempuser, syscfg.userreclen);
                }
                close(userfile);
        }
}
/*===================================================================*/
void user_import(int un, int user_num)
{
        /* tells a user (local) that he/she has one more piece of
           e-mail to read */
           
        char s[80];
        int userfile;
        unsigned long pos;
        userrec tempuser;
        
        sprintf(s, "%sUSER.LST", syscfg.datadir);
        userfile = open(s, O_RDWR | O_BINARY);
        if (userfile > 0) {
                pos = (long)(syscfg.userreclen * un);
                lseek(userfile, pos, SEEK_SET);
                read(userfile, (void *)&tempuser, syscfg.userreclen);
                lseek(userfile, pos, SEEK_SET);
                if (nowrite == 0) {
                        tempuser.waiting++;
                        write(userfile, (void *)&tempuser, syscfg.userreclen);
                        if (un == user_num)
                                temp.waiting++;
                }
                close(userfile);
        }
}
/*===================================================================*/
main(int argc, char *argv[])
{
        /* this is a stub for the REAL main() routine. However, since
       you are linking this to my .LIB, you have to have the main()..
       or at least it's easier if you do. */

       realmain(argc, argv);
}
/*===================================================================*/


