/*******************************************************************/
/* ARKALOG - Create a weekly name/dated archive of your log file   */
/* based upon the last two digits of the year and week number of   */
/* that year.  It does not delete the log file.  You may do that   */
/* in your in a batch file based upon the exit ERRORLEVEL.         */
/*                                                                 */
/* Created 01-MAY-91 by Keith Ford.                                */
/*                                                                 */
/*   Micro Magic BBS       Phone:  +1 205 830 2362                 */
/*   203 Creek Trail       Fido:   1:373/12                        */
/*   Madison, AL 35758     Usenet: sysop@umagic.fidonet.org        */
/*                                                                 */
/* This file is being placed into the public domain.  If you make  */
/* interesting or useful enhancements, the author would like to    */
/* know about them.                                                */
/*******************************************************************/


#include <stdio.h>
#ifdef __clipper__
#include <conio.h>
#endif
#include <time.h>



show_help()
{
  puts("");
  puts("Usage: ARKALOG DAY \"COMMAND\"");
  puts("");
  puts("  DAY is the day of week to execute \"COMMAND\"");
  puts("  [SUN, MON, TUE, WED, THU, FRI, SAT]");
  puts("");
  puts("  \"COMMAND\" is a quoted archive command string.");
  puts("  A 4 digit date code of YYWW will replace #### as it appears");
  puts("  in the command string.  YY = last two digits of the year,");
  puts("  WW = week number where 01 = week of January 1st.");
  puts("");
  puts("Examples: arkalog mon \"lharc a olog#### opus.log\"");
  puts("          ARKALOG Tue \"Pkzip -a C:\\Save\\LOG_#### D:\\Bbs\\Bbs.Log\"");
  puts("");
  puts("Exit ERRORLEVELs:");
  puts("   0 - completed successfully");
  puts("   1 - not the specified day of the week");
  puts("   2 - command not done due to error");
  puts("");
}


main(argc,argv)
int argc;
char **argv;
{
  struct tm *timeptr;
  time_t elapsed_seconds;
  int day_number;
  char *cptr, *dsptr, *acptr, archive_command[80], date_string[5];
  int status=0;

  if (argc!=3)
  {
    puts("** incorrect number of arguments specified");
    show_help();
    exit(2);
  }
  
  if (strlen(argv[1]) != 3)
  {
    printf("** unrecognized day: %s\n", argv[1]);
    puts("valid choices are SUN, MON, TUE, WED, THU, FRI, SAT\n");
    exit(2);
  }
  else
  {
    cptr = argv[1];
    for(;*cptr;++cptr) *cptr=toupper(*cptr);
    switch (argv[1][0])
    {
      case 'M': day_number = 1; break;
      case 'W': day_number = 3; break;
      case 'F': day_number = 5; break;
      case 'S':
      {
        if (argv[1][1] == 'U') day_number = 0;
        else day_number = 6;
        break;
      }
      case 'T':
      {
        if (argv[1][1] == 'U') day_number = 2;
        else day_number = 4;
        break;
      }
      default:
      {
        printf("** unrecognized day: %s\n", argv[1]);
        puts("valid choices are SUN, MON, TUE, WED, THU, FRI, SAT\n");
        exit(2);
        break;
      }
    }
  }

  tzset();
  time(&elapsed_seconds);
  timeptr = localtime(&elapsed_seconds);
  if (day_number != timeptr->tm_wday)
  {
    puts("** wrong day\n");
    exit(1);
  }

  sprintf(date_string, "%02d%02d", timeptr->tm_year, (int)(timeptr->tm_yday/7)+1);
  dsptr = date_string;
  cptr = argv[2];
  acptr = archive_command;
  while(*cptr && strncmp(cptr,"####",4)) *acptr++ = *cptr++;
  if (*cptr)
  {
    while(*dsptr) *acptr++ = *dsptr++;
    cptr+=4;
    while(*cptr) *acptr++ = *cptr++;
  }
  else
  {
    puts("** warning: #### not used in command string\n");
  }
  *acptr = 0;
  printf("executing: %s\n",archive_command);

  status = system(archive_command);
  if (status)
  {
    printf("** ERROR: command status returned was: %d\n\n",status);
    exit(2);
  }

  exit(0);
}
