/*  COPYDATE version 1.01        Copyright (C) 1992 by Jim Robeson
 *                                                     11/11/92
 *  Function:
 *    Read a PCBoard DIR LIST file (arg-1),
 *      and copy it to a file (arg-2),
 *      changing the date field to what is found in (arg-3).
 *      NOTE: the date MUST be formatted MM-DD-YY
 *
 *  Other uses:
 *    None.
 *
 *  Execution:
 *    Run from command line or .BAT:
 *      COPYDATE drv:\path\in-file-name drv:\path\out-file-name MM-DD-YY
 *    If run without arguments, a bit of help appears.
 *
 *  Compiled with:
 *    Borland's Turbo C 2.0.
 *    tcc copydate
 *
 *  Disclaimer:
 *    This program is contributed to the Public Domain.  It can be
 *    freely used, modified and/or distributed by anyone. The only
 *    thing I ask is that you remember that I am not responsible
 *    for anything that might go wrong through the use of this
 *    program.  I have tested the program enough for my own use.
 *    I also realize that bugs can appear in most every program.
 *    Therefore, YOU USE THIS PROGRAM AT YOUR OWN RISK.
 *
 *  To-do:
 *    do a "logical" test on the date
 *
 *  Enjoy,
 *  Jim Robeson
 *  The Cricket BBS, Pacific Grove CA,  408-373-3773
 */

#include "stdio.h"                        /* Standard I/O definitions */
#include "string.h"

#define TRUE 1
#define FALSE 0

/* test to see if 'ch' is a valid DOS character */
#define vld_dos(ch)  ( (( (ch) >= 'A' && (ch) <= 'Z' ) || \
                        ( (ch) >= '0' && (ch) <= '9' ) || \
                        (ch) == '!' || \
                        (ch) == '$' || \
                        (ch) == '@' || \
                        (ch) == '#')   \
                       ? 1             \
                       : 0 )
/* test to see if 'ch' is numeric..... <compare   to isdigit(c)> */
#define is_digit(ch)   ( ( (ch) < '0' || (ch) > '9' ) \
                         ? 0                          \
                         : ch )

void showhelp ( );         /* prototype */

  FILE *infile;            /* the IN file */
  FILE *outfile;           /* the OUT file */
  char inbuf[BUFSIZ];      /* line buffer for reading from file */
                           /* BUFSIZ = 512 in stdio.h */
  int ipt,opt,i;           /* index pointers */

/* ========================================= */
/* ===  MAIN                             === */
/* ========================================= */
main(int argc, char *argv[])       /* main reads command args  */
{
  char *progname;
  char *filein;
  char *fileout;
  char *date_buf;

/*  Display a little how-to "help" if arguments are null or improper  */

  if (argc != 4)           /*  should be 3 args + prognam */
     { if (argc != 1)
         printf("\nERROR: needs 3 arguments\n");
       showhelp();
       exit (1); }               /* exit with errorlevel=1 */

  progname = argv[0];
  filein   = argv[1];
  fileout  = argv[2];
  date_buf = argv[3];

    /* test for valid date in arg-3  */
  if (!(is_digit(date_buf[0]) &&      /* pos 1 is numeric       */
        is_digit(date_buf[1]) &&      /* pos 2 is numeric       */
        date_buf[2] == '-' &&         /* pos 3 = '-'            */
        is_digit(date_buf[3]) &&      /* pos 4 is numeric       */
        is_digit(date_buf[4]) &&      /* pos 5 is numeric       */
        date_buf[5] == '-' &&         /* pos 6 = '-'            */
        is_digit(date_buf[6]) &&      /* pos 7 is numeric       */
        is_digit(date_buf[7]) ))      /* pos 8 is numeric       */
     { printf("\nERROR: the date field (arg-3) must be formatted MM-DD-YY\n");
       showhelp();
       exit (1); }               /* exit with errorlevel=1 */

  printf("\nCOPYDATE IS RUNNING.  Input = %s, Output = %s,\n",filein,fileout);
  printf("                      date = %s.\n",date_buf);

  infile = fopen(filein,"r");          /* open the input file */
  if (infile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the INPUT file: %s.\n",progname,filein);
    exit (1);
    }

  outfile = fopen(fileout,"w");          /* open the output file */
  if (outfile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the OUTPUT file: %s.\n",progname,fileout);
    exit (1);
    }

 /* ========================  copy the file ========================= */
  while ( fgets(inbuf,BUFSIZ,infile) != NULL )  /* TOP-OF-LOOP */
    {
    /* test for line 1 of a file description:     */
    if (vld_dos(inbuf[0]) &&        /* pos 1 valid DOS chars & */
        is_digit(inbuf[20]) &&      /* pos 21 is numeric       */
        inbuf[25] == '-' &&         /* pos 26 = '-'            */
        inbuf[28] == '-')           /* pos 29 = '-'            */

      { /* ==== FILE DESCRIPTION LINE # 1 FOUND ======== */

        ipt = 0;           /* move the new date in */
        opt = 23;
        for (i=0; i < 8; i++)
          { inbuf[opt] = date_buf[ipt];
            ipt++;
            opt++;
          }

      }   /* ====== end  FILE #1 LINE REFORMAT =========== */

    fprintf(outfile,"%s",inbuf);

    } /* end of while at TOP-OF-LOOP */

  /* === Since we dropped through,  ============== */
  /* === implies end of file found. ============== */

  fclose(infile);
  fclose(outfile);

  printf("COPYDATE IS FINISHED.\n");
  exit (0);      /* job done, get out, errorvalue = 0 */

}  /* ------------- end of main ------------------------------- */

/* ========================================= */
/* ===  SHOWHELP                         === */
/* ========================================= */
void showhelp ()
{
  printf("\nCOPYDATE:\n");
  printf("    Copy PCBoard DIR files (descriptions) replacing the date field.\n");
  printf("    by Jim Robeson, 11-11-92\n\n");
  printf("USAGE:\n");
  printf("    COPYDATE drv:\path\in-file-name drv:\path\out-file-name MM-DD-YY \n");
  return;
}  /* ------------- end of showhelp --------------------------- */

/*------------- End of COPYDATE.C ------------------------------------*/
