{----------------------------------------------------------------------------}
{                                                                            }
{ Program:    PCBUSE.PAS                                                     }
{ Purpose:    Allow PCBOARD 14.0 to run Planet Busters 1.3                   }
{ Language:   Borland's Turbo Pascal Version 3.01                            }
{                                                                            }
{ Author:     Carl M. Evans                                                  }
{             Vervan's War Board BBS                                         }
{             P.O. Box 1176, Cucamonga, CA 91730  Voice: 714-989-7824        }
{             2400/1200/300 Baud (8-N-1 only)      Data: 714-989-7596        }
{                                                                            }
{ Notice:     This program is placed in the public domain and may be         }
{             freely used by anyone for any purpose.  When using this        }
{             code, please give credit to the original author and to         }
{             anyone who has subsequently improved or modified it.           }
{                                                                            }
{ Narrative:  This Turbo Pascal program allows a PCBOARD 14.0 BBS to run     }
{             the door program called Planet Busters (version 1.3).          }
{             This routine reads the PCBOARD.SYS file and creates the        }
{             special USERINFO.TXT file which the door needs to get the      }
{             information it needs about the caller. Place PCBUSE.COM on     }
{             your DOS path and call the program from whatever default       }
{             directory that is used by your Planet Busters door program.    }
{             This routine assumes certain default values for the            }
{             location of the PCBOARD.SYS file as well as the name and       }
{             location of the USERINFO.TXT file. The defaults are:           }
{                           C:\PCB\PCBOARD.SYS                               }
{                           USERINFO.TXT                                     }
{             but you may override the defaults by entering the new          }
{             values on the command line when you call the program.          }
{             For example:                                                   }
{             PCBUSE D:\PCB\PCBOARD.SYS E:\DOORS\PBUST\USERINFO.TXT          }
{                                                                            }
{                                                                            }
{ History:    Version 1.0, 11/17/87 - Original by Carl M. Evans              }
{                                                                            }
{             Version 2.0, 09/07/88 - Modified to handle PCBoard 14.0 door   }
{                                     interface changes. This version does   }
{                                     NOT support PCBoard 12.1!!!            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{                                                                            }
{----------------------------------------------------------------------------}
{.PA}
Program PCBUSE;
{$U-}
{$C-}
{============================================================================}
{ Declarations                                                               }
{============================================================================}

Const
  PCB14FileDef    = 'C:\PCB\PCBOARD.SYS';
  PBustFileDef    = 'USERINFO.TXT';
  VersionNumber   = '2.0';

Type
  Ascii2          = array[1.. 2] of char;
  Ascii4          = array[1.. 4] of char;
  Ascii5          = array[1.. 5] of char;
  Ascii8          = array[1.. 8] of char;
  Ascii12         = array[1..12] of char;
  Ascii15         = array[1..15] of char;
  Ascii25         = array[1..25] of char;
  String2         = String[2];
  String5         = String[5];
  String12        = String[12];
  String25        = String[25];
  String80        = String[80];
  FileNameType    = String[80];

  PCB14FileType   = Record             { 128 Bytes for PCBOARD version 14.0  }
         Display  : Ascii2;            { Sysop's Display ON/OFF              }
         Printer  : Ascii2;            { Sysop's Printer ON/OFF              }
         PageBell : Ascii2;            { Sysop's Page Bell ON/OFF            }
         CallAlarm: Ascii2;            { Caller Alarm ON/OFF                 }
         SysopNext: Char;              { Sysop "Next On" Flag                }
         ModemType: Ascii2;            { Error Correcting Modem YES/NO       }
         Graphics : Char;              { Graphics Mode of Caller             }
         NodeChat : Char;              { Available for Node Chat YES/NO      }
         BaudOpen : Ascii5;            { Baud Rate to Open Modem at          }
         BaudRate : Ascii5;            { "CONNECT" Baud Rate of Caller       }
         RecordNum: Integer;           { User's Database Record Number (MKI$)}
         FirstName: Ascii15;           { First Name of Caller                }
         Password : Ascii12;           { Password of Caller                  }
         TimeLogOn: Integer;           { Time User Logged On   (MKI$ minutes)}
         TimeUsed : Integer;           { Time Used Today       (MKI$ minutes)}
         LogOnStr : Ascii5;            { Time User Logged On       (HH:MM:SS)}
         TimeLimit: Integer;           { Daily Time Limit      (MKI$ minutes)}
         ByteLmtDL: Integer;           { Daily Download Limit  (MKI$ K-bytes)}
         ConfExit : Char;              { Conference (Area) User Exited From  }
         ConfFlags: Ascii5;            { Areas User Has "Joined" Today       }
         ConfScan : Ascii5;            { Areas User Has Scanned for New Mail }
         ConfTime : Integer;           { Area "Bonus" Time     (MKI$ minutes)}
         TimeCred : Integer;           { Upload Time Credit    (MKI$ minutes)}
         Language : Ascii4;            { Language Version Being Used         }
         Name     : Ascii25;           { Full Name of Caller   (First & Last)}
         TimeLeft : Integer;           { Session Time Remaining(MKI$ minutes)}
         NodeNum  : Char;              { BBS Node Number That Caller is Using}
         EventTime: Ascii5;            { Scheduled EVENT Time         (HH:MM)}
         EventFlag: Ascii2;            { Is EVENT Time Active?               }
         EventMove: Ascii2;            { Delay EVENT Until User Logs Off?    }
         MsgRecall: Ascii4;            { "Memorized" Message Number    (MKS$)}
         ComPortID: Char;              { Com Port Number (0, 1, 2)           }
         Reserved : Ascii2;            { Reserved for Future Use             }
       end;

Var
{ Variables used for Planet Busters USERINFO.TXT                             }
  UserName        : String25;          { PCBoard limits UserName to 25 bytes }
  BaudRate        : String5;           { Caller's baud rate                  }
  TimeLeftToday   : Integer;           { PCBoard (mins) => PBust (seconds)   }
  DataBits        : Char;              { 7 or 8                              }

{ Variables used to define disk files                                        }
  PCB14File       : File of PCB14FileType;
  PCB14FileName   : FileNameType;
  PCB14Data       : PCB14FileType;
  PBustFile       : Text;
  PBustFileName   : FileNameType;

{ Miscellaneous Variables                                                    }
  ErrorCode       : Integer;

{============================================================================}
{ Function to "pad" a date/time number to a 2-byte string                    }
{============================================================================}
Function Pad2(NumS:String2) :String2;

Begin { Pad2 }
  Case Length(NumS) of
    0            : Pad2 := '00';
    1            : Pad2 := '0' + NumS;
    2            : Pad2 := NumS;
  Else             Begin
                     Pad2[1] := NumS[1];
                     Pad2[2] := NumS[2];
                   End;
  End; {endcase}
End;  { Pad2  }
{============================================================================}
{ Function to trim leading blanks from a string                              }
{============================================================================}
Function TrimL(InpStr: String80): String80;

Var
  I,
  Len            : Integer;

Begin { TrimL }
  Len := Length(InpStr);
  I := 1;
  While (I <= Len) and (InpStr[I] = ' ') do
    I := I + 1;
    TrimL := Copy(InpStr,I,Len-I+1)
End;  { TrimL }

{============================================================================}
{ Function to trim trailing blanks from a string                             }
{============================================================================}
Function TrimR(InpStr: String80): String80;

Var
  I              : Integer;

Begin { TrimR }
  I := Length(InpStr);
  While (I >= 1) and (InpStr[I] = ' ') do
    I := I - 1;
    TrimR := Copy(InpStr,1,I)
End;  { TrimR }

{============================================================================}
{ Function to convert a string to upper case characters                      }
{============================================================================}
Function UpperCase(InpStr: String80): String80;

Var
  I : Integer;

Begin { UpperCase }
   For I := 1 to Length(InpStr) do
      UpperCase[I] := UpCase(InpStr[I]);
   UpperCase[0] := InpStr[0]
End;  { UpperCase }

{============================================================================}
{ Procedure to make an annoying BEEP sound                                   }
{============================================================================}
Procedure Beep;

Begin { Beep }
  Sound(450);
  Delay(500);
  NoSound;
End;  { Beep }

{============================================================================}
{ Procedure to display command line syntax for sysop when error occurs       }
{============================================================================}
Procedure FatalError;

Begin { FatalError }
  Beep;
  Writeln(' ');
  Writeln('FIRST PARAMETER (optional) -');
  Writeln(' The default is:  C:\PCB\PCBOARD.SYS');
  Writeln(' If you wish to override the default path for PCBOARD.SYS,');
  Writeln(' then specify a new path as the first parameter.');
  Writeln(' NOTE: Include the file name with the path.');
  Writeln(' ');
  Writeln('SECOND PARAMETER (optional) -');
  Writeln(' The default is:  USERINFO.TXT');
  Writeln(' If you wish to override the default path for USERINFO.TXT,');
  Writeln(' then specify a new path as the second parameter.');
  Writeln(' NOTE: Include the file name with the path.');
  Writeln(' ');
  Writeln('For Example:');
  Writeln('PCBUSE D:\PCB\PCBOARD.SYS E:\DOORS\PBUST\USERINFO.TXT');
  HALT(1);
End;  { FatalError }

{============================================================================}
{ Procedure to parse the command line                                        }
{============================================================================}
Procedure ParseCommandLine;

Begin { ParseCommandLine }
  If ParamCount > 0 then begin
    PCB14FileName   := ParamStr(1);
    PCB14FileName   := TrimL(PCB14FileName);
    PCB14FileName   := TrimR(PCB14FileName);
    PCB14FileName   := UpperCase(PCB14FileName);
  End else begin
    PCB14FileName   := PCB14FileDef;
  End; {endif}
  Writeln(' ');
  Writeln('INPUT FILESPEC = ' + PCB14FileName);

  If ParamCount > 1 then begin
    PBustFileName   := ParamStr(2);
    PBustFileName   := TrimL(PBustFileName);
    PBustFileName   := TrimR(PBustFileName);
    PBustFileName   := UpperCase(PBustFileName);
  End else begin
    PBustFileName   := PBustFileDef;
  End; {endif}
End;  { ParseCommandLine }

{============================================================================}
{ Procedure to read the PCBOARD.SYS file                                     }
{============================================================================}
Procedure ReadPCBoardSysFile;

Begin { ReadPCBoardSysFile }
  Assign(PCB14File,PCB14FileName);
  {$I-} Reset(PCB14File); {$I+}
  ErrorCode := IOresult;
  If ErrorCode <> 0 then begin
    Close(PCB14File);
    Writeln(' ');
    Writeln('ERROR: Could not find PCBOARD.SYS');
    FatalError;
  End; {endif}
  Read(PCB14File,PCB14Data);
  Close(PCB14File);
End;  { ReadPCBoardSysFile }

{============================================================================}
{ Procedure to translate PCBOARD.SYS to USERINFO.TXT                         }
{============================================================================}
Procedure TranslateUserData;

Var
  I              : Integer;
  Temp           : String5;

Begin { TranslateUserData }
  UserName       := TrimR(PCB14Data.Name);

  For I := 1 to 5 do begin
    Temp[I] := PCB14Data.BaudRate[I];
  End;
  BaudRate := Temp;

  If PCB14Data.Graphics = '7' then begin
    DataBits     := '7';
  End else begin
    DataBits     := '8';
  End; {endif}

  TimeLeftToday  := 60*PCB14Data.TimeLeft;
End;  { TranslateUserData }

{============================================================================}
{ Procedure to create USERINFO.TXT file                                      }
{============================================================================}
Procedure WritePBustFile;

Begin { WritePBustFile }
  Assign(PBustFile,PBustFileName);
  {$I-} Rewrite(PBustFile); {$I+}
  ErrorCode := IOresult;
  If ErrorCode <> 0 then begin
    Writeln(' ');
    Writeln('ERROR: Illegal file name specified for output file');
    Close(PBustFile);
    FatalError;
  End; {endif}
  Writeln(PBustfile,UserName);       { Caller's logon name                 }
  Writeln(PBustfile,BaudRate);       { Caller's logon baud rate            }
  Writeln(PBustfile,DataBits);       { Com setting: 7 or 8 databits/word   }
  Writeln(PBustfile,TimeLeftToday);  { Caller's remaining time on the BBS  }
  Close(PBustFile);
End;  { WritePBustFile }

{============================================================================}
{ Main Program                                                               }
{============================================================================}

Begin
  Writeln('');
  Writeln('PCBUSE version ' + VersionNumber +
   ' Run Planet Busters Door on PCBOARD 14.0');
  Writeln('');
  Writeln('[ A PCBoard 14.0 utility from Vervan' + Chr(39) +
    's War Board (714) 989-7596 ]');
  Writeln('');
  ParseCommandLine;
  ReadPCBoardSysFile;
  TranslateUserData;
  WritePBustFile;
End.

{===[ END OF PROGRAM ]=======================================================}
