; RAStat v1.00 rastat.ctl file
;
; This file controls RAStat, and customizes the program's operation as desired
; for any RemoteAccess/FrontDoor system.  It *must* be named rastat.ctl, and
; it *must* be located in the current directory when RAStat is executed.
;
; Comment lines begin with a semicolon (;) as the first character, and are
; ignored by the program.  No comment lines are required.
;
; All non-comment lines in rastat.ctl begin with a keyword.  All valid keywords
; are shown below.  Keywords are case insensitive, and may appear in rastat.ctl
; in any order.  All must be spelled exactly as shown below.  Invalid lines and
; invalid keywords are ignored by the program.
;
; Several keywords (ie: BBSName or Background) require a parameter.  There must
; be *exactly* one blank space (not three spaces, or two, or a tab, but *one*
; space) between the keyword and the parameter.  
;
; Several keywords (ie: RAPath or FDPath) require a DOS path as a parameter.
; The paths specified in rastat.ctl *must* exist; the program will abort if
; they do not.  A trailing backslash (\) is optional on all path parameters.
;
; Several keywords (ie: FDCalls or SysOpExclude) toggle features on/off.
; All are enabled by default.  To disable these features, comment-out the
; keyword with a semicolon.
;
; All keyword lines *must* be terminated by a CRLF immediately after the last
; significant text character; trailing spaces or trailing comments are *not*
; permitted.
;
;
; Name of the BBS (mandatory, may include any printable character including
; spaces, maximum length 30 characters, excess characters truncated):
;
BBSName Moose Mania
;       ------------------------------
;       123456789012345678901234567890
;       length gauge  --  max length ^
;
;
; Path to the RemoteAccess users.bbs and lastcall.bbs files (mandatory):
;
RAPath c:\ra\
;
;
; Path to the directory for RAStat's output files (mandatory):
;
TextPath c:\ra\text\
;
;
; Path to the FrontDoor *.his files (mandatory in -calls mode if FDCalls is
; enabled, ignored otherwise):
;
FDPath c:\fd\
;
;
; Base filename for -stats mode output files (mandatory for -stats mode,
; ignored otherwise, do *not* include a path or extension):
;
StatsFile stats
;
;
; Base filename for -calls mode output files (mandatory for -calls mode,
; ignored otherwise, do *not* include a path or extension):
;
CallsFile calls
;
;
; Generate FD mailer call info (optional for -calls mode, ignored in -stats
; mode, comment-out to disable):
;
FDCalls
;
;
; Exclude first record in users.bbs from output files (optional, comment-out
; to disable):
;
SysOpExclude
;
;
; Exclude users with hidden attribute set in users.bbs from output files
; (optional, comment-out to disable):
;
HiddenExclude
;
;
; Silence the speaker (optional, comment-out to disable):
;
Quiet
;
;
; Colors for ANSI output files (mandatory):
;
Title 15
Header 12
Data 14
Prompt 10
Background 00
;
;
; Valid color parameters are:
;
; Background        Foreground
; ------------      ----------------------------------
;
; 00 = Black        00 = Black     08 = Dark grey
; 01 = Blue         01 = Blue      09 = Bright blue
; 02 = Green        02 = Green     10 = Bright green
; 03 = Cyan         03 = Cyan      11 = Bright cyan
; 04 = Red          04 = Red       12 = Bright red
; 05 = Magenta      05 = Magenta   13 = Bright magenta
; 06 = Brown        06 = Brown     14 = Bright yellow
; 07 = Gray         07 = Gray      15 = Bright white
;
