DEFINT A-Z
PassedArguments$ = COMMAND$ + " "
X = INSTR(" H h ? ", PassedArguments$)
IF X > 0 THEN
   CLS
   PRINT "MAKETABS version 1.1 Copyright (c) 1991 by Ken Goosens"
   PRINT "an RBBS utility to make an index tab for sorted file list"
   PRINT
   PRINT "Format:      MAKETABS <options>    where options are:"
   PRINT
   PRINT "/IN=<input file>                       Default:  FIDX.DEF"
   PRINT "/OUT=<output file>                     Default:  FIDXT.DEF"
   PRINT "/B  (run batch)                        Default:  (no)"
   PRINT "/INDEXPOS=<column position to index>   Default:  1"
   IF X > 1 THEN END
END IF

' Initialize

InFile$ = "FIDX.DEF"
OutFile$ = "FIDXT.DEF"
IndexPos = 1
TRUE = -1
FALSE = 0
RunBatch = FALSE

' Process Command Line

PassedArguments$ = UCASE$(PassedArguments$)
X = INSTR(PassedArguments$, "/INDEXPOS=")
IF X > 0 THEN
   IndexPos = VAL(MID$(PassedArguments$, X + 10))
END IF
X = INSTR(PassedArguments$, "/IN=")
IF X > 0 THEN
   Y = INSTR(X, PassedArguments$, " ")
   InFile$ = MID$(PassedArguments$, X + 4, Y - X - 4)
END IF
X = INSTR(PassedArguments$, "/OUT=")
IF X > 0 THEN
   Y = INSTR(X, PassedArguments$, " ")
   OutFile$ = MID$(PassedArguments$, X + 5, Y - X - 5)
END IF
RunBatch = (INSTR(PassedArguments$, "/B ") > 0)

PRINT
PRINT "File to Create Tabs for .. "; InFile$
PRINT "TAB file to make ......... "; OutFile$
PRINT "Position to index ........ "; IndexPos
PRINT
IF NOT RunBatch THEN
   INPUT "A to abort, anything else runs"; ANS$
   ANS$ = UCASE$(ANS$)
   IF ANS$ = "A" THEN END
END IF

StartRun! = TIMER
DIM StartPos(36)
CharsCounted$ = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
OPEN InFile$ FOR INPUT AS #1
FOR i = 1 TO 36
   StartPos(i) = 0
NEXT
LinesRead = 0
PRINT "Processing file "; InFile$; " ";
ColPos = POS(0)
WHILE NOT EOF(1)
   LINE INPUT #1, A$
   LinesRead = LinesRead + 1
   LOCATE , ColPos
   PRINT LinesRead;
   IndexChar$ = MID$(A$, IndexPos, 1)
   Position = INSTR(CharsCounted$, IndexChar$)
   IF Position > 0 THEN
      IF StartPos(Position) = 0 THEN
         StartPos(Position) = LinesRead
      END IF
   END IF
WEND
CLOSE 1

OPEN OutFile$ FOR RANDOM AS #1 LEN = 72
FIELD #1, 72 AS OutRec$
PrevValue = 0
' put 1 in for leading 0's
i = 1
WHILE i < 37 AND StartPos (i) = 0
   StartPos (i) = 1
   i = i + 1
WEND
' find last non-zero value
i = 36
WHILE i > 0 AND StartPos(i) = 0
   i = i - 1
WEND
StartPos(36) = StartPos(i)
' propagate high values to left over 0's
FOR i = 36 TO 1 STEP -1
   IF StartPos(i) = 0 THEN
      CurrentValue = 1
      IF PrevValue > CurrentValue THEN
         CurrentValue = PrevValue
      END IF
   ELSE
      CurrentValue = StartPos(i)
   END IF
   StartPos(i) = CurrentValue
   PrevValue = CurrentValue
NEXT
FOR i = 1 TO 36
   MID$(OutRec$, 1 + 2 * (i - 1), 2) = MKI$(StartPos(i))
NEXT
PUT 1, 1
CLOSE 1
PRINT
PRINT "Created TAB file "; OutFile$
'FOR i = 1 TO 36
'   PRINT MID$(CharsCounted$, i, 1); StartPos(i); ". ";
'NEXT
EndRun! = TIMER
IF EndRun! < StartRun! THEN                                          ' 022891
   EndRun! = EndRun! + 60!*60!*24!                                   ' 022891
END IF                                                               ' 022891
PRINT "Run time: "; (EndRun! - StartRun!)/60 ; " minutes"
END

