' $title: 'ANSIChat Split Screen Chat for RBBS-PC v17.4'
'          By Dan Drinnon 8:903/2 1:313/6
'
'          Copyright 1992 by Daniel T. Drinnon   All Rights Reserved
'
'          DO NOT Distribute in Modified Form!
'
' Revisions: 1.01 - added support to handle Sysop's Shell to DOS (F2)
'
'            1.02 - Prevent F10 from Loading another ANSIChat
'                   Keep ANSIChat from showing 'RBBS' if that is already
'                   part of the BBS name.
'                   added support for Sysop's PgUp/PgDn (RBBSSUB3.BAS)
'                   Combined local and remote input routines - thanks Scott!
'
'            1.03 - Greater control over ANSI colors when ANSITest = ZTrue
'                   but user is not set up for ANSI Color Graphics.
'
'
' $INCLUDE: 'RBBS-VAR.MOD'
'
' $SUBTITLE: 'ANSIChat - ANSI Split Screen Chat Routine'
'
' $PAGE
'
'  SUBROUTINE NAME    -- ANSIChat
'
'  INPUT PARAMETERS   -- None
'
'  OUTPUT PARAMETERS  -- None
'
'  SUBROUTINE PURPOSE -- Allows Split Screen ANSI Chat for RBBS
'
'
DIM ZANSIRow(1), ZANSICol(1), ACColor$(1), HoldInput$(1), StartRow(1)
DIM MaxRow(1), WasX$(1)

Common Shared ZANSIRow(), ZANSICol(), ACColor$(), HoldInput$(), StartRow()
Common Shared MaxRow(), WasX$()
Common Shared LocalOut, RemoteOut, SideOut
Common Shared MenuColor1$, MenuColor2$
'
1000 SUB ANSIChat STATIC
'
     LocalOut = 0
     RemoteOut = 1
     SideOut = LocalOut
     ZANSIRow(LocalOut) = 2
     ZANSIRow(RemoteOut) = 14
     ZANSICol(LocalOut) = 1
     ZANSICol(RemoteOut) = 1
     ACColor$(LocalOut) = ZEscape$ + "[1;32;40m"                     ' 1.03
     ACColor$(RemoteOut) = ZEscape$ + "[1;33;40m"                    ' 1.03
     ZWasCM = ZTrue
     TimeChatStarted! = TIMER
     ZSubParm = 1
     HoldColorReset$ = ZColorReset$
     MenuColor1$ = ZEscape$ + "[1;33;44m"                            ' 1.03
     MenuColor2$ = ZEscape$ + "[1;36;44m"                            ' 1.03
     ZColorReset$ = MenuColor2$                                      ' 1.03
     CALL ANSIMenu
     CALL ANSILocate (ZANSIRow(LocalOut),ZANSICol(LocalOut))
     CALL QuickTPut1 (ACColor$(LocalOut) + ZSysopGreeting$)
     CALL SplitScreenChat
     ZWasCM = 0
     CALL CheckTime(TimeChatStarted!,Elapsed!, 2)
     ZSecsPerSession! = ZSecsPerSession! + Elapsed!
     IF NOT ZLocalUser THEN _
        ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL ClearANSIScreen
     CALL QuickTPut(ZCrLF$ + "Chat over.  BBS resuming",2)
     ZColorReset$ = HoldColorReset$
     END SUB
'
4000 SUB ANSIMenu STATIC
'
     LineBar$ = ""
     FOR I= 1 to 80
        LineBar$="" + LineBar$
     NEXT I
     CALL ClearANSIScreen
     CALL ANSILocate (1,1)
     CALL QuickTPut (MenuColor2$ + LineBar$,0)                       ' 1.03
     IF INSTR(ZRBBSName$,"BBS") <> 0 THEN _                          ' 1.02
        ZOutTxt$ = "*>>> " + ZRBBSName$ + " ANSI Chat <<<*" _      ' 1.02
     ELSE _                                                          ' 1.02
        ZOutTxt$ = "*>>> " + ZRBBSName$ + " RBBS ANSI Chat <<<*"   ' 1.02
     temppos = (40 - (LEN(ZOutTxt$)/2))
     CALL ANSILocate (1,temppos)
     CALL QuickTPut (MenuColor1$ + ZOutTxt$,0)                       ' 1.03
     CALL ANSILocate (13,1)
     CALL QuickTPut (MenuColor2$ + LineBar$,0)                       ' 1.03
     CALL ANSILocate (13,3)
     CALL QuickTPut (MenuColor2$ + "" + ZSysopFirstName$ + " " + ZSysopLastName$ + "",0) ' 1.03
     CALL ANSILocate (13,43)
     CALL QuickTPut (MenuColor2$ + "" + ZActiveUserName$ + "",0) ' 1.03
     CALL Line25
     END SUB
'
5000 SUB ClearANSIScreen STATIC
'
     CALL QuickTPut ("[0;37;40m[2J[m",0)                          ' 1.03
     ZSubParm = 2
     CALL Line25
     ZSubParm = 0
     CALL ANSILocate (1,1)
     END SUB
'
6000 SUB ANSILocate (ANSIRow,ANSICol) STATIC
'
     CALL QuickTPut ("[" + MID$(STR$(ANSIRow),2) + ";" + MID$(STR$(ANSICol),2) + "H",0)
     END SUB
'
8000 SUB SplitScreenChat STATIC
'
8001 HoldInput$(LocalOut) = ""                                       ' 1.01
     HoldInput$(RemoteOut) = ""
     MaxLen = 78
     StartRow(LocalOut) = 2
     StartRow(RemoteOut) = 14
     MaxRow(LocalOut) = 12
     MaxRow(RemoteOut) = 24
     ZANSICol(LocalOut) = 1
     ZANSICol(RemoteOut) = 1
     ZANSIRow(LocalOut) = StartRow(LocalOut) + 1
     ZANSIRow(RemoteOut) = StartRow(RemoteOut)
     WasX$(LocalOut) = ""
     WasX$(RemoteOut) = ""
     ZWaitExpired = ZFalse
'
8010 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL Carrier
     IF ZSubParm < 0 THEN _
        EXIT SUB
'
8020 CALL FindFKey
     IF ZWasCM = 0 THEN _                                            ' 1.01
        CALL FlushCom (ZCommPortStack$) : _                          ' 1.01
        ZKeyPressed$ = "" : _                                        ' 1.01
        CALL ANSIMenu : _                                            ' 1.01
        ZWasCM = ZTrue : _                                           ' 1.01
        GOTO 8001                                                    ' 1.01
     SideOut = LocalOut
     WasX$(LocalOut) = ZKeyPressed$
     IF ZKeyPressed$ = ZEscape$ THEN _
        EXIT SUB
     IF WasX$(LocalOut) <> "" THEN _
        GOTO 8060
'
8030 IF ZLocalUser THEN _
        GOTO 8010
     SideOut = RemoteOut
     IF ZCommPortStack$ <> "" THEN _
        WasX$(RemoteOut) = LEFT$(ZCommPortStack$,LEN(ZCommPortStack$)-1) : _
        GOTO 9000
     CALL EofComm (Char)
     IF Char <> -1 THEN _
        GOTO 8050 _
     ELSE _
        GOTO 8010
'
8050 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     SideOut = RemoteOut
     CALL GetCom (WasX$(RemoteOut))
'
8060 'Control keys
     IF WasX$(SideOut) = CHR$(8) THEN _
        GOTO 8500 _
     ELSE IF WasX$(SideOut) = CHR$(9) THEN _
        GOTO 8510 _
     ELSE IF WasX$(SideOut) = CHR$(13) THEN _
        GOTO 8520
     GOTO 9000
'
8500 'BackSpace
     HoldInput$(SideOut) = ""
     IF ZANSICol(SideOut) > 1 THEN _
        ZANSICol(SideOut) = ZANSICol(SideOut) - 1
     IF ZANSICol(SideOut) = 0 THEN _                                 ' 1.03
        ZANSICol(SideOut) = MaxLen : _                               ' 1.03
        ZANSIRow(SideOut) = ZANSIRow(SideOut) - 1                    ' 1.03
     CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut))
     IF NOT ZLocalUser THEN _
        CALL PutCom (" ")
     CALL LPrnt (" ",0)
     CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut))
     GOTO 8010
'
8510 'TAB
     HoldInput$(SideOut) = ""
     IF ZANSICol(SideOut) + 5 > MaxLen THEN _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut)) _
     ELSE _
        ZANSICol(SideOut) = ZANSICol(SideOut) + 5 : _
        CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut))
     GOTO 8010
'
8520 'CR
     HoldInput$(SideOut) = ""
     CALL AddRow (StartRow(SideOut),MaxRow(SideOut))
     GOTO 8010
'
9000 'Character Placement
     HoldInput$(SideOut) = HoldInput$(SideOut) + WasX$(SideOut)
     IF WasX$(SideOut) = " " THEN _
        HoldInput$(SideOut) = ""
     IF ZANSICol(SideOut) = MaxLen AND WasX$(SideOut) <> " " THEN _
        CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut) - LEN(HoldInput$(SideOut))) : _
        CALL QuickTput("[K", 0) : _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut)) : _
        CALL QuickTPut (HoldInput$(SideOut),0) : _
        ZANSICol(SideOut) = ZANSICol(SideOut) + LEN(HoldInput$(SideOut)) - 1 : _
        WasX$(SideOut) = "" : _
        HoldInput$(SideOut) = ""
     CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut))
     IF NOT ZLocalUser THEN _
        CALL PutCom (ACColor$(SideOut) + WasX$(SideOut))
     CALL LPrnt (ACColor$(SideOut) + WasX$(SideOut),0)
     ZANSICol(SideOut) = ZANSICol(SideOut) + 1
     IF ZANSICol(SideOut) > MaxLen THEN _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut))
     WasX$(SideOut) = ""
     GOTO 8010
     END SUB
'
10000 SUB AddRow (StartRow,MaxRow) STATIC
'
      ZANSICol(SideOut) = 1
      ZANSIRow(SideOut) = ZANSIRow(SideOut) + 1
      IF ZANSIRow(SideOut) > MaxRow THEN _
         ZANSIRow(SideOut) = StartRow
      IF ZANSIRow(SideOut) < MaxRow THEN _
         CALL ANSILocate (ZANSIRow(SideOut) + 1,ZANSICol(SideOut)) : _
         CALL QuickTput("[K", 0)
      IF ZANSIRow(SideOut) = MaxRow THEN _
         CALL ANSILocate (StartRow,ZANSICol(SideOut)) : _
         CALL QuickTput("[K", 0)
      CALL ANSILocate (ZANSIRow(SideOut),ZANSICol(SideOut))
      END SUB
'
