;
; Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
; used with code compiled with BC's /Fs option.  (Most) changes marked with
; ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
; for the original code.

;BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
;  saved to meet requirements of BC 7.x.

	Extrn	StringAddress:far                                            ;BCFS0726

CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEG
	PUBLIC	LPLK10
	PUBLIC	LOK10
	PUBLIC	UNLOK10
LOOPLCK	EQU	11H		; 3COM LOCK WITH DELAY
LANLOCK	EQU	12H		; 3COM LOCK WITH RETURN
UNLOCK	EQU	13H		; 3COM UNLOCK
DRIVE	DB	?		; INPUT DRIVE NUMBER
REQUEST	DB	?		; TYPE OF REQUEST
DELAY	DW	?		; DELAY TIME
ENET	DW	0		; DUMMY ETHERNET ADDRESS
LENLOK	DW	?		; LENGTH OF LOCK NAME
POINTER	DW	?		; POINTER TO LOCK NAME
LCKNAME	DB	31 DUP(?)	; INPUT LOCK NAME
	DB	0		; TERMINATOR

LPLK10	PROC	FAR
	MOV	REQUEST,LOOPLCK
	MOV	DELAY,300	; WAIT 5 MINUTES FOR LOCK
	JMP	PROCESS
LPLK10	ENDP

LOK10	PROC	FAR
	MOV	REQUEST,LANLOCK
	MOV	DELAY,10	; WAIT 10 SECONDS FOR LOCK
	JMP	PROCESS
LOK10	ENDP

UNLOK10	PROC	FAR
	MOV	REQUEST,UNLOCK
	MOV	DELAY,0

PROCESS:
	PUSH	BP		; SAVE BP
	MOV	BP,SP		; SAVE SP INTO BP FOR PARM ADDRESSING
	PUSH	DS		; SAVE BASIC'S DATA SEGMENT
	PUSH	ES		; SAVE BASIC'S EXTRA SEGMENT
	MOV	BX,[BP+10]	; GET ADDRESS OF DRIVE NUMBER
	MOV	AL,[BX]		; GET LOW ORDER BYTE OF DRIVE ADDRESS
	INC	AL		; ADJUST DRIVE NUMBER
	MOV	DRIVE,AL	; SAVE THE DRIVE NUMBER
	PUSH	[BP+8]		; GET A$ STRING DESCRIPTOR ADDRESS	      ;BCFS0726
	CALL	StringAddress						      ;BCFS0726
	MOV	LENLOK,CX	; GET LENGTH OF STRING A$ IN CX REGISTER      ;BCFS0726
	MOV	POINTER,AX						      ;BCFS0726
	MOV	SI,AX		; OFFSET OF BASIC'S STRING		      ;BCFS0726
	MOV	DS,DX							      ;BCFS0726
	PUSH	CS		; MOV CS TO ES VIA STACK
	POP	ES		; TARGET IS IN OUR CSEG
	MOV	DI,OFFSET LCKNAME   ; OFFSET OF WORK AREA
	CLD			; START FROM THE BOTTOM
	REP	MOVSB		; COPY BASIC'S STRING TO OUR WORK AREA
	PUSH	CS		; MOV CS TO DS VIA STACK
	POP	DS		; OUR CSEG SEGMENT INTO DS
	MOV	BX,OFFSET LCKNAME+2 ; POINT TO NEW NAME
	MOV	SI,OFFSET ENET	; POINT TO DUMMY ETHERNET ADDRESS
	MOV	AX,WORD PTR DRIVE ; GET DRIVE AND LOCK REQ TYPE FOR LOCK	      ;BCFS0726
	MOV	DX,DELAY	; 3COM DELAY TIME
	INT	60H		; CALL 3COM LOCK MANAGER
	POP	ES		; GET BACK BASIC'S EXTRA SEGMENT
	POP	DS		; GET BACK BASIC'S DATA SEGMENT
	MOV	BX,[BP+6]	; GET ADDRESS OF RESULT VARIABLE	      ;BCFS0801
	MOV	[BX],AL		; STORE RETURN CODE FROM LOCK MANAGER	      ;BCFS0801
	POP	BP
	RET	6
UNLOK10	ENDP
CSEG	ENDS
	END
