' $linesize:132
' $segment
' $title: 'Alias sub for CDor version of RBBS'
'          Originally by Gregg Snyder
'          Modifications by Peter Eibl
' $INCLUDE: 'RBBS-VAR.BAS'
'
' $SUBTITLE: 'AliasChk - Checks whether ALIAS exists'
' $PAGE
'
'  SUBROUTINE NAME    -- AliasChk
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         WhoFind$                    ALIAS to find
'
'  OUTPUT PARAMETERS  --  WhoFound                    Whether ALIAS found
'                         UserNumFound                Record # of User
'
'  SUBROUTINE PURPOSE --  Validate that ALIAS exists.  Get User Record
'
2257 SUB AliasChk (WhoFind$,WhoFound,UserNumFound) STATIC
     If WhoFound = Ztrue Then Exit Sub
     CALL BreakFileName (ZMainUserFile$,Drive$,Prefix$,Ext$,ZTrue)
     DgsTemp = INSTR(ZConfName$,SPACE$(1))
     IF DgsTemp > 0 THEN _
      DgsFileName$ = Drive$ + LEFT$(ZConfName$,DgsTemp-1) + "A.DEF" _
     ELSE DgsFileName$ = Drive$ + ZConfName$ + "A.DEF"
     CALL FindIt (DgsFileName$)
     IF NOT ZOK THEN _
        EXIT SUB
     Call OpenWork (7,DgsFileName$)
     WhoFound=ZFalse
     DgsAlias$ = ""
     WHILE DgsAlias$ = "" AND NOT EOF(7)
        INPUT #7, DgsUserName$, DgsTempAlias$
        IF Instr(DgsTempAlias$,WhoFind$) > 0 THEN
           '* "Send to{SP"
           CALL FormatString (817,ZFalse,ZFalse,0,ZFalse,0,Strng$)
           ZSubParm = 1
           ZOutTxt$ = Strng$ + DgsTempAlias$ + ZYesPrompt$
           Call TGet
           IF ZSubParm = -1 THEN _
              EXIT SUB
           IF ZWasQ=0 THEN
              ZYes = ZTrue
           END IF
           IF ZYes THEN
              WhoFound = ZTrue
              WhoFind$ = DgsTempAlias$
              DgsAlias$ = DgsUserName$
           END IF
        END IF
     WEND
     CLOSE 7
   END SUB
59750' $SUBTITLE: 'AliasDgs - Subroutine to Create/Update Alias Info file'
' $PAGE
'
'  SUBROUTINE NAME    -- DgsAlias
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         ZConfName$                  CONFERENCE NAME
'                         ZOrigUserNameDgs$           USERS - LOG ON NAME
'                         DgsAlias$                   USERS - ALIAS NAME
'                         DgsFileName$                CONFERENCE ALIAS FILE
'
'  OUTPUT PARAMETERS  --  ZConfName$ ZOrigUserNameDgs$ DgsAlias$
'                         DgsFileName$
'
'  SUBROUTINE PURPOSE --  TO Read ConfA.DEF and Get Users ALIAS or
'                         Create One
'
     SUB AliasDgs (ZConfName$,ZOrigUserNameDgs$,DgsAlias$) STATIC
'
     ConfADefFlag = ZFalse
     CALL BreakFileName (ZMainUserFile$,Drive$,Prefix$,Ext$,ZTrue)
     DgsFileName$ = Drive$ + ZConfName$ + "A.DEF"
     CALL FindIt (DgsFileName$)
     IF ZOK THEN
        ConfADefFlag = ZTrue
     END IF
     IF ConfADefFlag = ZTrue THEN
        Call OpenWork (7,DgsFileName$)
        DgsAlias$ = ""
        WHILE DgsAlias$ = "" AND NOT EOF(7)
           INPUT #7, DgsUserName$, DgsTempAlias$
           DgsUnl = LEN(DgsUserName$)
           IF DgsUserName$ = LEFT$(ZOrigUserNameDgs$,DgsUnl) THEN
              DgsAlias$ = DgsTempAlias$
           END IF
        WEND
        CLOSE 7
     ELSE
        DgsAlias$ = "N"
        EXIT SUB
     END IF
     CALL GoodAls (ZConfName$,ZOrigUserNameDgs$,DgsAlias$,DgsFileName$)
     END SUB
'
'
' $SUBTITLE: 'GoodAls - Subroutine to Make Sure Alias Good'
' $PAGE
'
'  SUBROUTINE NAME    -- GoodAls
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         ZConfName$                  CONFERENCE NAME
'                         ZOrigUserNameDgs$           USERS - LOG ON NAME
'                         DgsAlias$                   USERS - ALIAS NAME
'                         DgsStl$                     NULL FIRST TIME IN
'                                                      'STILL' IF ALIAS EXISTS
'                                                         OR REAL NAME
'                         DgsFileName$                CONFERENCE ALIAS FILE
'
'  OUTPUT PARAMETERS  --  ZConfName$ ZOrigUserNameDgs$ DgsAlias$ DgsStl$
'                         DgsFileName$
'
'  SUBROUTINE PURPOSE --  To Read ConfA.DEF and see if Users ALIAS is
'                         Aready in Use or a Real Name
'
     SUB GoodAls (ZConfName$,ZOrigUserNameDgs$,DgsAlias$,DgsFileName$) STATIC
'
     IF DgsAlias$ = "" THEN
        DgsSfnSln$ = ZSysopFirstName$+SPACE$(1)+ZSysopLastName$
        '* "{CBThis is an {CAALIAS {CBConferences!{C0"
        LineNum = 818
        GOSUB 59990
        ABFlg$ = ""
        '* "{CAEnter your ALIAS name (31 Characters Max){C0"
        CALL FormatString (819,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
        ZSubParm = 1
        CALL TGet
        CALL AllCaps (ZUserIn$)
        IF ZUserIn$ = "" OR INSTR(SPACE$(31),ZUserIn$) > 0 THEN
           ZUserIn$ = ""
           '* "{CO Alias must NOT be Blank! {C0"
           LineNum = 820
           GOSUB 59980
        END IF
        IF LEN(ZUserIn$) > 31 THEN
           ZUserIn$= ""
           '* "{CO Alias name must be LESS than 31 Characters! {C0"
           LineNum = 821
           GOSUB 59980
        END IF
        IF (ZUserIn$ = "SYSOP" OR ZUserIn$ = DgsSfnSln$) AND NOT ZSysop THEN
           '* "SYSOP name attempt for ALIAS name"
           CALL FormatString (822,ZFalse,ZTrue,2,ZFalse,0,"")
           '* "{RI{RI{CE{G4 Name not Allowed! {C0{CR{CR{CDContact the SysOp for help{C0"
           LineNum = 823
           GOSUB 59990
           DgsAlias$ = ZOrigUserNameDgs$+CHR$(250)
           ZActiveUserName$ = ZOrigUserNameDgs$+CHR$(250)
           ZFirstName$ = ZOrigUserNameDgs$+CHR$(250)
        ELSE
           Call OpenWork (7,DgsFileName$)
           WHILE ABFlg$ = "" AND NOT EOF(7)
           INPUT #7, DgsUserName$, DgsTempAlias$
           IF ZUserIn$ = DgsUserName$ THEN
              '* "{SPis a Real User"
              LineNum = 954
              GOSUB 59980
           ELSE
              IF ZUserIn$ = DgsTempAlias$ THEN
                 '* "{SPhas already been used"
                 LineNum = 824
                 GOSUB 59980
              END IF
           END IF
           WEND
           CLOSE 7
           IF ABFlg$="" THEN
              DgsAlias$ = ZUserIn$
              ZActiveUserName$ = ZUserIn$
              ZFirstName$ = ZUserIn$
           ELSE
              CALL QuickTPut1 (ZFGF$ + ZUserIng$ + ABFlg$)
              DgsAlias$ = ""
           END IF
       END IF

        IF DgsAlias$ <> "" THEN
           CLOSE 2
           FOR I = 1 TO LEN(DgsAlias$)
              IF MID$(DgsAlias$,I,1)=CHR$(34) THEN MID$(DgsAlias$,I,1)=CHR$(39)
           NEXT I
           Call OpenWorkA (2,DgsFileName$)
           WRITE #2, ZOrigUserNameDgs$, DgsAlias$
           CLOSE 2
        END IF
      ELSE
        ZActiveUserName$ = DgsAlias$
        ZFirstName$ = DgsAlias$
      END IF
      EXIT SUB
59980 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ABFlg$)
      RETURN
59990 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
      RETURN
      END SUB
