
; Changes made to ANSI17 by Scott McNay (1:395/11) July 26, 1992, to allow
; routine to be used with code compiled with BC's /Fs option.  (Most) changes
; marked with ;BCFS0726.  May have optimized some code also.  This is a plug-in
; replacement for the original code with BC, but requires use of RBBSQBFS.OBJ
; when using QuickBASIC.


; BCFS0728: Updated to ANSI18, but removed ANSISET() and hardcoded ANSI() to
; use video page 0, since RBBS does not change the video page, and I doubt that
; anyone bothers to change to other than page 0 before running RBBS.  This
; removes some more overhead and makes the code shorter.  Also partly fixed bug
; with lines going past column 80 getting cut off instead of wrapping.
; Also did a LOT of optimizing.  EVERYTHING marked BCFS0728 (except the XOR
; BH,BH lines), as well as a few others, was modified by optimizations!  This
; is about half of the code, and a bunch of code was removed also.


;|(THE FOLLOWING HAS BEEN REMOVED!)
;|BCFS0729: Added another parameter to return the number of line wraps that
;|occurred, so that RBBS can keep it's line count accurate.  This was not
;|possible before, since long lines were cut off, partly fixed by BCFS0728.
;|Example:

;|   CALL ANSI ("AVeryLongLineOfText",NewX,NewY,NumLines)


; BCFS0831: Another virtual rewrite, to make sure that the cursor never moves
; to line 25 when it shouldn't.  Solved the problem by having separate routines
; for line 25 and the rest of the screen.  Now, if the cursor ever moves to
; line 25 for ANY reason, including ANSI cursor codes, the screen is scrolled
; and the cursor moved back up to line 24.  Code has been reduced to a mere 60
; lines, and only a handful have not been moved, removed, or replaced.  Since
; the code is so different and is stable now, have renamed to ANSI19.

; Standardized code format.  Made sure that DI, SI, BP, and DS are saved to
; meet requirements of BC 7.x.

; Managed to confirm that the problem with missing line feeds is in RBBSSUB2
; line 3750.  I suspect that the problem in ANSI16 was actually a case of a bug
; in RBBS being "fixed" by a bug in ANSI16.  Specifically, BX was used as a
; pointer to the character being printed.  ANSI, at one point, would find a CR
; as the last character of the string and then look at [BX+1] without checking
; to verify that it was within the string.  I believe that normally [BX+1]
; would contain a LF (for whatever reason) except right after a shell to DOS
; from within chat, in which case the LF would get replaced by something else.
; Change RBBSSUB2 line 3750 to read as follows:

; 3750 IF SendRemote THEN _
;	  CALL PutCom(WasX$)
;      IF WasX$ = ZCarriageReturn$ THEN _
;	  CALL LPrnt (ZCrLf$,0) : _
;	  Col = Col - 1 : _
;	  GOTO 3850 _
;      ELSE _
;	  CALL LPrnt (WasX$, 0)



;ANSI1-8ASM  Revised 10/18/90 Nathan T. Barber
;   V1.7 of Ansi.obj works well except in one situation:  The attribute byte of
;   character 1 on line 24 is used when scrolling the screen.  This causes
;   color bleeding on the local screen.  The fix can be done in two ways:
;   always set the attrib byte to the correct one, or just use attrib 7, which
;   appears to be for "bland" text.  I use attrib 7 since RBBS seems to set the
;   color for the next line all by itself.

;   Also in this version, a new function called ANSISET.  It replaces the
;   initialization code that fetchs the current video page for every call to
;   ANSI().  This makes an appreciable speed difference when scrolling the
;   screen at 9600+ BPS.  It requires changing one line in RBBS-PC.BAS, which
;   is noted here:  (from line 108)
;    IF ZUseBASICWrites THEN _
;	ZLocalBksp$ = ZBackArrow$ _
;    ELSE ZLocalBksp$ = ZBackSpace$ : call ANSISET		      'NB101890
;   I don't THINK what I do is illegal from a programming point of view, as I
;   don't think RBBS ever changes video pages when it executes this routine!

;   Finally, the routine Where_are_we has been moved from a proc call to
;   mainline.  Every cycle counts!




; ANSI2-0ASM  Revised 10/9/93   W. Scott McNay
;   Added function ANSISize to change the right and bottom margins so that
;   43/50/etc column screens can be used.
; ANSI1-9ASM  Revised 8/1/92   W. Scott McNay
;   Changed code to allow far strings with BC 7.1.  Change requires use of
;   RBBSQBFS.OBJ when using QB to compile.  Removed all code dealing with video
;   pages, and simply assumed page 0.  Code completely rewritten, so that there
;   are now no problems with wrapping around column 80.  Also removed code to
;   bypass chat LF bug.  Fixed chat LF bug in RBBSSUB2, and determined that
;   probable cause of bug apparently occurring only after shell to DOS was
;   because of another, unnoticed, bug in ANSI.
; ANSI1-8ASM  Revised 10/18/90 Nathan T. Barber
;   Fix background color bleeding during scroll.  Also changed code for
;   detecting video page, so only checks once.  Moved Where_are_we inline.
; ANSI1-7ASM  Revised 11/28/88 Garry G. Kraemer
;   Kludge fix for chat LF bug.
; ANSI1-6ASM  Revised 10/28/87 Jon Martin
;   Fix boundary bug.
; ANSI1-5ASM  Revised 8/24/85  Dave Terry
;   Changes for QuickBasic compiler.
; ANSI1-4ASM  Revised 8/23/85  Dave Staehlin

	Extrn	StringAddress:far					      ;BCFS0726 
CR	equ	13
LF	equ	10

ANSI_PRNT SEGMENT PUBLIC 'CODE'	;By  David W. Terry
	ASSUME	CS:ANSI_PRNT	;    3036 So. Putnam Ct.
	PUBLIC	ANSI,ANSISize	;    West Valley City, UT 84120

;		Screen scroll mods by David C. Staehlin
;				      5430 Candle Glow NE
;				      Albuquerque, NM 87111

;				  Data (505) 821-7379 24 Hrs, 2400 Baud
STRG_LEN	DW	0	 ;CHANGED TO ENDING ADDRESS OF STRING PASSED
Bottom	db	23							      ;ANSI20
Right	db	79							      ;ANSI20
Fill	db	7							      ;ANSI20


ANSI	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	ES							      ;BCFS0801
	PUSH	BP		;Bypass bug in orig PC BIOS, duplicated by    ;BCFS0801
				; some clone BIOSes

	PUSH	[BP+10]		;GET A$ STRING DESCRIPTOR ADDRESS
	CALL	StringAddress						      ;BCFS0726
	MOV	BX,AX							      ;BCFS0726
	ADD	AX,CX							      ;BCFS0728
	MOV	STRG_LEN,AX
	MOV	ES,DX							      ;BCFS0726

	PUSH	BX						      ;nb101890
	MOV	AH,3		;SET UP FOR ROM-BIOS CALL (03H)	      ;nb101890
	XOR	BH,BH		;TO READ THE CURRENT CURSOR POSITION	      ;BCFS0728
	INT	10H		;  DH = ROW   DL = COLUMN	      ;nb101890
	POP	BX						      ;nb101890
	CMP	DH,Bottom	;Handle line 25 separately, which must fit and;ANSI20
	JA	LastLine	; have no control characters.		      ;BCFS0801

LOOP1:
	MOV	DL,es:[BX]	;SET DL TO CHARACTER TO PRINT		      ;BCFS0728
	MOV	AH,2		;SET UP FOR FUNCTION CALL 02H		      ;BCFS0728
	INT	21H		; Display it

	PUSH	BX		;Save pointer			      ;nb101890
	MOV	AH,3		;SET UP FOR ROM-BIOS CALL (03H)	      ;nb101890
	XOR	BH,BH		;TO READ THE CURRENT CURSOR POSITION	      ;BCFS0728
	INT	10H		;  DH = ROW   DL = COLUMN	      ;nb101890
	POP	BX						      ;nb101890
	CMP	DH,Bottom	;Did cursor get moved to last line?           ;ANSI20
	JA	SCROLL		; Yes, scroll screen, move cursor back!
SKIPIT:
	INC	BX		; point to next char
	CMP	BX, STRG_LEN	; AT END OF STRING?			    GGK
	JB	LOOP1		; NO, CONTINUE - NEXT MUST BE A LF!!	    GGK

EXIT1:
	MOV	AH,3		;SET UP FOR ROM-BIOS CALL (03H)
	XOR	BH,BH		;TO READ THE CURRENT CURSOR POSITION	      ;BCFS0728
	INT	10H		;  DH = ROW   DL = COLUMN
	INC	DH		;ADD 1 TO ROW (BECAUSE TOP OF SCREEN = 0)
	INC	DL		;ADD 1 TO COL (BECAUSE POS 1 = 0)

	POP	BP		;Gets around PC BIOS bug		      ;BCFS0801
	POP	ES							      ;BCFS0801
	MOV	BX,[BP+8]						      ;BCFS0728
	MOV	[BX],DH		;PASS BACK ROW COORDINATE		      ;BCFS0728
	MOV	BX,[BP+6]						      ;BCFS0728
	MOV	[BX],DL		;PASS BACK COLUMN COORDINATE		      ;BCFS0728

	POP	BP
	RET	6

LastLine:			;This assumes no control characters!!
	MOV	DL,es:[BX]	;SET DL TO CHARACTER TO PRINT		      ;BCFS0728
	MOV	AH,2		;SET UP FOR FUNCTION CALL 02H		      ;BCFS0728
	INT	21H		; Else just display it
	INC	BX		; point to next char
	CMP	BX, STRG_LEN	; AT END OF STRING?			    GGK
	JB	LastLine	; NO, CONTINUE - NEXT MUST BE A LF!!	    GGK
	JMP	short EXIT1

SCROLL:
	PUSH	BX		;Save the pointer
	MOV	AH,2		;Now set cursor position to line 23	      ;BCFS0801
	XOR	BH,BH							      ;BCFS0801
	DEC	DH							      ;BCFS0801
	INT	10H							      ;BCFS0801
	mov	bh,Fill							      ;ANSI20
	MOV	AX,601h		; Scroll up 1 line			      ;BCFS0728
	XOR	CX,CX		; Begin scroll at position 1,1		      ;BCFS0728
	MOV	DH,Bottom	; End scroll at line 24, Col 80		      ;ANSI20
	MOV	DL,Right						      ;ANSI20
	INT	10H		; And do it...
	POP	BX		;Restore the stack like it was		      ;BCFS0801
	JMP	short SKIPIT						      ;BCFS0728

ANSI	ENDP


ANSISize	PROC	FAR						      ;ANSI20
	PUSH	BP							      ;ANSI20
	MOV	BP,SP							      ;ANSI20
	PUSH	BX							      ;ANSI20
	MOV	BX,[BP+6]						      ;ANSI20
	MOV	BL,[BX]							      ;ANSI20
	MOV	Fill,BL							      ;ANSI20
	MOV	BX,[BP+8]						      ;ANSI20
	MOV	BL,[BX]							      ;ANSI20
	DEC	BL
	MOV	Bottom,BL						      ;ANSI20
	MOV	BX,[BP+10]						      ;ANSI20
	MOV	BL,[BX]							      ;ANSI20
	DEC	BL							      ;ANSI20
	MOV	Right,BL						      ;ANSI20
	POP	BX							      ;ANSI20
	POP	BP							      ;ANSI20
	RET	6							      ;ANSI20
ANSISize	ENDP							      ;ANSI20

ANSI_PRNT	ENDS
	END
