' $segment
' $linesize:132
' $title: 'DOSFUNC.BAS 17.4/CDor, Copyright 1993 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: DOSFUNC.BAS
'  First Released .....: August 17, 1993
'  Subsequent Releases.: 
'  Copyright ..........: 1993
'  Purpose.............: DOS Function calls for RBBS-PC
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine or Function             Purpose
'  CheckShare                         Check/Return status of DOS SHARE
'  CheckPrinter                       Check/Return status of PRINTER
'
' $INCLUDE: 'RBBS-VAR.MOD'

   TYPE RegTypeX
      ax      AS INTEGER
      bx      AS INTEGER
      cx      AS INTEGER
      dx      AS INTEGER
      bp      AS INTEGER
      si      AS INTEGER
      di      AS INTEGER
      flags   AS INTEGER
      ds      AS INTEGER
      es      AS INTEGER
   END TYPE

' =============================================================================
' * GetFirstMatchingFile$ - DOS FindFirst
' =============================================================================
    FUNCTION GetFirstMatchingFile$ (FileSpec$)

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
' *
' * REM Get Disk Transfer Area (DTA) address
' *
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
' *
' * REM Now find first match
' *
    NameFile$ = FileSpec$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.cx = 0
    InRegs.ax = &H4E00
    CALL InterruptX(&H21, InRegs, OutRegs)

    IF OutRegs.flags AND 1 THEN
       GetFirstMatchingFile$ = ""
       EXIT FUNCTION
    END IF

    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29

    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i

    DEF SEG

    GetFirstMatchingFile$ = Match$

    END FUNCTION
'
' =============================================================================
' * GetNextMatchingFile$ - DOS FindNext
' =============================================================================
    FUNCTION GetNextMatchingFile$

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
' *
' * REM Get Disk Transfer Area (DTA) address
' *
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
' *
' * REM Now find next match
' *
    InRegs.ax = &H4F00
    CALL InterruptX(&H21, InRegs, OutRegs)

    IF OutRegs.flags AND 1 THEN
       GetNextMatchingFile$ = ""
       EXIT FUNCTION
    END IF

    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29

    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i

    DEF SEG

    GetNextMatchingFile$ = Match$

    END FUNCTION

' =============================================================================
' * CheckShare - Returns ZOK = ZTrue if SHARE is loaded
' =============================================================================

    SUB CheckShare

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    ' * Don't abort if SHARE not loaded on a Novell workstation
    ' * CheckNovell returns 0 if Novell installed

    CALL CheckNovell (Installed)
    IF Installed = 0 THEN
       ZOK = ZTrue
       EXIT SUB
    END IF

    ZOK = ZFalse

    InRegs.ax = &H1000
    CALL InterruptX(&H2F, InRegs, OutRegs)
    CheckShareVal = OutRegs.ax AND &HFF
    IF CheckShareVal = &HFF THEN
       ZOK = ZTrue
    ELSE
       ZSnoop = ZTrue
       '* "ERROR - SHARE NOT INSTALLED"
       CALL FormatString (848,ZTrue,ZFalse,0,ZFalse,0,"")
       CALL DelayTime (5)
    END IF
    END SUB

' =============================================================================
' * CheckPrinter - Returns ZOK = ZTrue if Printer Ready
' =============================================================================

    SUB CheckPrinter (PrinterNumber)

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    ZOK = ZFalse

    IF PrinterNumber = 0 THEN
       EXIT SUB
    END IF

    InRegs.ax = &H0200
    InRegs.dx = PrinterNumber - 1

    CALL InterruptX(&H17, InRegs, OutRegs)

    PrinterAlive = (OutRegs.ax AND &HFF00) / &H100

    ZOK = (((PrinterAlive AND &H29) = 0) AND ((PrinterAlive AND &H90) = &H90))

    END SUB
